/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**********************************************************************/
/*                                                                    */
/*   Module          = EDDLGRAT                                       */
/*                                                                    */
/*   Description     = Display Device Driver function GetStyleRatio   */
/*                                                                    */
/*   Function        = returns the style ratio in *pRatio             */
/*                        high byte = y component                     */
/*                        low byte  = x component                     */
/*                                                                    */
/*   Reference       = Winthorn Functional Specification              */
/*                     Device Driver Interface Specification          */
/*                     Display Device Driver Design Specification     */
/*                                                                    */
/*                                                                    */
/**********************************************************************/
#define INCL_DDIMISC
#define INCL_DDIPATHS
#include <eddinclt.h>

#include <eddlextf.h>
#include <eddgextf.h>

extern BYTE      LinePatStep;

/**********************************************************************/
/* Looks up the style ratio in the DDT and returns it via supplied    */
/* pointer.                                                           */
/**********************************************************************/

DDIENTRY eddl_GetStyleRatio (HDC        hdc,
                             PUSHORT    pRatio,
                             PDC        pdcArg,
                             ULONG      FunN)

{
    /******************************************************************/
    /* Prevent compiler warnings.                                     */
    /******************************************************************/
    IgnoreParam(hdc);

    /******************************************************************/
    /* Get driver semaphore and perform entry checks                  */
    /******************************************************************/
    EnterDriver(pdcArg, FunN, EDF_STANDARD | EDF_DONT_CLEAN);

    /******************************************************************/
    /* This ensures that the style value passed to the                */
    /* driver in the DrawLinesInPath and PolyShortLine structures (to */
    /* indicate the current position in the line style pattern)       */
    /* is incremented correctly by the Engine for each pel in the     */
    /* line (see EDDDATA.C for details).                              */
    /******************************************************************/
    *pRatio = (LinePatStep << 8) | LinePatStep;

    /******************************************************************/
    /* Release driver semaphore                                       */
    /******************************************************************/
    ExitDriver(pdcArg, FunN, EDF_STANDARD | EDF_DONT_CLEAN);

    return(TRUE);
}


/**********************************************************************/
/* Sets the style ratio. The hardware does not support style ratios   */
/* and so immediately return                                          */
/**********************************************************************/
DDIENTRY eddl_SetStyleRatio (HDC        hdc,
                             PUSHORT    pRatio,
                             PDC        pdcArg,
                             ULONG      FunN)

{
    /******************************************************************/
    /* Prevent compiler warnings.                                     */
    /******************************************************************/
    IgnoreParam(hdc);
    IgnoreParam(pRatio);

#ifdef FIREWALLS
    /******************************************************************/
    /* Return immediately                                             */
    /* We still enter and exit driver so that we know this call has   */
    /* been made while debugging / timing etc.                        */
    /******************************************************************/
    EnterDriver(pdcArg, FunN, EDF_STANDARD);
    ExitDriver(pdcArg, FunN, EDF_STANDARD);
#endif

    return(TRUE);
}
