/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**********************************************************************/
/*                                                                    */
/*   Module          = EDDLGETC                                       */
/*                                                                    */
/*   Description     = Display Device Driver minor function handler   */
/*                     GetCurrentPosition                             */
/*                                                                    */
/*   Function        = Gets the current position in world coordinates */
/*                                                                    */
/*   Reference       = Winthorn Functional Specification              */
/*                     Device Driver Interface Specification          */
/*                     Display Device Driver Design Specification     */
/*                                                                    */
/*                                                                    */
/**********************************************************************/
#define INCL_DDICOMFLAGS
#define INCL_DDIMISC
#define INCL_DDIPATHS
#include <eddinclt.h>

#include <eddlextf.h>
#include <eddgextf.h>

/**********************************************************************/
/* GetCurrentPosition returns the current position in world           */
/* coordinates as an x,y coordinate pair.                             */
/**********************************************************************/
DDIENTRY eddl_GetCurrentPosition (HDC           hdc,
                                  PPOINTL       pptPosition,
                                  PDC           pdcArg,
                                  ULONG         FunN)

{
    /******************************************************************/
    /* Prevent compiler warnings.                                     */
    /******************************************************************/
    IgnoreParam(hdc);

    /******************************************************************/
    /* Get driver semaphore and perform entry checks                  */
    /******************************************************************/
    EnterDriver(pdcArg, FunN, EDF_STANDARD | EDF_DONT_CLEAN);

    /******************************************************************/
    /* If the transform flag is set pass the current position back in */
    /* world coordinates, otherwise they should be returned in screen */
    /* coordinates.                                                   */
    /******************************************************************/
    if (FunNTest(COM_TRANSFORM))
    {
        /**************************************************************/
        /* COM_TRANSFORM set so return WORLD coordinates              */
        /**************************************************************/
        *pptPosition = pdc->DCICurrPosWorld;
    }
    else
    {
        /**************************************************************/
        /* Otherwise return SCREEN coordinates                        */
        /**************************************************************/
        pptPosition->x = pdc->DCICurrPosAI.X;
        pptPosition->y = pdc->DCIBoundingClip[1].Y - pdc->DCICurrPosAI.Y;
    }

    /******************************************************************/
    /* Release driver semaphore                                       */
    /******************************************************************/
    ExitDriver(pdcArg, FunN, EDF_STANDARD | EDF_DONT_CLEAN);

    return(TRUE);
}
