/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/

/**********************************************************************/
/*                                                                    */
/*   File            = EDDGEXTF                                       */
/*                                                                    */
/*   Description     = Printer Device Driver external files for       */
/*                     Global routines                                */
/*                                                                    */
/*   Function        =                                                */
/*                                                                    */
/*   Reference       = Device Driver Interface Specification          */
/*                                                                    */
/*                                                                    */
/**********************************************************************/


USHORT PASCAL eddg_Convert (PULONG      SourceXY,
                            PULONG      TargetXY,
                            USHORT      Source,
                            USHORT      Target,
                            USHORT      n,
                            ULONG       command);

USHORT PASCAL eddg_FastConvert (pWcsPoint       SourceXY,
                                pDevPoint       TargetXY,
                                USHORT          n);

DSPENTRY eddg_AccumulateBounds (HDC              hdc,
                                pWcsRect         ArgBoundsRect,
                                PDC              pdcArg,
                                ULONG            FunN);

DSPENTRY eddg_GetBoundsData (HDC            hdc,
                             ULONG          ArgStyle,
                             pWcsRect       ArgBoundsRect,
                             PDC            pdcArg,
                             ULONG          FunN);

DSPENTRY eddg_ResetBounds (HDC            hdc,
                           ULONG          ArgFlags,
                           PDC            pdcArg,
                           ULONG          FunN);

VOID PASCAL eddg_AddRectToBounds (pDevRect      Bounds,
                                  pDevRect      Rectangle,
                                  USHORT        UnitsFlag);

VOID PASCAL eddg_AddPointToBounds (pDevRect     Bounds,
                                   pDevPoint    Point,
                                   USHORT       UnitsFlag);

USHORT PASCAL eddg_AddBounds (pDevRect  Bounds,
                              ULONG     StyleFlag,
                              USHORT    CoordFlag);

DSPENTRY eddg_SetPickWindow (HDC        hdc,
                             pWcsRect   Pwindow,
                             PDC        pdcArg,
                             ULONG      FunN);

DSPENTRY eddg_GetPickWindow (HDC        hdc,
                             pWcsRect   Pwindow,
                             PDC        pdcArg,
                             ULONG      FunN);

USHORT PASCAL eddg_ClipPickWindow(VOID);

USHORT PASCAL eddg_CheckLineCorrelation(pDevPoint  Startpt,
                                        pDevPoint  Endpt);

USHORT PASCAL eddg_CheckRectCorrelation(pDevRect Rectangle);

USHORT PASCAL eddg_ClipAndCorrLine(USHORT       StartValue,
                                   USHORT       EndValue,
                                   DevPoint     Startpt,
                                   DevPoint     Endpt,
                                   pDevRect     Rectangle);

VOID XGA_EnterDriver(PDC    pdcEntered,
                     ULONG  FunN,
                     ULONG  fEnterOptions);

VOID XGA_ExitDriver(PDC    pdcExit,
                    ULONG  FunN,
                    ULONG  fExitOptions);

ULONG GetVRAMPointer ( ULONG ulAddr , ULONG ulSize , PULONG pulFirst , PULONG  ppVRAM );
