/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/

/**********************************************************************/
/*                                                                    */
/*   File            = EDDERSET                                       */
/*                                                                    */
/*   Description     = Enable : subfunction Reset DC state            */
/*                                                                    */
/*   Function        = ResetDC resets the DC to its default state     */
/*                                                                    */
/*   Reference       = Winthorn Functional Specification              */
/*                     Device Driver Interface Specification          */
/*                     Display Device Driver Design                   */
/*                                                                    */
/*                                                                    */
/**********************************************************************/


#define INCL_GRE_PALETTE
#define INCL_DDIMISC
#define INCL_DOSSEMAPHORES
#include <eddinclt.h>

#include <eddacone.h>
#include <edddtypt.h>
#include <eddetypt.h>
#include <eddeextf.h>
#include <eddgextf.h>
#include <eddtextf.h>

#include <semaphor.h>
#ifdef PALETTE_MGR
#include <twozero.h>

#endif /* PALETTE_MGR */

/**********************************************************************/
/* ResetDC resets the current DC to its default state.                */
/**********************************************************************/

USHORT ResetDC (PDC  pdcArg)

{
#define TFUNC "edde_ResetDC"
    /******************************************************************/
    /* Local variables                                                */
    /******************************************************************/
    USHORT         Result;


    /******************************************************************/
    /* Get driver semaphore and perform entry checks                  */
    /******************************************************************/
    EnterDriver(pdcArg, FUNN_UNKNOWN, EDF_STANDARD | EDF_DONT_CLEAN);

    PROFILE_ENTER(69);

    /******************************************************************/
    /* First return any heap items 'hanging off' the DC type          */
    /* structure. Note that in this case the clip rectangles and the  */
    /* correlation rectangles are not released                        */
    /******************************************************************/
    free_transient_dc_memory();

#ifdef PALETTE_MGR
#ifdef FIREWALLS
    /**************************************************************/
    /* The engine should have cleaned up the DC before trying to  */
    /* reset it.                                                  */
    /* This means it should have delete any bitmaps, palettes etc */
    /* which may have been selected into it - however just to     */
    /* make sure we will check for the existence of a palette     */
    /* ourselves, and delete it if necessary                      */
    /**************************************************************/
    if (pdc->DCIColFormat == LCOLF_PALETTE)
    {
        haltproc();
        DebugOutput("Reset DC - palette still selected\n\r");

        InnerDeletePalette(pdc->Palette);

        /**************************************************************/
        /* Make sure the palette info in the DC instance is all reset */
        /**************************************************************/
        pdc->Palette      = NULL;
        pdc->DCIColFormat = LCOLF_DEFAULT;
    }
#endif /* FIREWALLS */
#endif /* PALETTE_MGR */

    /******************************************************************/
    /* reset the device context to its created state                  */
    /******************************************************************/
    Result = set_dc_defaults();

    /******************************************************************/
    /* Release driver semaphore                                       */
    /******************************************************************/
    ExitDriver(pdcArg, FUNN_UNKNOWN, EDF_STANDARD | EDF_DONT_CLEAN);
    PROFILE_EXIT(69);
    return(Result);

}
#undef TFUNC
