/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/

/**********************************************************************/
/*                                                                    */
/*   File            = EDDDCONE                                       */
/*                                                                    */
/*   Description     = Display Device Driver Table error constants    */
/*                                                                    */
/*   Function        =                                                */
/*                                                                    */
/*   Reference       = Device Driver Interface Specification          */
/*                                                                    */
/*                                                                    */
/**********************************************************************/


/**********************************************************************/
/* Error codes                                                        */
/**********************************************************************/
#define EDDDERR          800


/**********************************************************************/
/* Dispatch Table Length                                              */
/* old (1.3) length 76 entries                                        */
/* PALETTE_MGR adds 10 new entries                                    */
/* FLOOD_FILL  adds 1 new entry                                       */
/* DRAW_BITS   adds 1 new entry                                       */
/**********************************************************************/
#ifdef PALETTE_MGR
#define PALMGR_ADDS 10
#else /* PALETTE_MGR */
#define PALMGR_ADDS 0
#endif /* PALETTE_MGR */

#ifdef FLOOD_FILL
#define FLOOD_ADDS 1
#else /* FLOOD_FILL */
#define FLOOD_ADDS 0
#endif /* FLOOD_FILL */

#ifdef DRAW_BITS
#define DRAWB_ADDS 1
#else /* DRAW_BITS */
#define DRAWB_ADDS 0
#endif /* DRAW_BITS */

#define DISP_TAB_COPY_LENGTH    (76+PALMGR_ADDS+FLOOD_ADDS+DRAWB_ADDS)

/**********************************************************************/
/* Dispatch Table Positions of functions called by device driver      */
/**********************************************************************/
#define DISP_TAB_CONVERT                      0
#define DISP_TAB_NOTIFYCLIPCHANGE             1
#define DISP_TAB_POLYLINE                     3
#define DISP_TAB_GETCURRENTPOSITION           6
#define DISP_TAB_SETCURRENTPOSITION           7
#define DISP_TAB_BITBLT                      15
#define DISP_TAB_CHARSTRINGPOS               18
#define DISP_TAB_QUERYTEXTBOX                19
#define DISP_TAB_CHARSTRING                  20
#define DISP_TAB_QUERYCHARPOSITIONS          21
#define DISP_TAB_POLYMARKER                  43
#define DISP_TAB_NOTIFYTRANSFORMCHANGE       56
#define DISP_TAB_QUERYWIDTHTABLE             70
#define DISP_TAB_GETCLIPRECTS                72
#define DISP_TAB_DISJOINTLINE                74
#ifdef PALETTE_MGR
#define DISP_TAB_GETVISRECTS                 85
#endif /* PALETTE_MGR */
#ifdef DRAW_BITS
#define DISP_TAB_DRAWBITS                    76+PALMGR_ADDS+FLOOD_ADDS
#endif /* DRAW_BITS */

/**********************************************************************/
/* Number of resident fonts                                           */
/**********************************************************************/
#define MAX_RESIDENT_FONTS  40

/**********************************************************************/
/* max number of codepages expected                                   */
/**********************************************************************/
#define MAX_CODEPAGES 25

/**********************************************************************/
/* number of AA glyphs in each font                                   */
/**********************************************************************/
#define NUM_AA_GLYPHS 316

#ifdef OMIT_RESOURCE_LOADING

/**********************************************************************/
/* ID's given to resident font resources in the resource file         */
/* They are passed to DosGetResource to gain access to the font      */
/**********************************************************************/
#define PMH8_NAMEID    102
#define PMH12_NAMEID   103

#endif
