/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/

/**********************************************************************/
/*                                                                    */
/*   Module          = EDDBSELE                                       */
/*                                                                    */
/*   Description     = Display Device Driver Function :               */
/*                     DeviceSelectBitMap                             */
/*                                                                    */
/*   Function        = Selects a given Bitmap into a given DC         */
/*                                                                    */
/*   Reference       = Winthorn Functional Specification              */
/*                     Device Driver Interface Specification          */
/*                     Display Device Driver Design Specification     */
/*                                                                    */
/*                                                                    */
/**********************************************************************/

#define INCL_DOSSEMAPHORES
#define INCL_DEV
#define INCL_DDIMISC
#define INCL_GRE_DEVSUPPORT
#include <eddinclt.h>

#include <eddbtypt.h>

#include <eddaextf.h>
#include <eddbextf.h>
#include <eddcextf.h>
#include <eddgextf.h>

#include <semaphor.h>






/**********************************************************************/
/*                                                                    */
/* This selects a given bitmap handle into a DC and de-selects any    */
/* currently selected bitmap handle in that DC.                       */
/*                                                                    */
/* If the application gives a null bitmap handle any currently        */
/* selected bitmap handle is still de-selected.                       */
/*                                                                    */
/* The bitmap handle for a bitmap is the address of the bitmap        */
/* list entry as returned by DeviceCreateBitmap                       */
/*                                                                    */
/* The correlation rectangles and conversion factor (for transforming */
/* the y-coord) are also altered                                      */
/*                                                                    */
/**********************************************************************/

DDIENTRY eddb_DeviceSelectBitmap (HDC             hdc,
                                  lpBitmap        ArgHandle,
                                  PDC             pdcArg,
                                  ULONG           FunN)

{
#define TFUNC "eddb_DevSelBmap"

    /******************************************************************/
    /* Local variables                                                */
    /******************************************************************/
    pBitmapHeader        pNewBitmapHeader;/* ptr to new bitmap header */
    SHORT                OldConvFactor;   /* using old bitmap height  */
    USHORT               usLastBpp;

    /******************************************************************/
    /* Get driver semaphore and perform entry checks                  */
    /******************************************************************/
    EnterDriver(pdcArg, FunN, EDF_STANDARD | EDF_DONT_CLEAN);

    /******************************************************************/
    /* If given bitmap handle is not null                             */
    /******************************************************************/
    if (ArgHandle != FNULL)
    {
        /**************************************************************/
        /* The handle we get is the bitmap list entry pointer.        */
        /* complex casting is to avoid compiler warnings              */
        /* pBitmapHeader is only a near pointer                       */
        /**************************************************************/
        pNewBitmapHeader = (pBitmapHeader)ArgHandle;

        /**************************************************************/
        /* If the new handle is the same as the currently selected    */
        /* handle then return (there is nothing to do)                */
        /**************************************************************/
        if (pNewBitmapHeader == pdc->DCISelListEntry)
        {
            goto SELECTBITMAP_OK_EXIT;
        }
    }

    /******************************************************************/
    /* Either the given handle is null or we have a valid bitmap      */
    /* handle. In the latter case, the engine should have ensured     */
    /* that the supplied bitmap is not currently selected into any    */
    /* other DCs.                                                     */
    /******************************************************************/

    /******************************************************************/
    /* De-select any currently selected handle for this DC (and if so */
    /* de-select the DC from that handle)                             */
    /******************************************************************/
    if (pdc->DCIBitmapType != BITMAP_NOT_SELECTED)
    {
        /**************************************************************/
        /* A bitmap is currently selected                             */
        /**************************************************************/
        usLastBpp = pdc->DCISelListEntry->Info.BitCount;

        pdc->DCISelListEntry->DCHandle = FNULL;

        pdc->DCIBitmapType   = BITMAP_NOT_SELECTED;
        pdc->DCISelListEntry = FNULL;
    }
    else
    {
        /**************************************************************/
        /* There was no bpp valid in this bitmap!                     */
        /**************************************************************/
        usLastBpp = 0;
    }

    /******************************************************************/
    /* If we have a valid handle then select it into the DC (and the  */
    /* DC into this handle)                                           */
    /******************************************************************/
    if (ArgHandle != FNULL)
    {
        pNewBitmapHeader->DCHandle = hdc;

        /**************************************************************/
        /* New bitmap is small (no other choice now...)               */
        /**************************************************************/
        pdc->DCIBitmapType = BITMAP_IS_SMALL;

        pdc->DCISelListEntry = pNewBitmapHeader;

        /**************************************************************/
        /* Store the old conversion factor                            */
        /**************************************************************/
        OldConvFactor = pdc->DCIConvFactor;

        /**************************************************************/
        /* Reset the conversion factor                                */
        /**************************************************************/
        pdc->DCIConvFactor = pNewBitmapHeader->Info.Height - (USHORT)1 -
                                                 pdc->DCIOrigin.Y;

        /**************************************************************/
        /* Set the bounding clip rectangle and the current clip       */
        /* rectangle to be the size of the bitmap.                    */
        /**************************************************************/
        pdc->DCIClipNum = 1;

        pdc->DCIClipRects[0].X0 =
        pdc->DCIBoundingClip[0].X = 0;

        pdc->DCIClipRects[0].Y0 =
        pdc->DCIBoundingClip[0].Y = 0;

        pdc->DCIClipRects[0].X1 =
        pdc->DCIBoundingClip[1].X = pNewBitmapHeader->Info.Width - (USHORT)1;

        pdc->DCIClipRects[0].Y1 =
        pdc->DCIBoundingClip[1].Y = pNewBitmapHeader->Info.Height - (USHORT)1;

        pdc->ClipChanged = FALSE;

        pdc->DCIEngineClips = 1;

        /**************************************************************/
        /* Reset the current position in AI coordinates               */
        /**************************************************************/
        pdc->DCICurrPosAI.Y += ( pdc->DCIConvFactor - OldConvFactor );

        /**************************************************************/
        /* Adjust the Pattern Origin                                  */
        /**************************************************************/
        pdc->DCIPatternOrigin.Y += ( pdc->DCIConvFactor -
                                                       OldConvFactor );

        if (pdc->DCISelListEntry->Info.BitCount != usLastBpp)
        {
            /**********************************************************/
            /* The bpp has changed, so we must recalulate all the     */
            /* stored physical color indices in the DC instance.      */
            /**********************************************************/
            eddc_UpdateAttributes();
        }
    }


SELECTBITMAP_OK_EXIT:
    /******************************************************************/
    /* Release driver semaphore                                       */
    /******************************************************************/
    ExitDriver(pdcArg, FunN, EDF_STANDARD | EDF_DONT_CLEAN);
    return(OK);
}
#undef TFUNC
