/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/

/**********************************************************************/
/*                                                                    */
/*   Module File     = EDDBDATA                                       */
/*                                                                    */
/*   Description     = Display Device Driver data for bitmaps         */
/*                                                                    */
/*   Function        =                                                */
/*                                                                    */
/*   Reference       = Display Device Driver Design                   */
/*                                                                    */
/*                                                                    */
/**********************************************************************/


#define INCL_DDIMISC
#define INCL_AFI
#define INCL_AFIEXT
#include <eddinclt.h>
#include <eddbcone.h>
#include <eddccone.h>
#include <eddhcone.h>

#include <eddbtypt.h>
#include <eddhextf.h>

#include <eddfcone.h>
#ifdef VRAMPTR
#include <eddncach.h>
#endif /* VRAMPTR */

#ifdef _8514
#include <8514.h>
#endif

extern PBYTE Colorpat[];

/**********************************************************************/
/* Define the patterns                                                */
/* Note: because someone chose not to have all patterns the same size */
/*       the changes to add new patterns are not that simple          */
/*    changes needed are:                                             */
/*      eddconse.h      change pattern number constants               */
/*      eddhcone.inc    change pattern number constant                */
/*      eddevram.c      change copying of patterns to vram etc        */
/*      eddhcone.h      change DEFAULT_PATTERN_SIZE value             */
/*      eddhbblt.c      accesses newpatterntable                      */
/**********************************************************************/

BYTE  Pattern [DEFAULT_PATTERNS_SIZE] =
    { 0x77,0xFF,0xFF,0xFF,0xDD,0xFF,0xFF,0xFF,  /* PATSYM_DENSE1     */
      0x77, 0xFF, 0xDD, 0xFF,                   /* PATSYM_DENSE2     */
      0x77, 0xDD,                               /* PATSYM_DENSE3     */
      0x77, 0xAA, 0xDD, 0xAA,                   /* PATSYM_DENSE4     */
      0xAA, 0x55,                               /* PATSYM_DENSE5     */
      0x88, 0x55, 0x22, 0x55,                   /* PATSYM_DENSE6     */
      0x88, 0x22,                               /* PATSYM_DENSE7     */
      0x88, 0x00, 0x22, 0x00,                   /* PATSYM_DENSE8     */
      0x88,                                     /* PATSYM_VERT       */
      0xFF, 0x00, 0x00, 0x00,                   /* PATSYM_HORIZ      */
      0x88, 0x11, 0x22, 0x44,                   /* PATSYM_DIAG1      */
      0x81, 0x06, 0x18, 0x60,                   /* PATSYM_DIAG2      */
      0x11, 0x88, 0x44, 0x22,                   /* PATSYM_DIAG3      */
      0x81, 0x60, 0x18, 0x06,                   /* PATSYM_DIAG4      */
      0x00,                                     /* PATSYM_NOSHADE    */
      0xFF,                                     /* PATSYM_SOLID      */
      0x55, 0xAA                                /* PATSYM_HALFTONE   */
#ifdef NEW_PATTERNS
      ,
      0xFF, 0xAA,                               /* PATSYM_HATCH      */
      0x99, 0x99, 0x66, 0x66                    /* PATSYM_DIAGHATCH  */
#endif /* NEW_PATTERNS */
    };

/**********************************************************************/
/* new pattern table, each entry is a bitmap header for use by direct */
/* hardware access.                                                   */
/* Includes entries for dithered pattern and mono dithered pattern    */
/* (hence the NUMBER_PATTERNS + 2)                                    */
/**********************************************************************/
BitmapHeader   NewPatternTable[NUMBER_PATTERNS+2] =
{
#ifdef VRAMPTR
    {Pattern,      FNULL, 8L, 8, 8, 1, 7, 7, 8, 0L, 0, BITMAP_NOT_CACHED },
    {&Pattern[8],  FNULL, 4L, 8, 4, 1, 7, 3, 8, 0L, 0, BITMAP_NOT_CACHED },
    {&Pattern[12], FNULL, 2L, 8, 2, 1, 7, 1, 8, 0L, 0, BITMAP_NOT_CACHED },
    {&Pattern[14], FNULL, 4L, 8, 4, 1, 7, 3, 8, 0L, 0, BITMAP_NOT_CACHED },
    {&Pattern[18], FNULL, 2L, 8, 2, 1, 7, 1, 8, 0L, 0, BITMAP_NOT_CACHED },
    {&Pattern[20], FNULL, 4L, 8, 4, 1, 7, 3, 8, 0L, 0, BITMAP_NOT_CACHED },
    {&Pattern[24], FNULL, 2L, 8, 2, 1, 7, 1, 8, 0L, 0, BITMAP_NOT_CACHED },
    {&Pattern[26], FNULL, 4L, 8, 4, 1, 7, 3, 8, 0L, 0, BITMAP_NOT_CACHED },
    {&Pattern[30], FNULL, 1L, 8, 1, 1, 7, 0, 8, 0L, 0, BITMAP_NOT_CACHED },
    {&Pattern[31], FNULL, 4L, 8, 4, 1, 7, 3, 8, 0L, 0, BITMAP_NOT_CACHED },
    {&Pattern[35], FNULL, 4L, 8, 4, 1, 7, 3, 8, 0L, 0, BITMAP_NOT_CACHED },
    {&Pattern[39], FNULL, 4L, 8, 4, 1, 7, 3, 8, 0L, 0, BITMAP_NOT_CACHED },
    {&Pattern[43], FNULL, 4L, 8, 4, 1, 7, 3, 8, 0L, 0, BITMAP_NOT_CACHED },
    {&Pattern[47], FNULL, 4L, 8, 4, 1, 7, 3, 8, 0L, 0, BITMAP_NOT_CACHED },
    {&Pattern[51], FNULL, 1L, 8, 1, 1, 7, 0, 8, 0L, 0, BITMAP_NOT_CACHED },
    {&Pattern[52], FNULL, 1L, 8, 1, 1, 7, 0, 8, 0L, 0, BITMAP_NOT_CACHED },
    {&Pattern[53], FNULL, 2L, 8, 2, 1, 7, 1, 8, 0L, 0, BITMAP_NOT_CACHED },

#ifdef NEW_PATTERNS
    {&Pattern[55], FNULL, 2L, 8, 2, 1, 7, 1, 8, 0L, 0, BITMAP_NOT_CACHED },
    {&Pattern[57], FNULL, 4L, 8, 4, 1, 7, 3, 8, 0L, 0, BITMAP_NOT_CACHED },
#endif /* NEW_PATTERNS */

    /******************************************************************/
    /* Note that the logical address for the dithered pattern isn't   */
    /* known yet (as it will be put on the locked heap)               */
    /******************************************************************/
    {FNULL,  FNULL,  (LONG)(DITHMATRIX_XSIZE*DITHMATRIX_YSIZE),
     DITHMATRIX_XSIZE, DITHMATRIX_YSIZE, 0,
     DITHMATRIX_XSIZE - 1, DITHMATRIX_YSIZE - 1, 0,
     0L, 0, BITMAP_NOT_CACHED },
    /******************************************************************/
    /* now the mono dithered pattern                                  */
    /******************************************************************/
    {FNULL,  FNULL, MONO_DITHER_BUFFER_SIZE,
     MONODITH_XSIZE, MONODITH_YSIZE, 1,
     MONODITH_XSIZE - 1, MONODITH_YSIZE - 1, 8,
     0L, 0, BITMAP_NOT_CACHED }
#else /* ndef VRAMPTR */
    {Pattern,      FNULL, 8L, 8, 8, 1, 7, 7, 8, 0L, 0 },
    {&Pattern[8],  FNULL, 4L, 8, 4, 1, 7, 3, 8, 0L, 0 },
    {&Pattern[12], FNULL, 2L, 8, 2, 1, 7, 1, 8, 0L, 0 },
    {&Pattern[14], FNULL, 4L, 8, 4, 1, 7, 3, 8, 0L, 0 },
    {&Pattern[18], FNULL, 2L, 8, 2, 1, 7, 1, 8, 0L, 0 },
    {&Pattern[20], FNULL, 4L, 8, 4, 1, 7, 3, 8, 0L, 0 },
    {&Pattern[24], FNULL, 2L, 8, 2, 1, 7, 1, 8, 0L, 0 },
    {&Pattern[26], FNULL, 4L, 8, 4, 1, 7, 3, 8, 0L, 0 },
    {&Pattern[30], FNULL, 1L, 8, 1, 1, 7, 0, 8, 0L, 0 },
    {&Pattern[31], FNULL, 4L, 8, 4, 1, 7, 3, 8, 0L, 0 },
    {&Pattern[35], FNULL, 4L, 8, 4, 1, 7, 3, 8, 0L, 0 },
    {&Pattern[39], FNULL, 4L, 8, 4, 1, 7, 3, 8, 0L, 0 },
    {&Pattern[43], FNULL, 4L, 8, 4, 1, 7, 3, 8, 0L, 0 },
    {&Pattern[47], FNULL, 4L, 8, 4, 1, 7, 3, 8, 0L, 0 },
    {&Pattern[51], FNULL, 1L, 8, 1, 1, 7, 0, 8, 0L, 0 },
    {&Pattern[52], FNULL, 1L, 8, 1, 1, 7, 0, 8, 0L, 0 },
    {&Pattern[53], FNULL, 2L, 8, 2, 1, 7, 1, 8, 0L, 0 },

#ifdef NEW_PATTERNS
    {&Pattern[55], FNULL, 2L, 8, 2, 1, 7, 1, 8, 0L, 0 },
    {&Pattern[57], FNULL, 4L, 8, 4, 1, 7, 3, 8, 0L, 0 },
#endif /* NEW_PATTERNS */

    /******************************************************************/
    /* Note that the logical address for the dithered pattern isn't   */
    /* known yet (as it will be put on the locked heap)               */
    /******************************************************************/
    {FNULL,  FNULL,  (LONG)(DITHMATRIX_XSIZE*DITHMATRIX_YSIZE),
     DITHMATRIX_XSIZE, DITHMATRIX_YSIZE, 0,
     DITHMATRIX_XSIZE - 1, DITHMATRIX_YSIZE - 1, 0,
     0L, 0 },
    /******************************************************************/
    /* now the mono dithered pattern                                  */
    /******************************************************************/
    {FNULL,  FNULL, MONO_DITHER_BUFFER_SIZE,
     MONODITH_XSIZE, MONODITH_YSIZE, 1,
     MONODITH_XSIZE - 1, MONODITH_YSIZE - 1, 8,
     0L, 0 }
#endif /* ndef VRAMPTR */
};

/**********************************************************************/
/* instruction table for three way blts                               */
/* format is:                                                         */
/* BYTE    Source;                                                    */
/* BYTE    Destination;                                               */
/* BYTE    Mix;                                                       */
/* SHORT   BltFunction - index to drawFunctions table                 */
/**********************************************************************/
BltInst Blt3WayInsts[] = {
                     /* 0x00 0 */
   /* not a three-way blt */
   #ifndef   _8514

                     /* 0x01 ~(P OR S OR D) */
   BT_SRC, BT_DEST, HWMIX_NOTSOURCE_AND_NOTDEST, index_SrcDestBlt,
   BT_PAT, BT_DEST, HWMIX_NOTSOURCE_AND_DEST, index_PatDestBlt,

                     /* 0x02 ~(P OR S) AND D */
   BT_SRC, BT_DEST, HWMIX_NOTSOURCE_AND_DEST, index_SrcDestBlt,
   BT_PAT, BT_DEST, HWMIX_NOTSOURCE_AND_DEST, index_PatDestBlt,

                     /* 0x03 ~(P OR S) */
   BT_SRC, BT_DEST, HWMIX_SOURCE, index_SrcDestBlt,
   BT_PAT, BT_DEST, HWMIX_NOTSOURCE_AND_NOTDEST, index_PatDestBlt,

                     /* 0x04 ~(P OR D) AND S */
   BT_SRC, BT_DEST, HWMIX_SOURCE_AND_NOTDEST, index_SrcDestBlt,
   BT_PAT, BT_DEST, HWMIX_NOTSOURCE_AND_DEST, index_PatDestBlt,

                     /* 0x05 ~(P OR D) */
   /* not a three-way blt */

                     /* 0x06 ~(~(S XOR D) OR P) */
   BT_SRC, BT_DEST, HWMIX_SOURCE_XOR_DEST, index_SrcDestBlt,
   BT_PAT, BT_DEST, HWMIX_NOTSOURCE_AND_DEST, index_PatDestBlt,

                     /* 0x07 ~(~(S XOR D) OR P) */
   BT_SRC, BT_DEST, HWMIX_NOTSOURCE_OR_NOTDEST, index_SrcDestBlt,
   BT_PAT, BT_DEST, HWMIX_NOTSOURCE_AND_DEST, index_PatDestBlt,

                     /* 0x08 ~P AND (S AND D) */
   BT_SRC, BT_DEST, HWMIX_SOURCE_AND_DEST, index_SrcDestBlt,
   BT_PAT, BT_DEST, HWMIX_NOTSOURCE_AND_DEST, index_PatDestBlt,

                     /* 0x09 ~P AND ~(S XOR D) */
   BT_SRC, BT_DEST, HWMIX_SOURCE_XOR_NOTDEST, index_SrcDestBlt,
   BT_PAT, BT_DEST, HWMIX_NOTSOURCE_AND_DEST, index_PatDestBlt,

                     /* 0x0a ~P AND D */
   /* not a three-way blt */

                     /* 0x0b ~((~D AND S) OR P) */
   BT_SRC, BT_DEST, HWMIX_NOTSOURCE_OR_DEST, index_SrcDestBlt,
   BT_PAT, BT_DEST, HWMIX_NOTSOURCE_AND_DEST, index_PatDestBlt,

                     /* 0x0c ~P AND S */
   BT_SRC, BT_DEST, HWMIX_SOURCE, index_SrcDestBlt,
   BT_PAT, BT_DEST, HWMIX_NOTSOURCE_AND_DEST, index_PatDestBlt,

                     /* 0x0d ~((~S AND D) OR P) */
   BT_SRC, BT_DEST, HWMIX_SOURCE_OR_NOTDEST, index_SrcDestBlt,
   BT_PAT, BT_DEST, HWMIX_NOTSOURCE_AND_DEST, index_PatDestBlt,

                     /* 0x0e ~(~(S OR D) OR P) */
   BT_SRC, BT_DEST, HWMIX_SOURCE_OR_DEST, index_SrcDestBlt,
   BT_PAT, BT_DEST, HWMIX_NOTSOURCE_AND_DEST, index_PatDestBlt,

                     /* 0x0f ~P */
   /* not a three-way blt */

                     /* 0x10 ~(S OR D) AND P */
   BT_SRC, BT_DEST, HWMIX_SOURCE_OR_DEST, index_SrcDestBlt,
   BT_PAT, BT_DEST, HWMIX_SOURCE_AND_NOTDEST, index_PatDestBlt,

                     /* 0x11 ~(S OR D) */
   /* not a three-way blt */

                     /* 0x12 ~(~(D XOR P) OR S) */
   BT_PAT, BT_DEST, HWMIX_SOURCE_XOR_DEST, index_PatDestBlt,
   BT_SRC, BT_DEST, HWMIX_NOTSOURCE_AND_DEST, index_SrcDestBlt,

                     /* 0x13 ~((D AND P) OR S) */
   BT_PAT, BT_DEST, HWMIX_SOURCE_AND_DEST, index_PatDestBlt,
   BT_SRC, BT_DEST, HWMIX_NOTSOURCE_AND_NOTDEST, index_SrcDestBlt,

                     /* 0x14 ~(~(P XOR S) OR D) */
   BT_SRC, BT_WORK, HWMIX_SOURCE, index_SrcDestBlt,
   BT_PAT, BT_WORK, HWMIX_SOURCE_XOR_DEST, index_PatDestBlt,
   BT_WORK, BT_DEST, HWMIX_SOURCE_AND_NOTDEST, index_SrcDestBlt,

                     /* 0x15 ~((P AND S) OR D) */
   BT_SRC, BT_WORK, HWMIX_SOURCE, index_SrcDestBlt,
   BT_PAT, BT_WORK, HWMIX_NOTSOURCE_OR_NOTDEST, index_PatDestBlt,
   BT_WORK, BT_DEST, HWMIX_SOURCE_AND_NOTDEST, index_SrcDestBlt,

                     /* 0x16 ((~(P AND S) AND D) XOR S) XOR P */
   BT_SRC, BT_WORK, HWMIX_SOURCE, index_SrcDestBlt,
   BT_PAT, BT_WORK, HWMIX_NOTSOURCE_OR_NOTDEST, index_PatDestBlt,
   BT_WORK, BT_DEST, HWMIX_SOURCE_AND_DEST, index_SrcDestBlt,
   BT_SRC, BT_DEST, HWMIX_SOURCE_XOR_DEST, index_SrcDestBlt,
   BT_PAT, BT_DEST, HWMIX_SOURCE_XOR_DEST, index_PatDestBlt,

                     /* 0x17 ~(((D XOR S) AND (S XOR P)) XOR S) */
   BT_SRC, BT_WORK, HWMIX_SOURCE, index_SrcDestBlt,
   BT_PAT, BT_WORK, HWMIX_SOURCE_XOR_DEST, index_PatDestBlt,
   BT_SRC, BT_DEST, HWMIX_SOURCE_XOR_DEST, index_SrcDestBlt,
   BT_WORK, BT_DEST, HWMIX_SOURCE_AND_DEST, index_SrcDestBlt,
   BT_SRC, BT_DEST, HWMIX_SOURCE_XOR_NOTDEST, index_SrcDestBlt,

                     /* 0x18 (P XOR D) AND (S XOR P) */
   BT_SRC, BT_WORK, HWMIX_SOURCE, index_SrcDestBlt,
   BT_PAT, BT_WORK, HWMIX_SOURCE_XOR_DEST, index_PatDestBlt,
   BT_PAT, BT_DEST, HWMIX_SOURCE_XOR_DEST, index_PatDestBlt,
   BT_WORK, BT_DEST, HWMIX_SOURCE_AND_DEST, index_SrcDestBlt,

                     /* 0x19 ~((~(P AND S) AND D) XOR S) */
   BT_SRC, BT_WORK, HWMIX_SOURCE, index_SrcDestBlt,
   BT_PAT, BT_WORK, HWMIX_NOTSOURCE_OR_NOTDEST, index_PatDestBlt,
   BT_WORK, BT_DEST, HWMIX_SOURCE_AND_DEST, index_SrcDestBlt,
   BT_SRC, BT_DEST, HWMIX_SOURCE_XOR_NOTDEST, index_SrcDestBlt,

                     /* 0x1a ((P AND S) OR D) XOR P */
   BT_SRC, BT_WORK, HWMIX_SOURCE, index_SrcDestBlt,
   BT_PAT, BT_WORK, HWMIX_SOURCE_AND_DEST, index_PatDestBlt,
   BT_WORK, BT_DEST, HWMIX_SOURCE_OR_DEST, index_SrcDestBlt,
   BT_PAT, BT_DEST, HWMIX_SOURCE_XOR_DEST, index_PatDestBlt,

                     /* 0x1b ~(((P XOR S) AND D) XOR S) */
   BT_SRC, BT_WORK, HWMIX_SOURCE, index_SrcDestBlt,
   BT_PAT, BT_WORK, HWMIX_SOURCE_XOR_DEST, index_PatDestBlt,
   BT_WORK, BT_DEST, HWMIX_SOURCE_AND_DEST, index_SrcDestBlt,
   BT_SRC, BT_DEST, HWMIX_SOURCE_XOR_NOTDEST, index_SrcDestBlt,

                     /* 0x1c ((P AND D) OR S) XOR P */
   BT_PAT, BT_DEST, HWMIX_SOURCE_AND_DEST, index_PatDestBlt,
   BT_SRC, BT_DEST, HWMIX_SOURCE_OR_DEST, index_SrcDestBlt,
   BT_PAT, BT_DEST, HWMIX_SOURCE_XOR_DEST, index_PatDestBlt,

                     /* 0x1d ~(((P XOR D) AND S) XOR D) */
   BT_DEST, BT_WORK, HWMIX_SOURCE, index_SrcDestBlt,
   BT_PAT, BT_WORK, HWMIX_SOURCE_XOR_DEST, index_PatDestBlt,
   BT_SRC, BT_WORK, HWMIX_SOURCE_AND_DEST, index_SrcDestBlt,
   BT_WORK, BT_DEST, HWMIX_SOURCE_XOR_NOTDEST, index_SrcDestBlt,

                     /* 0x1e (S OR D) XOR P */
   BT_SRC, BT_DEST, HWMIX_SOURCE_OR_DEST, index_SrcDestBlt,
   BT_PAT, BT_DEST, HWMIX_SOURCE_XOR_DEST, index_PatDestBlt,

                     /* 0x1f ~((S OR D) AND P) */
   BT_SRC, BT_DEST, HWMIX_SOURCE_OR_DEST, index_SrcDestBlt,
   BT_PAT, BT_DEST, HWMIX_NOTSOURCE_OR_NOTDEST, index_PatDestBlt,

                     /* 0x20 ~S AND P AND D */
   BT_SRC, BT_DEST, HWMIX_NOTSOURCE_AND_DEST, index_SrcDestBlt,
   BT_PAT, BT_DEST, HWMIX_SOURCE_AND_DEST, index_PatDestBlt,

                     /* 0x21 ~((D XOR P) OR S) */
   BT_PAT, BT_DEST, HWMIX_SOURCE_XOR_DEST, index_PatDestBlt,
   BT_SRC, BT_DEST, HWMIX_NOTSOURCE_AND_NOTDEST, index_SrcDestBlt,

                     /* 0x22 ~S AND D */
   /* not a three-way blt */

                     /* 0x23 ~((~D AND P) OR S) */
   BT_PAT, BT_DEST, HWMIX_SOURCE_AND_NOTDEST, index_PatDestBlt,
   BT_SRC, BT_DEST, HWMIX_NOTSOURCE_AND_NOTDEST, index_SrcDestBlt,

                     /* 0x24 (S XOR P) AND (S XOR D) */
   BT_SRC, BT_WORK, HWMIX_SOURCE, index_SrcDestBlt,
   BT_PAT, BT_WORK, HWMIX_SOURCE_XOR_DEST, index_PatDestBlt,
   BT_SRC, BT_DEST, HWMIX_SOURCE_XOR_DEST, index_SrcDestBlt,
   BT_WORK, BT_DEST, HWMIX_SOURCE_AND_DEST, index_SrcDestBlt,

                     /* 0x25 ~((~(P AND S) AND D) XOR P) */
   BT_SRC, BT_WORK, HWMIX_SOURCE, index_SrcDestBlt,
   BT_PAT, BT_WORK, HWMIX_NOTSOURCE_OR_NOTDEST, index_PatDestBlt,
   BT_WORK, BT_DEST, HWMIX_SOURCE_AND_DEST, index_SrcDestBlt,
   BT_PAT, BT_DEST, HWMIX_SOURCE_XOR_NOTDEST, index_PatDestBlt,

                     /* 0x26 ((P AND S) OR D) XOR S */
   BT_SRC, BT_WORK, HWMIX_SOURCE, index_SrcDestBlt,
   BT_PAT, BT_WORK, HWMIX_SOURCE_AND_DEST, index_PatDestBlt,
   BT_WORK, BT_DEST, HWMIX_SOURCE_OR_DEST, index_SrcDestBlt,
   BT_SRC, BT_DEST, HWMIX_SOURCE_XOR_DEST, index_SrcDestBlt,

                     /* 0x27 (~(P XOR S) OR D) XOR S */
   BT_SRC, BT_WORK, HWMIX_SOURCE, index_SrcDestBlt,
   BT_PAT, BT_WORK, HWMIX_SOURCE_XOR_NOTDEST, index_PatDestBlt,
   BT_WORK, BT_DEST, HWMIX_SOURCE_OR_DEST, index_SrcDestBlt,
   BT_SRC, BT_DEST, HWMIX_SOURCE_XOR_DEST, index_SrcDestBlt,

                     /* 0x28 (P XOR S) AND D */
   BT_SRC, BT_WORK, HWMIX_SOURCE, index_SrcDestBlt,
   BT_PAT, BT_WORK, HWMIX_SOURCE_XOR_DEST, index_PatDestBlt,
   BT_WORK, BT_DEST, HWMIX_SOURCE_AND_DEST, index_SrcDestBlt,

                     /* 0x29 ~((((P AND S) OR D) XOR S) XOR P) */
   BT_SRC, BT_WORK, HWMIX_SOURCE, index_SrcDestBlt,
   BT_PAT, BT_WORK, HWMIX_SOURCE_AND_DEST, index_PatDestBlt,
   BT_WORK, BT_DEST, HWMIX_SOURCE_OR_DEST, index_SrcDestBlt,
   BT_SRC, BT_DEST, HWMIX_SOURCE_XOR_DEST, index_SrcDestBlt,
   BT_PAT, BT_DEST, HWMIX_SOURCE_XOR_NOTDEST, index_PatDestBlt,

                     /* 0x2a ~(P AND S) AND D */
   BT_SRC, BT_WORK, HWMIX_SOURCE, index_SrcDestBlt,
   BT_PAT, BT_WORK, HWMIX_NOTSOURCE_OR_NOTDEST, index_PatDestBlt,
   BT_WORK, BT_DEST, HWMIX_SOURCE_AND_DEST, index_SrcDestBlt,

                     /* 0x2b ~(((P XOR S) AND (P XOR D)) XOR S) */
   BT_SRC, BT_WORK, HWMIX_SOURCE, index_SrcDestBlt,
   BT_PAT, BT_WORK, HWMIX_SOURCE_XOR_DEST, index_PatDestBlt,
   BT_PAT, BT_DEST, HWMIX_SOURCE_XOR_DEST, index_PatDestBlt,
   BT_WORK, BT_DEST, HWMIX_SOURCE_AND_DEST, index_SrcDestBlt,
   BT_SRC, BT_DEST, HWMIX_SOURCE_XOR_NOTDEST, index_SrcDestBlt,

                     /* 0x2c ((D OR S) AND P) XOR S */
   BT_SRC, BT_DEST, HWMIX_SOURCE_OR_DEST, index_SrcDestBlt,
   BT_PAT, BT_DEST, HWMIX_SOURCE_AND_DEST, index_PatDestBlt,
   BT_SRC, BT_DEST, HWMIX_SOURCE_XOR_DEST, index_SrcDestBlt,

                     /* 0x2d (~D OR S) XOR P */
   BT_SRC, BT_DEST, HWMIX_SOURCE_OR_NOTDEST, index_SrcDestBlt,
   BT_PAT, BT_DEST, HWMIX_SOURCE_XOR_DEST, index_PatDestBlt,

                     /* 0x2e ((P XOR D) OR S) XOR P */
   BT_PAT, BT_DEST, HWMIX_SOURCE_XOR_DEST, index_PatDestBlt,
   BT_SRC, BT_DEST, HWMIX_SOURCE_OR_DEST, index_SrcDestBlt,
   BT_PAT, BT_DEST, HWMIX_SOURCE_XOR_DEST, index_PatDestBlt,

                     /* 0x2f ~((~D OR S) AND P) */
   BT_SRC, BT_DEST, HWMIX_SOURCE_OR_NOTDEST, index_SrcDestBlt,
   BT_PAT, BT_DEST, HWMIX_NOTSOURCE_OR_NOTDEST, index_PatDestBlt,

                     /* 0x30 ~S AND P */
   BT_SRC, BT_DEST, HWMIX_SOURCE, index_SrcDestBlt,
   BT_PAT, BT_DEST, HWMIX_SOURCE_AND_NOTDEST, index_PatDestBlt,

                     /* 0x31 ~((~P AND D) OR S) */
   BT_PAT, BT_DEST, HWMIX_NOTSOURCE_AND_DEST, index_PatDestBlt,
   BT_SRC, BT_DEST, HWMIX_NOTSOURCE_AND_NOTDEST, index_SrcDestBlt,

                     /* 0x32 ((P OR S) OR D) XOR S */
   BT_PAT, BT_DEST, HWMIX_SOURCE_OR_DEST, index_PatDestBlt,
   BT_SRC, BT_DEST, HWMIX_SOURCE_OR_DEST, index_SrcDestBlt,
   BT_SRC, BT_DEST, HWMIX_SOURCE_XOR_DEST, index_SrcDestBlt,

                     /* 0x33 ~S AND D */
   /* not a three-way blt */

                     /* 0x34 ((S AND D) OR P) XOR S */
   BT_SRC, BT_DEST, HWMIX_SOURCE_AND_DEST, index_SrcDestBlt,
   BT_PAT, BT_DEST, HWMIX_SOURCE_OR_DEST, index_PatDestBlt,
   BT_SRC, BT_DEST, HWMIX_SOURCE_XOR_DEST, index_SrcDestBlt,

                     /* 0x35 (~(S XOR D) OR P) XOR S */
   BT_SRC, BT_DEST, HWMIX_SOURCE_XOR_NOTDEST, index_SrcDestBlt,
   BT_PAT, BT_DEST, HWMIX_SOURCE_OR_DEST, index_PatDestBlt,
   BT_SRC, BT_DEST, HWMIX_SOURCE_XOR_DEST, index_SrcDestBlt,

                     /* 0x36 (P OR D) XOR S */
   BT_PAT, BT_DEST, HWMIX_SOURCE_OR_DEST, index_PatDestBlt,
   BT_SRC, BT_DEST, HWMIX_SOURCE_XOR_DEST, index_SrcDestBlt,

                     /* 0x37 ~((P OR D) AND S) */
   BT_PAT, BT_DEST, HWMIX_SOURCE_OR_DEST, index_PatDestBlt,
   BT_SRC, BT_DEST, HWMIX_NOTSOURCE_OR_NOTDEST, index_SrcDestBlt,

                     /* 0x38 ((P OR D) AND S) XOR P */
   BT_PAT, BT_DEST, HWMIX_SOURCE_OR_DEST, index_PatDestBlt,
   BT_SRC, BT_DEST, HWMIX_SOURCE_AND_DEST, index_SrcDestBlt,
   BT_PAT, BT_DEST, HWMIX_SOURCE_XOR_DEST, index_PatDestBlt,

                     /* 0x39 (P OR ~D) XOR S */
   BT_PAT, BT_DEST, HWMIX_SOURCE_OR_NOTDEST, index_PatDestBlt,
   BT_SRC, BT_DEST, HWMIX_SOURCE_XOR_DEST, index_SrcDestBlt,

                     /* 0x3a ((S XOR D) OR P) XOR S */
   BT_SRC, BT_DEST, HWMIX_SOURCE_XOR_DEST, index_SrcDestBlt,
   BT_PAT, BT_DEST, HWMIX_SOURCE_OR_DEST, index_PatDestBlt,
   BT_SRC, BT_DEST, HWMIX_SOURCE_XOR_DEST, index_SrcDestBlt,

                     /* 0x3b ~((P OR ~D) AND S) */
   BT_PAT, BT_DEST, HWMIX_SOURCE_OR_NOTDEST, index_PatDestBlt,
   BT_SRC, BT_DEST, HWMIX_NOTSOURCE_OR_NOTDEST, index_SrcDestBlt,

                     /* 0x3c P XOR S */
   BT_SRC, BT_DEST, HWMIX_SOURCE, index_SrcDestBlt,
   BT_PAT, BT_DEST, HWMIX_SOURCE_XOR_DEST, index_PatDestBlt,

                     /* 0x3d (~(S OR D) OR P) XOR S */
   BT_SRC, BT_DEST, HWMIX_NOTSOURCE_AND_NOTDEST, index_SrcDestBlt,
   BT_PAT, BT_DEST, HWMIX_SOURCE_OR_DEST, index_PatDestBlt,
   BT_SRC, BT_DEST, HWMIX_SOURCE_XOR_DEST, index_SrcDestBlt,

                     /* 0x3e ((~S AND D) OR P) XOR S */
   BT_SRC, BT_DEST, HWMIX_NOTSOURCE_AND_DEST, index_SrcDestBlt,
   BT_PAT, BT_DEST, HWMIX_SOURCE_OR_DEST, index_PatDestBlt,
   BT_SRC, BT_DEST, HWMIX_SOURCE_XOR_DEST, index_SrcDestBlt,

                     /* 0x3f ~(P AND S) */
   BT_SRC, BT_DEST, HWMIX_SOURCE, index_SrcDestBlt,
   BT_PAT, BT_DEST, HWMIX_NOTSOURCE_OR_NOTDEST, index_PatDestBlt,

                     /* 0x40 P AND S AND ~D */
   BT_SRC, BT_DEST, HWMIX_SOURCE_AND_NOTDEST, index_SrcDestBlt,
   BT_PAT, BT_DEST, HWMIX_SOURCE_AND_DEST, index_PatDestBlt,

                     /* 0x41 ~((P XOR S) OR D) */
   BT_SRC, BT_WORK, HWMIX_SOURCE, index_SrcDestBlt,
   BT_PAT, BT_WORK, HWMIX_SOURCE_XOR_DEST, index_PatDestBlt,
   BT_WORK, BT_DEST, HWMIX_NOTSOURCE_AND_NOTDEST, index_SrcDestBlt,

                     /* 0x42 (S XOR D) AND (P XOR D) */
   BT_SRC, BT_WORK, HWMIX_SOURCE, index_SrcDestBlt,
   BT_DEST, BT_WORK, HWMIX_SOURCE_XOR_DEST, index_SrcDestBlt,
   BT_PAT, BT_DEST, HWMIX_SOURCE_XOR_DEST, index_PatDestBlt,
   BT_WORK, BT_DEST, HWMIX_SOURCE_AND_DEST, index_SrcDestBlt,

                     /* 0x43 ~((~(S AND D) AND P) XOR S) */
   BT_SRC, BT_DEST, HWMIX_NOTSOURCE_OR_NOTDEST, index_SrcDestBlt,
   BT_PAT, BT_DEST, HWMIX_SOURCE_AND_DEST, index_PatDestBlt,
   BT_SRC, BT_DEST, HWMIX_SOURCE_XOR_NOTDEST, index_SrcDestBlt,

                     /* 0x44 ~D AND S */
   /* not a three-way blt */

                     /* 0x45 ~((~S AND P) OR D) */
   BT_SRC, BT_WORK, HWMIX_SOURCE, index_SrcDestBlt,
   BT_PAT, BT_WORK, HWMIX_SOURCE_AND_NOTDEST, index_PatDestBlt,
   BT_WORK, BT_DEST, HWMIX_NOTSOURCE_AND_NOTDEST, index_SrcDestBlt,

                     /* 0x46 ((D AND P) OR S) XOR D */
   BT_DEST, BT_WORK, HWMIX_SOURCE, index_SrcDestBlt,
   BT_PAT, BT_WORK, HWMIX_SOURCE_AND_DEST, index_PatDestBlt,
   BT_SRC, BT_WORK, HWMIX_SOURCE_OR_DEST, index_SrcDestBlt,
   BT_WORK, BT_DEST, HWMIX_SOURCE_XOR_DEST, index_SrcDestBlt,

                     /* 0x47 ~((D XOR P) AND S) XOR P) */
   BT_PAT, BT_DEST, HWMIX_SOURCE_XOR_DEST, index_PatDestBlt,
   BT_SRC, BT_DEST, HWMIX_SOURCE_AND_DEST, index_SrcDestBlt,
   BT_PAT, BT_DEST, HWMIX_SOURCE_XOR_NOTDEST, index_PatDestBlt,

                     /* 0x48 (D XOR P) AND S */
   BT_PAT, BT_DEST, HWMIX_SOURCE_XOR_DEST, index_PatDestBlt,
   BT_SRC, BT_DEST, HWMIX_SOURCE_AND_DEST, index_SrcDestBlt,

                     /* 0x49 ~((((D AND P) OR S) XOR D) XOR P) */
   BT_DEST, BT_WORK, HWMIX_SOURCE, index_SrcDestBlt,
   BT_PAT, BT_WORK, HWMIX_SOURCE_AND_DEST, index_PatDestBlt,
   BT_SRC, BT_WORK, HWMIX_SOURCE_OR_DEST, index_SrcDestBlt,
   BT_WORK, BT_DEST, HWMIX_SOURCE_XOR_DEST, index_SrcDestBlt,
   BT_PAT, BT_DEST, HWMIX_SOURCE_XOR_NOTDEST, index_PatDestBlt,

                     /* 0x4a ((S OR D) AND P) XOR D */
   BT_DEST, BT_WORK, HWMIX_SOURCE, index_SrcDestBlt,
   BT_SRC, BT_WORK, HWMIX_SOURCE_OR_DEST, index_SrcDestBlt,
   BT_PAT, BT_WORK, HWMIX_SOURCE_AND_DEST, index_PatDestBlt,
   BT_WORK, BT_DEST, HWMIX_SOURCE_XOR_DEST, index_SrcDestBlt,

                     /* 0x4b (~S OR D) XOR P */
   BT_SRC, BT_DEST, HWMIX_NOTSOURCE_OR_DEST, index_SrcDestBlt,
   BT_PAT, BT_DEST, HWMIX_SOURCE_XOR_DEST, index_PatDestBlt,

                     /* 0x4c ~(P AND D) AND S */
   BT_PAT, BT_DEST, HWMIX_NOTSOURCE_OR_NOTDEST, index_PatDestBlt,
   BT_SRC, BT_DEST, HWMIX_SOURCE_AND_DEST, index_SrcDestBlt,

                     /* 0x4d ~(((S XOR P) OR (D XOR S)) XOR S) */
   BT_SRC, BT_WORK, HWMIX_SOURCE, index_SrcDestBlt,
   BT_PAT, BT_WORK, HWMIX_SOURCE_XOR_DEST, index_PatDestBlt,
   BT_SRC, BT_DEST, HWMIX_SOURCE_XOR_DEST, index_SrcDestBlt,
   BT_WORK, BT_DEST, HWMIX_SOURCE_OR_DEST, index_SrcDestBlt,
   BT_SRC, BT_DEST, HWMIX_SOURCE_XOR_NOTDEST, index_SrcDestBlt,

                     /* 0x4e ((P XOR S) OR D) XOR P */
   BT_SRC, BT_WORK, HWMIX_SOURCE, index_SrcDestBlt,
   BT_PAT, BT_WORK, HWMIX_SOURCE_XOR_DEST, index_PatDestBlt,
   BT_WORK, BT_DEST, HWMIX_SOURCE_OR_DEST, index_SrcDestBlt,
   BT_PAT, BT_DEST, HWMIX_SOURCE_XOR_DEST, index_PatDestBlt,

                     /* 0x4f ~((~S OR D) AND P) */
   BT_SRC, BT_DEST, HWMIX_NOTSOURCE_OR_DEST, index_SrcDestBlt,
   BT_PAT, BT_DEST, HWMIX_NOTSOURCE_OR_NOTDEST, index_PatDestBlt,

                     /* 0x50 ~D AND P */
   /* not a three-way blt */

                     /* 0x51 ~((~P AND S) OR D) */
   BT_SRC, BT_WORK, HWMIX_SOURCE, index_SrcDestBlt,
   BT_PAT, BT_WORK, HWMIX_NOTSOURCE_AND_DEST, index_PatDestBlt,
   BT_WORK, BT_DEST, HWMIX_NOTSOURCE_AND_NOTDEST, index_SrcDestBlt,

                     /* 0x52 ((S AND D) OR P) XOR D */
   BT_SRC, BT_WORK, HWMIX_SOURCE, index_SrcDestBlt,
   BT_DEST, BT_WORK, HWMIX_SOURCE_AND_DEST, index_SrcDestBlt,
   BT_PAT, BT_WORK, HWMIX_SOURCE_OR_DEST, index_PatDestBlt,
   BT_WORK, BT_DEST, HWMIX_SOURCE_XOR_DEST, index_SrcDestBlt,

                     /* 0x53 ~(((S XOR D) AND P) XOR S) */
   BT_SRC, BT_DEST, HWMIX_SOURCE_XOR_DEST, index_SrcDestBlt,
   BT_PAT, BT_DEST, HWMIX_SOURCE_AND_DEST, index_PatDestBlt,
   BT_SRC, BT_DEST, HWMIX_SOURCE_XOR_NOTDEST, index_SrcDestBlt,

                     /* 0x54 ~(~(S OR P) OR D) */
   BT_SRC, BT_WORK, HWMIX_SOURCE, index_SrcDestBlt,
   BT_PAT, BT_WORK, HWMIX_NOTSOURCE_AND_NOTDEST, index_PatDestBlt,
   BT_WORK, BT_DEST, HWMIX_NOTSOURCE_AND_NOTDEST, index_SrcDestBlt,

                     /* 0x55 ~D */
   /* not a three-way blt */

                     /* 0x56 (S OR P) XOR D */
   BT_SRC, BT_WORK, HWMIX_SOURCE, index_SrcDestBlt,
   BT_PAT, BT_WORK, HWMIX_SOURCE_OR_DEST, index_PatDestBlt,
   BT_WORK, BT_DEST, HWMIX_SOURCE_XOR_DEST, index_SrcDestBlt,

                     /* 0x57 ~((S OR P) AND D) */
   BT_SRC, BT_WORK, HWMIX_SOURCE, index_SrcDestBlt,
   BT_PAT, BT_WORK, HWMIX_SOURCE_OR_DEST, index_PatDestBlt,
   BT_WORK, BT_DEST, HWMIX_NOTSOURCE_OR_NOTDEST, index_SrcDestBlt,

                     /* 0x58 ((S OR P) AND D) XOR P */
   BT_SRC, BT_WORK, HWMIX_SOURCE, index_SrcDestBlt,
   BT_PAT, BT_WORK, HWMIX_SOURCE_OR_DEST, index_PatDestBlt,
   BT_WORK, BT_DEST, HWMIX_SOURCE_AND_DEST, index_SrcDestBlt,
   BT_PAT, BT_DEST, HWMIX_SOURCE_XOR_DEST, index_PatDestBlt,

                     /* 0x59 (~S OR P) XOR D */
   BT_SRC, BT_WORK, HWMIX_SOURCE, index_SrcDestBlt,
   BT_PAT, BT_WORK, HWMIX_SOURCE_OR_NOTDEST, index_PatDestBlt,
   BT_WORK, BT_DEST, HWMIX_SOURCE_XOR_DEST, index_SrcDestBlt,

                     /* 0x5a D XOR P */
   /* not a three-way blt */

                     /* 0x5b (~(S OR D) OR P) XOR D */
   BT_SRC, BT_WORK, HWMIX_SOURCE, index_SrcDestBlt,
   BT_DEST, BT_WORK, HWMIX_NOTSOURCE_AND_NOTDEST, index_SrcDestBlt,
   BT_PAT, BT_WORK, HWMIX_SOURCE_OR_DEST, index_PatDestBlt,
   BT_WORK, BT_DEST, HWMIX_SOURCE_XOR_DEST, index_SrcDestBlt,

                     /* 0x5c ((S XOR D) OR P) XOR D */
   BT_SRC, BT_WORK, HWMIX_SOURCE, index_SrcDestBlt,
   BT_DEST, BT_WORK, HWMIX_SOURCE_XOR_DEST, index_SrcDestBlt,
   BT_PAT, BT_WORK, HWMIX_SOURCE_OR_DEST, index_PatDestBlt,
   BT_WORK, BT_DEST, HWMIX_SOURCE_XOR_DEST, index_SrcDestBlt,

                     /* 0x5d ~((~S OR P) AND D) */
   BT_SRC, BT_WORK, HWMIX_SOURCE, index_SrcDestBlt,
   BT_PAT, BT_WORK, HWMIX_SOURCE_OR_NOTDEST, index_PatDestBlt,
   BT_WORK, BT_DEST, HWMIX_NOTSOURCE_OR_NOTDEST, index_SrcDestBlt,

                     /* 0x5e ((~D AND S) OR P) XOR D */
   BT_SRC, BT_WORK, HWMIX_SOURCE, index_SrcDestBlt,
   BT_DEST, BT_WORK, HWMIX_NOTSOURCE_AND_DEST, index_SrcDestBlt,
   BT_PAT, BT_WORK, HWMIX_SOURCE_OR_DEST, index_PatDestBlt,
   BT_WORK, BT_DEST, HWMIX_SOURCE_XOR_DEST, index_SrcDestBlt,

                     /* 0x5f ~(D AND P) */
   /* not a three-way blt */

                     /* 0x60 (S XOR D) AND P  */
   BT_SRC, BT_DEST, HWMIX_SOURCE_XOR_DEST, index_SrcDestBlt,
   BT_PAT, BT_DEST, HWMIX_SOURCE_AND_DEST, index_PatDestBlt,

                     /* 0x61 ~((((D AND S) OR P) XOR S) XOR D) */
   BT_SRC, BT_WORK, HWMIX_SOURCE, index_SrcDestBlt,
   BT_DEST, BT_WORK, HWMIX_SOURCE_AND_DEST, index_SrcDestBlt,
   BT_PAT, BT_WORK, HWMIX_SOURCE_OR_DEST, index_PatDestBlt,
   BT_SRC, BT_WORK, HWMIX_SOURCE_XOR_DEST, index_SrcDestBlt,
   BT_WORK, BT_DEST, HWMIX_SOURCE_XOR_NOTDEST, index_SrcDestBlt,

                     /* 0x62 ((D OR P) AND S) XOR D */
   BT_DEST, BT_WORK, HWMIX_SOURCE, index_SrcDestBlt,
   BT_PAT, BT_WORK, HWMIX_SOURCE_OR_DEST, index_PatDestBlt,
   BT_SRC, BT_WORK, HWMIX_SOURCE_AND_DEST, index_SrcDestBlt,
   BT_WORK, BT_DEST, HWMIX_SOURCE_XOR_DEST, index_SrcDestBlt,

                     /* 0x63 (D OR ~P) XOR S */
   BT_PAT, BT_DEST, HWMIX_NOTSOURCE_OR_DEST, index_PatDestBlt,
   BT_SRC, BT_DEST, HWMIX_SOURCE_XOR_DEST, index_SrcDestBlt,

                     /* 0x64 ((S OR P) AND D) XOR S */
   BT_SRC, BT_WORK, HWMIX_SOURCE, index_SrcDestBlt,
   BT_PAT, BT_WORK, HWMIX_SOURCE_OR_DEST, index_PatDestBlt,
   BT_WORK, BT_DEST, HWMIX_SOURCE_AND_DEST, index_SrcDestBlt,
   BT_SRC, BT_DEST, HWMIX_SOURCE_XOR_DEST, index_SrcDestBlt,

                     /* 0x65 (S OR ~P) XOR D */
   BT_SRC, BT_WORK, HWMIX_SOURCE, index_SrcDestBlt,
   BT_PAT, BT_WORK, HWMIX_NOTSOURCE_OR_DEST, index_PatDestBlt,
   BT_WORK, BT_DEST, HWMIX_SOURCE_XOR_DEST, index_SrcDestBlt,

                     /* 0x66 D XOR S */
   /* not a three-way blt */

                     /* 0x67 (~(S OR P) OR D) XOR S */
   BT_SRC, BT_WORK, HWMIX_SOURCE, index_SrcDestBlt,
   BT_PAT, BT_WORK, HWMIX_NOTSOURCE_AND_NOTDEST, index_PatDestBlt,
   BT_WORK, BT_DEST, HWMIX_SOURCE_OR_DEST, index_SrcDestBlt,
   BT_SRC, BT_DEST, HWMIX_SOURCE_XOR_DEST, index_SrcDestBlt,

                     /* 0x68 ~(((~(S OR D) OR P) XOR S) XOR D) */
   BT_SRC, BT_WORK, HWMIX_SOURCE, index_SrcDestBlt,
   BT_DEST, BT_WORK, HWMIX_NOTSOURCE_AND_NOTDEST, index_SrcDestBlt,
   BT_PAT, BT_WORK, HWMIX_SOURCE_OR_DEST, index_PatDestBlt,
   BT_SRC, BT_WORK, HWMIX_SOURCE_XOR_DEST, index_SrcDestBlt,
   BT_WORK, BT_DEST, HWMIX_SOURCE_XOR_NOTDEST, index_SrcDestBlt,

                     /* 0x69 ~((S XOR D) XOR P) */
   BT_SRC, BT_DEST, HWMIX_SOURCE_XOR_DEST, index_SrcDestBlt,
   BT_PAT, BT_DEST, HWMIX_SOURCE_XOR_NOTDEST, index_PatDestBlt,

                     /* 0x6a (P AND S) XOR D */
   BT_SRC, BT_WORK, HWMIX_SOURCE, index_SrcDestBlt,
   BT_PAT, BT_WORK, HWMIX_SOURCE_AND_DEST, index_PatDestBlt,
   BT_WORK, BT_DEST, HWMIX_SOURCE_XOR_DEST, index_SrcDestBlt,

                     /* 0x6b ~((((P OR S) AND D) XOR S) XOR P) */
   BT_SRC, BT_WORK, HWMIX_SOURCE, index_SrcDestBlt,
   BT_PAT, BT_WORK, HWMIX_SOURCE_OR_DEST, index_PatDestBlt,
   BT_WORK, BT_DEST, HWMIX_SOURCE_AND_DEST, index_SrcDestBlt,
   BT_SRC, BT_DEST, HWMIX_SOURCE_XOR_DEST, index_SrcDestBlt,
   BT_PAT, BT_DEST, HWMIX_SOURCE_XOR_NOTDEST, index_PatDestBlt,

                     /* 0x6c (P AND D) XOR S */
   BT_PAT, BT_DEST, HWMIX_SOURCE_AND_DEST, index_PatDestBlt,
   BT_SRC, BT_DEST, HWMIX_SOURCE_XOR_DEST, index_SrcDestBlt,

                     /* 0x6d ~((((P OR D) AND S) XOR D) XOR P) */
   BT_DEST, BT_WORK, HWMIX_SOURCE, index_SrcDestBlt,
   BT_PAT, BT_WORK, HWMIX_SOURCE_OR_DEST, index_PatDestBlt,
   BT_SRC, BT_WORK, HWMIX_SOURCE_AND_DEST, index_SrcDestBlt,
   BT_WORK, BT_DEST, HWMIX_SOURCE_XOR_DEST, index_SrcDestBlt,
   BT_PAT, BT_DEST, HWMIX_SOURCE_XOR_NOTDEST, index_PatDestBlt,

                     /* 0x6e ((~S OR P) AND D) XOR S */
   BT_SRC, BT_WORK, HWMIX_SOURCE, index_SrcDestBlt,
   BT_PAT, BT_WORK, HWMIX_SOURCE_OR_NOTDEST, index_PatDestBlt,
   BT_WORK, BT_DEST, HWMIX_SOURCE_AND_DEST, index_SrcDestBlt,
   BT_SRC, BT_DEST, HWMIX_SOURCE_XOR_DEST, index_SrcDestBlt,

                     /* 0x6f ~(~(S XOR D) AND P) */
   BT_SRC, BT_DEST, HWMIX_SOURCE_XOR_NOTDEST, index_SrcDestBlt,
   BT_PAT, BT_DEST, HWMIX_NOTSOURCE_OR_NOTDEST, index_PatDestBlt,

                     /* 0x70 ~(S AND D) AND P */
   BT_SRC, BT_DEST, HWMIX_NOTSOURCE_OR_NOTDEST, index_SrcDestBlt,
   BT_PAT, BT_DEST, HWMIX_SOURCE_AND_DEST, index_PatDestBlt,

                     /* 0x71 ~((S XOR D) AND (P XOR D) XOR S) */
   BT_DEST, BT_WORK, HWMIX_SOURCE, index_SrcDestBlt,
   BT_PAT, BT_WORK, HWMIX_SOURCE_XOR_DEST, index_PatDestBlt,
   BT_SRC, BT_DEST, HWMIX_SOURCE_XOR_DEST, index_SrcDestBlt,
   BT_WORK, BT_DEST, HWMIX_SOURCE_AND_DEST, index_SrcDestBlt,
   BT_SRC, BT_DEST, HWMIX_SOURCE_XOR_NOTDEST, index_SrcDestBlt,

                     /* 0x72 ((S XOR P) OR D) XOR S */
   BT_SRC, BT_WORK, HWMIX_SOURCE, index_SrcDestBlt,
   BT_PAT, BT_WORK, HWMIX_SOURCE_XOR_DEST, index_PatDestBlt,
   BT_WORK, BT_DEST, HWMIX_SOURCE_OR_DEST, index_SrcDestBlt,
   BT_SRC, BT_DEST, HWMIX_SOURCE_XOR_DEST, index_SrcDestBlt,

                     /* 0x73 ~((~P OR D) AND S) */
   BT_PAT, BT_DEST, HWMIX_NOTSOURCE_OR_DEST, index_PatDestBlt,
   BT_SRC, BT_DEST, HWMIX_NOTSOURCE_OR_NOTDEST, index_SrcDestBlt,

                     /* 0x74 ((D XOR P) OR S) XOR D */
   BT_DEST, BT_WORK, HWMIX_SOURCE, index_SrcDestBlt,
   BT_PAT, BT_WORK, HWMIX_SOURCE_XOR_DEST, index_PatDestBlt,
   BT_SRC, BT_WORK, HWMIX_SOURCE_OR_DEST, index_SrcDestBlt,
   BT_WORK, BT_DEST, HWMIX_SOURCE_XOR_DEST, index_SrcDestBlt,

                     /* 0x75 ~((S OR ~P) AND D) */
   BT_SRC, BT_WORK, HWMIX_SOURCE, index_SrcDestBlt,
   BT_PAT, BT_WORK, HWMIX_NOTSOURCE_OR_DEST, index_PatDestBlt,
   BT_WORK, BT_DEST, HWMIX_NOTSOURCE_OR_NOTDEST, index_SrcDestBlt,

                     /* 0x76 ((~S AND P) OR D) XOR S */
   BT_SRC, BT_WORK, HWMIX_SOURCE, index_SrcDestBlt,
   BT_PAT, BT_WORK, HWMIX_SOURCE_AND_NOTDEST, index_PatDestBlt,
   BT_WORK, BT_DEST, HWMIX_SOURCE_OR_DEST, index_SrcDestBlt,
   BT_SRC, BT_DEST, HWMIX_SOURCE_XOR_DEST, index_SrcDestBlt,

                     /* 0x77 ~(S AND D) */
   /* not a three-way blt */

                     /* 0x78 (S AND D) XOR P */
   BT_SRC, BT_DEST, HWMIX_SOURCE_AND_DEST, index_SrcDestBlt,
   BT_PAT, BT_DEST, HWMIX_SOURCE_XOR_DEST, index_PatDestBlt,

                     /* 0x79 ~((((D OR S) AND P) XOR S) XOR D) */
   BT_SRC, BT_WORK, HWMIX_SOURCE, index_SrcDestBlt,
   BT_DEST, BT_WORK, HWMIX_SOURCE_OR_DEST, index_SrcDestBlt,
   BT_PAT, BT_WORK, HWMIX_SOURCE_AND_DEST, index_PatDestBlt,
   BT_SRC, BT_WORK, HWMIX_SOURCE_XOR_DEST, index_SrcDestBlt,
   BT_WORK, BT_DEST, HWMIX_SOURCE_XOR_NOTDEST, index_SrcDestBlt,

                     /* 0x7a ((~D OR S) AND P) XOR D */
   BT_SRC, BT_WORK, HWMIX_SOURCE, index_SrcDestBlt,
   BT_DEST, BT_WORK, HWMIX_NOTSOURCE_OR_DEST, index_SrcDestBlt,
   BT_PAT, BT_WORK, HWMIX_SOURCE_AND_DEST, index_PatDestBlt,
   BT_WORK, BT_DEST, HWMIX_SOURCE_XOR_DEST, index_SrcDestBlt,

                     /* 0x7b ~(~(P XOR D) AND S) */
   BT_PAT, BT_DEST, HWMIX_SOURCE_XOR_NOTDEST, index_PatDestBlt,
   BT_SRC, BT_DEST, HWMIX_NOTSOURCE_OR_NOTDEST, index_SrcDestBlt,

                     /* 0x7c ((~S OR D) AND P) XOR S */
   BT_SRC, BT_DEST, HWMIX_NOTSOURCE_OR_DEST, index_SrcDestBlt,
   BT_PAT, BT_DEST, HWMIX_SOURCE_AND_DEST, index_PatDestBlt,
   BT_SRC, BT_DEST, HWMIX_SOURCE_XOR_DEST, index_SrcDestBlt,

                     /* 0x7d ~(~(S XOR P) AND D) */
   BT_SRC, BT_WORK, HWMIX_SOURCE, index_SrcDestBlt,
   BT_PAT, BT_WORK, HWMIX_SOURCE_XOR_NOTDEST, index_PatDestBlt,
   BT_WORK, BT_DEST, HWMIX_NOTSOURCE_OR_NOTDEST, index_SrcDestBlt,

                     /* 0x7e (S XOR P) OR (D XOR S) */
   BT_SRC, BT_WORK, HWMIX_SOURCE, index_SrcDestBlt,
   BT_PAT, BT_WORK, HWMIX_SOURCE_XOR_DEST, index_PatDestBlt,
   BT_SRC, BT_DEST, HWMIX_SOURCE_XOR_DEST, index_SrcDestBlt,
   BT_WORK, BT_DEST, HWMIX_SOURCE_OR_DEST, index_SrcDestBlt,

                     /* 0x7f ~((S AND P) AND D) */
   BT_PAT, BT_DEST, HWMIX_NOTSOURCE_OR_NOTDEST, index_PatDestBlt,
   BT_SRC, BT_DEST, HWMIX_NOTSOURCE_OR_DEST, index_SrcDestBlt,

                     /* 0xfe S OR P OR D  */
   BT_SRC, BT_DEST, HWMIX_SOURCE_OR_DEST, index_SrcDestBlt,
   BT_PAT, BT_DEST, HWMIX_SOURCE_OR_DEST, index_PatDestBlt
                         };
   #else   // _8514
                     /* 0x01 ~(P OR S OR D) */
   BT_SRC, BT_DEST, FUNC_NS_AND_ND, index_SrcDestBlt,
   BT_PAT, BT_DEST, FUNC_NS_AND_D, index_PatDestBlt,

                     /* 0x02 ~(P OR S) AND D */
   BT_SRC, BT_DEST, FUNC_NS_AND_D, index_SrcDestBlt,
   BT_PAT, BT_DEST, FUNC_NS_AND_D, index_PatDestBlt,

                     /* 0x03 ~(P OR S) */
   BT_SRC, BT_DEST, FUNC_S, index_SrcDestBlt,
   BT_PAT, BT_DEST, FUNC_NS_AND_ND, index_PatDestBlt,

                     /* 0x04 ~(P OR D) AND S */
   BT_SRC, BT_DEST, FUNC_S_AND_ND, index_SrcDestBlt,
   BT_PAT, BT_DEST, FUNC_NS_AND_D, index_PatDestBlt,

                     /* 0x05 ~(P OR D) */
   /* not a three-way blt */

                     /* 0x06 ~(~(S XOR D) OR P) */
   BT_SRC, BT_DEST, FUNC_S_XOR_D, index_SrcDestBlt,
   BT_PAT, BT_DEST, FUNC_NS_AND_D, index_PatDestBlt,

                     /* 0x07 ~(~(S XOR D) OR P) */
   BT_SRC, BT_DEST, FUNC_NS_OR_ND, index_SrcDestBlt,
   BT_PAT, BT_DEST, FUNC_NS_AND_D, index_PatDestBlt,

                     /* 0x08 ~P AND (S AND D) */
   BT_SRC, BT_DEST, FUNC_S_AND_D, index_SrcDestBlt,
   BT_PAT, BT_DEST, FUNC_NS_AND_D, index_PatDestBlt,

                     /* 0x09 ~P AND ~(S XOR D) */
   BT_SRC, BT_DEST, FUNC_S_XNOR_D, index_SrcDestBlt,
   BT_PAT, BT_DEST, FUNC_NS_AND_D, index_PatDestBlt,

                     /* 0x0a ~P AND D */
   /* not a three-way blt */

                     /* 0x0b ~((~D AND S) OR P) */
   BT_SRC, BT_DEST, FUNC_NS_OR_D, index_SrcDestBlt,
   BT_PAT, BT_DEST, FUNC_NS_AND_D, index_PatDestBlt,

                     /* 0x0c ~P AND S */
   BT_SRC, BT_DEST, FUNC_S, index_SrcDestBlt,
   BT_PAT, BT_DEST, FUNC_NS_AND_D, index_PatDestBlt,

                     /* 0x0d ~((~S AND D) OR P) */
   BT_SRC, BT_DEST, FUNC_S_OR_ND, index_SrcDestBlt,
   BT_PAT, BT_DEST, FUNC_NS_AND_D, index_PatDestBlt,

                     /* 0x0e ~(~(S OR D) OR P) */
   BT_SRC, BT_DEST, FUNC_S_OR_D, index_SrcDestBlt,
   BT_PAT, BT_DEST, FUNC_NS_AND_D, index_PatDestBlt,

                     /* 0x0f ~P */
   /* not a three-way blt */

                     /* 0x10 ~(S OR D) AND P */
   BT_SRC, BT_DEST, FUNC_S_OR_D, index_SrcDestBlt,
   BT_PAT, BT_DEST, FUNC_S_AND_ND, index_PatDestBlt,

                     /* 0x11 ~(S OR D) */
   /* not a three-way blt */

                     /* 0x12 ~(~(D XOR P) OR S) */
   BT_PAT, BT_DEST, FUNC_S_XOR_D, index_PatDestBlt,
   BT_SRC, BT_DEST, FUNC_NS_AND_D, index_SrcDestBlt,

                     /* 0x13 ~((D AND P) OR S) */
   BT_PAT, BT_DEST, FUNC_S_AND_D, index_PatDestBlt,
   BT_SRC, BT_DEST, FUNC_NS_AND_ND, index_SrcDestBlt,

                     /* 0x14 ~(~(P XOR S) OR D) */
   BT_SRC, BT_WORK, FUNC_S, index_SrcDestBlt,
   BT_PAT, BT_WORK, FUNC_S_XOR_D, index_PatDestBlt,
   BT_WORK, BT_DEST, FUNC_S_AND_ND, index_SrcDestBlt,

                     /* 0x15 ~((P AND S) OR D) */
   BT_SRC, BT_WORK, FUNC_S, index_SrcDestBlt,
   BT_PAT, BT_WORK, FUNC_NS_OR_ND, index_PatDestBlt,
   BT_WORK, BT_DEST, FUNC_S_AND_ND, index_SrcDestBlt,

                     /* 0x16 ((~(P AND S) AND D) XOR S) XOR P */
   BT_SRC, BT_WORK, FUNC_S, index_SrcDestBlt,
   BT_PAT, BT_WORK, FUNC_NS_OR_ND, index_PatDestBlt,
   BT_WORK, BT_DEST, FUNC_S_AND_D, index_SrcDestBlt,
   BT_SRC, BT_DEST, FUNC_S_XOR_D, index_SrcDestBlt,
   BT_PAT, BT_DEST, FUNC_S_XOR_D, index_PatDestBlt,

                     /* 0x17 ~(((D XOR S) AND (S XOR P)) XOR S) */
   BT_SRC, BT_WORK, FUNC_S, index_SrcDestBlt,
   BT_PAT, BT_WORK, FUNC_S_XOR_D, index_PatDestBlt,
   BT_SRC, BT_DEST, FUNC_S_XOR_D, index_SrcDestBlt,
   BT_WORK, BT_DEST, FUNC_S_AND_D, index_SrcDestBlt,
   BT_SRC, BT_DEST, FUNC_S_XNOR_D, index_SrcDestBlt,

                     /* 0x18 (P XOR D) AND (S XOR P) */
   BT_SRC, BT_WORK, FUNC_S, index_SrcDestBlt,
   BT_PAT, BT_WORK, FUNC_S_XOR_D, index_PatDestBlt,
   BT_PAT, BT_DEST, FUNC_S_XOR_D, index_PatDestBlt,
   BT_WORK, BT_DEST, FUNC_S_AND_D, index_SrcDestBlt,

                     /* 0x19 ~((~(P AND S) AND D) XOR S) */
   BT_SRC, BT_WORK, FUNC_S, index_SrcDestBlt,
   BT_PAT, BT_WORK, FUNC_NS_OR_ND, index_PatDestBlt,
   BT_WORK, BT_DEST, FUNC_S_AND_D, index_SrcDestBlt,
   BT_SRC, BT_DEST, FUNC_S_XNOR_D, index_SrcDestBlt,

                     /* 0x1a ((P AND S) OR D) XOR P */
   BT_SRC, BT_WORK, FUNC_S, index_SrcDestBlt,
   BT_PAT, BT_WORK, FUNC_S_AND_D, index_PatDestBlt,
   BT_WORK, BT_DEST, FUNC_S_OR_D, index_SrcDestBlt,
   BT_PAT, BT_DEST, FUNC_S_XOR_D, index_PatDestBlt,

                     /* 0x1b ~(((P XOR S) AND D) XOR S) */
   BT_SRC, BT_WORK, FUNC_S, index_SrcDestBlt,
   BT_PAT, BT_WORK, FUNC_S_XOR_D, index_PatDestBlt,
   BT_WORK, BT_DEST, FUNC_S_AND_D, index_SrcDestBlt,
   BT_SRC, BT_DEST, FUNC_S_XNOR_D, index_SrcDestBlt,

                     /* 0x1c ((P AND D) OR S) XOR P */
   BT_PAT, BT_DEST, FUNC_S_AND_D, index_PatDestBlt,
   BT_SRC, BT_DEST, FUNC_S_OR_D, index_SrcDestBlt,
   BT_PAT, BT_DEST, FUNC_S_XOR_D, index_PatDestBlt,

                     /* 0x1d ~(((P XOR D) AND S) XOR D) */
   BT_DEST, BT_WORK, FUNC_S, index_SrcDestBlt,
   BT_PAT, BT_WORK, FUNC_S_XOR_D, index_PatDestBlt,
   BT_SRC, BT_WORK, FUNC_S_AND_D, index_SrcDestBlt,
   BT_WORK, BT_DEST, FUNC_S_XNOR_D, index_SrcDestBlt,

                     /* 0x1e (S OR D) XOR P */
   BT_SRC, BT_DEST, FUNC_S_OR_D, index_SrcDestBlt,
   BT_PAT, BT_DEST, FUNC_S_XOR_D, index_PatDestBlt,

                     /* 0x1f ~((S OR D) AND P) */
   BT_SRC, BT_DEST, FUNC_S_OR_D, index_SrcDestBlt,
   BT_PAT, BT_DEST, FUNC_NS_OR_ND, index_PatDestBlt,

                     /* 0x20 ~S AND P AND D */
   BT_SRC, BT_DEST, FUNC_NS_AND_D, index_SrcDestBlt,
   BT_PAT, BT_DEST, FUNC_S_AND_D, index_PatDestBlt,

                     /* 0x21 ~((D XOR P) OR S) */
   BT_PAT, BT_DEST, FUNC_S_XOR_D, index_PatDestBlt,
   BT_SRC, BT_DEST, FUNC_NS_AND_ND, index_SrcDestBlt,

                     /* 0x22 ~S AND D */
   /* not a three-way blt */

                     /* 0x23 ~((~D AND P) OR S) */
   BT_PAT, BT_DEST, FUNC_S_AND_ND, index_PatDestBlt,
   BT_SRC, BT_DEST, FUNC_NS_AND_ND, index_SrcDestBlt,

                     /* 0x24 (S XOR P) AND (S XOR D) */
   BT_SRC, BT_WORK, FUNC_S, index_SrcDestBlt,
   BT_PAT, BT_WORK, FUNC_S_XOR_D, index_PatDestBlt,
   BT_SRC, BT_DEST, FUNC_S_XOR_D, index_SrcDestBlt,
   BT_WORK, BT_DEST, FUNC_S_AND_D, index_SrcDestBlt,

                     /* 0x25 ~((~(P AND S) AND D) XOR P) */
   BT_SRC, BT_WORK, FUNC_S, index_SrcDestBlt,
   BT_PAT, BT_WORK, FUNC_NS_OR_ND, index_PatDestBlt,
   BT_WORK, BT_DEST, FUNC_S_AND_D, index_SrcDestBlt,
   BT_PAT, BT_DEST, FUNC_S_XNOR_D, index_PatDestBlt,

                     /* 0x26 ((P AND S) OR D) XOR S */
   BT_SRC, BT_WORK, FUNC_S, index_SrcDestBlt,
   BT_PAT, BT_WORK, FUNC_S_AND_D, index_PatDestBlt,
   BT_WORK, BT_DEST, FUNC_S_OR_D, index_SrcDestBlt,
   BT_SRC, BT_DEST, FUNC_S_XOR_D, index_SrcDestBlt,

                     /* 0x27 (~(P XOR S) OR D) XOR S */
   BT_SRC, BT_WORK, FUNC_S, index_SrcDestBlt,
   BT_PAT, BT_WORK, FUNC_S_XNOR_D, index_PatDestBlt,
   BT_WORK, BT_DEST, FUNC_S_OR_D, index_SrcDestBlt,
   BT_SRC, BT_DEST, FUNC_S_XOR_D, index_SrcDestBlt,

                     /* 0x28 (P XOR S) AND D */
   BT_SRC, BT_WORK, FUNC_S, index_SrcDestBlt,
   BT_PAT, BT_WORK, FUNC_S_XOR_D, index_PatDestBlt,
   BT_WORK, BT_DEST, FUNC_S_AND_D, index_SrcDestBlt,

                     /* 0x29 ~((((P AND S) OR D) XOR S) XOR P) */
   BT_SRC, BT_WORK, FUNC_S, index_SrcDestBlt,
   BT_PAT, BT_WORK, FUNC_S_AND_D, index_PatDestBlt,
   BT_WORK, BT_DEST, FUNC_S_OR_D, index_SrcDestBlt,
   BT_SRC, BT_DEST, FUNC_S_XOR_D, index_SrcDestBlt,
   BT_PAT, BT_DEST, FUNC_S_XNOR_D, index_PatDestBlt,

                     /* 0x2a ~(P AND S) AND D */
   BT_SRC, BT_WORK, FUNC_S, index_SrcDestBlt,
   BT_PAT, BT_WORK, FUNC_NS_OR_ND, index_PatDestBlt,
   BT_WORK, BT_DEST, FUNC_S_AND_D, index_SrcDestBlt,

                     /* 0x2b ~(((P XOR S) AND (P XOR D)) XOR S) */
   BT_SRC, BT_WORK, FUNC_S, index_SrcDestBlt,
   BT_PAT, BT_WORK, FUNC_S_XOR_D, index_PatDestBlt,
   BT_PAT, BT_DEST, FUNC_S_XOR_D, index_PatDestBlt,
   BT_WORK, BT_DEST, FUNC_S_AND_D, index_SrcDestBlt,
   BT_SRC, BT_DEST, FUNC_S_XNOR_D, index_SrcDestBlt,

                     /* 0x2c ((D OR S) AND P) XOR S */
   BT_SRC, BT_DEST, FUNC_S_OR_D, index_SrcDestBlt,
   BT_PAT, BT_DEST, FUNC_S_AND_D, index_PatDestBlt,
   BT_SRC, BT_DEST, FUNC_S_XOR_D, index_SrcDestBlt,

                     /* 0x2d (~D OR S) XOR P */
   BT_SRC, BT_DEST, FUNC_S_OR_ND, index_SrcDestBlt,
   BT_PAT, BT_DEST, FUNC_S_XOR_D, index_PatDestBlt,

                     /* 0x2e ((P XOR D) OR S) XOR P */
   BT_PAT, BT_DEST, FUNC_S_XOR_D, index_PatDestBlt,
   BT_SRC, BT_DEST, FUNC_S_OR_D, index_SrcDestBlt,
   BT_PAT, BT_DEST, FUNC_S_XOR_D, index_PatDestBlt,

                     /* 0x2f ~((~D OR S) AND P) */
   BT_SRC, BT_DEST, FUNC_S_OR_ND, index_SrcDestBlt,
   BT_PAT, BT_DEST, FUNC_NS_OR_ND, index_PatDestBlt,

                     /* 0x30 ~S AND P */
   BT_SRC, BT_DEST, FUNC_S, index_SrcDestBlt,
   BT_PAT, BT_DEST, FUNC_S_AND_ND, index_PatDestBlt,

                     /* 0x31 ~((~P AND D) OR S) */
   BT_PAT, BT_DEST, FUNC_NS_AND_D, index_PatDestBlt,
   BT_SRC, BT_DEST, FUNC_NS_AND_ND, index_SrcDestBlt,

                     /* 0x32 ((P OR S) OR D) XOR S */
   BT_PAT, BT_DEST, FUNC_S_OR_D, index_PatDestBlt,
   BT_SRC, BT_DEST, FUNC_S_OR_D, index_SrcDestBlt,
   BT_SRC, BT_DEST, FUNC_S_XOR_D, index_SrcDestBlt,

                     /* 0x33 ~S AND D */
   /* not a three-way blt */

                     /* 0x34 ((S AND D) OR P) XOR S */
   BT_SRC, BT_DEST, FUNC_S_AND_D, index_SrcDestBlt,
   BT_PAT, BT_DEST, FUNC_S_OR_D, index_PatDestBlt,
   BT_SRC, BT_DEST, FUNC_S_XOR_D, index_SrcDestBlt,

                     /* 0x35 (~(S XOR D) OR P) XOR S */
   BT_SRC, BT_DEST, FUNC_S_XNOR_D, index_SrcDestBlt,
   BT_PAT, BT_DEST, FUNC_S_OR_D, index_PatDestBlt,
   BT_SRC, BT_DEST, FUNC_S_XOR_D, index_SrcDestBlt,

                     /* 0x36 (P OR D) XOR S */
   BT_PAT, BT_DEST, FUNC_S_OR_D, index_PatDestBlt,
   BT_SRC, BT_DEST, FUNC_S_XOR_D, index_SrcDestBlt,

                     /* 0x37 ~((P OR D) AND S) */
   BT_PAT, BT_DEST, FUNC_S_OR_D, index_PatDestBlt,
   BT_SRC, BT_DEST, FUNC_NS_OR_ND, index_SrcDestBlt,

                     /* 0x38 ((P OR D) AND S) XOR P */
   BT_PAT, BT_DEST, FUNC_S_OR_D, index_PatDestBlt,
   BT_SRC, BT_DEST, FUNC_S_AND_D, index_SrcDestBlt,
   BT_PAT, BT_DEST, FUNC_S_XOR_D, index_PatDestBlt,

                     /* 0x39 (P OR ~D) XOR S */
   BT_PAT, BT_DEST, FUNC_S_OR_ND, index_PatDestBlt,
   BT_SRC, BT_DEST, FUNC_S_XOR_D, index_SrcDestBlt,

                     /* 0x3a ((S XOR D) OR P) XOR S */
   BT_SRC, BT_DEST, FUNC_S_XOR_D, index_SrcDestBlt,
   BT_PAT, BT_DEST, FUNC_S_OR_D, index_PatDestBlt,
   BT_SRC, BT_DEST, FUNC_S_XOR_D, index_SrcDestBlt,

                     /* 0x3b ~((P OR ~D) AND S) */
   BT_PAT, BT_DEST, FUNC_S_OR_ND, index_PatDestBlt,
   BT_SRC, BT_DEST, FUNC_NS_OR_ND, index_SrcDestBlt,

                     /* 0x3c P XOR S */
   BT_SRC, BT_DEST, FUNC_S, index_SrcDestBlt,
   BT_PAT, BT_DEST, FUNC_S_XOR_D, index_PatDestBlt,

                     /* 0x3d (~(S OR D) OR P) XOR S */
   BT_SRC, BT_DEST, FUNC_NS_AND_ND, index_SrcDestBlt,
   BT_PAT, BT_DEST, FUNC_S_OR_D, index_PatDestBlt,
   BT_SRC, BT_DEST, FUNC_S_XOR_D, index_SrcDestBlt,

                     /* 0x3e ((~S AND D) OR P) XOR S */
   BT_SRC, BT_DEST, FUNC_NS_AND_D, index_SrcDestBlt,
   BT_PAT, BT_DEST, FUNC_S_OR_D, index_PatDestBlt,
   BT_SRC, BT_DEST, FUNC_S_XOR_D, index_SrcDestBlt,

                     /* 0x3f ~(P AND S) */
   BT_SRC, BT_DEST, FUNC_S, index_SrcDestBlt,
   BT_PAT, BT_DEST, FUNC_NS_OR_ND, index_PatDestBlt,

                     /* 0x40 P AND S AND ~D */
   BT_SRC, BT_DEST, FUNC_S_AND_ND, index_SrcDestBlt,
   BT_PAT, BT_DEST, FUNC_S_AND_D, index_PatDestBlt,

                     /* 0x41 ~((P XOR S) OR D) */
   BT_SRC, BT_WORK, FUNC_S, index_SrcDestBlt,
   BT_PAT, BT_WORK, FUNC_S_XOR_D, index_PatDestBlt,
   BT_WORK, BT_DEST, FUNC_NS_AND_ND, index_SrcDestBlt,

                     /* 0x42 (S XOR D) AND (P XOR D) */
   BT_SRC, BT_WORK, FUNC_S, index_SrcDestBlt,
   BT_DEST, BT_WORK, FUNC_S_XOR_D, index_SrcDestBlt,
   BT_PAT, BT_DEST, FUNC_S_XOR_D, index_PatDestBlt,
   BT_WORK, BT_DEST, FUNC_S_AND_D, index_SrcDestBlt,

                     /* 0x43 ~((~(S AND D) AND P) XOR S) */
   BT_SRC, BT_DEST, FUNC_NS_OR_ND, index_SrcDestBlt,
   BT_PAT, BT_DEST, FUNC_S_AND_D, index_PatDestBlt,
   BT_SRC, BT_DEST, FUNC_S_XNOR_D, index_SrcDestBlt,

                     /* 0x44 ~D AND S */
   /* not a three-way blt */

                     /* 0x45 ~((~S AND P) OR D) */
   BT_SRC, BT_WORK, FUNC_S, index_SrcDestBlt,
   BT_PAT, BT_WORK, FUNC_S_AND_ND, index_PatDestBlt,
   BT_WORK, BT_DEST, FUNC_NS_AND_ND, index_SrcDestBlt,

                     /* 0x46 ((D AND P) OR S) XOR D */
   BT_DEST, BT_WORK, FUNC_S, index_SrcDestBlt,
   BT_PAT, BT_WORK, FUNC_S_AND_D, index_PatDestBlt,
   BT_SRC, BT_WORK, FUNC_S_OR_D, index_SrcDestBlt,
   BT_WORK, BT_DEST, FUNC_S_XOR_D, index_SrcDestBlt,

                     /* 0x47 ~((D XOR P) AND S) XOR P) */
   BT_PAT, BT_DEST, FUNC_S_XOR_D, index_PatDestBlt,
   BT_SRC, BT_DEST, FUNC_S_AND_D, index_SrcDestBlt,
   BT_PAT, BT_DEST, FUNC_S_XNOR_D, index_PatDestBlt,

                     /* 0x48 (D XOR P) AND S */
   BT_PAT, BT_DEST, FUNC_S_XOR_D, index_PatDestBlt,
   BT_SRC, BT_DEST, FUNC_S_AND_D, index_SrcDestBlt,

                     /* 0x49 ~((((D AND P) OR S) XOR D) XOR P) */
   BT_DEST, BT_WORK, FUNC_S, index_SrcDestBlt,
   BT_PAT, BT_WORK, FUNC_S_AND_D, index_PatDestBlt,
   BT_SRC, BT_WORK, FUNC_S_OR_D, index_SrcDestBlt,
   BT_WORK, BT_DEST, FUNC_S_XOR_D, index_SrcDestBlt,
   BT_PAT, BT_DEST, FUNC_S_XNOR_D, index_PatDestBlt,

                     /* 0x4a ((S OR D) AND P) XOR D */
   BT_DEST, BT_WORK, FUNC_S, index_SrcDestBlt,
   BT_SRC, BT_WORK, FUNC_S_OR_D, index_SrcDestBlt,
   BT_PAT, BT_WORK, FUNC_S_AND_D, index_PatDestBlt,
   BT_WORK, BT_DEST, FUNC_S_XOR_D, index_SrcDestBlt,

                     /* 0x4b (~S OR D) XOR P */
   BT_SRC, BT_DEST, FUNC_NS_OR_D, index_SrcDestBlt,
   BT_PAT, BT_DEST, FUNC_S_XOR_D, index_PatDestBlt,

                     /* 0x4c ~(P AND D) AND S */
   BT_PAT, BT_DEST, FUNC_NS_OR_ND, index_PatDestBlt,
   BT_SRC, BT_DEST, FUNC_S_AND_D, index_SrcDestBlt,

                     /* 0x4d ~(((S XOR P) OR (D XOR S)) XOR S) */
   BT_SRC, BT_WORK, FUNC_S, index_SrcDestBlt,
   BT_PAT, BT_WORK, FUNC_S_XOR_D, index_PatDestBlt,
   BT_SRC, BT_DEST, FUNC_S_XOR_D, index_SrcDestBlt,
   BT_WORK, BT_DEST, FUNC_S_OR_D, index_SrcDestBlt,
   BT_SRC, BT_DEST, FUNC_S_XNOR_D, index_SrcDestBlt,

                     /* 0x4e ((P XOR S) OR D) XOR P */
   BT_SRC, BT_WORK, FUNC_S, index_SrcDestBlt,
   BT_PAT, BT_WORK, FUNC_S_XOR_D, index_PatDestBlt,
   BT_WORK, BT_DEST, FUNC_S_OR_D, index_SrcDestBlt,
   BT_PAT, BT_DEST, FUNC_S_XOR_D, index_PatDestBlt,

                     /* 0x4f ~((~S OR D) AND P) */
   BT_SRC, BT_DEST, FUNC_NS_OR_D, index_SrcDestBlt,
   BT_PAT, BT_DEST, FUNC_NS_OR_ND, index_PatDestBlt,

                     /* 0x50 ~D AND P */
   /* not a three-way blt */

                     /* 0x51 ~((~P AND S) OR D) */
   BT_SRC, BT_WORK, FUNC_S, index_SrcDestBlt,
   BT_PAT, BT_WORK, FUNC_NS_AND_D, index_PatDestBlt,
   BT_WORK, BT_DEST, FUNC_NS_AND_ND, index_SrcDestBlt,

                     /* 0x52 ((S AND D) OR P) XOR D */
   BT_SRC, BT_WORK, FUNC_S, index_SrcDestBlt,
   BT_DEST, BT_WORK, FUNC_S_AND_D, index_SrcDestBlt,
   BT_PAT, BT_WORK, FUNC_S_OR_D, index_PatDestBlt,
   BT_WORK, BT_DEST, FUNC_S_XOR_D, index_SrcDestBlt,

                     /* 0x53 ~(((S XOR D) AND P) XOR S) */
   BT_SRC, BT_DEST, FUNC_S_XOR_D, index_SrcDestBlt,
   BT_PAT, BT_DEST, FUNC_S_AND_D, index_PatDestBlt,
   BT_SRC, BT_DEST, FUNC_S_XNOR_D, index_SrcDestBlt,

                     /* 0x54 ~(~(S OR P) OR D) */
   BT_SRC, BT_WORK, FUNC_S, index_SrcDestBlt,
   BT_PAT, BT_WORK, FUNC_NS_AND_ND, index_PatDestBlt,
   BT_WORK, BT_DEST, FUNC_NS_AND_ND, index_SrcDestBlt,

                     /* 0x55 ~D */
   /* not a three-way blt */

                     /* 0x56 (S OR P) XOR D */
   BT_SRC, BT_WORK, FUNC_S, index_SrcDestBlt,
   BT_PAT, BT_WORK, FUNC_S_OR_D, index_PatDestBlt,
   BT_WORK, BT_DEST, FUNC_S_XOR_D, index_SrcDestBlt,

                     /* 0x57 ~((S OR P) AND D) */
   BT_SRC, BT_WORK, FUNC_S, index_SrcDestBlt,
   BT_PAT, BT_WORK, FUNC_S_OR_D, index_PatDestBlt,
   BT_WORK, BT_DEST, FUNC_NS_OR_ND, index_SrcDestBlt,

                     /* 0x58 ((S OR P) AND D) XOR P */
   BT_SRC, BT_WORK, FUNC_S, index_SrcDestBlt,
   BT_PAT, BT_WORK, FUNC_S_OR_D, index_PatDestBlt,
   BT_WORK, BT_DEST, FUNC_S_AND_D, index_SrcDestBlt,
   BT_PAT, BT_DEST, FUNC_S_XOR_D, index_PatDestBlt,

                     /* 0x59 (~S OR P) XOR D */
   BT_SRC, BT_WORK, FUNC_S, index_SrcDestBlt,
   BT_PAT, BT_WORK, FUNC_S_OR_ND, index_PatDestBlt,
   BT_WORK, BT_DEST, FUNC_S_XOR_D, index_SrcDestBlt,

                     /* 0x5a D XOR P */
   /* not a three-way blt */

                     /* 0x5b (~(S OR D) OR P) XOR D */
   BT_SRC, BT_WORK, FUNC_S, index_SrcDestBlt,
   BT_DEST, BT_WORK, FUNC_NS_AND_ND, index_SrcDestBlt,
   BT_PAT, BT_WORK, FUNC_S_OR_D, index_PatDestBlt,
   BT_WORK, BT_DEST, FUNC_S_XOR_D, index_SrcDestBlt,

                     /* 0x5c ((S XOR D) OR P) XOR D */
   BT_SRC, BT_WORK, FUNC_S, index_SrcDestBlt,
   BT_DEST, BT_WORK, FUNC_S_XOR_D, index_SrcDestBlt,
   BT_PAT, BT_WORK, FUNC_S_OR_D, index_PatDestBlt,
   BT_WORK, BT_DEST, FUNC_S_XOR_D, index_SrcDestBlt,

                     /* 0x5d ~((~S OR P) AND D) */
   BT_SRC, BT_WORK, FUNC_S, index_SrcDestBlt,
   BT_PAT, BT_WORK, FUNC_S_OR_ND, index_PatDestBlt,
   BT_WORK, BT_DEST, FUNC_NS_OR_ND, index_SrcDestBlt,

                     /* 0x5e ((~D AND S) OR P) XOR D */
   BT_SRC, BT_WORK, FUNC_S, index_SrcDestBlt,
   BT_DEST, BT_WORK, FUNC_NS_AND_D, index_SrcDestBlt,
   BT_PAT, BT_WORK, FUNC_S_OR_D, index_PatDestBlt,
   BT_WORK, BT_DEST, FUNC_S_XOR_D, index_SrcDestBlt,

                     /* 0x5f ~(D AND P) */
   /* not a three-way blt */

                     /* 0x60 (S XOR D) AND P  */
   BT_SRC, BT_DEST, FUNC_S_XOR_D, index_SrcDestBlt,
   BT_PAT, BT_DEST, FUNC_S_AND_D, index_PatDestBlt,

                     /* 0x61 ~((((D AND S) OR P) XOR S) XOR D) */
   BT_SRC, BT_WORK, FUNC_S, index_SrcDestBlt,
   BT_DEST, BT_WORK, FUNC_S_AND_D, index_SrcDestBlt,
   BT_PAT, BT_WORK, FUNC_S_OR_D, index_PatDestBlt,
   BT_SRC, BT_WORK, FUNC_S_XOR_D, index_SrcDestBlt,
   BT_WORK, BT_DEST, FUNC_S_XNOR_D, index_SrcDestBlt,

                     /* 0x62 ((D OR P) AND S) XOR D */
   BT_DEST, BT_WORK, FUNC_S, index_SrcDestBlt,
   BT_PAT, BT_WORK, FUNC_S_OR_D, index_PatDestBlt,
   BT_SRC, BT_WORK, FUNC_S_AND_D, index_SrcDestBlt,
   BT_WORK, BT_DEST, FUNC_S_XOR_D, index_SrcDestBlt,

                     /* 0x63 (D OR ~P) XOR S */
   BT_PAT, BT_DEST, FUNC_NS_OR_D, index_PatDestBlt,
   BT_SRC, BT_DEST, FUNC_S_XOR_D, index_SrcDestBlt,

                     /* 0x64 ((S OR P) AND D) XOR S */
   BT_SRC, BT_WORK, FUNC_S, index_SrcDestBlt,
   BT_PAT, BT_WORK, FUNC_S_OR_D, index_PatDestBlt,
   BT_WORK, BT_DEST, FUNC_S_AND_D, index_SrcDestBlt,
   BT_SRC, BT_DEST, FUNC_S_XOR_D, index_SrcDestBlt,

                     /* 0x65 (S OR ~P) XOR D */
   BT_SRC, BT_WORK, FUNC_S, index_SrcDestBlt,
   BT_PAT, BT_WORK, FUNC_NS_OR_D, index_PatDestBlt,
   BT_WORK, BT_DEST, FUNC_S_XOR_D, index_SrcDestBlt,

                     /* 0x66 D XOR S */
   /* not a three-way blt */

                     /* 0x67 (~(S OR P) OR D) XOR S */
   BT_SRC, BT_WORK, FUNC_S, index_SrcDestBlt,
   BT_PAT, BT_WORK, FUNC_NS_AND_ND, index_PatDestBlt,
   BT_WORK, BT_DEST, FUNC_S_OR_D, index_SrcDestBlt,
   BT_SRC, BT_DEST, FUNC_S_XOR_D, index_SrcDestBlt,

                     /* 0x68 ~(((~(S OR D) OR P) XOR S) XOR D) */
   BT_SRC, BT_WORK, FUNC_S, index_SrcDestBlt,
   BT_DEST, BT_WORK, FUNC_NS_AND_ND, index_SrcDestBlt,
   BT_PAT, BT_WORK, FUNC_S_OR_D, index_PatDestBlt,
   BT_SRC, BT_WORK, FUNC_S_XOR_D, index_SrcDestBlt,
   BT_WORK, BT_DEST, FUNC_S_XNOR_D, index_SrcDestBlt,

                     /* 0x69 ~((S XOR D) XOR P) */
   BT_SRC, BT_DEST, FUNC_S_XOR_D, index_SrcDestBlt,
   BT_PAT, BT_DEST, FUNC_S_XNOR_D, index_PatDestBlt,

                     /* 0x6a (P AND S) XOR D */
   BT_SRC, BT_WORK, FUNC_S, index_SrcDestBlt,
   BT_PAT, BT_WORK, FUNC_S_AND_D, index_PatDestBlt,
   BT_WORK, BT_DEST, FUNC_S_XOR_D, index_SrcDestBlt,

                     /* 0x6b ~((((P OR S) AND D) XOR S) XOR P) */
   BT_SRC, BT_WORK, FUNC_S, index_SrcDestBlt,
   BT_PAT, BT_WORK, FUNC_S_OR_D, index_PatDestBlt,
   BT_WORK, BT_DEST, FUNC_S_AND_D, index_SrcDestBlt,
   BT_SRC, BT_DEST, FUNC_S_XOR_D, index_SrcDestBlt,
   BT_PAT, BT_DEST, FUNC_S_XNOR_D, index_PatDestBlt,

                     /* 0x6c (P AND D) XOR S */
   BT_PAT, BT_DEST, FUNC_S_AND_D, index_PatDestBlt,
   BT_SRC, BT_DEST, FUNC_S_XOR_D, index_SrcDestBlt,

                     /* 0x6d ~((((P OR D) AND S) XOR D) XOR P) */
   BT_DEST, BT_WORK, FUNC_S, index_SrcDestBlt,
   BT_PAT, BT_WORK, FUNC_S_OR_D, index_PatDestBlt,
   BT_SRC, BT_WORK, FUNC_S_AND_D, index_SrcDestBlt,
   BT_WORK, BT_DEST, FUNC_S_XOR_D, index_SrcDestBlt,
   BT_PAT, BT_DEST, FUNC_S_XNOR_D, index_PatDestBlt,

                     /* 0x6e ((~S OR P) AND D) XOR S */
   BT_SRC, BT_WORK, FUNC_S, index_SrcDestBlt,
   BT_PAT, BT_WORK, FUNC_S_OR_ND, index_PatDestBlt,
   BT_WORK, BT_DEST, FUNC_S_AND_D, index_SrcDestBlt,
   BT_SRC, BT_DEST, FUNC_S_XOR_D, index_SrcDestBlt,

                     /* 0x6f ~(~(S XOR D) AND P) */
   BT_SRC, BT_DEST, FUNC_S_XNOR_D, index_SrcDestBlt,
   BT_PAT, BT_DEST, FUNC_NS_OR_ND, index_PatDestBlt,

                     /* 0x70 ~(S AND D) AND P */
   BT_SRC, BT_DEST, FUNC_NS_OR_ND, index_SrcDestBlt,
   BT_PAT, BT_DEST, FUNC_S_AND_D, index_PatDestBlt,

                     /* 0x71 ~((S XOR D) AND (P XOR D) XOR S) */
   BT_DEST, BT_WORK, FUNC_S, index_SrcDestBlt,
   BT_PAT, BT_WORK, FUNC_S_XOR_D, index_PatDestBlt,
   BT_SRC, BT_DEST, FUNC_S_XOR_D, index_SrcDestBlt,
   BT_WORK, BT_DEST, FUNC_S_AND_D, index_SrcDestBlt,
   BT_SRC, BT_DEST, FUNC_S_XNOR_D, index_SrcDestBlt,

                     /* 0x72 ((S XOR P) OR D) XOR S */
   BT_SRC, BT_WORK, FUNC_S, index_SrcDestBlt,
   BT_PAT, BT_WORK, FUNC_S_XOR_D, index_PatDestBlt,
   BT_WORK, BT_DEST, FUNC_S_OR_D, index_SrcDestBlt,
   BT_SRC, BT_DEST, FUNC_S_XOR_D, index_SrcDestBlt,

                     /* 0x73 ~((~P OR D) AND S) */
   BT_PAT, BT_DEST, FUNC_NS_OR_D, index_PatDestBlt,
   BT_SRC, BT_DEST, FUNC_NS_OR_ND, index_SrcDestBlt,

                     /* 0x74 ((D XOR P) OR S) XOR D */
   BT_DEST, BT_WORK, FUNC_S, index_SrcDestBlt,
   BT_PAT, BT_WORK, FUNC_S_XOR_D, index_PatDestBlt,
   BT_SRC, BT_WORK, FUNC_S_OR_D, index_SrcDestBlt,
   BT_WORK, BT_DEST, FUNC_S_XOR_D, index_SrcDestBlt,

                     /* 0x75 ~((S OR ~P) AND D) */
   BT_SRC, BT_WORK, FUNC_S, index_SrcDestBlt,
   BT_PAT, BT_WORK, FUNC_NS_OR_D, index_PatDestBlt,
   BT_WORK, BT_DEST, FUNC_NS_OR_ND, index_SrcDestBlt,

                     /* 0x76 ((~S AND P) OR D) XOR S */
   BT_SRC, BT_WORK, FUNC_S, index_SrcDestBlt,
   BT_PAT, BT_WORK, FUNC_S_AND_ND, index_PatDestBlt,
   BT_WORK, BT_DEST, FUNC_S_OR_D, index_SrcDestBlt,
   BT_SRC, BT_DEST, FUNC_S_XOR_D, index_SrcDestBlt,

                     /* 0x77 ~(S AND D) */
   /* not a three-way blt */

                     /* 0x78 (S AND D) XOR P */
   BT_SRC, BT_DEST, FUNC_S_AND_D, index_SrcDestBlt,
   BT_PAT, BT_DEST, FUNC_S_XOR_D, index_PatDestBlt,

                     /* 0x79 ~((((D OR S) AND P) XOR S) XOR D) */
   BT_SRC, BT_WORK, FUNC_S, index_SrcDestBlt,
   BT_DEST, BT_WORK, FUNC_S_OR_D, index_SrcDestBlt,
   BT_PAT, BT_WORK, FUNC_S_AND_D, index_PatDestBlt,
   BT_SRC, BT_WORK, FUNC_S_XOR_D, index_SrcDestBlt,
   BT_WORK, BT_DEST, FUNC_S_XNOR_D, index_SrcDestBlt,

                     /* 0x7a ((~D OR S) AND P) XOR D */
   BT_SRC, BT_WORK, FUNC_S, index_SrcDestBlt,
   BT_DEST, BT_WORK, FUNC_NS_OR_D, index_SrcDestBlt,
   BT_PAT, BT_WORK, FUNC_S_AND_D, index_PatDestBlt,
   BT_WORK, BT_DEST, FUNC_S_XOR_D, index_SrcDestBlt,

                     /* 0x7b ~(~(P XOR D) AND S) */
   BT_PAT, BT_DEST, FUNC_S_XNOR_D, index_PatDestBlt,
   BT_SRC, BT_DEST, FUNC_NS_OR_ND, index_SrcDestBlt,

                     /* 0x7c ((~S OR D) AND P) XOR S */
   BT_SRC, BT_DEST, FUNC_NS_OR_D, index_SrcDestBlt,
   BT_PAT, BT_DEST, FUNC_S_AND_D, index_PatDestBlt,
   BT_SRC, BT_DEST, FUNC_S_XOR_D, index_SrcDestBlt,

                     /* 0x7d ~(~(S XOR P) AND D) */
   BT_SRC, BT_WORK, FUNC_S, index_SrcDestBlt,
   BT_PAT, BT_WORK, FUNC_S_XNOR_D, index_PatDestBlt,
   BT_WORK, BT_DEST, FUNC_NS_OR_ND, index_SrcDestBlt,

                     /* 0x7e (S XOR P) OR (D XOR S) */
   BT_SRC, BT_WORK, FUNC_S, index_SrcDestBlt,
   BT_PAT, BT_WORK, FUNC_S_XOR_D, index_PatDestBlt,
   BT_SRC, BT_DEST, FUNC_S_XOR_D, index_SrcDestBlt,
   BT_WORK, BT_DEST, FUNC_S_OR_D, index_SrcDestBlt,

                     /* 0x7f ~((S AND P) AND D) */
   BT_PAT, BT_DEST, FUNC_NS_OR_ND, index_PatDestBlt,
   BT_SRC, BT_DEST, FUNC_NS_OR_D, index_SrcDestBlt,

                     /* 0xfe S OR P OR D  */
   BT_SRC, BT_DEST, FUNC_S_OR_D, index_SrcDestBlt,
   BT_PAT, BT_DEST, FUNC_S_OR_D, index_PatDestBlt
                         };
   #endif  // _8514

/**********************************************************************/
/* array of pointers to instructions for each blt                     */
/* format is:                                                         */
/* BYTE       CreateNew;                                              */
/* BYTE       Size;                                                   */
/* pBltInst   Instruction;                                            */
/**********************************************************************/
BltBuffEntry Blt3WayBuffer[] = {
                   NULL,  0, NULL,                /* 0x00 */
                   FALSE, 2, Blt3WayInsts,        /* 0x01 */
                   FALSE, 2, &Blt3WayInsts[2],    /* 0x02 */
                   FALSE, 2, &Blt3WayInsts[4],    /* 0x03 */
                   FALSE, 2, &Blt3WayInsts[6],    /* 0x04 */
                   NULL,  0, NULL,                /* 0x05 */
                   FALSE, 2, &Blt3WayInsts[8],    /* 0x06 */
                   FALSE, 2, &Blt3WayInsts[10],   /* 0x07 */
                   FALSE, 2, &Blt3WayInsts[12],   /* 0x08 */
                   FALSE, 2, &Blt3WayInsts[14],   /* 0x09 */
                   NULL,  0, NULL,                /* 0x0a */
                   FALSE, 2, &Blt3WayInsts[16],   /* 0x0b */
                   FALSE, 2, &Blt3WayInsts[18],   /* 0x0c */
                   FALSE, 2, &Blt3WayInsts[20],   /* 0x0d */
                   FALSE, 2, &Blt3WayInsts[22],   /* 0x0e */
                   NULL,  0, NULL,                /* 0x0f */
                   FALSE, 2, &Blt3WayInsts[24],   /* 0x10 */
                   NULL,  0, NULL,                /* 0x11 */
                   FALSE, 2, &Blt3WayInsts[26],   /* 0x12 */
                   FALSE, 2, &Blt3WayInsts[28],   /* 0x13 */
                   TRUE,  3, &Blt3WayInsts[30],   /* 0x14 */
                   TRUE,  3, &Blt3WayInsts[33],   /* 0x15 */
                   TRUE,  5, &Blt3WayInsts[36],   /* 0x16 */
                   TRUE,  5, &Blt3WayInsts[41],   /* 0x17 */
                   TRUE,  4, &Blt3WayInsts[46],   /* 0x18 */
                   TRUE,  4, &Blt3WayInsts[50],   /* 0x19 */
                   TRUE,  4, &Blt3WayInsts[54],   /* 0x1a */
                   TRUE,  4, &Blt3WayInsts[58],   /* 0x1b */
                   FALSE, 3, &Blt3WayInsts[62],   /* 0x1c */
                   TRUE,  4, &Blt3WayInsts[65],   /* 0x1d */
                   FALSE, 2, &Blt3WayInsts[69],   /* 0x1e */
                   FALSE, 2, &Blt3WayInsts[71],   /* 0x1f */
                   FALSE, 2, &Blt3WayInsts[73],   /* 0x20 */
                   FALSE, 2, &Blt3WayInsts[75],   /* 0x21 */
                   NULL,  0, NULL,                /* 0x22 */
                   FALSE, 2, &Blt3WayInsts[77],   /* 0x23 */
                   TRUE,  4, &Blt3WayInsts[79],   /* 0x24 */
                   TRUE,  4, &Blt3WayInsts[83],   /* 0x25 */
                   TRUE,  4, &Blt3WayInsts[87],   /* 0x26 */
                   TRUE,  4, &Blt3WayInsts[91],   /* 0x27 */
                   TRUE,  3, &Blt3WayInsts[95],   /* 0x28 */
                   TRUE,  5, &Blt3WayInsts[98],   /* 0x29 */
                   TRUE,  3, &Blt3WayInsts[103],  /* 0x2a */
                   TRUE,  5, &Blt3WayInsts[106],  /* 0x2b */
                   FALSE, 3, &Blt3WayInsts[111],  /* 0x2c */
                   FALSE, 2, &Blt3WayInsts[114],  /* 0x2d */
                   FALSE, 3, &Blt3WayInsts[116],  /* 0x2e */
                   FALSE, 2, &Blt3WayInsts[119],  /* 0x2f */
                   FALSE, 2, &Blt3WayInsts[121],  /* 0x30 */
                   FALSE, 2, &Blt3WayInsts[123],  /* 0x31 */
                   FALSE, 3, &Blt3WayInsts[125],  /* 0x32 */
                   NULL,  0, NULL,                /* 0x33 */
                   FALSE, 3, &Blt3WayInsts[128],  /* 0x34 */
                   FALSE, 3, &Blt3WayInsts[131],  /* 0x35 */
                   FALSE, 2, &Blt3WayInsts[134],  /* 0x36 */
                   FALSE, 2, &Blt3WayInsts[136],  /* 0x37 */
                   FALSE, 3, &Blt3WayInsts[138],  /* 0x38 */
                   FALSE, 2, &Blt3WayInsts[141],  /* 0x39 */
                   FALSE, 3, &Blt3WayInsts[143],  /* 0x3a */
                   FALSE, 2, &Blt3WayInsts[146],  /* 0x3b */
                   FALSE, 2, &Blt3WayInsts[148],  /* 0x3c */
                   FALSE, 3, &Blt3WayInsts[150],  /* 0x3d */
                   FALSE, 3, &Blt3WayInsts[153],  /* 0x3e */
                   FALSE, 2, &Blt3WayInsts[156],  /* 0x3f */
                   FALSE, 2, &Blt3WayInsts[158],  /* 0x40 */
                   TRUE,  3, &Blt3WayInsts[160],  /* 0x41 */
                   TRUE,  4, &Blt3WayInsts[163],  /* 0x42 */
                   FALSE, 3, &Blt3WayInsts[167],  /* 0x43 */
                   NULL,  0, NULL,                /* 0x44 */
                   TRUE,  3, &Blt3WayInsts[170],  /* 0x45 */
                   TRUE,  4, &Blt3WayInsts[173],  /* 0x46 */
                   FALSE, 3, &Blt3WayInsts[177],  /* 0x47 */
                   FALSE, 2, &Blt3WayInsts[180],  /* 0x48 */
                   TRUE,  5, &Blt3WayInsts[182],  /* 0x49 */
                   TRUE,  4, &Blt3WayInsts[187],  /* 0x4a */
                   FALSE, 2, &Blt3WayInsts[191],  /* 0x4b */
                   FALSE, 2, &Blt3WayInsts[193],  /* 0x4c */
                   TRUE,  5, &Blt3WayInsts[195],  /* 0x4d */
                   TRUE,  4, &Blt3WayInsts[200],  /* 0x4e */
                   FALSE, 2, &Blt3WayInsts[204],  /* 0x4f */
                   NULL,  0, NULL,                /* 0x50 */
                   TRUE,  3, &Blt3WayInsts[206],  /* 0x51 */
                   TRUE,  4, &Blt3WayInsts[209],  /* 0x52 */
                   FALSE, 3, &Blt3WayInsts[213],  /* 0x53 */
                   TRUE,  3, &Blt3WayInsts[216],  /* 0x54 */
                   NULL,  0, NULL,                /* 0x55 */
                   TRUE,  3, &Blt3WayInsts[219],  /* 0x56 */
                   TRUE,  3, &Blt3WayInsts[222],  /* 0x57 */
                   TRUE,  4, &Blt3WayInsts[225],  /* 0x58 */
                   TRUE,  3, &Blt3WayInsts[229],  /* 0x59 */
                   NULL,  0, NULL,                /* 0x5a */
                   TRUE,  4, &Blt3WayInsts[232],  /* 0x5b */
                   TRUE,  4, &Blt3WayInsts[236],  /* 0x5c */
                   TRUE,  3, &Blt3WayInsts[240],  /* 0x5d */
                   TRUE,  4, &Blt3WayInsts[243],  /* 0x5e */
                   NULL,  0, NULL,                /* 0x5f */
                   FALSE, 2, &Blt3WayInsts[247],  /* 0x60 */
                   TRUE,  5, &Blt3WayInsts[249],  /* 0x61 */
                   TRUE,  4, &Blt3WayInsts[254],  /* 0x62 */
                   FALSE, 2, &Blt3WayInsts[258],  /* 0x63 */
                   TRUE,  4, &Blt3WayInsts[260],  /* 0x64 */
                   TRUE,  3, &Blt3WayInsts[264],  /* 0x65 */
                   NULL,  0, NULL,                /* 0x66 */
                   TRUE,  4, &Blt3WayInsts[267],  /* 0x67 */
                   TRUE,  5, &Blt3WayInsts[271],  /* 0x68 */
                   FALSE, 2, &Blt3WayInsts[276],  /* 0x69 */
                   TRUE,  3, &Blt3WayInsts[278],  /* 0x6a */
                   TRUE,  5, &Blt3WayInsts[281],  /* 0x6b */
                   FALSE, 2, &Blt3WayInsts[286],  /* 0x6c */
                   TRUE,  5, &Blt3WayInsts[288],  /* 0x6d */
                   TRUE,  4, &Blt3WayInsts[293],  /* 0x6e */
                   FALSE, 2, &Blt3WayInsts[297],  /* 0x6f */
                   FALSE, 2, &Blt3WayInsts[299],  /* 0x70 */
                   TRUE,  5, &Blt3WayInsts[301],  /* 0x71 */
                   TRUE,  4, &Blt3WayInsts[306],  /* 0x72 */
                   FALSE, 2, &Blt3WayInsts[310],  /* 0x73 */
                   TRUE,  4, &Blt3WayInsts[312],  /* 0x74 */
                   TRUE,  3, &Blt3WayInsts[316],  /* 0x75 */
                   TRUE,  4, &Blt3WayInsts[319],  /* 0x76 */
                   NULL,  0, NULL,                /* 0x77 */
                   FALSE, 2, &Blt3WayInsts[323],  /* 0x78 */
                   TRUE,  5, &Blt3WayInsts[325],  /* 0x79 */
                   TRUE,  4, &Blt3WayInsts[330],  /* 0x7a */
                   FALSE, 2, &Blt3WayInsts[334],  /* 0x7b */
                   FALSE, 3, &Blt3WayInsts[336],  /* 0x7c */
                   TRUE,  3, &Blt3WayInsts[339],  /* 0x7d */
                   TRUE,  4, &Blt3WayInsts[342],  /* 0x7e */
                   FALSE, 2, &Blt3WayInsts[346],  /* 0x7f */
                   FALSE, 2, &Blt3WayInsts[5]   /* 0xfe */
                               };
