/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**********************************************************************/
/*                                                                    */
/*   Module          = EDDAQERY                                       */
/*                                                                    */
/*   Description     = Display Device Driver text query functions     */
/*                     DeviceQueryFontAttributes,                     */
/*                     DeviceQueryFonts                               */
/*                                                                    */
/*   Function        =                                                */
/*                                                                    */
/*   Reference       = Winthorn Functional Specification              */
/*                     Device Driver Interface Specification          */
/*                     Display Device Driver Design Specification     */
/*                                                                    */
/*                                                                    */
/**********************************************************************/
#include <eddinclt.h>

#include <eddacone.h>
#include <eddtcone.h>
#include <edddtypt.h>
#include <eddttypt.h>

#include <eddaextf.h>
#include <eddgextf.h>

extern DDTType   DDT;
extern USHORT    ResidentFonts;


/**********************************************************************/
/* DeviceQueryFontAttributes obtains the metrics of the currently     */
/* selected font                                                      */
/**********************************************************************/
DDIENTRY edda_DeviceQueryFontAttributes (HDC           hdc,
                                         ULONG         ArgSize,
                                         PFONTMETRICS  ArgMetrics,
                                         PDC           pdcArg,
                                         ULONG         FunN)

{
    /******************************************************************/
    /* With the engine managing our font this should never be called. */
    /* Just return TRUE in case it is.                                */
    /******************************************************************/
    IgnoreParam(hdc);
    IgnoreParam(ArgSize);
    IgnoreParam(ArgMetrics);
    IgnoreParam(pdcArg);
    IgnoreParam(FunN);

    return(TRUE);
}


/**********************************************************************/
/* DeviceQueryFonts enumerates the fonts on a device. For each font on*/
/* the device the function returns the metrics of the font.           */
/* A filter can be supplied in which case font metrics are only       */
/* returned for fonts whose facename matches the filter.              */
/**********************************************************************/
DDIENTRY edda_DeviceQueryFonts (HDC           hdc,
                                ULONG         ArgOptions,
                                PCHAR         ArgFilter,
                                PFONTMETRICS  ArgMetrics,
                                ULONG         ArgSize,
                                PULONG        ArgCount,
                                PDC           pdcArg,
                                ULONG         FunN)

{
    /******************************************************************/
    /* With the engine managing our font we have nothing to do here.  */
    /* We have to set ArgCount to be the number of metrics returned   */
    /* (always 0), and we return the number of fonts left to fill in  */
    /* (also 0 as we don't have any)                                  */
    /******************************************************************/
    IgnoreParam(hdc);
    IgnoreParam(ArgOptions);
    IgnoreParam(ArgFilter);
    IgnoreParam(ArgMetrics);
    IgnoreParam(ArgSize);
    IgnoreParam(pdcArg);
    IgnoreParam(FunN);

    *ArgCount = 0;
    return(0);
}
