/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**********************************************************************/
/*                                                                    */
/*   Module          = EDDAPAGE                                       */
/*                                                                    */
/*   Description     = Display Device Driver minor functions          */
/*                     SetCodePage and GetCodePage                    */
/*                                                                    */
/*   Function        = SetCodePage sets the code page for the         */
/*                     default font.                                  */
/*                     GetCodePage returns the current code page.     */
/*                                                                    */
/*   Reference       = Winthorn Functional Specification              */
/*                     Device Driver Interface Specification          */
/*                     Display Device Driver Design Specification     */
/*                                                                    */
/*                                                                    */
/**********************************************************************/
#define INCL_DDICOMFLAGS
#define INCL_DDIMISC
#define INCL_GRE_FONTS
#include <eddinclt.h>

#include <edddtypt.h>
#include <eddaextf.h>
#include <eddgextf.h>
#include <eddtextf.h>
#include <eddacone.h>
#include <eddtcone.h>

#include <memman.h>

extern DDTType                DDT;
extern USHORT                 DefaultFontListIndex;
extern PVOID                  pDefaultFont;

/**********************************************************************/
/* SetCodePage sets the code page to be used with the default font.   */
/**********************************************************************/
DDIENTRY edda_SetCodePage (HDC             hdc,
                           ULONG           ArgCodePage,
                           PDC             pdcArg,
                           ULONG           FunN)

{
    /******************************************************************/
    /* Local variables                                                */
    /******************************************************************/
    pAICharDef          lpCsd;         /* pointer to char set def     */
    ULONG               OldCodepage;   /* previous codepage           */
    USHORT              CodepageType;  /* real or simulated           */
    BOOL                CodePageSimulated;
    ULONG               i;

    /******************************************************************/
    /* Get driver semaphore and perform entry checks                  */
    /******************************************************************/
    EnterDriver(pdcArg, FunN, EDF_STANDARD | EDF_DONT_CLEAN);

    /******************************************************************/
    /* if no change required, return at once                          */
    /******************************************************************/
    if (pdc->DCICodePage == ArgCodePage)
    {
        goto SETCODEPAGE_EXIT;
    }

    /******************************************************************/
    /* Apply the DC command mask to the command bits                  */
    /******************************************************************/
    COMMANDBITS(FunN) &= pdc->DCICommandMask;

    /******************************************************************/
    /* This call is invalid within an area definition.                */
    /******************************************************************/
    if (FunNTest(COM_AREA))
    {
        /**************************************************************/
        /* We have been called within an area definition. Log an      */
        /* error and exit.                                            */
        /**************************************************************/
        LogError(PMERR_INV_IN_AREA);
        goto SETCODEPAGE_ERR_EXIT;
    }

    /******************************************************************/
    /* Save the new code page in the DC instance data                 */
    /******************************************************************/
    pdc->DCICodePage = ArgCodePage;

    /******************************************************************/
    /* The default font is a FocaFont.                                */
    /* Call LocateFont to ensure that all pointers, vectors etc.      */
    /* are correct.                                                   */
    /******************************************************************/
    eddt_LocateFont();


SETCODEPAGE_EXIT:
    /******************************************************************/
    /* Release driver semaphore                                       */
    /******************************************************************/
    ExitDriver(pdcArg, FunN, EDF_STANDARD | EDF_DONT_CLEAN);
    return(TRUE);


SETCODEPAGE_ERR_EXIT:
    /******************************************************************/
    /* Release driver semaphore                                       */
    /******************************************************************/
    ExitDriver(pdcArg, FunN, EDF_STANDARD | EDF_DONT_CLEAN);
    return(FALSE);
}






/**********************************************************************/
/* GetCodePage gets the code page that is currently being used by the */
/* default font                                                       */
/**********************************************************************/

DDIENTRY edda_GetCodePage (HDC             hdc,
                           PDC             pdcArg,
                           ULONG           FunN)

{
    /******************************************************************/
    /* Local variables                                                */
    /******************************************************************/
    ULONG       ulCodePage;

    /******************************************************************/
    /* Get driver semaphore and perform entry checks                  */
    /******************************************************************/
    EnterDriver(pdcArg, FunN, EDF_STANDARD | EDF_DONT_CLEAN);

    /******************************************************************/
    /* Return the current codepage.                                   */
    /******************************************************************/
    ulCodePage = pdc->DCICodePage;

    /******************************************************************/
    /* Release driver semaphore                                       */
    /******************************************************************/
    ExitDriver(pdcArg, FunN, EDF_STANDARD | EDF_DONT_CLEAN);

    return(ulCodePage);
}
