/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/

/**********************************************************************/
/*                                                                    */
/*   File            = EDDACONE                                       */
/*                                                                    */
/*   Description     = Display Device Driver attributes constants     */
/*                                                                    */
/*   Function        =                                                */
/*                                                                    */
/*   Reference       = Device Driver Interface Specification          */
/*                                                                    */
/*                                                                    */
/**********************************************************************/

/**********************************************************************/
/* Error codes                                                        */
/**********************************************************************/
#define EDDAERR         1500
#define RECT_CONV_FAIL  EDDAERR+1      /* failure to convert clip rect*/
#define RECT_GET_FAIL   EDDAERR+2      /* failure to get next clip rct*/
#define UNKNOWN_PARM    EDDAERR+3

/**********************************************************************/
/* Constants for realize font                                         */
/**********************************************************************/
#define RF_DEVICE_FONT        0x1
#define RF_LOAD_ENGINE_FONT   0x2
#define RF_DELETE_FONT        0x3

#define NO_FONT_MATCH           0

#define DELETE_FONT_ONE         1      /* Delete single table entry   */
#define DELETE_FONT_ALL         2      /* Delete rest of table        */

/**********************************************************************/
/* Options for DeviceGetAttributes.                                   */
/**********************************************************************/
#define GET_FORE_COLOR    0x0001L
#define GET_BACK_COLOR    0x0002L

/**********************************************************************/
/* default values for global attributes                               */
/**********************************************************************/
#define DEFAULT_FOREGROUND_COL   SYSCLR_WINDOWTEXT
#define DEFAULT_BACKGROUND_COL   SYSCLR_WINDOW
#define DEFAULT_FOREGROUND_MIX   2L       /*    FM_OVERPAINT          */
#define DEFAULT_BACKGROUND_MIX   5L       /*    BM_LEAVEALONE         */
#define NO_OF_FOREGROUND_MIXES   18
#define NO_OF_BACKGROUND_MIXES   6
#ifdef LINESBG
#define NO_OF_LINE_MIXES         NO_OF_FOREGROUND_MIXES
#endif /* LINESBG */
#ifdef EXTRAMIX
#define NO_OF_AREA_MIXES         NO_OF_FOREGROUND_MIXES
#endif /* EXTRAMIX */

/**********************************************************************/
/* base value for LCID's                                              */
/**********************************************************************/
#define FTB_LCID_BASE 0x10
#define FONT_DELETED  0

/**********************************************************************/
/* Constants describing the default marker set                        */
/**********************************************************************/
#define  DEF_MARKER_WIDTH     9
#define  DEF_MARKER_HEIGHT    9
#define  DEF_MARKER_WIDTH_IN_BYTES 2
#define  DEF_MARKER_LENGTH   (DEF_MARKER_WIDTH_IN_BYTES*DEF_MARKER_HEIGHT)
#define  DEF_MARKER_NUMBER   12

/**********************************************************************/
/* Constants defining font types                                      */
/**********************************************************************/
#define  FIXED_PITCH          1
#define  PROPORTIONAL_SPACED  2
#define  A_B_C_SPACED         4

/**********************************************************************/
/* Constants to indicate type of codepage                             */
/**********************************************************************/
#define SIMULATED -1
#define REAL      1

/**********************************************************************/
/* Offsets of data within per character data                          */
/**********************************************************************/
#define  CHARDEF_CELLWIDTH    2

/**********************************************************************/
/* Maximum size of patterns                                           */
/**********************************************************************/
#define  MAX_PATTERN_WIDTH   32
#define  MAX_PATTERN_HEIGHT  32

/**********************************************************************/
/* Flags used when converting fonts and bitmaps to patterns and marker*/
/**********************************************************************/
#define  PACKED               1
#define  NOT_PACKED           2
#define  MULTICOLOUR          4

/**********************************************************************/
/* values used when selecting fonts                                   */
/**********************************************************************/
#define ItalicUnderscoreStrikeoutMask  FATTR_SEL_ITALIC |         \
                                       FATTR_SEL_UNDERSCORE |     \
                                       FATTR_SEL_STRIKEOUT
#define Metrics_SemiBold               6
#define Metrics_Fixed_Spaced           1
#define Metrics_Outline                4
