;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
title Display Device Driver Dynamic Link Entry Point
page ,132

;**********************************************************************/
;*                                                                    */
;*   Module File     = EDDDYNA                                        */
;*                                                                    */
;*   Description     = Display Device Driver Dynamic Link Entry Points*/
;*                                                                    */
;*   Function        = Provide entry point for start up procedures    */
;*                     when DLL is loaded.                            */
;*                                                                    */
;*                                                                    */
;**********************************************************************/
                .386p
INCL_GPIBITMAPS EQU 1
include os2.inc
include eddinclt.inc

; Microsoft C likes adding underscores to the start of names
haltproc        equ     <_haltproc>

extrn   XGA_DLLInit                     : NEAR

_TEXT   segment dword use32 public 'CODE'
        assume  cs:FLAT, ds:FLAT, es:FLAT

; We now initialize in C, so just jump to the C code
; this will not affect the stack frame, and the C code will return
; directly to the calling point
        public  loadproc
loadproc        proc    near
        jmp     XGA_DLLInit
loadproc        endp

; A haltproc procedure callable from C is useful for debugging
        public  _haltproc
haltproc        proc    near
        int     3
        ret
haltproc        endp

_TEXT   ends

END     loadproc
