/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/*static char *SCCSID = "@(#)dekko32.h  6.3 91/11/21";*/
/**********************************************************************/
/*                                                                    */
/* Include File    = Dekko32.H                                        */
/*                                                                    */
/* Description     = 32 bit Dekko trace common header information     */
/*                                                                    */
/* Function        = Declare trace API, and define macros to invoke   */
/*                   it. As macros take a fixed number of parameters, */
/*                   a different one is required for each possible    */
/*                   number of PM API arguments.                      */
/*                                                                    */
/*                                                                    */
/* Flag Reason   Rlse Date   Origin   Comments                        */
/* ---- -------- ---- ------ -------  ------------------------------- */
/* STA1 PTR73175  2.1 930820 STA      Remove timing hooks             */
/**********************************************************************/


VOID FAR cdecl Dekko32Trace( ULONG, ULONG, ULONG, PSZ );

/* Macro for PM call with 0 parameters. */
#define Dekko32Trace0(a,b,c,d)  \
  c APIENTRY Dek##d( VOID );    \
  c APIENTRY Dek##d( VOID )     \
  { c result;                   \
  Dekko32Trace(a##00,b,0,NULL); \
  result = d();                 \
  Dekko32Trace(a##80,b,0,NULL); \
  return( result ); }

/* Macro for Void PM call with 0 parameters. */
#define Dekko32Trace0Void(a,b,c,d)  \
  c APIENTRY Dek##d( VOID );        \
  c APIENTRY Dek##d( VOID )         \
  { Dekko32Trace(a##00,b,0,NULL);   \
  d();                              \
  Dekko32Trace(a##80,b,0,NULL);     \
  return; }

/* Macro for PM call with 1 parameter. */
#define Dekko32Trace1(a,b,c,d,e) \
  c APIENTRY Dek##d(##e p1);     \
  c APIENTRY Dek##d(##e p1)      \
  { c result;                    \
  Dekko32Trace(a##00,b,0,NULL);  \
  result = d(p1);                \
  Dekko32Trace(a##80,b,0,NULL);  \
  return( result ); }

/* Macro for Void PM call with 1 parameter. */
#define Dekko32Trace1Void(a,b,c,d,e) \
  c APIENTRY Dek##d(##e p1);         \
  c APIENTRY Dek##d(##e p1)          \
  { Dekko32Trace(a##00,b,0,NULL);    \
  d(p1);                             \
  Dekko32Trace(a##80,b,0,NULL);      \
  return; }

/* Macro for PM call with 2 parameters. */
#define Dekko32Trace2(a,b,c,d,e,f)  \
  c APIENTRY Dek##d(##e p1,##f p2); \
  c APIENTRY Dek##d(##e p1,##f p2)  \
  { c result;                       \
  Dekko32Trace(a##00,b,0,NULL);     \
  result = d(p1,p2);                \
  Dekko32Trace(a##80,b,0,NULL);     \
  return( result ); }

/* Macro for Void PM call with 2 parameters. */
#define Dekko32Trace2Void(a,b,c,d,e,f) \
  c APIENTRY Dek##d(##e p1,##f p2);    \
  c APIENTRY Dek##d(##e p1,##f p2)     \
  { Dekko32Trace(a##00,b,0,NULL);      \
  d(p1,p2);                            \
  Dekko32Trace(a##80,b,0,NULL);        \
  return; }

/* Macro for PM call with 2 parameters, tracing parameter 2. */
#define Dekko32Trace2Plus2(a,b,c,d,e,f)             \
  c APIENTRY Dek##d(##e p1,##f p2);                 \
  c APIENTRY Dek##d(##e p1,##f p2)                  \
  { c result;                                       \
  Dekko32Trace(a##00,b,sizeof(p2),(CHAR FAR *)&p2); \
  result = d(p1,p2);                                \
  Dekko32Trace(a##80,b,0,NULL);                     \
  return( result ); }

/* Macro for PM call with 2 parameters, tracing the  */
/* "msg" part of parameter 2, which must be a PQMSG. */
#define Dekko32Trace2Plus2Msg(a,b,c,d,e,f)                      \
  c APIENTRY Dek##d(##e p1,##f p2);                             \
  c APIENTRY Dek##d(##e p1,##f p2)                              \
  { c result;                                                   \
  Dekko32Trace(a##00,b,sizeof(p2->msg),(CHAR FAR *)&(p2->msg)); \
  result = d(p1,p2);                                            \
  Dekko32Trace(a##80,b,0,NULL);                                 \
  return( result ); }

/* Macro for PM call with 3 parameters. */
#define Dekko32Trace3(a,b,c,d,e,f,g)       \
  c APIENTRY Dek##d(##e p1,##f p2,##g p3); \
  c APIENTRY Dek##d(##e p1,##f p2,##g p3)  \
  { c result;                              \
  Dekko32Trace(a##00,b,0,NULL);            \
  result = d(p1,p2,p3);                    \
  Dekko32Trace(a##80,b,0,NULL);            \
  return( result ); }


/* Macro for Void PM call with 3 parameters. */
#define Dekko32Trace3Void(a,b,c,d,e,f,g)   \
  c APIENTRY Dek##d(##e p1,##f p2,##g p3); \
  c APIENTRY Dek##d(##e p1,##f p2,##g p3)  \
  { Dekko32Trace(a##00,b,0,NULL);          \
  d(p1,p2,p3);                             \
  Dekko32Trace(a##80,b,0,NULL);            \
  return; }

/* Macro for PM call with 3 parameters, tracing parameter 3. */
#define Dekko32Trace3Plus3(a,b,c,d,e,f,g)           \
  c APIENTRY Dek##d(##e p1,##f p2,##g p3);          \
  c APIENTRY Dek##d(##e p1,##f p2,##g p3)           \
  { c result;                                       \
  Dekko32Trace(a##00,b,sizeof(p3),(CHAR FAR *)&p3); \
  result = d(p1,p2,p3);                             \
  Dekko32Trace(a##80,b,0,NULL);                     \
  return( result ); }

/* Macro for PM call with 4 parameters. */
#define Dekko32Trace4(a,b,c,d,e,f,g,h)            \
  c APIENTRY Dek##d(##e p1,##f p2,##g p3,##h p4); \
  c APIENTRY Dek##d(##e p1,##f p2,##g p3,##h p4)  \
  { c result;                                     \
  Dekko32Trace(a##00,b,0,NULL);                   \
  result = d(p1,p2,p3,p4);                        \
  Dekko32Trace(a##80,b,0,NULL);                   \
  return( result ); }

/* Macro for PM call with 4 parameters, tracing parameter 2. */
#define Dekko32Trace4Plus2(a,b,c,d,e,f,g,h)         \
  c APIENTRY Dek##d(##e p1,##f p2,##g p3,##h p4);   \
  c APIENTRY Dek##d(##e p1,##f p2,##g p3,##h p4)    \
  { c result;                                       \
  Dekko32Trace(a##00,b,sizeof(p2),(CHAR FAR *)&p2); \
  result = d(p1,p2,p3,p4);                          \
  Dekko32Trace(a##80,b,0,NULL);                     \
  return( result ); }

/* Macro for PM call with 4 parameters, tracing parameter 4. */
#define Dekko32Trace4Plus4(a,b,c,d,e,f,g,h)         \
  c APIENTRY Dek##d(##e p1,##f p2,##g p3,##h p4);   \
  c APIENTRY Dek##d(##e p1,##f p2,##g p3,##h p4)    \
  { c result;                                       \
  Dekko32Trace(a##00,b,sizeof(p4),(CHAR FAR *)&p4); \
  result = d(p1,p2,p3,p4);                          \
  Dekko32Trace(a##80,b,0,NULL);                     \
  return( result ); }

/* Macro for PM call with 5 parameters. */
#define Dekko32Trace5(a,b,c,d,e,f,g,h,i)                 \
  c APIENTRY Dek##d(##e p1,##f p2,##g p3,##h p4,##i p5); \
  c APIENTRY Dek##d(##e p1,##f p2,##g p3,##h p4,##i p5)  \
  { c result;                                            \
  Dekko32Trace(a##00,b,0,NULL);                          \
  result = d(p1,p2,p3,p4,p5);                            \
  Dekko32Trace(a##80,b,0,NULL);                          \
  return( result ); }

/* Macro for PM call with 5 parameters, tracing parameter 5. */
#define Dekko32Trace5Plus5(a,b,c,d,e,f,g,h,i)            \
  c APIENTRY Dek##d(##e p1,##f p2,##g p3,##h p4,##i p5); \
  c APIENTRY Dek##d(##e p1,##f p2,##g p3,##h p4,##i p5)  \
  { c result;                                            \
  Dekko32Trace(a##00,b,sizeof(p5),(CHAR FAR *)&p5);      \
  result = d(p1,p2,p3,p4,p5);                            \
  Dekko32Trace(a##80,b,0,NULL);                          \
  return( result ); }

/* Macro for PM call with 6 parameters. */
#define Dekko32Trace6(a,b,c,d,e,f,g,h,i,j)                      \
  c APIENTRY Dek##d(##e p1,##f p2,##g p3,##h p4,##i p5,##j p6); \
  c APIENTRY Dek##d(##e p1,##f p2,##g p3,##h p4,##i p5,##j p6)  \
  { c result;                                                   \
  Dekko32Trace(a##00,b,0,NULL);                                 \
  result = d(p1,p2,p3,p4,p5,p6);                                \
  Dekko32Trace(a##80,b,0,NULL);                                 \
  return( result ); }


/* Macro for PM call with 6 parameters, tracing parameter 6. */
#define Dekko32Trace6Plus6(a,b,c,d,e,f,g,h,i,j)                 \
  c APIENTRY Dek##d(##e p1,##f p2,##g p3,##h p4,##i p5,##j p6); \
  c APIENTRY Dek##d(##e p1,##f p2,##g p3,##h p4,##i p5,##j p6)  \
  { c result;                                                   \
  Dekko32Trace(a##00,b,sizeof(p6),(CHAR FAR *)&p6);             \
  result = d(p1,p2,p3,p4,p5,p6);                                \
  Dekko32Trace(a##80,b,0,NULL);                                 \
  return( result ); }

/* Macro for PM call with 7 parameters. */
#define Dekko32Trace7(a,b,c,d,e,f,g,h,i,j,k)                           \
  c APIENTRY Dek##d(##e p1,##f p2,##g p3,##h p4,##i p5,##j p6,##k p7); \
  c APIENTRY Dek##d(##e p1,##f p2,##g p3,##h p4,##i p5,##j p6,##k p7)  \
  { c result;                                                          \
  Dekko32Trace(a##00,b,0,NULL);                                        \
  result = d(p1,p2,p3,p4,p5,p6,p7);                                    \
  Dekko32Trace(a##80,b,0,NULL);                                        \
  return( result ); }

/* Macro for PM call with 7 parameters, tracing parameter 7. */
#define Dekko32Trace7Plus7(a,b,c,d,e,f,g,h,i,j,k)                      \
  c APIENTRY Dek##d(##e p1,##f p2,##g p3,##h p4,##i p5,##j p6,##k p7); \
  c APIENTRY Dek##d(##e p1,##f p2,##g p3,##h p4,##i p5,##j p6,##k p7)  \
  { c result;                                                          \
  Dekko32Trace(a##00,b,sizeof(p7),(CHAR FAR *)&p7);                    \
  result = d(p1,p2,p3,p4,p5,p6,p7);                                    \
  Dekko32Trace(a##80,b,0,NULL);                                        \
  return( result ); }

/* Macro for PM call with 8 parameters. */
#define Dekko32Trace8(a,b,c,d,e,f,g,h,i,j,k,l)                                  \
  c APIENTRY Dek##d(##e p1,##f p2,##g p3,##h p4,##i p5,##j p6,##k p7,##l p8); \
  c APIENTRY Dek##d(##e p1,##f p2,##g p3,##h p4,##i p5,##j p6,##k p7,##l p8)  \
  { c result;                                                                 \
  Dekko32Trace(a##00,b,0,NULL);                                               \
  result = d(p1,p2,p3,p4,p5,p6,p7,p8);                                        \
  Dekko32Trace(a##80,b,0,NULL);                                                 \
  return( result ); }

/* Macro for PM call with 8 parameters, tracing parameter 8. */
#define Dekko32Trace8Plus8(a,b,c,d,e,f,g,h,i,j,k,l)                           \
  c APIENTRY Dek##d(##e p1,##f p2,##g p3,##h p4,##i p5,##j p6,##k p7,##l p8); \
  c APIENTRY Dek##d(##e p1,##f p2,##g p3,##h p4,##i p5,##j p6,##k p7,##l p8)  \
  { c result;                                                                 \
  Dekko32Trace(a##00,b,sizeof(p8),(CHAR FAR *)&p8);                           \
  result = d(p1,p2,p3,p4,p5,p6,p7,p8);                                        \
  Dekko32Trace(a##80,b,0,NULL);                                                 \
  return( result ); }

/* Macro for PM call with 9 parameters. */
#define Dekko32Trace9(a,b,c,d,e,f,g,h,i,j,k,l,m)                                     \
  c APIENTRY Dek##d(##e p1,##f p2,##g p3,##h p4,##i p5,##j p6,##k p7,##l p8,##m p9); \
  c APIENTRY Dek##d(##e p1,##f p2,##g p3,##h p4,##i p5,##j p6,##k p7,##l p8,##m p9)  \
  { c result;                                                                        \
  Dekko32Trace(a##00,b,0,NULL);                                                      \
  result = d(p1,p2,p3,p4,p5,p6,p7,p8,p9);                                            \
  Dekko32Trace(a##80,b,0,NULL);                                                      \
  return( result ); }

/* Macro for PM call with 9 parameters, tracing parameter 9. */
#define Dekko32Trace9Plus9(a,b,c,d,e,f,g,h,i,j,k,l,m)                                \
  c APIENTRY Dek##d(##e p1,##f p2,##g p3,##h p4,##i p5,##j p6,##k p7,##l p8,##m p9); \
  c APIENTRY Dek##d(##e p1,##f p2,##g p3,##h p4,##i p5,##j p6,##k p7,##l p8,##m p9)  \
  { c result;                                                                        \
  Dekko32Trace(a##00,b,sizeof(p9),(CHAR FAR *)&p9);                                  \
  result = d(p1,p2,p3,p4,p5,p6,p7,p8,p9);                                            \
  Dekko32Trace(a##80,b,0,NULL);                                                      \
  return( result ); }

/* Macro for PM call with 10 parameters. */
#define Dekko32Trace10(a,b,c,d,e,f,g,h,i,j,k,l,m,n)                                          \
  c APIENTRY Dek##d(##e p1,##f p2,##g p3,##h p4,##i p5,##j p6,##k p7,##l p8,##m p9,##n p10); \
  c APIENTRY Dek##d(##e p1,##f p2,##g p3,##h p4,##i p5,##j p6,##k p7,##l p8,##m p9,##n p10)  \
  { c result;                                                                                \
  Dekko32Trace(a##00,b,0,NULL);                                                              \
  result = d(p1,p2,p3,p4,p5,p6,p7,p8,p9,p10);                                                \
  Dekko32Trace(a##80,b,0,NULL);                                                              \
  return( result ); }

/* Macro for PM call with 10 parameters, tracing parameter 10. */
#define Dekko32Trace10Plus10(a,b,c,d,e,f,g,h,i,j,k,l,m,n)                                    \
  c APIENTRY Dek##d(##e p1,##f p2,##g p3,##h p4,##i p5,##j p6,##k p7,##l p8,##m p9,##n p10); \
  c APIENTRY Dek##d(##e p1,##f p2,##g p3,##h p4,##i p5,##j p6,##k p7,##l p8,##m p9,##n p10)  \
  { c result;                                                                                \
  Dekko32Trace(a##00,b,sizeof(p10),(CHAR FAR *)&p10);                                        \
  result = d(p1,p2,p3,p4,p5,p6,p7,p8,p9,p10);                                                \
  Dekko32Trace(a##80,b,0,NULL);                                                              \
  return( result ); }

/* Macro for PM call with 11 parameters. */
#define Dekko32Trace11(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o)                                                \
  c APIENTRY Dek##d(##e p1,##f p2,##g p3,##h p4,##i p5,##j p6,##k p7,##l p8,##m p9,##n p10,##o p11); \
  c APIENTRY Dek##d(##e p1,##f p2,##g p3,##h p4,##i p5,##j p6,##k p7,##l p8,##m p9,##n p10,##o p11)  \
  { c result;                                                                                        \
  Dekko32Trace(a##00,b,0,NULL);                                                                      \
  result = d(p1,p2,p3,p4,p5,p6,p7,p8,p9,p10,p11);                                                    \
  Dekko32Trace(a##80,b,0,NULL);                                                                      \
  return( result ); }

/* Macro for PM call with 13 parameters. */
#define Dekko32Trace13(a,b,c,d,e,f,g,h,i,j,k,l,m,n,o,p,q)                                                            \
  c APIENTRY Dek##d(##e p1,##f p2,##g p3,##h p4,##i p5,##j p6,##k p7,##l p8,##m p9,##n p10,##o p11,##p p12,##q p13); \
  c APIENTRY Dek##d(##e p1,##f p2,##g p3,##h p4,##i p5,##j p6,##k p7,##l p8,##m p9,##n p10,##o p11,##p p12,##q p13)  \
  { c result;                                                                                                        \
  Dekko32Trace(a##00,b,0,NULL);                                                                                      \
  result = d(p1,p2,p3,p4,p5,p6,p7,p8,p9,p10,p11,p12,p13);                                                            \
  Dekko32Trace(a##80,b,0,NULL);                                                                                      \
  return( result ); }
