/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
#ifdef DCAF

/**********************************************************************/
/* DCAF function definitions used within the Driver.                  */
/**********************************************************************/
VOID    AccumulateScreenBounds(PRECTL prclArgBound);

VOID    AccumulateScreenBoundsThroughClips( pDevRect pBoundCoords,
                                            ULONG    ulCoordType  );


/***********************************************************************/
/* Define the macro that decides whether we accumulate DCAF            */
/* bounds.                                                             */
/* The criteria for accumulating DCAF bounds are:                      */
/*   - COM_SCR_BOUND is set                                            */
/*   - COM_DRAW is set                                                 */
/*   - the destination is the screen                                   */
/***********************************************************************/
#define DCAFBoundsRequired(FunN)     \
    ( (FunN & COM_SCR_BOUND) &&       \
      (FunN & COM_DRAW) &&            \
      (pdc->DCIDCType == OD_DIRECT) )

#endif
