;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/

MAXULONG        EQU     0FFFFFFFFH
GSB_OPT_4BPP    EQU     0000H
GSB_OPT_8BPP    EQU     0001H
GSB_OPT_16BPP   EQU     0002H
GSB_OPT_24BPP   EQU     0004H
GSB_OPT_LINEAR  EQU     0000H
GSB_OPT_PLANAR  EQU     0008H
GSB_OPT_HRGN    EQU     0010H
COM_SCR_BOUND   EQU     0200H
COM_CLIP_BOUND  EQU     0400H
COM_CLIP_TO_SCREEN      EQU     0800H
PMERR_NO_HANDLE EQU     1203H

RECTS           struc
rcs_xLeft       dw      ?
rcs_yBottom     dw      ?
rcs_xRight      dw      ?
rcs_yTop        dw      ?
RECTS           ends


ifdef NRECT
% MAX_SCA_RECTS equ NRECT
else
MAX_SCA_RECTS   EQU     14
endif

SCA     STRUC
sca_pNextSCA    DD      ?
sca_cRects      DD      ?
sca_arcl        DB      SIZE RECTL * (MAX_SCA_RECTS+1) DUP (?)
sca_aulRectSize DD      MAX_SCA_RECTS+1 DUP (?)
SCA     ENDS

ifdef DCAFTEST
DEVESC_DCAF_OSCA        EQU     0DCAFH
DEVESC_DCAF_GSCA        EQU     0DCAEH
DEVESC_DCAF_CSCA        EQU     0DCADH
DEVESC_DCAF_ON  EQU     0DCACH
DEVESC_DCAF_OFF EQU     0DCABH
DEVESC_DCAF_GSB EQU     0DCAAH
DEVESC_DCAF_SSB EQU     0DCA9H
endif

PACKETHDR       STRUC
phd_length      DD      ?
phd_format      DW      ?
PACKETHDR       ENDS


CD_MAX_8BIT_RUN_LENGTH  EQU     7FH
CD_NON_REPEATING_DATA_FLAG_8    EQU     80H
CD_NON_REPEATING_DATA_FLAG_16   EQU     8000H

MAX_X_RESOLUTION        EQU     1024
MAX_SCANLINE_BYTES      EQU     (MAX_X_RESOLUTION*2 )

WORST_CASE_ROW_EXPANSION EQU     ((MAX_X_RESOLUTION+CD_MAX_8BIT_RUN_LENGTH-1 )/CD_MAX_8BIT_RUN_LENGTH)


WORST_CASE_ROW_LENGTH   EQU     (MAX_SCANLINE_BYTES+WORST_CASE_ROW_EXPANSION)
MIN_BUFFER_SIZE EQU     (SIZE   PACKETHDR  + SIZE   RECTS  + WORST_CASE_ROW_LENGTH)
ifdef S3
    GSB_OPT_FLAGS   EQU     (GSB_OPT_4BPP  OR  GSB_OPT_8BPP  OR  GSB_OPT_16BPP  OR  GSB_OPT_24BPP  OR  GSB_OPT_LINEAR  OR    GSB_OPT_PLANAR  OR  GSB_OPT_HRGN)
    GSB_FORMAT_FLAGS        EQU     (GSB_OPT_4BPP  OR  GSB_OPT_8BPP  OR    GSB_OPT_16BPP  OR  GSB_OPT_24BPP  OR  GSB_OPT_LINEAR  OR    GSB_OPT_PLANAR)
else
    GSB_OPT_FLAGS   EQU     (GSB_OPT_4BPP  OR  GSB_OPT_8BPP  OR    GSB_OPT_16BPP  OR  GSB_OPT_LINEAR  OR    GSB_OPT_PLANAR  OR  GSB_OPT_HRGN)
    GSB_FORMAT_FLAGS        EQU     (GSB_OPT_4BPP  OR  GSB_OPT_8BPP  OR    GSB_OPT_16BPP  OR  GSB_OPT_LINEAR  OR    GSB_OPT_PLANAR)
endif
