/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**********************************************************************/
/*                                                                    */
/*   File            = CACHEMAN                                       */
/*                                                                    */
/*   Description     = Display Device Driver header for cache mgr.    */
/*                                                                    */
/*   Function        =                                                */
/*                                                                    */
/*   Reference       = Device Driver Interface Specification          */
/*                                                                    */
/*                                                                    */
/**********************************************************************/


typedef struct _HWMAP { /* hwm */
        ULONG   vis_width;
        ULONG   vis_height;
        ULONG   phys_width;
        ULONG   phys_height;
        ULONG   phys_memory;
        ULONG   BitCount;
        ULONG   hw_cursor;
        ULONG   hw_cursor_Y1024;
        ULONG   and_mask;
        ULONG   xor_mask;
        ULONG   save_area;
        ULONG   color_cursor;
        ULONG   start_bm_cache;
        ULONG   num_font_planes;
        ULONG   vertical_bmaps;
#ifdef ENDIVE
        ULONG   ulScanLine;
        ULONG   ulScanLineBytes;
        ULONG   ulScansShared;
        ULONG   ulScansPrivate;
#endif
} HWMAP;

typedef HWMAP  *PHWMAP;


typedef struct _CACHEMAP { /* cm */
        ULONG   max_bitmaps;
        ULONG   font_cache_start;
        ULONG   font_cache_left;
        ULONG   font_cache_top;
        ULONG   font_cache_right;
        ULONG   font_cache_bottom;
        ULONG   color_dither;
        ULONG   mono_dither;
} CACHEMAP;

typedef CACHEMAP *PCACHEMAP;

#define TURN_SEAMLESS_ON        1
#define TURN_SEAMLESS_OFF       0

extern  ULONG   HWResolution;
extern  HWMAP   aResTable[];

#define MAX_HW_RESOLUTION_INDEX         11

