/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**********************************************************************/
/*                                                                    */
/*   Module          = CACHEMAN                                       */
/*                                                                    */
/*   Description     = Display Device Driver off-screen cache manager.*/
/*                                                                    */
/*   Function        = CacheManager()                                 */
/*                                                                    */
/*                                                                    */
/**********************************************************************/
#ifdef _8514
#include <eddinclt.h>
#include <cacheman.h>

// HWResolution is an index that describes the current resolution and the
// amount of memory we have to work with.  The configurations currently
// supported are:
//
//      0        640 x  480 x  8 in .5 Meg
//      1        640 x  480 x  8 in  1 Meg
//      2        800 x  600 x  8 in  1 Meg
//      3       1024 x  768 x  8 in  1 Meg
//      4       1280 x 1024 x  8 in  2 Meg
//      5        640 x  480 x 16 in  1 Meg
//      6        800 x  600 x 16 in  1 Meg
//      7        800 x  600 x 16 in  2 Meg
//      8       1024 x  768 x 16 in  2 Meg
//      9        640 x  480 x 24 in  1 Meg
//     10        640 x  480 x 24 in  2 Meg
//     11       1024 x  768 x 24 in  4 Meg

ULONG   HWResolution;

// This table, aFontTable, contains all the values needed to manage the
// offscreen VRAM resource for both PM only or PM w/ seamless.  When
// CacheManager() is called, he uses the HWResolution value (described
// above) and the fSeamlessOn flag to calculate which structure in the
// array to use for our mapping values.  The array is organized so that
// the first two array structures contain the values for the PM only and
// the PM w/ Seamless configurations for the first HW Resolution.  The
// second two array structures are used for the second HW Resolution, and
// so on.


CACHEMAP      aFontTable[] = {
                             //   max     start     left    top    right   bottom     mono        color
                             // bitmaps,  fonts,   fonts,  fonts,  fonts,  fonts,    dither,     dither
                             //============================================================================
/* HWResolution 0        */  {    0L,  0xF08001E0,  128L,   480L,   952L,   510L,  0xF3C001E0, 0xF3E001E0 },
/* HWResolution 0 w/ S/L */  {    0L,  0xF08001E0,  128L,   480L,   952L,   510L,  0xF3C001E0, 0xF3E001E0 },

/* HWResolution 1        */  {    8L,  0xF0000260,    0L,   608L,  1016L,  1023L,  0xF3C001E0, 0xF3C00220 },
/* HWResolution 1 w/ S/L */  {    8L,  0xF0000260,    0L,   608L,  1016L,   751L,  0xF3C001E0, 0xF3C00220 },

/* HWResolution 2        */  {   13L,  0xF00002E0,    0L,   736L,  1016L,  1023L,  0xF3C00260, 0xF3C002A0 },
/* HWResolution 2 w/ S/L */  {    2L,  0xF1000260,  256L,   608L,  1016L,   812L,  0xF00002E0, 0xF04002E0 },

/* HWResolution 3        */  {   13L,  0xF0000380,    0L,   896L,  1016L,  1023L,  0xF3C00300, 0xF3C00340 },
/* HWResolution 3 w/ S/L */  {    2L,  0xF1000300,  256L,   768L,   952L,   894L,  0xF3C00300, 0xF3C00340 },

/* HWResolution 4        */  {   17L,  0xF0000481,    0L,  1153L,  1272L,  1637L,  0xF4C00400, 0xF4C00440 },
/* HWResolution 4 w/ S/L */  {   17L,  0xF0000481,    0L,  1153L,  1272L,  1330L,  0xF4C00400, 0xF4C00440 },

/* HWResolution 5        */  {    7L,  0xF0000260,    0L,   608L,   632L,   818L,  0xF24001E1, 0xF2400220 },
/* HWResolution 5 w/ S/L */  {    2L,  0xF10001E1,  256L,   480L,   632L,   649L,  0xF0000260, 0xF0400260 },

/* HWResolution 6        */  {    0L,  0xF1000259,  256L,   601L,   728L,   655L,  0xF2E00259, 0xF3000259 },
/* HWResolution 6 w/ S/L */  {    0L,  0xF1000259,  256L,   601L,   728L,   636L,  0xF2E00259, 0xF3000259 },

/* HWResolution 7        */  {   10L,  0xF00002E0,    0L,   736L,   792L,  1310L,  0xF3000260, 0xF30002A0 },
/* HWResolution 7 w/ S/L */  {   10L,  0xF00002E0,    0L,   736L,   792L,   954L,  0xF3000260, 0xF30002A0 },

/* HWResolution 8        */  {   13L,  0xF0000380,    0L,   896L,  1016L,  1023L,  0xF3C00300, 0xF3C00340 },
/* HWResolution 8 w/ S/L */  {    2L,  0xF1000300,  256L,   768L,   952L,   894L,  0xF3C00300, 0xF3C00340 },

/* HWResolution 9        */  {    2L,  0xF00001E1,    0L,   481L,   640L,   512L,  0xF28000A0, 0xF28000E0 },
/* HWResolution 9 w/ S/L */  {    2L,  0xF00001E1,    0L,   481L,   640L,   504L,  0xF28000A0, 0xF28000E0 },

/* HWResolution 10        */  {    8L,  0xF0000260,    0L,   608L,   624L,  1023L,  0xF27001E0, 0xF2700220 },
/* HWResolution 10 w/ S/L */  {    8L,  0xF0000260,    0L,   608L,   624L,  1023L,  0xF27001E0, 0xF2700220 },

/* HWResolution 11        */ {    0L,  0x00000000,    0L,     0L,     0L,     0L,  0x00000000, 0x00000000 },
/* HWResolution 11 w/ S/L */ {    0L,  0x00000000,    0L,     0L,     0L,     0L,  0x00000000, 0x00000000 }
                };
#ifdef ENDIVE
HWMAP      aResTable[] = {
             //  vis     vis    phys   phys     phys     Bit       HW     HW Cursor    AND         XOR        Save         Color       BMap     Font   Vertical ScanLine ScanLine  Shared  Private
             // width, height, width, height,  memory,  Count,   cursor,   Y_1024,     Mask,       Mask,      Area,        BMap,      Cache,   Planes,   Bmaps,  Pels,    Bytes,   Scans,   Scans
             //===================================================================================================================================================================================
/* [ 0  ] */ {   640L,  480L,  1024L,   512L, 0x080000,   8,   0xF00001FF,   511L,  0xF00001E0, 0xF02001E0, 0xF04001E0, 0xF06001E0, 0xF0000000,  8L,       0L,   1024L,   1024L,    20L,    20L },
/* [ 1  ] */ {   640L,  480L,  1024L,  1024L, 0x700000,   8,   0xF000025F,   607L,  0xF00001E0, 0xF04001E0, 0xF0000220, 0xF0400220, 0xF08001E0,  8L,       0L,   1024L,   1024L,    20L,    20L },
/* [ 2  ] */ {   800L,  600L,  1024L,  1024L, 0x700000,   8,   0xF0000258,   600L,  0xF0000260, 0xF0400260, 0xF00002A0, 0xF04002A0, 0xF0800260,  8L,       0L,   1024L,   1024L,    20L,    20L },
/* [ 3  ] */ {  1024L,  768L,  1024L,  1024L, 0x700000,   8,   0xF000037F,   895L,  0xF0000300, 0xF0400300, 0xF0000340, 0xF0400340, 0xF0800300,  8L,       0L,   1024L,   1024L,    20L,    20L },
/* [ 4  ] */ {  1280L, 1024L,  1280L,  1638L, 0x600000,   8,   0xF0000480,  1440L,  0xF0000400, 0xF0400400, 0xF0000440, 0xF0400440, 0xF0800400,  8L,       0L,   1280L,   1280L,    20L,    20L },
/* [ 5  ] */ {   640L,  480L,   640L,   819L, 0x700000,  16,   0xF00001E0,   600L,  0xF00001E0, 0xF04001E0, 0xF0000220, 0xF0400220, 0xF08001E1, 16L,       0L,    640L,   1280L,    20L,    20L },
/* [ 6  ] */ {   800L,  600L,   800L,   655L, 0x100000,  16,   0xF1000258,   938L,  0xF0000258, 0xF0400258, 0xF0800258, 0xF0C00258, 0xF1000259,  8L,       0L,    800L,   1600L,    10L,     0L },
/* [ 7  ] */ {   800L,  600L,   800L,  1310L, 0x600000,  16,   0xF1000258,   938L,  0xF0000260, 0xF0400260, 0xF00002A0, 0xF04002A0, 0xF0800260, 16L,       0L,    800L,   1600L,    20L,    20L },
/* [ 8  ] */ {  1024L,  768L,  1024L,  1024L, 0x600000,  16,   0xF000037F,  1790L,  0xF0000300, 0xF0400300, 0xF0000340, 0xF0400340, 0xF0800300, 16L,       0L,   1024L,   2048L,    20L,    20L },
/* [ 9  ] */ {   640L,  480L,  2048L,   512L, 0x100000,  24,   0xF00001E0,   960L,  0xF2800000, 0xF2800028, 0xF2800050, 0xF2800078, 0xF2800120,  1L,       2L,    682L,   2048L,     0L,     0L },
/* [ 10 ] */ {   640L,  480L,  2048L,  1024L, 0x200000,  24,   0xF000025f,  1214L,  0xF00001E0, 0xF04001E0, 0xF0000220, 0xF0400220, 0xF08001E0,  1L,       0L,    682L,   2048L,    20L,    20L },
/* [ 11 ] */ {  1024L,  768L,  1024L,  1024L, 0x400000,  24,   0xF000037F,  2685L,  0xF0000300, 0xF0400300, 0xF0400340, 0xF0400340, 0x00000000,  1L,       0L,   1024L,   3072L,    20L,    20L }
                };
#else
HWMAP      aResTable[] = {
             //  vis     vis    phys   phys     phys     Bit       HW     HW Cursor    AND         XOR        Save         Color       BMap     Font   Vertical
             // width, height, width, height,  memory,  Count,   cursor,   Y_1024,     Mask,       Mask,      Area,        BMap,      Cache,   Planes,   Bmaps
             //================================================================================================================================================
/* [ 0  ] */ {   640L,  480L,  1024L,   512L, 0x080000,   8,   0xF00001FF,   511L,  0xF00001E0, 0xF02001E0, 0xF04001E0, 0xF06001E0, 0xF0000000,  8L,       0L },
/* [ 1  ] */ {   640L,  480L,  1024L,  1024L, 0x700000,   8,   0xF000025F,   607L,  0xF00001E0, 0xF04001E0, 0xF0000220, 0xF0400220, 0xF08001E0,  8L,       0L },
/* [ 2  ] */ {   800L,  600L,  1024L,  1024L, 0x700000,   8,   0xF0000258,   600L,  0xF0000260, 0xF0400260, 0xF00002A0, 0xF04002A0, 0xF0800260,  8L,       0L },
/* [ 3  ] */ {  1024L,  768L,  1024L,  1024L, 0x700000,   8,   0xF000037F,   895L,  0xF0000300, 0xF0400300, 0xF0000340, 0xF0400340, 0xF0800300,  8L,       0L },
/* [ 4  ] */ {  1280L, 1024L,  1280L,  1638L, 0x600000,   8,   0xF0000480,  1440L,  0xF0000400, 0xF0400400, 0xF0000440, 0xF0400440, 0xF0800400,  8L,       0L },
/* [ 5  ] */ {   640L,  480L,   640L,   819L, 0x700000,  16,   0xF00001E0,   600L,  0xF00001E0, 0xF04001E0, 0xF0000220, 0xF0400220, 0xF08001E1, 16L,       0L },
/* [ 6  ] */ {   800L,  600L,   800L,   655L, 0x100000,  16,   0xF1000258,   938L,  0xF0000258, 0xF0400258, 0xF0800258, 0xF0C00258, 0xF1000259,  8L,       0L },
/* [ 7  ] */ {   800L,  600L,   800L,  1310L, 0x600000,  16,   0xF1000258,   938L,  0xF0000260, 0xF0400260, 0xF00002A0, 0xF04002A0, 0xF0800260, 16L,       0L },
/* [ 8  ] */ {  1024L,  768L,  1024L,  1024L, 0x600000,  16,   0xF000037F,  1790L,  0xF0000300, 0xF0400300, 0xF0000340, 0xF0400340, 0xF0800300, 16L,       0L },
/* [ 9  ] */ {   640L,  480L,  2048L,   512L, 0x100000,  24,   0xF00001E0,   960L,  0xF2800000, 0xF2800028, 0xF2800050, 0xF2800078, 0xF2800120,  1L,       2L },
/* [ 10 ] */ {   640L,  480L,  2048L,  1024L, 0x200000,  24,   0xF000025f,  1214L,  0xF00001E0, 0xF04001E0, 0xF0000220, 0xF0400220, 0xF08001E0,  1L,       0L },
/* [ 11 ] */ {  1024L,  768L,  1024L,  1024L, 0x400000,  24,   0xF000037F,  2685L,  0xF0000300, 0xF0400300, 0xF0400340, 0xF0400340, 0x00000000,  1L,       0L }
                };
#endif

PCACHEMAP       pCacheMap;
PHWMAP          pHWMap;

VOID CacheManager (BOOL fSeamlessOn)
{
    pHWMap = &(aResTable[ HWResolution ]);

    if (fSeamlessOn)
        pCacheMap = &(aFontTable[ HWResolution*2 + 1 ]);
    else
        pCacheMap = &(aFontTable[ HWResolution*2 ]);
}

#endif /* _8514 */
