;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;/*****************************************************************************
;*
;* SOURCE FILE NAME = TGRIO.ASM
;*
;* DESCRIPTIVE NAME = IO routines.
;*
;*
;* VERSION      V2.1
;*
;* DATE
;*
;* DESCRIPTION
;*
;* FUNCTIONS
;*
;*
;* NOTES        NONE
;*
;* STRUCTURES   NONE
;*
;* EXTERNAL REFERENCES
;*
;*              NONE
;*
;* EXTERNAL FUNCTIONS
;*
;*              NONE
;*
;* CHANGE ACTIVITY =
;*  DATE      FLAG        APAR   CHANGE DESCRIPTION
;*  --------  ----------  -----  --------------------------------------
;*  mm/dd/yy  @Vr.mpppxx  xxxxx  xxxxxxx
;*
;*****************************************************************************/

.386p

;/*
;**  Include files
;*/

;/*
;**  Segment definitions
;*/

CODE32   SEGMENT dword PUBLIC USE32 'CODE'
CODE32   ENDS

;/*
;**  Externals and Publics
;*/

                PUBLIC  HWInpByte
                PUBLIC  HWInpWord
                PUBLIC  HWInpDWord
                PUBLIC  HWOutpByte
                PUBLIC  HWOutpWord
                PUBLIC  HWOutpDWord
                PUBLIC  HWInt3
                PUBLIC  FlushPipeline

CODE32          SEGMENT
                ASSUME CS:FLAT, DS:FLAT, ES:NOTHING

                ALIGN 4

;************************************************************************
;*
;* FUNCTION NAME = HWInpByte
;*
;* DESCRIPTION   =
;*
;* INPUT         = Port from which to read
;* OUTPUT        = EAX has data read.
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;*************************************************************************

HWInpByte  proc

                push    ebp                     ; 
                mov     ebp,esp                 ; 

                xor     eax,eax                 ; 
                mov     dx,word ptr [ebp+8]     ; 
                in      al,dx                   ; 

                pop     ebp                     ; 
                ret                             ; 

HWInpByte  endp

;************************************************************************
;*
;* FUNCTION NAME = HWInpWord
;*
;* DESCRIPTION   =
;*
;* INPUT         = Port from which to read
;* OUTPUT        = EAX has data read.
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;*************************************************************************

HWInpWord       PROC

                push    ebp                     ; 
                mov     ebp,esp                 ; 

                xor     eax,eax                 ; 
                mov     dx,word ptr [ebp+8]     ; 
                in      ax,dx                   ; 

                pop     ebp                     ; 
                ret                             ; 

HWInpWord       ENDP

;************************************************************************
;*
;* FUNCTION NAME = HWInpDWord
;*
;* DESCRIPTION   =
;*
;* INPUT         = Port from which to read
;* OUTPUT        = EAX has data read.
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;*************************************************************************

HWInpDWord      PROC

                push    ebp                     ; 
                mov     ebp,esp                 ; 

                xor     eax,eax                 ; 
                mov     dx,word ptr [ebp+8]     ; 
                in      eax,dx                  ; 

                pop     ebp                     ; 
                ret                             ; 

HWInpDWord      ENDP

;************************************************************************
;*
;* FUNCTION NAME = HWOutpByte
;*
;* DESCRIPTION   =
;*
;* INPUT         = Port to write to
;*                 Byte of data to write
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;*************************************************************************

HWOutpByte      PROC

                push    ebp                     ; 
                mov     ebp,esp                 ; 

                mov     dx,word ptr [ebp+8]     ; 
                mov     al,byte ptr [ebp+12]    ; 
                out     dx,al                   ; 

                pop     ebp                     ; 
                ret                             ; 

HWOutpByte      ENDP

;************************************************************************
;*
;* FUNCTION NAME = HWOutpWord
;*
;* DESCRIPTION   =
;*
;* INPUT         = Port to write to
;*                 Word of data to write
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;*************************************************************************

HWOutpWord      PROC

                push    ebp                     ; 
                mov     ebp,esp                 ; 

                mov     dx,word ptr [ebp+8]     ; 
                mov     ax,word ptr [ebp+12]    ; 
                out     dx,ax                   ; 

                pop     ebp                     ; 
                ret                             ; 

HWOutpWord      ENDP

;************************************************************************
;*
;* FUNCTION NAME = HWOutpDWord
;*
;* DESCRIPTION   =
;*
;* INPUT         = Port to write to
;*                 DWord of data to write
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;*************************************************************************

HWOutpDWord     PROC

                push    ebp                     ; 
                mov     ebp,esp                 ; 

                mov     dx,word ptr [ebp+8]     ; 
                mov     eax,dword ptr [ebp+12]  ; 
                out     dx,eax                  ; 

                pop     ebp                     ; 
                ret                             ; 

HWOutpDWord     ENDP

;************************************************************************
;*
;* FUNCTION NAME = HWInt3
;*
;* DESCRIPTION   = Force an INT 3, with EBP set up for stack unwind
;*
;* INPUT         = NONE
;* OUTPUT        = NONE
;*
;* RETURN-NORMAL = NONE
;* RETURN-ERROR  = NONE
;*
;*************************************************************************

HWInt3          PROC

                push    ebp                     ; 
                mov     ebp,esp                 ; 
                int     3                       ; 
                pop     ebp                     ; 
                ret                             ; 

HWInt3          ENDP

;****************************************************************
;
;       void FlushPipeline
;
;       INPUTS  :       NONE
;       OUTPUT  :
;
;       SIDE EFFECTS:
;       DESCRIPTION :   Flushes the pipeline with masked pixels
;
;******************************************************************
FlushPipeline  PROC

;
; Wait for hw to stop running
;
        ret

FlushPipeline  ENDP

CODE32          ENDS

                END

