/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/*****************************************************************************
 *
 * SOURCE FILE NAME = TMPEXT.C
 *
 * AUTHOR           = Joe Celi
 *
 * DATE CREATED     = 6/9/94
 *
 *
 * VERSION = V2.1
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS
 *
 * NOTES
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#define INCL_WIN
#define INCL_GPI
#define INCL_DOS
#include <os2.h>
#include <string.h>
#include "next.h"
#include "endive.h"
#include "template.h"

extern BOOL         fForeground;
extern BOOL         fPlaying;

/*****************************************************************************
 *
 *  FUNCTION NAME:    HWExtend()
 *
 *
 *  DESCRIPTIVE NAME:
 *
 *  FUNCTION:
 *
 *  ENTRY POINT:
 *
 *  INPUT: (Passed on stack)
 *
 *  EXIT-NORMAL:
 *
 *  EXIT-ERROR:
 *
 *  EFFECTS:
 *
 *  NOTES:
 *
 *  INTERNAL REFERENCES:
 *    ROUTINES:
 *
 *  EXTERNAL REFERENCES:
 *    ROUTINES:
 *
 ****************************************************************************/

ULONG HWExtend( PVOID pInput, PVOID pOutput )
{
  ULONG  rc;

  switch (((PHWEXTENSION)pInput)->ulXSubFunction)
  {
     case ENDIVE_INIT:
        rc = TmpInit(((PHWEXTENSION)pInput)->pXP1, (PEXTINITOUT)pOutput);
        break;

     case ENDIVE_QUERY:
        rc = TmpQCaps(pOutput);
        break;

     case ENDIVE_PUT:
        fPlaying = TRUE;

        /* HW activation logic removed! */

        rc = PutImage(((PHWEXTENSION)pInput)->pXP1);

        /* HW de-activation logic removed! */

        fPlaying = FALSE;
        break;

     case ENDIVE_GET:
        rc = RC_UNSUPPORTED;
        break;

     case ENDIVE_FOREGROUND:
        rc = Foreground();
        break;

     case ENDIVE_BACKGROUND:
        rc = Background();
        break;

     default:
        rc = RC_UNSUPPORTED;
  }
  return(rc);

} /* end of HWExtend */

/*****************************************************************************
 *
 *  FUNCTION NAME:    Foreground()
 *
 *
 *  DESCRIPTIVE NAME:
 *
 *  FUNCTION:
 *
 *  ENTRY POINT:
 *
 *  INPUT: (Passed on stack)
 *
 *  EXIT-NORMAL:
 *
 *  EXIT-ERROR:
 *
 *  EFFECTS:
 *
 *  NOTES:
 *
 *  INTERNAL REFERENCES:
 *    ROUTINES:
 *
 *  EXTERNAL REFERENCES:
 *    ROUTINES:
 *
 ****************************************************************************/

ULONG Foreground( VOID )
{
   fForeground = TRUE;
   return(InitHW());

} /* end of Foreground */

/*****************************************************************************
 *
 *  FUNCTION NAME:    Background()
 *
 *
 *  DESCRIPTIVE NAME:
 *
 *  FUNCTION:
 *
 *  ENTRY POINT:
 *
 *  INPUT: (Passed on stack)
 *
 *  EXIT-NORMAL:
 *
 *  EXIT-ERROR:
 *
 *  EFFECTS:
 *
 *  NOTES:
 *
 *  INTERNAL REFERENCES:
 *    ROUTINES:
 *
 *  EXTERNAL REFERENCES:
 *    ROUTINES:
 *
 ****************************************************************************/

ULONG Background( VOID )
{

   fForeground = FALSE;
   /*
   ** If MediaBurst is busy, wait for it to complete before we allow
   ** PM to go to the background.
   */
   while(fPlaying)
   {
      DosSleep(0);
   }
   return(RC_SUCCESS);

} /* end of Background */
