/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/*****************************************************************************
 *
 * SOURCE FILE NAME = TMPENTRY.C
 *
 * AUTHOR           = Joe Celi
 *
 * DATE CREATED     = 6/2/94
 *
 * DESCRIPTIVE NAME = GRADD exported entry point.
 *
 *
 * VERSION = V2.1
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS
 *
 * NOTES
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#define INCL_WIN
#define INCL_GPI
#define INCL_DOS
#include <os2.h>
#include "next.h"
#include "endive.h"
#include "template.h"

extern HWCMD        aHWCmd[];
extern GID          gidTmp;
extern BOOL         fForceInterpolation;
extern BOOL         fForcedIntState;
extern BOOL         fInitialized;
extern FBINFO       FBInfo;

/*****************************************************************************
 *
 *  FUNCTION NAME:    HWEntry()
 *
 *
 *  DESCRIPTIVE NAME: Main entry point.
 *
 *  FUNCTION:
 *
 *  ENTRY POINT:
 *
 *  INPUT: (Passed on stack)
 *
 *  EXIT-NORMAL:
 *
 *  EXIT-ERROR:
 *
 *  EFFECTS:
 *
 *  NOTES:
 *
 *  INTERNAL REFERENCES:
 *    ROUTINES:
 *
 *  EXTERNAL REFERENCES:
 *    ROUTINES:
 *
 ****************************************************************************/

ULONG EXPENTRY HWEntry( GID gid, ULONG ulFun, PVOID pInput, PVOID pOutput )
{
   ULONG rc = RC_ERROR;

   if (ulFun == GHI_CMD_INIT)
   {
      gidTmp = gid;
   }

   if ((gid == gidTmp) && (ulFun < GHI_CMD_MAX))
   {
      if (aHWCmd[ulFun].pfnHWCmd)
      {
         if (aHWCmd[ulFun].fRing2Call)
         {
            rc = HWCallIOPL(aHWCmd[ulFun].pfnHWCmd, pInput, pOutput);
         }
         else
         {
            rc = aHWCmd[ulFun].pfnHWCmd(pInput, pOutput);
         }
      }
      else
      {
         rc = aHWCmd[ulFun].ulRc;
      }
   }
   return rc;
}

/*****************************************************************************
 *
 *  FUNCTION NAME:    TMPQueryVersion()
 *
 *  DESCRIPTIVE NAME:
 *
 *  FUNCTION:
 *
 *  ENTRY POINT:
 *
 *  INPUT:
 *
 *  EXIT-NORMAL:
 *
 *  EXIT-ERROR:
 *
 *  EFFECTS:
 *
 *  NOTES:
 *
 *  INTERNAL REFERENCES:
 *    ROUTINES:
 *
 *  EXTERNAL REFERENCES:
 *    ROUTINES:
 *
 ****************************************************************************/

ULONG EXPENTRY TMPQueryVersion( VOID )
{
   return(100);
}

/*****************************************************************************
 *
 *  FUNCTION NAME:    TMPInterpolation()
 *
 *
 *  DESCRIPTIVE NAME:
 *
 *  FUNCTION:
 *
 *  ENTRY POINT:
 *
 *  INPUT: (Passed on stack)
 *
 *  EXIT-NORMAL:
 *
 *  EXIT-ERROR:
 *
 *  EFFECTS:
 *
 *  NOTES:
 *
 *  INTERNAL REFERENCES:
 *    ROUTINES:
 *
 *  EXTERNAL REFERENCES:
 *    ROUTINES:
 *
 ****************************************************************************/

ULONG EXPENTRY TMPInterpolation( BOOL fOnOff )
{
   /*
   ** If we have not been initialized yet OR
   ** we are running at 8 bpp we simply fail this call.
   **
   ** NOTE: POWERPLAY 32 does not support interpolation at 8 bpp
   */

   if( (!fInitialized) || (FBInfo.ulBPP == 8) )
      return(RC_ERROR);

   fForceInterpolation = TRUE;
   fForcedIntState = fOnOff;
   return(RC_SUCCESS);
}
