/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/*****************************************************************************
 *
 * SOURCE FILE NAME = TMPCAPS.C
 *
 * AUTHOR           = Joe Celi
 *
 * DATE CREATED     = 6/9/94
 *
 *
 * VERSION = V2.1
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS
 *
 * NOTES
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

#define INCL_WIN
#define INCL_GPI
#define INCL_DOS
#include <os2.h>
#include "next.h"
#include "endive.h"
#include "template.h"

extern FBINFO   FBInfo;

/*****************************************************************************
 *
 *  FUNCTION NAME:    TmpQCaps()
 *
 *
 *  DESCRIPTIVE NAME:
 *
 *  FUNCTION:
 *
 *  ENTRY POINT:
 *
 *  INPUT: (Passed on stack)
 *
 *  EXIT-NORMAL:
 *
 *  EXIT-ERROR:
 *
 *  EFFECTS:
 *
 *  NOTES:
 *
 *  INTERNAL REFERENCES:
 *    ROUTINES:
 *
 *  EXTERNAL REFERENCES:
 *    ROUTINES:
 *
 ****************************************************************************/

ULONG TmpQCaps( PIMAGECAPS pImageCaps )
{

  ULONG       rc = RC_SUCCESS;

  pImageCaps->ulLength = sizeof(IMAGECAPS);
  pImageCaps->ulCaps = IMAGECAPS_STRETCHBLT |
                       IMAGECAPS_INTERPOL;

  pImageCaps->ulMaxHorz = 0xffff;              /* Max X pels supported by HW */
  pImageCaps->ulMaxVert = 0xffff;              /* Max Y pels supported by HW */

  pImageCaps->fAccelMem = FALSE;               /* No extra VRAM to play with */
  pImageCaps->ulPhysAddrVRAM = 0;
  pImageCaps->ulSize = 0;
  pImageCaps->ulScanlineBytes = 0;

  pImageCaps->ulNumCodecs = 0;                 /* Number of CODECs supported */
  pImageCaps->ulNumDst = 1;                    /* Output color fmts supported */

  if(FBInfo.ulBPP == 16)
  {
     if( (pImageCaps->pSrcColorInfo) &&
         (pImageCaps->ulNumSrc >= 6) )
     {
        pImageCaps->pSrcColorInfo[0].ulLength = sizeof(COLORINFO);
        pImageCaps->pSrcColorInfo[0].fccColorEncoding = FOURCC_R565;

        pImageCaps->pSrcColorInfo[1].ulLength = sizeof(COLORINFO);
        pImageCaps->pSrcColorInfo[1].fccColorEncoding = FOURCC_R555;

        pImageCaps->pSrcColorInfo[2].ulLength = sizeof(COLORINFO);
        pImageCaps->pSrcColorInfo[2].fccColorEncoding = FOURCC_RGB3;

        pImageCaps->pSrcColorInfo[3].ulLength = sizeof(COLORINFO);
        pImageCaps->pSrcColorInfo[3].fccColorEncoding = FOURCC_BGR3;

        pImageCaps->pSrcColorInfo[4].ulLength = sizeof(COLORINFO);
        pImageCaps->pSrcColorInfo[4].fccColorEncoding = FOURCC_RGB4;

        pImageCaps->pSrcColorInfo[5].ulLength = sizeof(COLORINFO);
        pImageCaps->pSrcColorInfo[5].fccColorEncoding = FOURCC_BGR4;
     }
     else
     {
        rc = RC_ERROR;
     }
     pImageCaps->ulNumSrc = 6;
  }
  else if(FBInfo.ulBPP == 8)
  {
     if( (pImageCaps->pSrcColorInfo) &&
         (pImageCaps->ulNumSrc >= 1) )
     {
        pImageCaps->pSrcColorInfo[0].ulLength = sizeof(COLORINFO);
        pImageCaps->pSrcColorInfo[0].fccColorEncoding = FOURCC_LUT8;
     }
     else
     {
        rc = RC_ERROR;
     }
     pImageCaps->ulNumSrc = 1;
  }


  if( pImageCaps->pDstColorInfo && pImageCaps->ulNumDst )
  {
     pImageCaps->pDstColorInfo[0].ulLength = sizeof(COLORINFO);
     if(FBInfo.ulBPP == 16)
        pImageCaps->pDstColorInfo[0].fccColorEncoding = FOURCC_R565;
     else
        pImageCaps->pDstColorInfo[0].fccColorEncoding = FOURCC_LUT8;
  }
  else
  {
     rc = RC_ERROR;
  }
  pImageCaps->ulNumDst = 1;
  return(rc);

} /* end of TmpQCaps */
