/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/*****************************************************************************
 *
 * SOURCE FILE NAME = TEMPLATE.H
 *
 * AUTHOR           = Joe Celi
 *
 * DATE CREATED     = 6/2/94
 *
 * DESCRIPTIVE NAME =
 *
 *
 * VERSION = V2.1
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS
 *
 * NOTES
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

/*
** Protos for functions in TGRENTRY.C
*/
ULONG EXPENTRY HWEntry( GID, ULONG, PVOID, PVOID );
ULONG EXPENTRY TGRQueryVersion( VOID );
ULONG EXPENTRY TGRInterpolation( BOOL );

/*
** Protos for functions in TGRINIT.C
*/
ULONG TmpInit( PFBINFO, PEXTINITOUT );
ULONG InitHW( VOID );

/*
** Protos for functions in TGRCAPS.C
*/
ULONG TmpQCaps( PIMAGECAPS );

/*
** Protos for functions in TGREXT.C
*/
FNHWCMD   HWExtend;
ULONG     GetImage( PIMAGEPACK );
ULONG     Foreground( VOID );
ULONG     Background( VOID );

/*
** Protos for functions in TGRPUT.C
*/
ULONG     ScreenToScreen( PIMAGEPACK, ULONG );
ULONG     MemToScreen( PIMAGEPACK, ULONG );
ULONG     PutImage( PIMAGEPACK );

/*
** Protos for functions in TGRIO.ASM
*/
VOID  HWInt3( VOID );
VOID  FlushPipeline( VOID );
BYTE  EXPENTRY HWInpByte(IOPORT);
VOID  EXPENTRY HWOutpByte(IOPORT, BYTE);
WORD  EXPENTRY HWInpWord(IOPORT);

/*
** Data structure used for the PutImage function.
** The fields in this structure are common for MemToScreen
** and ScreenToScreen operations.
*/
typedef struct _PUTIMAGEINFO
{
   BOOL      fUseHWInterpol;
   ULONG     ulDstOff;
   BYTE      bPF;
} PUTIMAGEINFO;
typedef PUTIMAGEINFO *PPUTIMAGEINFO;

/*
** Data structure used for the PutImage function.
** The fields in this structure are common for MemToScreen
** and ScreenToScreen operations.
*/
typedef struct _M2SINFO
{
   ULONG     ulWBOff;
   PBYTE     pbWBStart;
   ULONG     cMaxScansPerPass;
   ULONG     cBands;
   ULONG     ulCellHeight;
} M2SINFO;
typedef M2SINFO *PM2SINFO;

#define WaitForHW()

/*
** S3 defines and macros
*/
#define WaitQIdle() while(HWInpWord(QSTATUS) & QS_BUSY)
#define WaitQEmpty() while(!(HWInpWord(QSTATUS) & QS_EMPTY))

#define QSTATUS                 0x9ae8  /* queue status register (r)  */
#define QS_BUSY                 0x0200  /* executing a graphics cmd.  */
#define QS_EMPTY                0x0400  /* executing a graphics cmd.  */

#define S3_INDX_PORT            0x3D4
#define S3_DATA_PORT            0x3D5
#define S3_LAW_CTL              0x58
#define S3_LINEAR_ADDRESSING    0x10
