/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/*****************************************************************************
 *
 * SOURCE FILE NAME = NEXT.H
 *
 * AUTHOR           = Joe Celi
 *
 * DATE CREATED     = 6/2/94
 *
 * DESCRIPTIVE NAME = Endive (GRADD) extension defines and structures
 *
 *
 * VERSION = V2.1
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS
 *
 * NOTES
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

typedef ULONG GID;             /* Gradd ID */

typedef ULONG  (EXPENTRY FNHWCMD)(PVOID, PVOID);
typedef ULONG  (EXPENTRY FNHWIOPL)(FNHWCMD *, PVOID, PVOID);
typedef ULONG  (EXPENTRY FNHWENTRY)(GID, ULONG, PVOID, PVOID);

/*
**  Prototype declarations for low level driver routines
*/

FNHWIOPL  HWCallIOPL;
FNHWENTRY HWEntry;

/*
**  Possible return codes from the individual DDI's
*/
#define RC_SUCCESS              0
#define RC_SIMULATE             1
#define RC_UNSUPPORTED          2
#define RC_ERROR                3

typedef unsigned long   DWORD;
typedef unsigned short  WORD;
typedef unsigned short  IOPORT;

/*
**  Structure for HWEntry router, see tgrdata.c for array.
*/

typedef struct _HWCMD {           /* hwcmd */
        FNHWCMD         *pfnHWCmd;
        ULONG           fRing2Call;
        ULONG           ulRc;
} HWCMD;
typedef HWCMD *PHWCMD;

/*
**  Flags for HWCMD (fRing2Call)
*/

#define RING3                  (FALSE)
#define RING2                  (TRUE)

/*
**  Graphics Hardware Interface (GHI) commands
*/
#define GHI_CMD_INIT           0
#define GHI_CMD_TERM           1
#define GHI_CMD_QUERYCAPS      2
#define GHI_CMD_QUERYMODES     3
#define GHI_CMD_SETMODE        4
#define GHI_CMD_PALETTE        5
#define GHI_CMD_BITBLT         6
#define GHI_CMD_LINE           7
#define GHI_CMD_MOVEPTR        8
#define GHI_CMD_SETPTR         9
#define GHI_CMD_SHOWPTR        10
#define GHI_CMD_VRAMALLOC      11
#define GHI_CMD_REQUESTHW      12
#define GHI_CMD_BANK           13
#define GHI_CMD_EXTENSION      14
#define GHI_CMD_MAX            15

/*
** Place holder for data fields which don't apply
*/
#define DONTCARE                0

/*
**  Defines and structures for the GHI_CMD_EXTENSION command
*/
typedef struct _HWEXTENSION {          /* hwextension */
   ULONG  ulLength;
   ULONG  ulXSubFunction;
   ULONG  cScrChangeRects;
   PRECTL arectlScreen;
   ULONG  ulXFlags;
   PVOID  pXP1;
} HWEXTENSION;
typedef HWEXTENSION *PHWEXTENSION;

#define ENDIVE_INIT            1
#define ENDIVE_QUERY           2
#define ENDIVE_PUT             3
#define ENDIVE_GET             4
#define ENDIVE_FOREGROUND      5
#define ENDIVE_BACKGROUND      6
