/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/*****************************************************************************
 *
 * SOURCE FILE NAME = ENDIVE.H
 *
 * AUTHOR           = Joe Celi
 *
 * DATE CREATED     = 6/2/94
 *
 * DESCRIPTIVE NAME =
 *
 *
 * VERSION = V2.1
 *
 * DATE
 *
 * DESCRIPTION
 *
 * FUNCTIONS
 *
 * NOTES
 *
 * STRUCTURES
 *
 * EXTERNAL REFERENCES
 *
 * EXTERNAL FUNCTIONS
 *
*/

typedef struct _CUSTPALINFO
{
   ULONG  ulLength;
   ULONG  fFlags;               /* Get/Set palette                      */
   ULONG  ulStartIndex;         /*                                      */
   ULONG  ulNumEntries;         /*                                      */
   PRGB2  pRGBs;                /*                                      */
} CUSTPALINFO;
typedef CUSTPALINFO *PCUSTPALINFO;

#define FOURCC( ch0, ch1, ch2, ch3 )                      \
  ( (ULONG)(BYTE)(ch0) | ( (ULONG)(BYTE)(ch1) << 8 ) |    \
  ( (ULONG)(BYTE)(ch2) << 16 ) | ((ULONG)(BYTE)(ch3) << 24 ) )

#define FOURCC_LUT8 FOURCC('L','U','T','8')  /* 8-bit palettized */
#define FOURCC_R565 FOURCC('R','5','6','5')  /* RGB 565 */
#define FOURCC_R555 FOURCC('R','5','5','5')  /* RGB 555 */
#define FOURCC_R666 FOURCC('R','6','6','6')  /* RGB 666 */
#define FOURCC_R664 FOURCC('R','6','6','4')  /* RGB 664 */
#define FOURCC_RGB3 FOURCC('R','G','B','3')  /* RGB 24 in 3 bytes */
#define FOURCC_BGR3 FOURCC('B','G','R','3')  /* BGR 24 in 3 bytes */
#define FOURCC_RGB4 FOURCC('R','G','B','4')  /* RGB 24 in 4 bytes */
#define FOURCC_BGR4 FOURCC('B','G','R','4')  /* BGR 24 in 4 bytes */
#define FOURCC_Y888 FOURCC('Y','8','8','8')  /* YUV 24 */
#define FOURCC_Y411 FOURCC('Y','4','1','1')  /* YUV 411 interleaved 4 by 1 subsampled*/
#define FOURCC_Y422 FOURCC('Y','4','2','2')  /* YUV 422 (CCIR601) */
#define FOURCC_YUV9 FOURCC('Y','U','V','9')  /* YUV9 */
#define FOURCC_Y2X2 FOURCC('Y','2','X','2')  /* YUV 2 by 2 subsampled multi-plane */
#define FOURCC_Y4X4 FOURCC('Y','4','X','4')  /* YUV 4 by 4 subsampled multi-plane */

typedef struct _FBINFO
{
   ULONG ulLength;
   ULONG ulFlags;
   ULONG ulBPP;
   ULONG ulXres;
   ULONG ulYres;
   ULONG ulScanLineBytes;
   ULONG fccColorEncoding;
   ULONG ulENDIVEDrivers;
} FBINFO;
typedef FBINFO *PFBINFO;

typedef struct _EXTINITOUT
{
   ULONG ulLength;
   ULONG ulFlags;
} EXTINITOUT;
typedef EXTINITOUT *PEXTINITOUT;

#define EXT_SERIALIZEDAC       0x0001

typedef struct _CODECINFO
{
   ULONG        ulLength;
   ULONG        fccCodecType;           /* Fourcc of compression type  'RAW' if uncompressed .*/
   ULONG        ulCodecCaps;            /* CODEC capabilities flags */
} CODECINFO,  *PCODECINFO;

/*
**  Defines for the fccCodecType field of the CODECINFO data structure
*/
#define CODEC_ULTIMOTION        "ULTI"
#define CODEC_INDEO21           "RT21"
#define CODEC_INDEO31           "IV31"
#define CODEC_MPEG1             "MPG1"
#define CODEC_MPEG2             "MPG2"
#define CODEC_MJPEG             "MJPG"

/*
**  Defines for the ulCodecCaps field of the CODECINFO data structure
*/
#define CODEC_ACCEL_STRETCHBLT  0x0001               /* HW Stretch           */
#define CODEC_ACCEL_BLTCOPROC   0x0002               /* HW BLT               */
#define CODEC_ACCEL_DECOMP      0x0004               /* Has HW decompression */
#define CODEC_ACCEL_COMP        0x0008               /* Has HW compression   */

typedef struct _COLORINFO
{
   ULONG   ulLength;
   ULONG   fccColorEncoding;       /* Name for the color space (RGB8, Y24, ...) */
}  COLORINFO,  *PCOLORINFO;

typedef  struct  _IMAGECAPS
{
   ULONG      ulLength;          /* Length of the fixed portion of this structure AND the arrays */
   ULONG      ulCaps;            /* Specifies image capabilities supported */
   ULONG      ulMaxHorz;         /* maximum horizontal pels supported by scaler                */
   ULONG      ulMaxVert;         /* maximum vertical scan lines supported by scaler            */
   BOOL       fAccelMem;         /* True if scaler has seperate VRAM to play with */
   ULONG      ulPhysAddrVRAM;    /* Phys address of the scalers VRAM */
   ULONG      ulSize;            /* Size in bytes of scaler VRAM */
   ULONG      ulScanlineBytes;   /* Scan line size in bytes */
   ULONG      ulNumCodecs;       /* Number of FOURCCs that follow in structure */
   PCODECINFO pCodecList;        /* pointer to array of CODEC FOURCCs supported by HW/Driver */
   ULONG      ulNumSrc;          /* number of COLORINFO structures pointed to by pSrcColorInfo */
   PCOLORINFO pSrcColorInfo;     /* pointer to array of COLORINFO structures */
   ULONG      ulNumDst;          /* number of COLORINFO structures pointed to by pDstColorInfo */
   PCOLORINFO pDstColorInfo;     /* pointer to array of COLORINFO structures */
} IMAGECAPS,  *PIMAGECAPS;

/*
**  Defines for the ulCaps field of the IMAGECAPS data structure.
*/

#define IMAGECAPS_STRETCHBLT   0x0001 /* Has HW stretch BLT assist               */
#define IMAGECAPS_CAPTURE      0x0002 /* Has capture to VRAM hardware present    */
#define IMAGECAPS_1X_BLT       0x0004 /* Has non-stretch BLT assit               */
#define IMAGECAPS_WINDOWCLIP   0x0008 /* Supports clipping in HW and/or SW       */
#define IMAGECAPS_BUFALLOC     0x0010 /* Supports allocation of on card mem      */
#define IMAGECAPS_RECTALLOC    0x0020 /* Supports alloc of rects in on card mem  */
#define IMAGECAPS_COMP         0x0040 /* Compression supported by driver         */
#define IMAGECAPS_DECOMP       0x0080 /* Decompression supported by driver       */
#define IMAGECAPS_PAL_CACHING  0x0100 /* Supports 8 bit palette caching          */
#define IMAGECAPS_INTERPOL     0x0200 /* Supports color interpolation in HW      */
#define IMAGECAPS_BYLOCSYSMEM  0x0400 /* can read/write to system memory */
#define IMAGECAPS_SEM_BYPASS   0x0800 /* device serialization not required */
#define IMAGECAPS_NO_SHARED_FB 0x1000 /* overlay device */

typedef struct _IMAGEBUF
{
   ULONG          ulLength;
   ULONG          ulFlags;        /*                                     */
   ULONG          ulType;         /* VRAM or system memory               */
   PBYTE          pBits;          /* Virtual address of the image.       */
                                  /* NOTE: Not required if src in VRAM   */
   ULONG          ulImgWidth;     /* Image width in pels                 */
   ULONG          ulImgHeight;    /* Image height in pels                */
   ULONG          ulBytesPerScan; /* Bytes per scan line                 */
   PCOLORINFO     pColorInfo;     /* Color space of data in buffer       */
   PCODECINFO     pCodecInfo;     /* Compression type of data in buffer  */
   PCUSTPALINFO   pCustPalInfo;   /* Ptr to custom palette information   */
}  IMAGEBUF,  *PIMAGEBUF;

/*
**  Defines for the ulType field of the IMAGEBUF data structure.
**
**  NOTE: IBT (Image Buf Type)
*/
#define IBT_SRC_VRAM               0x0000  /*  */
#define IBT_SRC_MEM                0x0001  /*  */

/*
**  Defines for the ulFlags field of the PUTIMAGEBUF data structure.
**
**  NOTE: IBF (Image Buf Flags)
*/

#define IBF_Y_ORG_BOTTOM       0x0001  /*  */

/*
** NOTE: This flag can be used as an optimization for 8 bpp images
**       for the following two conditions:
**
**       1.) The HW has support for cached custom palettes and the
**           client application is playing frames using the same
**           palette. (The driver will return IMG_CAPS_PAL_CACHING
**           if it has this support).
**
**       2.) The screen is in 256 color mode and the source image
**           bits have already been translated to the current
**           hardware palette.
*/
#define IBF_IGNORE_CUST_PAL    0x0002  /* Ignore the custom palette */

typedef struct _IMAGEPACK
{
   ULONG        ulLength;
   ULONG        ulFlags;     /*                                             */
   ULONG        ulHandle;    /* Unique ID returned by ProcessInit funtion   */
   ULONG        ulID;        /* Unique buffer ID                            */
   ULONG        ulCmdMask;   /* Specific changes since last frame           */
   PIMAGEBUF    pPutBuf;     /* Used as source image in PutImage command    */
   PIMAGEBUF    pGetBuf;     /* Used as dest image in GetImage command      */
   POINTL       ptlDstOrg;   /* Destination origin (org at upper left)      */
   ULONG        ulDstXext;   /* Destination X extent                        */
   ULONG        ulDstYext;   /* Destination Y extent                        */
   POINTL       ptlSrcOrg;   /* Offset into the source image                */
   ULONG        ulSrcXext;   /* Source X extent                             */
   ULONG        ulSrcYext;   /* Source Y extent                             */
   ULONG        cVisRects;   /* # of output visible rectangles              */
   PRECTL       prctlVis;    /* Pointer to array of visible regions         */
   POINTL       ptlWBOrg;    /* Origin of off screen VRAM work buffer       */
   ULONG        cWBBytes;    /* # of bytes in the work buffer               */
   PBYTE        pVirtVRAM;   /* 32 bit virtual pointer to the start of VRAM */
   ULONG        ulGrafXPar;  /* Transparent color for overlay type devices  */
} IMAGEPACK,  *PIMAGEPACK;

/*
**  Defines for the ulFlags field of the IMAGEPACK data structure.
**
**  NOTE: IPF (Image Pack Flags)
*/
#define IPF_DONT_INTERPOLATE  0x0001   /* Don't use HW color interpolation */


/*
**  Defines for the ulCmdMask field of the IMAGEPACK data structure.
**
**  NOTE: IPC (Image Pack Command)
*/
#define IPC_INTERMEDIATE_PUT  0x0001   /* NOTE: Not used!!!                */
#define IPC_RECTLS            0x0002   /* Visible regions have changed     */
#define IPC_SRC_COLOR         0x0004   /*                                  */
#define IPC_DST_COLOR         0x0008   /*                                  */
#define IPC_PALETTE           0x0010   /*                                  */
#define IPC_SRC_SIZE          0x0020   /*                                  */
#define IPC_DST_SIZE          0x0040   /*                                  */
#define IPC_DST_POS           0x0080   /*                                  */
#define IPC_DROP_FRAME        0x0100   /* Ignore this frame                */
