/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**********************************************************************/
/*                                                                    */
/* xgaadapt.h definitions needed to use the xga kernel device driver  */
/*                                                                    */
/**********************************************************************/

/**********************************************************************/
/* Implement hardware register access as a structure.                 */
/* The additional fields for paged pixmap parameters are placed at    */
/* the end.                                                           */
/**********************************************************************/
#ifdef   _8514

typedef struct _CMDFLAG
    {                                /* Bits - Usage                                    */
                                     /*-------------------------------------------------*/
        unsigned Read_Write : 1;     /*    0 - Set for Writes; Clear for Reads          */
        unsigned PelAccrual : 1;     /*    1 - Set for Planar mode; Clear for pixels    */
        unsigned LastPel    : 1;     /*    2 - Set for Last pixel NOT drawn             */
        unsigned CodedDir   : 1;     /*    3 - Set for Vector draw; Clear for Bresenham */
        unsigned MoveAccess : 1;     /*    4 - Set for draw, Clear for move only        */
        unsigned IncrX      : 1;     /*    5 - Set for Lines draw right                 */
        unsigned IncrZ      : 1;     /*    6 - Z Increment ????                         */
        unsigned IncrY      : 1;     /*    7 - Set for Lines draw down                  */
        unsigned FixedVar   : 1;     /*    8 - Set for access thru Color_0_Wait         */
        unsigned ByteWord   : 1;     /*    9 - Set for 16-bit access; or 8-bt access    */
        unsigned reserved1  : 2;     /*  A-B -                                          */
        unsigned ByteOrder  : 1;     /*    C - Set if low byte first, high byte second  */
        unsigned Command    : 3;     /*  D-F - Drawing operation                        */
    } CMDFLAG;

typedef struct _QSTATUS              /* Bits - Usage                                    */
    {                                /*-------------------------------------------------*/
        unsigned QState     : 8;     /*  0-7 - No. of commands in the queue.            */
        unsigned DataReady  : 1;     /*    8 - Set when data ready in Color_0_Wait reg. */
        unsigned Busy       : 1;     /*    9 - Set when executing a graphics cmd.       */
        unsigned reserved   : 6;     /*  A-F -                                          */
    } QSTATUS;

typedef struct _SSTROKE              /* Bits - Usage                                    */
    {                                /*-------------------------------------------------*/
        unsigned Length     : 4;     /*  0-3 - Length of line; 0-15 pels.               */
        unsigned Draw       : 1;     /*    4 - Set for Draw & Move; Clear for Move only */
        unsigned VectorDir  : 3;     /*  5-7 - Increments of 45%; 0 = Pos. X Axis       */
        unsigned reserved   : 8;     /*  8-F -                                          */
    } SSTROKE;

typedef struct _MIX                  /* Bits - Usage                                    */
    {                                /*-------------------------------------------------*/
        unsigned Mix        : 5;     /*  0-4 - ALU function                             */
        unsigned SrcSelect  : 2;     /*  5-6 - Source of data for mix ops.              */
        unsigned reserved   : 9;     /*  7-F -                                          */
    } MIX;

typedef struct _PIXMODE              /* Bits - Usage                                    */
    {                                /*-------------------------------------------------*/
        unsigned reserved2  : 1;     /*    0 -                                          */
        unsigned PlaneMode  : 2;     /*  1-2 - Enables Plane expansions                 */
        unsigned UnderPaint : 3;     /*  3-5 - Color Compare Operation                  */
        unsigned PatternSrc : 2;     /*  6-7 - Pattern Select; Mix, Pattern, etc.       */
        unsigned reserved1  : 8;     /*  8-F -                                          */
    } PIXMODE;

typedef struct _STATCTL              /* Bits - Usage                                    */
    {                                /*-------------------------------------------------*/
        unsigned VRetrace   : 1;     /*    0 - Set at start of vert. blanking           */
        unsigned Correlate  : 1;     /*    1 - Set if write within clip rect.           */
        unsigned OverRun    : 1;     /*    2 - Set if queue is overrun                  */
        unsigned OpDone     : 1;     /*    3 - Set if processor is idle                 */
        unsigned MonitorID  : 3;     /*  4-6 - Returns 3-bit IBM Monitor ID             */
        unsigned FourPlanes : 1;     /*    7 - Returns 4 or 8 planes of mem. expan.     */
        unsigned EVRetrace  : 1;     /*    8 - Enable VBLNKFLG Interrupt                */
        unsigned ECorrelate : 1;     /*    9 - Enable PICKFLAG Interrupt                */
        unsigned EOverRun   : 1;     /*    A - Enable INVALIDIO Interrupt               */
        unsigned EOpDone    : 1;     /*    B - Enable GPIDLE Interrupt                  */
        unsigned TestCtrl   : 2;     /*  C-D - Enable/Disable Sync. for 8514/A chips    */
        unsigned ResetCtrl  : 2;     /*  E-F - Enables or Resets/Disables the 8514/A    */
    } STATCTL;

typedef struct _MISCIO               /* Bits - Usage                                    */
    {                                /*-------------------------------------------------*/
        unsigned DisableVGA : 1;     /*   0 - Set for 8514/A; Clear for VGA pass-thru   */
        unsigned reserved2  : 1;     /*   1 -                                           */
        unsigned ClockSel   : 1;     /*   2 - Set for 1024 x 768; Clear for 640 x 480   */
        unsigned reserved1  :13;     /* 3-F -                                           */
    } MISCIO;


typedef struct _MM8514Reg
    {

/**********************************************************************/
/*  DRAWING CONTROL REGISTERS                                         */
/**********************************************************************/
        /**************************************************************/
        /*  X0 and Y0 are the current position values used as the     */
        /*  starting point for all drawing operations.  Most of the   */
        /*  drawing ops update this point during executions.  Any     */
        /*  attempt to read these values while drawing could result   */
        /*  is garbage data.                                          */
        /**************************************************************/
        volatile USHORT  X0;                /*  86e8  r/w  */
        volatile USHORT  Y0;                /*  82e8  r/w  */

        /**************************************************************/
        /*  The following two registers are dual purpose registers    */
        /*  that are used for both Line drawing and BitBlt.           */
        /*                                                            */
        /*  When used during a Blt, X1 and Y1 specify the target      */
        /*  rectangle coordinates.                                    */
        /*                                                            */
        /*  When used during a Line drawing op, K1 and K2 specify the */
        /*  axial step constant and the diagonal step constant,       */
        /*  respectively.  These values can be calculated as follows: */
        /*                                                            */
        /*  K1 =  2 * (minor axis delta)                              */
        /*  K2 = [2 * (minor axis delta)] - [2 * (major axis delta)]  */
        /**************************************************************/
        volatile USHORT  X1;                /*  8ee8   w   */
        volatile USHORT  Y1;                /*  8ae8   w   */

        volatile USHORT  K1;                /*  8ae8   w   */
        volatile USHORT  K2;                /*  8ee8   w   */

        /*********************************************************************/
        /*  Error Term is used during line drawing.  The error term          */
        /*  is calculated as:                                                */
        /*                                                                   */
        /*  Err_Term = [2 * (minor axis delta)] - (major axis delta) - fixup */
        /*                                                                   */
        /*********************************************************************/
        volatile USHORT  Err_Term;          /*  92e8  r/w  */

        /*********************************************************************/
        /*  There is a discrepacny between the 8514.H and the                */
        /*  Richter & Smith book on this register.  IBM labels this as the   */
        /*  X-axis length for primitives.  Richter & Smith define this as    */
        /*  the Major Axis length.  For now we will use IBM's definition and */
        /*  watch for problems while we test.  Change definitions should not */
        /*  be difficult, if necessary.                                      */
        /*                                                                   */
        /*  Note : LY, the counter part to LX, is accessed through Index 0   */
        /*         of the Multifunction Control Register, BEE8.              */
        /*********************************************************************/
        volatile USHORT  LX;                /*  96e8   w   */

        /*********************************************************************/
        /*  These two registers are used to pass commands to the Display     */
        /*  Processor and to check the status of the command queue.          */
        /*                                                                   */
        /*  Commands that can be initiated are:                              */
        /*                                                                   */
        /*    000  No Operation Performed                                    */
        /*    001  Line Draw                                                 */
        /*    010  Fast-Fill Rectangle                                       */
        /*    011  Fill Rectangle Vertically (#1)                            */
        /*    100  Fill Rectangle Vertically (#2)                            */
        /*    101  Draw Line for Area Fill                                   */
        /*    110  Copy Rectangle                                            */
        /*    111  reserved                                                  */
        /*                                                                   */
        /*  Before initiating a command, all of the attributes registers     */
        /*  necessary for the primitive should be set up first.              */
        /*                                                                   */
        /*  The QStatus register indicates whether or not a command is       */
        /*  currently being executed and how many of the eight slots in the  */
        /*  queue are currently used.                                        */
        /*                                                                   */
        /*       Queue State Value              Meaning                      */
        /*       -----------------              -------                      */
        /*           00000000                 Queue Empty                    */
        /*           00000001                 7 Entries available            */
        /*           00000011                 6 Entries available            */
        /*           00000111                 5 Entries available            */
        /*           00001111                 4 Entries available            */
        /*           00011111                 3 Entries available            */
        /*           00111111                 2 Entries available            */
        /*           01111111                 1 Entries available            */
        /*           11111111                 Queue Full                     */
        /*********************************************************************/
        volatile CMDFLAG Cmd_Flags;         /*  9ae8   w   */
        volatile QSTATUS QStatus;           /*  9ae8   r   */

        /*********************************************************************/
        /* Attribute Registers                                               */
        /*********************************************************************/
        volatile SSTROKE ShortStroke;       /*  9ee8   w   */

        #ifndef   BPP24
        volatile USHORT  Color_0;           /*  a2e8   w   */
        volatile USHORT  Color_1;           /*  a6e8   w   */

        volatile USHORT  Write_Enable;      /*  aae8   w   */
        volatile USHORT  Read_Enable;       /*  aee8   w   */

        volatile USHORT  Color_Comp;        /*  b2e8   w   */
        #else
        volatile ULONG   Color_0;           /*  a2e8   w   */
        volatile ULONG   Color_1;           /*  a6e8   w   */

        volatile ULONG   Write_Enable;      /*  aae8   w   */
        volatile ULONG   Read_Enable;       /*  aee8   w   */

        volatile ULONG   Color_Comp;        /*  b2e8   w   */
        #endif

        volatile MIX     Function_0;        /*  b6e8   w   */
        volatile MIX     Function_1;        /*  bae8   w   */

        /*********************************************************************/
        /*  The register at BEE8 is a multifunction control register for     */
        /*  drawing operations.  The differenct functions are differentiated */
        /*  by an index value in the high four bits.                         */
        /*********************************************************************/
        volatile USHORT  LY;                /*  bee8   w   Index 0  */
        volatile USHORT  YMin;              /*  bee8   w   Index 1  */
        volatile USHORT  XMin;              /*  bee8   w   Index 2  */
        volatile USHORT  YMax;              /*  bee8   w   Index 3  */
        volatile USHORT  XMax;              /*  bee8   w   Index 4  */
        volatile USHORT  Config;            /*  bee8   w   Index 5  */
        volatile USHORT  Pattern_0;         /*  bee8   w   Index 8  */
        volatile USHORT  Pattern_1;         /*  bee8   w   Index 9  */
        volatile PIXMODE Mode;              /*  bee8   w   Index A  */

        /*********************************************************************/
        /*  Color_0_Wait is the only mechanism for moving data to and from   */
        /*  the 8514's VRAM.  The register is capable of dealing with Pixel  */
        /*  mode and Planar mode color data.  The type used is determined by */
        /*  Config version of the Multifunction Control Register, BEE8.      */
        /*********************************************************************/
        volatile USHORT  Color_0_Wait;      /*  e2e8  r/w  */

        /*********************************************************************/
        /*  When read, this register is used to query information about the  */
        /*  graphics processor.  Information available is Whether or not...  */
        /*                                                                   */
        /*  1.) The graphics processor is idle.                              */
        /*  2.) A command was written to a full queue.                       */
        /*  3.) The Color_0_Wait register was read without any data being    */
        /*      available to read.                                           */
        /*  4.) A write to a pixel within the clipping rectangle is about    */
        /*      to be made.                                                  */
        /*                                                                   */
        /*  When written to, this register is used to enable and/or reset    */
        /*  any of the above registers.
        /*********************************************************************/
//        volatile STATCTL Control;           /*  42e8   w   */
//        volatile STATCTL Status;            /*  42e8   r   */
        volatile USHORT  Control;           /*  42e8   w   */
        volatile USHORT  Status;            /*  42e8   r   */

        /*********************************************************************/
        /*  The register is used to select which 4K page of the 32K ROM      */
        /*  on-board the IBM 8514/A is mapped to memory.  This only applies  */
        /*  to IBM Micro-channel machines that use the Power-on Self Test.   */
        /*  We should be able to ignore this register for clones.  However,  */
        /*  we must be careful not to cause a conflict with VGA ROMs.        */
        /*********************************************************************/
        volatile USHORT  Prom_Page;         /*  46e8   w   */

        /*********************************************************************/
        /*  This two main purposes of this register is to set the clock      */
        /*  speed, 25.175 MHz or 44.9 MHz, and to Enable or Disable the      */
        /*  VGA pass-thru feature of the 8514/A.                             */
        /*********************************************************************/
        volatile MISCIO  Misc_IO;           /*  4ae8   w   */

        /*********************************************************************/
        /* Start extra pixmap definitions here.  One each for A,B,C and the  */
        /* mask.  The arrangement of these is an exact mirror of the real    */
        /* registers (hence the padding).                                     */
        /* Note that these 'shadow' registers are only ever in memory so     */
        /* need not be declared as volatile.                                  */
        /*********************************************************************/
        USHORT  OpDim1;
        USHORT  OpDim2;

        USHORT  MaskXOffset;
        USHORT  MaskYOffset;

        USHORT  SrcXAddr;
        USHORT  SrcYAddr;

        USHORT  PatXAddr;
        USHORT  PatYAddr;

        SHORT    DstXAddr;
        SHORT    DstYAddr;

             ULONG       PixOp;
             BYTE        bFifthStep;    /* used by software simulation only */

        BYTE    PixMapIndexA;
        BYTE    bPaddingA;
        ULONG   PixMapBaseA;
        USHORT  PixMapWidthA;
        USHORT  PixMapHeightA;
        BYTE    PixMapFormatA;
        BYTE    bPaddingA2;

        BYTE    PixMapIndexB;
        BYTE    bPaddingB;
        ULONG   PixMapBaseB;
        USHORT  PixMapWidthB;
        USHORT  PixMapHeightB;
        BYTE    PixMapFormatB;
        BYTE    bPaddingB2;

        BYTE    PixMapIndexC;
        BYTE    bPaddingC;
        ULONG   PixMapBaseC;
        USHORT  PixMapWidthC;
        USHORT  PixMapHeightC;
        USHORT  PixMapFormatC;
        BYTE    bPaddingC2;

        BYTE    PixMapIndexM;
        BYTE    bPaddingM;
        ULONG   PixMapBaseM;
        USHORT  PixMapWidthM;
        USHORT  PixMapHeightM;
        BYTE    PixMapFormatM;
        BYTE    bPaddingM2;

    } MM8514Reg;

typedef MM8514Reg FAR * pMM8514Reg;

#else /* XGA Regs */

typedef struct _MMReg
    {
        /**************************************************************/
        /* Fields are declared as volatile to prevent the compiler    */
        /* generating code to write a value to the register, then     */
        /* read it back expecting it to be the same.                  */
        /* However volatile is not implemented by c5.1.               */
        /**************************************************************/
        volatile ULONG   PageDirBaseAdd;

        volatile ULONG   CurrVirtAddr;

        volatile BYTE    bNotUsed1;
        volatile BYTE    ExtPolling;
        volatile USHORT  bNotUsed2;

        volatile BYTE    StateAlen;
        volatile BYTE    StateBlen;
        volatile USHORT  usNotUsed3;

        volatile BYTE    bNotUsed4;
        volatile BYTE    PIControl;
/**********************************************************************/
/* These Pixmap registers will not be written to when in software     */
/* mode                                                               */
/**********************************************************************/
        volatile BYTE    PixMapIndex;
        volatile BYTE    bNotUsed5;

        volatile ULONG   PixMapBase;

        volatile USHORT  PixMapWidth;
        volatile USHORT  PixMapHeight;

        volatile BYTE    PixMapFormat;
        volatile BYTE    abNotUsed6[3];
/**********************************************************************/
/* End of Pixmap registers                                            */
/**********************************************************************/

        volatile USHORT  BresErrTerm;
        volatile USHORT  usNotUsed7;

        volatile USHORT  BresK1;
        volatile USHORT  usNotUsed8;

        volatile USHORT  BresK2;
        volatile USHORT  usNotUsed9;

        volatile ULONG   DirSteps;

        volatile BYTE    bFifthStep;    /* used by software simulation only */
        volatile BYTE    abNotUsed10[23];

        volatile BYTE    FgMix;
        volatile BYTE    BgMix;
        volatile BYTE    ColCompCond;
        volatile BYTE    bNotUsed11;

        volatile ULONG   ColCompVal;

        volatile ULONG   PlaneMask;

        volatile ULONG   CarryChMask;

        volatile USHORT  FgCol;
        volatile USHORT  FgColHi;

        volatile USHORT  BgCol;
        volatile USHORT  BgColHi;

        volatile USHORT  OpDim1;
        volatile USHORT  OpDim2;

        volatile ULONG   ausNotUsed12[2];

        volatile USHORT  MaskXOffset;
        volatile USHORT  MaskYOffset;

        volatile USHORT  SrcXAddr;
        volatile USHORT  SrcYAddr;

        volatile USHORT  PatXAddr;
        volatile USHORT  PatYAddr;

        volatile SHORT   DstXAddr;
        volatile SHORT   DstYAddr;

        volatile ULONG   PixOp;

 /*********************************************************************/
 /* Start extra pixmap definitions here.  One each for A,B,C and the  */
 /* mask.  The arrangement of these is an exact mirror of the real    */
 /* registers (hence the padding).                                    */
 /* Note that these 'shadow' registers are only ever in memory so     */
 /* need not be declared as volatile.                                 */
 /*********************************************************************/
        BYTE    PixMapIndexA;
        BYTE    bPaddingA;
        ULONG   PixMapBaseA;
        USHORT  PixMapWidthA;
        USHORT  PixMapHeightA;
        BYTE    PixMapFormatA;
        BYTE    bPaddingA2;

        BYTE    PixMapIndexB;
        BYTE    bPaddingB;
        ULONG   PixMapBaseB;
        USHORT  PixMapWidthB;
        USHORT  PixMapHeightB;
        BYTE    PixMapFormatB;
        BYTE    bPaddingB2;

        BYTE    PixMapIndexC;
        BYTE    bPaddingC;
        ULONG   PixMapBaseC;
        USHORT  PixMapWidthC;
        USHORT  PixMapHeightC;
        USHORT  PixMapFormatC;
        BYTE    bPaddingC2;

        BYTE    PixMapIndexM;
        BYTE    bPaddingM;
        ULONG   PixMapBaseM;
        USHORT  PixMapWidthM;
        USHORT  PixMapHeightM;
        BYTE    PixMapFormatM;
        BYTE    bPaddingM2;

    } MMReg;

typedef MMReg FAR * pMMReg;


/**********************************************************************/

#endif /* XGA */

/**********************************************************************/
/* Start of Software Motion Video Support                             */
/**********************************************************************/
/**********************************************************************/
/* I/O mapped controller registers                                    */
/**********************************************************************/
#define XGA_OP_MODE            0
#define XGA_APERTURE_CONTROL   1
#define XGA_APERTURE_INDEX     8
#define XGA_MEMORY_ACCESS_MODE 9
#define XGA_IO_INDEX           10

/**********************************************************************/
/* Aperture control register values                                   */
/**********************************************************************/
#define NO_64K_APERTURE  0
#define A0000_APERTURE   1
#define B0000_APERTURE   2
#define MAX_64K_APERTURE 0x3f

/**********************************************************************/
/* Memory Access Mode register values                                 */
/**********************************************************************/
#define PEL_ORDER_MOTOROLA  8

/**********************************************************************/
/* End of Software Motion Video Support                               */
/**********************************************************************/

// structure passed to the lock devioctl
typedef struct
{
   PVOID     virt_addr;
   ULONG     phys_addr;
   ULONG     lock_handle;
   ULONG     bitmap_size;
   USHORT    lock_type;
} BMAP;
typedef BMAP FAR * PBMAP;

typedef struct
{
   USHORT    count;
   PBMAP     bitmap;
} LOCKSTRUC;
typedef LOCKSTRUC FAR * PLOCKSTRUC;


typedef struct
{
   USHORT    count;
   ULONG     handle;
} UNLOCKSTRUC;
typedef UNLOCKSTRUC FAR * PUNLOCKSTRUC;

// values for flags in XGAADAPTERINFO
#ifndef   _8514
#define XGA_PRIMARY_ADAPTER  0x01
#define XGA_EXTERNAL_POLLING 0x02
#define XGA_16BPP_SUPPORTED  0x04

#define PRIMARY_ADAPTER 0x01

/**********************************************************************/
/* WARNING.                                                           */
/* This structure is used by both 16 and 32 bit code, but             */
/* the length of a HFILE differs in each model.                       */
/* Thus the nasty dummy field included in the 16 bit case.            */
/**********************************************************************/
// must match definition in xgaadapt.inc
typedef struct
{
   USHORT   usDisplayType;
   LONG     lMemorySize;
   USHORT   usFlags;
   USHORT   usIORegBase;
   pMMReg   pMemRegBase;
   ULONG    ulVRAMBase;
   HFILE    hfDevHandle;
#ifndef INCL_32
   USHORT   dummy;
#endif /* ndef INCL_32 */
   USHORT   AdapterID;
} ADAPTERINFO;

typedef ADAPTERINFO FAR * PADAPTERINFO;

typedef struct
{
    USHORT  usScreenWidth;
    USHORT  usScreenHeight;
    USHORT  usMonitorType;
} ADAPTERINFO2;

typedef ADAPTERINFO2 FAR * PADAPTERINFO2;
#else
typedef struct
{
    LONG         lMemorySize;
    USHORT       usFlags;
    USHORT       usIORegBase;
    pMM8514Reg   pMemRegBase;
    ULONG        ulVRAMBase;
    USHORT       usScreenWidth;
    USHORT       usScreenHeight;
} ADAPTER8514;

typedef ADAPTER8514 FAR * PADAPTER8514;
#endif


typedef union
{
  RGB2  rgb2;
  ULONG ul;
} RGB2TOUL;

#define MAX_ISO_COLOURS 11

#define MAX_MON_ID 5

typedef struct _XGAINSTANCE
{
    USHORT  pos_id;
    BYTE    pos_data[4];            /* for non-DMQS h/w               */

    BYTE    slot_number;            /* 0..8 (0 = planar)              */

    USHORT  XGA_level;              /* as DMQS */

    USHORT  XGA_io_base;            /* e.g. 0x2160 */
    ULONG   XGA_mem_map_phys;
    PBYTE   XGA_mem_map_virt;       /* 16:16 address    */
    ULONG   XGA_mem_map_flat;       /* flat:32 address  */
    ULONG   XGA_base_vram;          /* physical address */
    USHORT  XGA_monitor_id;
    ULONG   XGA_vram_size;

    BYTE    primary_adapter;
    ULONG   phys_addr_instance;
    ULONG   XGA_1M_aperture_phys;
    ULONG   XGA_1M_aperture_flat;
    ULONG   XGA_4M_aperture_phys;
    ULONG   XGA_4M_aperture_flat;
    SEL     DMQS_Mon_File_Memory;
    USHORT  usScreenSizeX;
    USHORT  usScreenSizeY;
    USHORT  usMonitorTypeInstance;
    UCHAR   psz_monitor_id[MAX_MON_ID];
    RGB2TOUL aISOColours[MAX_ISO_COLOURS];
} XGAINSTANCE;

typedef XGAINSTANCE FAR * PXGAINSTANCE;

typedef struct
{
   USHORT usXPels;
   USHORT usYPels;
   BYTE   bBitsPerPel;
   BYTE   bInstance;
   BYTE   bSlot;
   PVOID  pDMQSModeData;
} MODEDATA;

typedef MODEDATA FAR * PMODEDATA;

#define MAX_NUM_DMQS_MODES 30  /* Size of array of MODEDATA in driver and bvh */
#define NO_PRIMARY_ADAPTER_OVERRIDE 0xffff

typedef struct
{
   BYTE     bNumberOfModes;
   USHORT   primary_adapter_slot;
   MODEDATA ModeData[MAX_NUM_DMQS_MODES];
} MODEDATAINFO;

typedef struct
{
    USHORT  usLength;
    USHORT  usID;
} DMQSEXTENSIONPREFIX;

typedef struct
{
  DMQSEXTENSIONPREFIX Prefix;
  BYTE                abData[1];
} DMQSEXTENSIONDATA;

typedef DMQSEXTENSIONDATA FAR * PDMQSEXTENSIONDATA;

typedef struct
{
    BYTE    HeaderData[34];    /* Fixed data !                        */
    USHORT  usTotalLength;     /* Total file length in bytes          */
    USHORT  usMonitorID;       /*                                     */
    BYTE    bFileLevel;        /*                                     */
    BYTE    bNumberOfModes;    /*                                     */
    USHORT  usMonitorType;     /* 0=MonCRT 1=ColCRT 2=MonLCD 3=ColLCD */
    USHORT  usScreenWidth;     /* in millimeters                      */
    USHORT  usScreenHeight;    /* in millimeters                      */
    BYTE    Reserved[80];      /*                                     */
    USHORT  MonitorDataOffset; /* offset from start of file           */
    DMQSEXTENSIONDATA Extension;
} DMQS_MON_DATA_FILE;

typedef DMQS_MON_DATA_FILE FAR * PDMQS_MON_DATA_FILE;

/* Values for the DMQS_MON_DATA_HEADER usModeFlags                    */
#define MF_BORDERLESS     0x01
#define MF_NON_INTERLACED 0x02

typedef struct {
    USHORT  usLength;
    USHORT  usXPels;
    USHORT  usYPels;
    USHORT  usMinXGALevel;
    USHORT  usVendorID;
    USHORT  usReserved;
    USHORT  usModeFlags;
    USHORT  usModeDataOffset;
    USHORT  usModePixelRate;
    USHORT  usModeLineRate;
    USHORT  usModeFrameRate;
    DMQSEXTENSIONDATA Extension;
} DMQS_MON_DATA_HEADER;

typedef DMQS_MON_DATA_HEADER FAR * PDMQS_MON_DATA_HEADER;

#define DMQS_EXT_TERMINATE    0x00
#define DMQS_EXT_ID_DISP_ISO  0x01
#define DMQS_EXT_ID_PM_ISO    0x02
#define DMQS_COLOR_NAME_LEN 13
#define DMQS_NUM_ISO_COLORS 11

typedef struct
{
  USHORT x;
  USHORT y;
} ISOCIECOLORPOINT;

typedef struct
{
  ISOCIECOLORPOINT ColorPoint;
  USHORT           PeakLuminance;
  USHORT           GammaValue;
} ISOCIECOLORINFO;

typedef struct
{
  DMQSEXTENSIONPREFIX Prefix;
  ISOCIECOLORINFO     Red;
  ISOCIECOLORINFO     Green;
  ISOCIECOLORINFO     Blue;
  ISOCIECOLORINFO     White;
} DISPLAYISOCOLORSEXT;

typedef DISPLAYISOCOLORSEXT FAR * PDISPLAYISOCOLORSEXT;

typedef struct
{
  UCHAR               auchName[DMQS_COLOR_NAME_LEN];
  BYTE                bRed;
  BYTE                bGreen;
  BYTE                bBlue;
} PMISOCOLORS;

typedef struct
{
  DMQSEXTENSIONPREFIX Prefix;
  PMISOCOLORS         Color[DMQS_NUM_ISO_COLORS];
} PMISOCOLORSEXT;

typedef PMISOCOLORSEXT FAR * PPMISOCOLORSEXT;


/* Macros to access the DMQS extension data when it is the PM         */
/* preselected ISO colours (DMQS_EXT_ID_PM_ISO)                       */
#define DMQS_ISO_RGB(e,i)                                        \
  (0x80000000 |                                                  \
   (((ULONG)(((PPMISOCOLORSEXT)(e))->Color[i].bRed)) << 16) |    \
   (((ULONG)(((PPMISOCOLORSEXT)(e))->Color[i].bGreen)) << 8) |   \
   ((ULONG)(((PPMISOCOLORSEXT)(e))->Color[i].bBlue)))



// XGASTATE must be defined identically in xgaadapt.inc
typedef struct
{
   USHORT state_a_length;
   USHORT state_b_length;
   PBYTE  saved_state;
} COPROCSTATE;

typedef struct
{
   USHORT      huge_shift;
   PBYTE       saved_buffer;
} VRAMSTATE;

typedef struct
{
   COPROCSTATE coproc_state;
   VRAMSTATE   VRAM;
   PBYTE       saved_io_regs;
   PBYTE       saved_palette;
} XGASTATE;
typedef XGASTATE FAR * PXGASTATE;


/* DevIOCtl parameters */
#define IO_LOCK_MAP        0x04
#define IO_UNLOCK_MAP      0x05
#define BVH_CONFIG         0x06  /* same as below but silly name */
#define IO_GETADAPTERINFO  0x06  /* same as above but better name */
#define IO_SAVE_VRAM       0x07
#define IO_RESTORE_VRAM    0x08
#define IO_VGA_MODE        0x09
#define IO_NATIVE_MODE     0x0a
#define IO_SAVE_COPROC     0x0b
#define IO_RESTORE_COPROC  0x0c
#define IO_132_COL_MODE    0x0d
#define IO_SAVE_REGS       0x0e
#define IO_RESTORE_REGS    0x0f
#define IO_SAVE_PALETTE    0x10
#define IO_RESTORE_PALETTE 0x11
#define IO_SETMODEINFO     0x17
#define IO_GETMODEINFO     0x18
#define IO_SETINSTANCEDATA 0x19
#define IO_GETINSTANCEDATA 0x1A
#define IO_GETADAPTERINFO2 0x1B

/**********************************************************************/
/* 2.0 specific routines.                                             */
/**********************************************************************/
#define IO_FLAT_LOCK       0x12
#define IO_FLAT_UNLOCK     0x13
#define IO_FLAT_ACCESS     0x14
#define IO_CREATE_CALLGATE 0x15
#define IO_GLOBAL_ACCESS   0x16

#define GEN_FUNCTION       0x41
#define XGA_CATEGORY       0x81

/* max size of coprocessor save / restore buffer and the io registers */
#define SIZE_COPROC_STATE 0x400
#define SIZE_PALETTE      0x300
#define SIZE_IO_REGISTERS 0x44

/* operating mode register (address 21x0) values */
#define MODE_VGA_ADD      0
#define MODE_VGA_ADE      1
#define MODE_132_ADD      2
#define MODE_132_ADE      3
#define MODE_EXT_GRAPHICS 4

/* maximum vertical resolution available in 132 column mode */
#define MAX_132_ROWS       50
#define MAX_132_VRES      400

/* coprocessor control register values */
#define COPROC_BUSY              0x80
#define TERMINATE_OPERATION      0x20
#define SUSPEND_OPERATION        0x08
#define SAVE_STATE               0x02
#define OPERATION_SUSPENDED      0x10

/* monitor id for xga supported displays */
#define D_8517      0x90F0
#define D_8507_8604 0xF00F      // mono hires
#define D_8514      0xF0F0
#define D_8515      0xF0FF
#define D_8503      0xFF0F      // mono lores
#define D_8512_8513 0xFFF0
#define D_9515      0xf9ff
#define D_9517      0x99f0
#define D_9518      0xf9f0
#define D_NONE      0xFFFF

/* monitor types as defined by DMQS spec */
#define MT_MONO_CRT         0x0000
#define MT_COLOR_CRT        0x0001
#define MT_MONO_LCD         0x0002
#define MT_COLOR_LCD        0x0003
#define MT_MONO_BORDERLESS  0x0004
#define MT_COLOR_BORDERLESS 0x0005

#ifndef   _8514
/* macro evaluating to TRUE if the attached display is mono */
/* a is ADAPTERINFO2 structure                              */
#define MONO_DISPLAY(a) (((a).usMonitorType == MT_MONO_CRT) || \
                         ((a).usMonitorType == MT_MONO_LCD) || \
                         ((a).usMonitorType == MT_MONO_BORDERLESS))

/* macro evaluating to TRUE if the adapter has external polling enabled */
#define ExternalPollingEnabled() \
            ((aiXGAAdapter.usFlags & XGA_EXTERNAL_POLLING)!=0)

/* macro evaluating to TRUE if the adapter has 16 bpp support */
#define AdapterSupports16BPP() \
            ((aiXGAAdapter.usFlags & XGA_16BPP_SUPPORTED)!=0)
#endif

/* display information */
#define DM_HI_RES   0x01
#define DM_MONO     0x02
#define USE_16BPP   0x04
#ifdef   BPP24
#define USE_24BPP   0x08
#define USE_ATTDAC  0x10
#define USE_BROOKDAC 0x20
#endif
#define USE_8BIT_DAC 0x40

#define LO_RES_WIDTH   640
#define LO_RES_HEIGHT  480
#define RES_800_WIDTH   800
#define RES_800_HEIGHT  600
#define HI_RES_WIDTH  1024
#define HI_RES_HEIGHT  768
#define VGA_X_RESOLUTION 2667
#define VGA_Y_RESOLUTION 2667
#define LO_8515_X_RESOLUTION 2557
#define LO_8515_Y_RESOLUTION 2557
#define HI_8515_X_RESOLUTION 4098
#define HI_8515_Y_RESOLUTION 4098
#define LO_8514_X_RESOLUTION 2315
#define LO_8514_Y_RESOLUTION 2315
#define HI_8514_X_RESOLUTION 3597
#define HI_8514_Y_RESOLUTION 3597
#define HI_RES_8514_GRAPHICS_CHAR_X 16
#define HI_RES_8514_GRAPHICS_CHAR_Y 16
#define HI_RES_8515_GRAPHICS_CHAR_X 20
#define HI_RES_8515_GRAPHICS_CHAR_Y 20
#define LO_RES_GRAPHICS_CHAR_X 13
#define LO_RES_GRAPHICS_CHAR_Y 13
#define LO_RES_ALPHA_CHAR_X  8
#define LO_RES_ALPHA_CHAR_Y 14
#define RES_800_ALPHA_CHAR_X LO_RES_ALPHA_CHAR_X
#define RES_800_ALPHA_CHAR_Y LO_RES_ALPHA_CHAR_Y
#define HI_RES_ALPHA_CHAR_X 12
#define HI_RES_ALPHA_CHAR_Y 20

/**********************************************************************/
/* Pixel Operation constants                                          */
/**********************************************************************/
#define BACK_SRC_MASK 0xC0000000
#define FORE_SRC_MASK 0x30000000
#define STEP_FN_MASK 0x0F000000
#define SRC_PIX_MAP_MAKS 0x00F00000
#define DST_PIX_MAP_MASK 0x000F0000
#define PAT_PIX_MAP_MASK 0x0000F000
#define MSK_PIX_MAP_MASK 0x000000C0
#define DRAW_MODE_MASK 0x00000030
#define DIR_OCT_MASK 0x00000007

#define BACK_SRC_BACK_COL 0x0L
#define BACK_SRC_SRC_PIX_MAP 0x80000000

#define FORE_SRC_FORE_COL 0x0L
#define FORE_SRC_SRC_PIX_MAP 0x20000000

#define STEP_FN_LINE_DRAW_WRITE 0x05000000

#define SRC_PIX_MAP_A 0x00100000
#define SRC_PIX_MAP_B 0x00200000
#define SRC_PIX_MAP_C 0x00300000
#define SRC_PIX_MAP_DONTCARE SRC_PIX_MAP_A

#define DST_PIX_MAP_A 0x00010000
#define DST_PIX_MAP_B 0x00020000
#define DST_PIX_MAP_C 0x00030000

#define PAT_PIX_MAP_A 0x00001000
#define PAT_PIX_MAP_B 0x00002000
#define PAT_PIX_MAP_C 0x00003000
#define PAT_PIX_MAP_FORE 0x00008000
#define PAT_PIX_MAP_SRC 0x00009000

#define MASK_PIX_MAP_OFF 0x0L
#define MASK_PIX_MAP_EDGE 0x00000040
#define MASK_PIX_MAP_FULL 0x00000080

#define DRAW_MODE_ALL_PELS 0x0L
#define DRAW_MODE_NO_FIRST_PEL 0x00000010
#define DRAW_MODE_NO_LAST_PEL 0x00000020
#define DRAW_MODE_DONTCARE DRAW_MODE_ALL_PELS

#define STEP_PXBLT        0x08000000
#define DIR_OCTANT_LRTB      0x00000000
#define DIR_OCTANT_LRBT      0x00000002
#define DIR_OCTANT_RLTB      0x00000004
#define DIR_OCTANT_RLBT      0x00000006

#define BLTDIR_BOTTOMTOTOP   0x02
#define BLTDIR_RIGHTTOLEFT   0x04


/**********************************************************************/
/* Other register constants                                           */
/**********************************************************************/
#define SEL_PIX_MAP_A 0x01
#define SEL_PIX_MAP_B 0x02
#define SEL_PIX_MAP_C 0x03
#define SEL_MASK_MAP  0x00

/**********************************************************************/
/* values for pixel map hardware format register                      */
/* Note bitmaps are 'Motorola' format - think about it!               */
/**********************************************************************/
#define ONE_BPP     0x00
#define FOUR_BPP    0x02
#define EIGHT_BPP   0x03
#define SIXTEEN_BPP 0x04
#define TWENTYFOUR_BPP 0x05

#define INTEL       0x00
#define MOTOROLA    0x08

#define ONE_BIT_PER_PEL      (MOTOROLA | ONE_BPP)
#define FOUR_BITS_PER_PEL    (MOTOROLA | FOUR_BPP)
#define EIGHT_BITS_PER_PEL   (MOTOROLA | EIGHT_BPP)
#define SIXTEEN_BITS_PER_PEL (MOTOROLA | SIXTEEN_BPP)
#define TWENTYFOUR_BITS_PER_PEL (MOTOROLA | TWENTYFOUR_BPP)

/**********************************************************************/
/* hardware mixes                                                     */
/**********************************************************************/
#define HWMIX_ZEROS                     0
#define HWMIX_SOURCE_AND_DEST           1
#define HWMIX_SOURCE_AND_NOTDEST        2
#define HWMIX_SOURCE                    3
#define HWMIX_NOTSOURCE_AND_DEST        4
#define HWMIX_DEST                      5
#define HWMIX_SOURCE_XOR_DEST           6
#define HWMIX_SOURCE_OR_DEST            7
#define HWMIX_NOTSOURCE_AND_NOTDEST     8
#define HWMIX_SOURCE_XOR_NOTDEST        9
#define HWMIX_NOTDEST                0x0a
#define HWMIX_SOURCE_OR_NOTDEST      0x0b
#define HWMIX_NOTSOURCE              0x0c
#define HWMIX_NOTSOURCE_OR_DEST      0x0d
#define HWMIX_NOTSOURCE_OR_NOTDEST   0x0e
#define HWMIX_ONES                   0x0f

/**********************************************************************/
/* Constants for colour compare operations.  Used to process          */
/* BM_SRCTRANSPARENT and BM_DESTTRANSPARENT backgroun mixes.          */
/* NB COLCOMP_NOT_EQUAL is not implemented in the MESS.               */
/*                                                                    */
/* These values have the following meaning:                           */
/*                                                                    */
/*      COLCOMP_EQUAL     : Only update pixels in the destination that*/
/*                          have the same colour as the colour in the */
/*                          ColCompVal register.                      */
/*      COLCOMP_NOT_EQUAL : Only update pixels in the destination that*/
/*                          have a different colour to the colour in  */
/*                          the ColCompVal register.                  */
/*      COLCOMP_ALWAYS    : Update all pixels in the destination.     */
/**********************************************************************/
#define COLCOMP_EQUAL                0x06
#define COLCOMP_NOT_EQUAL            0x02
#define COLCOMP_ALWAYS               0x04

/**********************************************************************/
/* These values are also stored in the colour compare register, but   */
/* must not be written to the hardware. They are just used to         */
/* indicate a BM_SRCTRANSPARENT operation to the MESS.                */
/**********************************************************************/
#define COLCOMP_SRC_NOT_EQUAL       0x80

/**********************************************************************/
/* This callgate structure is used when createing a dynamicAPI entry. */
/**********************************************************************/
typedef struct _CALLGATE
{
    PVOID   linear_address;     /* address of the routine (flat model)*/
    ULONG   cParams;            /* number of (dword) parameters       */
    ULONG   cg_offset;          /* offset placed here (always 0!)     */
    ULONG   cg_selector;        /* callgate selector placed here      */
} CALLGATE;

#ifdef   _8514
typedef struct _VIOMODEINFO {   /* viomi */
        USHORT cb;
        UCHAR  fbType;
        UCHAR  color;
        USHORT col;
        USHORT row;
        USHORT hres;
        USHORT vres;
        PCH    ext_data_addr;
        } VIOMODEINFO;

extern VIOMODEINFO     VioModeInfo;
#endif

/**********************************************************************/
/* XGA POS ID constants.                                              */
/**********************************************************************/
#define XGA_ID_HIGHEST 0x8fdb
#define XGA_DMQS_ID    0x8fda
#define XGA_ID_LOWEST  0x8fd8

#ifdef MATROX
#define MATROX_ID      0x80ee
#endif /* MATROX */

/**********************************************************************/
/* RGB values to set in the hardware palette                          */
/**********************************************************************/
#define XGA_BLACK      0x80000000
#define XGA_DARK_BLUE  0x80000080
#define XGA_DARK_GREEN 0x80008000
#define XGA_DARK_CYAN  0x80008080
#define XGA_DARK_RED   0x80800000
#define XGA_PURPLE     0x80800080
#define XGA_MUSTARD    0x80808000
#define XGA_GRAY       0x80808080
#define XGA_LIGHT_GRAY 0x80cccccc
#define XGA_BLUE       0x800000ff
#define XGA_GREEN      0x8000ff00
#define XGA_CYAN       0x8000ffff
#define XGA_RED        0x80ff0000
#define XGA_MAGENTA    0x80ff00ff
#define XGA_YELLOW     0x80ffff00
#define XGA_WHITE      0x80ffffff

/**********************************************************************/
/* Max pixel rate allowed for running at 16 bits per pixel. The rate  */
/* is stored in the DMQS file multiplied by 4, eg a value of 360      */
/* means 90MHz.                                                       */
/**********************************************************************/
#define MAX_16BPP_PIXEL_RATE 4*45

#ifdef _8514
#define VGMT_MAKEITWORK 0x08
#define VGMT_OTHER      0x01
#define VGMT_GRAPHICS   0x02
#define VGMT_DISABLEBURST       0x04
#endif
