/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**********************************************************************/
/*                                                                    */
/*   File            = SEAMLESS.H                                     */
/*                                                                    */
/*   Description     = Seamless         types and structures          */
/*                                                                    */
/*   Function        =                                                */
/*                                                                    */
/*   Reference       = Device Driver Interface Specification          */
/*                                                                    */
/*                                                                    */
/**********************************************************************/

#ifdef SEAMLESS

#define VWIN_INIT           0x00c0    /* Send the semDriver address to VWIN */
#define VWIN_HEARTBEAT      0x00c1    /* Notify VWIN that we timed out.     */
#define VWIN_SETSIZE        0x00c4    /* Set the mode size info for VMOUSE. */
#define VWIN_VDMDIRTY       0x00c2    /* Start/stop VDM drawing:            */
#define VDMDIRTY_SUSPEND_DRAW 0x4001  /* to stop drawing                    */
#define VDMDIRTY_RESUME_DRAW  0x4002  /* to continue drawing.               */

#define SM_RING0            0x0000
#define SM_RING1            0x0001
#define SM_RING2            0x0002
#define SM_RING3            0x0003

#define SM_DATA_ADDRESS     0x0000
#define SM_CODE_ADDRESS     0x0004

#define SM_ADDRESS_16BIT    0x0000
#define SM_ADDRESS_32BIT    0x0008
#define SM_MATCH_LINEAR     0x0020

#define SM_MAPPING          0x0000
#define SM_PASSTHRU         0x0010

#define SEAMLESS_STACK_SIZE 1024

#ifndef _8514

#define WINDOWS_PRIVATE_AREA_SIZE 2200

typedef struct  _SEAMLESSDATA /* sd */
{
        CHAR    LevelID[4];
        pMMReg  pMemRegBase;            // 16:16 addr of memory mapped XGA regs
        USHORT  usIORegBase;            // base of IO XGA registers
        ULONG   ulVramBase;             // 32bit physical address of VRAM
        ULONG   ulVramSize;             // size of VRAM in bytes
        BYTE    fUseExternalPolling;    // TRUE if external polling supported
        BYTE    fVGAIsVirtualized;      // TRYE if VGA is enabled for virtualization

        USHORT  usScreenWidthMM;
        USHORT  usScreenHeightMM;
        USHORT  usScreenWidthPels;
        USHORT  usScreenHeightPels;
        BYTE    bBitsPerPel;

        PFSRSEM pSemaphore;             // flat pointer to driver FSR semaphor
        PULONG  pHeartBeat;             // flat point to heartbeat counter

        PULONG  pNumDefaultColors;      // flat ptr to # default colors in use

        PBYTE   pCursorStatus;          // flat ptr: bit 0x80 set if SW cursor
        ULONG   pExcludeCursor;         // 16:16 addr of exclude cursor function
        ULONG   pDisableCursor;         // 16:16 addr of disable cursor function
        ULONG   pEnableCursor;          // 16:16 addr of enable cursor function

        BYTE    WindowsPrivateArea[WINDOWS_PRIVATE_AREA_SIZE];

        BYTE    fPaletteIsFixed;        // TRUE if palette manager not enabled
        ULONG   ulLastPalUpdate;        // time stamp of last foreground realize
        PRGB2   pHWPalette;             // 16:16 ptr to HWPalette structure
        ULONG   pPhysSharedBuff;        // 32 bit physical address of the Phunk
        PVOID   pVirtSharedBuff;        // flat ptr to the Phunk

    } SEAMLESSDATA;

#else /* _8514 */

#define WINDOWS_PRIVATE_AREA_SIZE 3000

typedef struct  _SEAMLESSDATA /* sd */
{
   #ifdef S3
        CHAR    LevelID[4];             // "S301"

        ULONG   ulScreenWidthPels;
        ULONG   ulScreenHeightPels;
        ULONG   ulBitsPerPel;

   #else
        CHAR    LevelID[4];             // "8501"
   #endif

   #ifdef S3
        PVOID   pCursorStatus;
        PVOID   pDCAFActive;
        ULONG   ulDACRange;
   #endif

        ULONG   pExcludeCursor;         // 16:16 addr of exclude cursor function
        ULONG   pDisableCursor;         // 16:16 addr of disable cursor function
        ULONG   pEnableCursor;          // 16:16 addr of enable cursor function

        PVOID   pSemaphore;             // 16:16 addr of FSRSEM
        PVOID   pHeartBeat;             // 16:16 addr of Heartbeat counter

        BOOL    FirstVDM;               // TRUE if seamless driver is first up and
                                        // should initialize its' font cache info.

        PVOID   pWindowsPrivateArea;    // 16:16 addr of tiled memory for use by
                                        // seamless as PMDDSeg.

        ULONG   ulControllerMine;
        ULONG   ulControllerOwned;
        ULONG   ulControllerNotify;
        ULONG   ulShadowFlags;

        BYTE    fPaletteIsFixed;        // TRUE if palette manager not enabled
        ULONG   ulLastPalUpdate;        // time stamp of last foreground realize
        PRGB2   pHWPalette;             // 16:16 ptr to HWPalette structure

    } SEAMLESSDATA;

#endif

typedef struct _SM_PMDISP /* sm */
    {
        ULONG   flOptions;
        ULONG   ulLength;
        PVOID   pointer;
    } SM_PMDISP;

/**********************************************************************/
/* This structure is defined in the os2 headers but currently it is   */
/* not available to us without forcing other errors.                  */
/**********************************************************************/
typedef struct vmss_s {                 /* vmss */
    ULONG   vmss_nb;                    // size of structure, in bytes (36)
    LONG    vmss_lMode;                 // video mode (eg, 00h-13h, or -1)
    ULONG   vmss_ulWidth;               // width of screen, in pixels
    ULONG   vmss_ulHeight;              // height of screen, in pixels
    ULONG   vmss_ulCellWidth;           // width of screen cells, in pixels
    ULONG   vmss_ulCellHeight;          // height of screen cells, in pixels
    ULONG   vmss_ulPtrWidth;            // width of pointer drawing size, in pixels
    ULONG   vmss_ulPtrHeight;           // height of pointer drawing size, in pixels
    ULONG   vmss_ulPtrUnitWidth;        // width of pointer drawing unit, in pixels
} VMSSIZE;


/**********************************************************************/
/* Function prototypes required outside of seamless.c.                */
/**********************************************************************/
VOID InitialiseSeamless(VOID);

VOID SeamlessDeath(VOID);

VOID SeamlessResurection(VOID);

VOID SeamlessHeartBeat(VOID);

VOID SeamlessVDMCreated(VOID);

VOID SeamlessVDMDestroyed(VOID);


#endif /* SEAMLESS */
