/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**********************************************************************/
/*                                                                    */
/*    These are constants etc used for the Expressway KAUAI mods      */
/*                                                                    */
/*                                                                    */
/*                                                                    */
/*          Note this is only a temporary header                      */
/*                 - it should be changed later if this file gets     */
/*                   kept                                             */
/*                                                                    */
/*                                                                    */
/**********************************************************************/


/**********************************************************************/
/* a structure to bring all the cursor related fields together        */
/**********************************************************************/
typedef struct
    {
        USHORT          width;
        USHORT          height;
        USHORT          max_x;          /* equals width - 1  */
        USHORT          max_y;          /* equals height - 1 */
    } CursorInfoType;


/**********************************************************************/
/* allow external access to the CursorInfo                            */
/**********************************************************************/
extern  CursorInfoType  CursorInfo;

/**********************************************************************/
/* plasma display is present on kauai                                 */
/* identified by the submodel return type from DosDevConfig           */
/**********************************************************************/
#define KAUAI_SUBMODEL          0x52

/**********************************************************************/
/* constant to turn on the VFB bit in the display mode 1 register     */
/**********************************************************************/
#define VFB_ENABLED             0x10

/**********************************************************************/
/* plasma status flags                                                */
/**********************************************************************/
#define PLASMA_PRESENT          1
#define PLASMA_ENABLED          2
#define PLASMA_COLOUR           4

/**********************************************************************/
/* function prototype for ring 0 code to call ABIOS                   */
/**********************************************************************/
//VOID PASCAL FAR testplasma( USHORT far *, BYTE far * );
VOID FAR        GetPlasmaStatus(VOID);

/**********************************************************************/
/* allow access to plasma_status                                      */
/**********************************************************************/
extern  BOOL    plasma_status;

/**********************************************************************/
/* function prototypes                                                */
/**********************************************************************/
USHORT FAR plasma_type(VOID);
