/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/***********************************************************************/
/*                                                                     */
/*  Module          = HWACCESS.H                                       */
/*                                                                     */
/*  Description     = Header file for writing to the xga hardware      */
/*                                                                     */
/*                                                                     */
/***********************************************************************/

/* flags passed to TransferShadowRegisters indicating what to transfer */
#define TSR_MAP_A       0x01
#define TSR_MAP_B       0x02
#define TSR_MAP_C       0x04
#define TSR_LINES       0x08
#define TSR_COLOUR_MIX  0x10
#define TSR_COORDINATES 0x20
#define TSR_PIXELOP     0x40
#define TSR_CLIPPING    0x80



VOID TransferShadowRegisters( ULONG ulFlags );

VOID UpdateShadowRegisters( VOID );

VOID CopyMemoryToVRAM( PVOID  systemAddress,
                       ULONG  VRAMPhysicalAddress,
                       ULONG  width,
                       ULONG  height,
                       ULONG  format );

VOID MemoryPelToVRAMPel( PVOID  systemAddress,
                         ULONG  VRAMPhysicalAddress,
                         ULONG  F_Mix,
                         ULONG  Mix,
                         ULONG  format);


VOID CopyVRAMToMemory( PVOID  systemAddress,
                       ULONG  VRAMPhysicalAddress,
                       ULONG  width,
                       ULONG  height,
                       ULONG  format );

VOID WaitForRealHWFunction( VOID );

