;*DDK*************************************************************************/
;
; COPYRIGHT    Copyright (C) 1995 IBM Corporation
;
;    The following IBM OS/2 WARP source code is provided to you solely for
;    the purpose of assisting you in your development of OS/2 WARP device
;    drivers. You may use this code in accordance with the IBM License
;    Agreement provided in the IBM Device Driver Source Kit for OS/2. This
;    Copyright statement may not be removed.;
;*****************************************************************************/
;-------------------------------------------------------------------------
;
;   Module          = FFMACROS
;
;   Description     = 386 code for macros used in software blt code in MESS
;
;
;-------------------------------------------------------------------------
;***********************************************************************
;  CHANGE ACTIVITY:
;
;  FLAG RLSE  DATE  ORIGIN              COMMENTS
;  ---- ---- ------ ------  --------------------------------------------
;  @001 0206 930318 BZ      Modified the ONES portion of the mixTrashSourceAll
;                           macro to work with any size operand. (Defect 80448)
;
;***********************************************************************

; These macros are used by the PxBlt simulation to do its mixes.  They are
; accompanied by offset tables which we use to work out an address to jump
; to.  Note that the offsets depend on whether the src and dst are dwords
; (ie eax) or bytes (ie al).  This is because of the operation size override
; for dword operations.  If the driver becomes a 32 bit code segment (if it
; can ??) then this might well change..
; The macros try to put common (mixes) at the end so they only have one
; jmp in their execution path (eg ~S, ~D and S)


IF1

lbl macro n,m
n&m:
endm

mixTrashSourcePart      macro   src, dst, tableLabel
        local   uniqueLabel

uniqueLabel:

IFNB <tableLabel>
 IFNDEF Start_&tableLabel
  thisLabel equ <tableLabel>
 ELSE
  thisLabel equ <uniqueLabel>
 ENDIF
ELSE
 thisLabel equ <uniqueLabel>
ENDIF

lbl Start_ %thisLabel
                                ; operation
                                ; 
lbl SandNotD_ %thisLabel
        not     dst             ; S & ~D
lbl SandD_ %thisLabel
        and     dst, src        ; S & D
        jmp     short @f

lbl SorNotD_ %thisLabel
        not     dst             ; S | ~D
lbl SorD_ %thisLabel
        or      dst, src        ; S | D
        jmp     short @f

lbl SxorNotD_ %thisLabel
        not     dst             ; S ^ ~D
lbl SxorD_ %thisLabel
        xor     dst, src        ; S ^ D
        jmp     short @f

lbl NotSandNotD_ %thisLabel
        or      dst, src        ; ~S & ~D = ~(S | D)
        not     dst
        jmp     short @f

lbl NotSorNotD_ %thisLabel
        and     dst, src        ; ~S | ~D = ~(S & D)
        not     dst
        jmp     short @f

lbl NotSorD_ %thisLabel
        not     src             ; ~S | D
        or      dst, src
        jmp     short @f

lbl NotSandD_ %thisLabel
        not     src             ; ~S & D
        and     dst, src
        jmp     short @f

lbl NotS_ %thisLabel
        mov     dst, src        ; ~S
lbl NotD_ %thisLabel
        not     dst             ; ~D

lbl Leave_ %thisLabel
lbl Copy_ %thisLabel
lbl Zeroes_ %thisLabel
lbl Ones_ %thisLabel
                                ; Do nothing
@@:

endm


; This one will not corrupt the src register and does not do the special
; mixes (zeroes, source copy, ones)

mixKeepSourcePart       macro   src, dst, tableLabel
        local   uniqueLabel

uniqueLabel:

IFNB <tableLabel>
 IFNDEF Start_&tableLabel
  thisLabel equ <tableLabel>
 ELSE
  thisLabel equ <uniqueLabel>
 ENDIF
ELSE
 thisLabel equ <uniqueLabel>
ENDIF

lbl Start_ %thisLabel
                                ;    operation
                                ; 
lbl SandNotD_ %thisLabel
        not     dst             ; S & ~D
lbl SandD_ %thisLabel
        and     dst, src        ; S & D
        jmp     short @f

lbl SorNotD_ %thisLabel
        not     dst             ; S | ~D
lbl SorD_ %thisLabel
        or      dst, src        ; S | D
        jmp     short @f

lbl SxorNotD_ %thisLabel
        not     dst             ; S ^ ~D
lbl SxorD_ %thisLabel
        xor     dst, src        ; S ^ D
        jmp     short @f

lbl NotSandNotD_ %thisLabel
        or      dst, src        ; ~S & ~D = ~(S | D)
        not     dst
        jmp     short @f

lbl NotSorNotD_ %thisLabel
        and     dst, src        ; ~S | ~D = ~(S & D)
        not     dst
        jmp     short @f

lbl NotSorD_ %thisLabel
        not     dst             ; ~S | D
        and     dst, src
        not     dst
        jmp     short @f

lbl NotSandD_ %thisLabel
        not     dst             ; ~S & D
        or      dst, src
        not     dst
        jmp     short @f

lbl NotS_ %thisLabel
        mov     dst, src        ; ~S
lbl NotD_ %thisLabel
        not     dst             ; ~D
lbl Leave_ %thisLabel
lbl Copy_ %thisLabel
lbl Zeroes_ %thisLabel
lbl Ones_ %thisLabel
                                ; Do nothing

@@:
                        endm

; This one may corrupt the src register and it will do all the possible
; mixes.  It is used for pattern operations where we have to apply
; different mixes to foreground and background and consequently we
; cannot special case the special mixes.

mixTrashSourceAll       macro   src, dst, tableLabel
        local   uniqueLabel

uniqueLabel:

IFNB <tableLabel>
 IFNDEF Start_&tableLabel
  thisLabel equ <tableLabel>
 ELSE
  thisLabel equ <uniqueLabel>
 ENDIF
ELSE
 thisLabel equ <uniqueLabel>
ENDIF

lbl Start_ %thisLabel
                                ; operation
                                ; 
lbl SandNotD_ %thisLabel
        not     dst             ; S & ~D
lbl SandD_ %thisLabel
        and     dst, src        ; S & D
        jmp     short @f

lbl SorNotD_ %thisLabel
        not     dst             ; S | ~D
lbl SorD_ %thisLabel
        or      dst, src        ; S | D
        jmp     short @f

lbl SxorNotD_ %thisLabel
        not     dst             ; S ^ ~D
lbl SxorD_ %thisLabel
        xor     dst, src        ; S ^ D
        jmp     short @f

lbl NotSandNotD_ %thisLabel
        or      dst, src        ; ~S & ~D = ~(S | D)
        not     dst
        jmp     short @f

lbl NotSorNotD_ %thisLabel
        and     dst, src        ; ~S | ~D = ~(S & D)
        not     dst
        jmp     short @f

lbl NotSorD_ %thisLabel
        not     src             ; ~S | D
        or      dst, src
        jmp     short @f

lbl NotSandD_ %thisLabel
        not     src             ; ~S & D
        and     dst, src
        jmp     short @f

lbl NotS_ %thisLabel
        mov     dst, src        ; ~S
lbl NotD_ %thisLabel
        not     dst             ; ~D
        jmp     short @f

lbl Zeroes_ %thisLabel
        mov     dst, 0          ; ZEROES
        jmp     short @f

lbl Ones_ %thisLabel
;@001       mov     dst, 0FFh       ; ONES
        mov     dst, -1       ; ONES    ;@001
        jmp     short @f

lbl Copy_ %thisLabel
        mov     dst, src        ; S
lbl Leave_ %thisLabel
                                ; Do nothing

@@:
                        endm

ifndef  _8514
mixOffsetJumpTable      macro   tablename

public tablename
tablename       dd      Zeroes_&tablename      - Start_&tablename
                dd      SandD_&tablename       - Start_&tablename
                dd      SandNotD_&tablename    - Start_&tablename
                dd      Copy_&tablename        - Start_&tablename
                dd      NotSandD_&tablename    - Start_&tablename
                dd      Leave_&tablename       - Start_&tablename
                dd      SxorD_&tablename       - Start_&tablename
                dd      SorD_&tablename        - Start_&tablename
                dd      NotSandNotD_&tablename - Start_&tablename
                dd      SxorNotD_&tablename    - Start_&tablename
                dd      NotD_&tablename        - Start_&tablename
                dd      SorNotD_&tablename     - Start_&tablename
                dd      NotS_&tablename        - Start_&tablename
                dd      NotSorD_&tablename     - Start_&tablename
                dd      NotSorNotD_&tablename  - Start_&tablename
                dd      Ones_&tablename        - Start_&tablename
endm
else    ;_8514
mixOffsetJumpTable      macro   tablename

public tablename
tablename       dd      NotD_&tablename        - Start_&tablename
                dd      Zeroes_&tablename      - Start_&tablename
                dd      Ones_&tablename        - Start_&tablename
                dd      Leave_&tablename       - Start_&tablename
                dd      NotS_&tablename        - Start_&tablename
                dd      SxorD_&tablename       - Start_&tablename
                dd      SxorNotD_&tablename    - Start_&tablename
                dd      Copy_&tablename        - Start_&tablename
                dd      NotSorNotD_&tablename  - Start_&tablename
                dd      NotSorD_&tablename     - Start_&tablename
                dd      SorNotD_&tablename     - Start_&tablename
                dd      SorD_&tablename        - Start_&tablename
                dd      SandD_&tablename       - Start_&tablename
                dd      SandNotD_&tablename    - Start_&tablename
                dd      NotSandD_&tablename    - Start_&tablename
                dd      NotSandNotD_&tablename - Start_&tablename
endm
endif  ; _8514

ENDIF
