/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**********************************************************************/
/*                                                                    */
/* errors.h                                                           */
/*                                                                    */
/* Contains function prototypes and other definitions relating to     */
/* error detection and handling.                                      */
/**********************************************************************/

/**********************************************************************/
/* Macros                                                             */
/**********************************************************************/
/**********************************************************************/
/* Macro to test for the error flag being set and to call the error   */
/* logging function if it is.                                         */
/* Having logged the error, the error value is reset.                 */
/**********************************************************************/
#define CheckForErrors()                                               \
   if (ERRORIDERROR(eiErrorToLog) != 0)                                \
   {                                                                   \
       LogError( ERRORIDERROR(eiErrorToLog) );                         \
       eiErrorToLog = MAKEERRORID(0, 0);                               \
   }

/**********************************************************************/
/* Function prototypes                                                */
/**********************************************************************/
BOOL PASCAL IllegallyInPath(ULONG fsCommandBits);

/**********************************************************************/
/* Globals                                                            */
/**********************************************************************/
extern ERRORID eiErrorToLog;
