/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**********************************************************************/
/*                                                                    */
/*   File            = EDDVCONE                                       */
/*                                                                    */
/*   Description     = Display Device Driver AVIO constants           */
/*                                                                    */
/*   Function        =                                                */
/*                                                                    */
/*   Reference       = Device Driver Interface Specification          */
/*                                                                    */
/*                                                                    */
/**********************************************************************/

/**********************************************************************/
/* Constants for cursor visibility                                    */
/**********************************************************************/
#define  AVIO_CURSOR_VISIBLE  0x00
#define  AVIO_CURSOR_HIDDEN   0x01

/**********************************************************************/
/* Size of the AVIO palette                                           */
/**********************************************************************/
#define  AVIO_PALETTE_SIZE    16

/**********************************************************************/
/* Number of AVIO fonts supported                                     */
/* !!! Changed now thet pmformat is being used                        */
/**********************************************************************/
#define  MAX_AVIO_FONTS_LOADED   15
#define  NO_OF_AVIO_FONTS        17

/**********************************************************************/
/* Define constants that refer to the different AVIO fonts            */
/**********************************************************************/
#define SYS05x12    0
#define SYS05x16    1
#define SYS06x10    2
#define SYS06x14    3
#define SYS07x15    4
#define SYS07x25    5
#define SYS08x08    6
#define SYS08x10    7
#define SYS08x12    8
#define SYS08x14    9
#define SYS08x16   10
#define SYS08x18   11
#define SYS10x18   12
#define SYS12x16   13
#define SYS12x20   14
#define SYS12x22   15
#define SYS12x30   16

/**********************************************************************/
/* We put these here as an easy way to get it into all the            */
/* AVIO files.                                                        */
/**********************************************************************/
#define PVIOPS PVIOPS32
#define VIOPS VIOPS32

/**********************************************************************/
/* Index to the array of AVIO fonts to get the default for different  */
/* screen resolutions.                                                */
/**********************************************************************/
#define LO_RES_AVIO_FONT_INDEX  1
#define RES_800_AVIO_FONT_INDEX LO_RES_AVIO_FONT_INDEX
#define HI_RES_AVIO_FONT_INDEX  0
