/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/

/**********************************************************************/
/*                                                                    */
/*   File            = EDDQSRES                                       */
/*                                                                    */
/*   Description     = Display Device Driver query screen mode header */
/*                                                                    */
/*   Function        =                                                */
/*                                                                    */
/*   Reference       = Device Driver Interface Specification          */
/*                                                                    */
/*                                                                    */
/**********************************************************************/


/* Structure pointed to by the OutData         */
/* parameter to DEVESC_QUERYSCREENRESOLUTIONS. */
typedef struct
{
  SCREENRESCOUNT   srcScreenResCount;
  SCREENRESOLUTION srScreenResolution;
} SCREENRESDEVESCPARM;

typedef SCREENRESDEVESCPARM FAR * PSCREENRESDEVESCPARM;


/* Access macros for the OutData parameter */
#define VTOPSR(v) ((PSCREENRESDEVESCPARM)(v))

#define SRP_MAXCOUNT(srp) \
             (VTOPSR(srp)->srcScreenResCount.maxcount)

#define SRP_COUNT(srp) \
             (VTOPSR(srp)->srcScreenResCount.count)

#define SRP_STRUCTLEN(srp) \
             (VTOPSR(srp)->srcScreenResCount.res_struct_length)

#define SRP_RESBUFFER(srp) \
             (&(VTOPSR(srp)->srScreenResolution))

#define SR_WIDTH(sr) ((sr).width)
#define SR_HEIGHT(sr) ((sr).height)
#define SR_COLORS(sr) ((sr).colors)
#define SR_PLANES(sr) ((sr).planes)
#define SR_OPTIONS(sr) ((sr).floptions)

#define SR_OBTAINABLE_MODE(sr) ((SR_OPTIONS(sr)&DSP_RESOLUTION_OBTAINABLE)!=0)

/* Function prototypes */
ULONG NEAR QueryScreenResolutions(PULONG, PVOID);
