/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/

/**********************************************************************/
/*                                                                    */
/*   Module          = EDDQSRES                                       */
/*                                                                    */
/*   Description     = Display Device Driver functions:               */
/*                     OS2_PM_DRV_QUERYSCREENRESOLUTIONS              */
/*                                                                    */
/*   Function        = returns the modes supported by the adapter     */
/*                                                                    */
/*   Reference       = Device Driver Interface Specification          */
/*                     Display Device Driver Design Specification     */
/*                                                                    */
/*                                                                    */
/**********************************************************************/

#define INCL_GRE_DEVICE

#include <eddinclt.h>
#include <eddvcone.h>
#include <edddtypt.h>
#include <eddqextf.h>

#include <eddqsres.h>
#include <eddesres.h>


extern DDTType           DDT;
extern PSCREENRESOLUTION asrScreenResolution;
extern ULONG             PDBInstance;

#ifdef S3
extern VOID SetObtainableModes(VOID);
#endif

ULONG EXPENTRY OS2_PM_DRV_QUERYSCREENRESOLUTIONS(PVOID  pbOutData,
                                                 PULONG pcdOutData)

/**********************************************************************/
/* Returns a list of available screen resolution modes. pcdOutData is */
/* the length in bytes of the pbOutData buffer. On return it is the   */
/* number of bytes returned in pbOutData. pbOutData is a buffer of    */
/* the form                                                           */
/*   {                                                                */
/*     SCREENRESCOUNT                                                 */
/*     SCREENRESOLUTION[]                                             */
/*   }                                                                */
/*                                                                    */
/**********************************************************************/

{


#ifdef S3
  /********************************************************************/
  /* If we are being called at dspinstl time then we need to init     */                                                           
  /* the global asrscreenresolution table.   MRC 71126                */
  /********************************************************************/
  if(!PDBInstance) SetObtainableModes();
#endif

  /********************************************************************/
  /* If the OutData buffer length is zero then return the buffer size */
  /* needed to return the information.                                */
  /********************************************************************/
  if ( *pcdOutData == 0 )
  {
    *pcdOutData = sizeof(SCREENRESCOUNT)+
                  usNumScreenResolutions * sizeof(SCREENRESOLUTION);

    return(DEV_OK);
  }



  /********************************************************************/
  /* If the OutData buffer is not even as long as the SCREENRESCOUNT  */
  /* structure then return an error as there is nothing to do.        */
  /********************************************************************/
  if ( *pcdOutData < sizeof(SCREENRESCOUNT) )
  {
    LOGERR(TFUNC, "Invalid data buffer length", FNULL, 0,
           PMERR_INV_LENGTH_OR_COUNT);
    return(DEV_ERROR);
  }

  /********************************************************************/
  /* Set the length of the OutData SCREENRESOLUTION structure in      */
  /* the parameter for forward compatibility.                         */
  /********************************************************************/
  SRP_STRUCTLEN(pbOutData) = sizeof(SCREENRESOLUTION);


  /********************************************************************/
  /* Put the number of supported screen resolutions in the OutData    */
  /* buffer and calculate the number actually returned.               */
  /********************************************************************/
  SRP_MAXCOUNT(pbOutData) = usNumScreenResolutions;
  SRP_COUNT(pbOutData) = (*pcdOutData - sizeof(SCREENRESCOUNT)) /
                                               sizeof(SCREENRESOLUTION);

  /********************************************************************/
  /* Set the number of bytes of screen resolution data to return.     */
  /********************************************************************/
  *pcdOutData = SRP_COUNT(pbOutData) * sizeof(SCREENRESOLUTION);

  /********************************************************************/
  /* Copy each entry from our screen resolution table to the OutData  */
  /* SCREENRESOLUTION buffer.                                         */
  /********************************************************************/
  memcpy(SRP_RESBUFFER(pbOutData), asrScreenResolution, *pcdOutData);

  /********************************************************************/
  /* Set the number of bytes actually returned in the OutData count.  */
  /* This is the number of screen resolution bytes set above plus the */
  /* number of bytes in SCREENRESCOUNT.                               */
  /********************************************************************/
  *pcdOutData += sizeof(SCREENRESCOUNT);


  return(DEV_OK);

} /* OS2_PM_DRV_QUERYSCREENRESOLUTIONS */
