/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**********************************************************************/
/*                                                                    */
/*   File            = EDDMEXTF                                       */
/*                                                                    */
/*   Description     = Display Device Driver external files for       */
/*                     Display specfic routines                       */
/*                                                                    */
/*   Function        =                                                */
/*                                                                    */
/*   Reference       = Device Driver Interface Specification          */
/*                                                                    */
/*                                                                    */
/**********************************************************************/
DDIENTRY eddm_LockDevice (HDC       hdc,
                          PDC       pdcArg,
                          ULONG     FunN);

DDIENTRY eddm_UnlockDevice (HDC         hdc,
                            PDC         pdcArg,
                            ULONG       FunN);

DDIENTRY eddm_NotifyTransformChange (HDC        hdc,
                                     ULONG      ArgFlags,
                                     PULONG     ArgTransform,
                                     PDC        pdcArg,
                                     ULONG      FunN);

DDIENTRY eddm_SaveScreenBits (HDC       hdc,
                              PRECTL    ArgRectangle,
                              PDC       pdcArg,
                              ULONG     FunN);

DDIENTRY eddm_Death (HDC        hdc,
                     PDC        pdcArg,
                     ULONG      FunN);

DDIENTRY eddm_Resurrection (HDC         hdc,
                            ULONG       UnDocumented1,
                            ULONG       UnDocumented2,
                            PDC         pdcArg,
                            ULONG       FunN);

DDIENTRY eddm_ErasePS (HDC        hdc,
                       PDC        pdcArg,
                       ULONG      FunN);

DDIENTRY eddm_QueryDevResource (HDC     hdc,
                                ULONG   ArgTypeID,
                                ULONG   ArgNameID,
                                PDC     pdcArg,
                                ULONG   FunN);

DDIENTRY eddm_DeviceSetCursor (HDC            hdc,
                               PPOINTL        ArgHotSpot,
                               ULONG          ArgBitmap,
                               PDC            pdcArg,
                               ULONG          FunN);

DDIENTRY eddm_SetColorCursor (HDC            hdc,
                              PPOINTERINFO   ArgCursorInfo,
                              PDC            pdcArg,
                              ULONG          FunN);

/**********************************************************************/
/* Internal routines                                                  */
/**********************************************************************/
VOID SetSpriteShape(VOID);

VOID SetSpriteShapeWorker(VOID);

VOID DrawSprite(VOID);

USHORT eddm_ExcludeCursor(pDevPoint  ArgExclusionRect,
                          USHORT     CoordsType);

VOID eddm_Interrupts_Off(VOID);

VOID eddm_Interrupts_On(VOID);

VOID remove_software_cursor(VOID);

VOID disable_cursor(VOID);

VOID reenable_cursor(VOID);

VOID CopyCCToVRAM(VOID);

VOID UpdateXcludeRegion(RECTL);
