/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**********************************************************************/
/*                                                                    */
/*   Module          = EDDLSETC                                       */
/*                                                                    */
/*   Description     = Display Device Driver minor function handler   */
/*                     SetCurrentPosition                             */
/*                                                                    */
/*   Function        = Sets the current position                      */
/*                                                                    */
/*   Reference       = Winthorn Functional Specification              */
/*                     Device Driver Interface Specification          */
/*                     Display Device Driver Design Specification     */
/*                                                                    */
/*                                                                    */
/**********************************************************************/
#define INCL_DDIMISC
#define INCL_DDIPATHS
#define INCL_DDICOMFLAGS
#define INCL_GRE_XFORMS
#define INCL_GRE_LINES
#include <eddinclt.h>

#include <edddtypt.h>
#include <eddgextf.h>

extern PPFNL            EnginesDispatchTable;

/**********************************************************************/
/* SetCurrentPosition sets the current position by passing in an x,y  */
/* coordinate pair.                                                   */
/**********************************************************************/

DDIENTRY eddl_SetCurrentPosition (HDC           hdc,
                                  PPOINTL       pptlArgNewCurrPos,
                                  PDC           pdcArg,
                                  ULONG         FunN)

{
    /******************************************************************/
    /* Local variable                                                 */
    /******************************************************************/
    POINTL      ptlCurrPos;

    /******************************************************************/
    /* Get driver semaphore and perform entry checks.                 */
    /******************************************************************/
    EnterDriver(pdcArg, FunN, EDF_STANDARD | EDF_DONT_CLEAN);

    /******************************************************************/
    /* If an implicit close of a path then pass on to the default     */
    /* handler immediately.                                           */
    /******************************************************************/
    if (FunNTest(COM_PATH | COM_AREA))
    {
        ExitDriver(pdcArg, FunN,
                   EDF_STANDARD | EDF_IGNORE_TIME | EDF_DONT_CLEAN);
        return( EnginesDispatchTable[NGreSetCurrentPosition & 0xff](
                                                      hdc,
                                                      pptlArgNewCurrPos,
                                                      pdcArg,
                                                      FunN) );
    }

    /******************************************************************/
    /* Reset Line pattern count                                       */
    /******************************************************************/
    pdc->DCILinePatCnt = 0;

    /******************************************************************/
    /* Initialise the style number: the low byte is the style mask,   */
    /* while the high byte is the style                               */
    /******************************************************************/
    pdc->StyleNumber |= 0x0001ff00;

    /******************************************************************/
    /* Make a local copy of the new current position.                 */
    /******************************************************************/
    ptlCurrPos = *pptlArgNewCurrPos;

    /******************************************************************/
    /* If the COM_TRANSFORM bit is set then we are given the new      */
    /* current position in WORLD coordinates, otherwise they are in   */
    /* SCREEN coordinates.                                            */
    /******************************************************************/
    if (FunNTest(COM_TRANSFORM))
    {
        /**************************************************************/
        /* Convert world coordinates to device coordinates, but avoid */
        /* calling the engine if we can!                              */
        /**************************************************************/
        if ( !pdc->DCIXFrmSimple )
        {
            /**********************************************************/
            /* Call the engine convert function directly (for         */
            /* performance reasons).                                  */
            /**********************************************************/
            if ( OK != EnginesDispatchTable[NGreConvert & 0xff](
                                          pdc->DCIhdc,
                                          CVTC_WORLD,
                                          CVTC_DEVICE,
                                          (PPOINTL)&ptlCurrPos,
                                          1,
                                          NULL,
                                          NGreConvert) )
            {
                LogError(PMERR_COORDINATE_OVERFLOW);
                goto SETCURRENTPOS_ERR_EXIT;
            }

            /**********************************************************/
            /* Check that we are not going to lose any significant    */
            /* bits when we convert from a LONG to a SHORT.           */
            /* We can do this by casting the value to a SHORT, sign-  */
            /* extending it to a LONG, and then comparing the top     */
            /* 16 bits with the original 16 bits. If the upper bits   */
            /* are different then we are going to lose information    */
            /* when converting to a SHORT.                            */
            /**********************************************************/
            if ( ( HIUSHORT(ptlCurrPos.x) !=
                             HIUSHORT((LONG)((SHORT)ptlCurrPos.x)) ) ||
                 ( HIUSHORT(ptlCurrPos.y) !=
                              HIUSHORT((LONG)((SHORT)ptlCurrPos.y)) ) )
            {
                /******************************************************/
                /* We have an invalid coordinate. Log an error and    */
                /* return.                                            */
                /******************************************************/
                LogError(PMERR_COORDINATE_OVERFLOW);
                goto SETCURRENTPOS_ERR_EXIT;
            }
        }

        /**************************************************************/
        /* ptlCurrPos now contains the new current position in        */
        /* DEVICE coords. Convert it to HW coords and store it in     */
        /* DC data.                                                   */
        /**************************************************************/
        pdc->DCICurrPosAI.X = pdc->DCIOrigin.X + (SHORT)ptlCurrPos.x;
        pdc->DCICurrPosAI.Y = pdc->DCIConvFactor - (SHORT)ptlCurrPos.y;

        /**************************************************************/
        /* Now we know everything is OK, store the new world coords   */
        /* as well.                                                   */
        /**************************************************************/
        pdc->DCICurrPosWorld = *pptlArgNewCurrPos;
    }
    else
    {
        /**************************************************************/
        /* Do the SCREEN to WORLD conversion.                         */
        /**************************************************************/
        /**************************************************************/
        /* The given point is in SCREEN coords.  First we convert it  */
        /* to DEVICE coords.                                          */
        /**************************************************************/
        ptlCurrPos.x -= pdc->DCIOrigin.X;
        ptlCurrPos.y -= pdc->DCIOrigin.Y;

        if ( !pdc->DCIXFrmSimple )
        {
            /**********************************************************/
            /* Call the engine convert function directly (for         */
            /* performance reasons).                                  */
            /**********************************************************/
            if ( OK != EnginesDispatchTable[NGreConvert & 0xff](
                                          hdc,
                                          CVTC_DEVICE,
                                          CVTC_WORLD,
                                          &ptlCurrPos,
                                          1,
                                          NULL,
                                          NGreConvert) )
            {
                /******************************************************/
                /* The conversion failed so log an error.             */
                /******************************************************/
                LogError(PMERR_COORDINATE_OVERFLOW);
                goto SETCURRENTPOS_ERR_EXIT;
            }
        }

        /**********************************************************/
        /* Copy the new world current position into DC Data.      */
        /**********************************************************/
        pdc->DCICurrPosWorld = ptlCurrPos;

        /**********************************************************/
        /* Now we know everything is OK, store the new position   */
        /* in HW coords.                                          */
        /**********************************************************/
        pdc->DCICurrPosAI.X = (SHORT)pptlArgNewCurrPos->x;
        pdc->DCICurrPosAI.Y = pdc->DCIBoundingClip[1].Y
                                      - (SHORT)pptlArgNewCurrPos->y;
    }

    /******************************************************************/
    /* Release driver semaphore                                       */
    /******************************************************************/
    ExitDriver(pdcArg, FunN, EDF_STANDARD | EDF_DONT_CLEAN);
    return(TRUE);

SETCURRENTPOS_ERR_EXIT:
    /******************************************************************/
    /* Release driver semaphore                                       */
    /******************************************************************/
    ExitDriver(pdcArg, FunN, EDF_STANDARD | EDF_DONT_CLEAN);
    return(FALSE);
}
