/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**********************************************************************/
/*                                                                    */
/*   Module          = EDDFCONE                                       */
/*                                                                    */
/*   Description     = MESS constants                                 */
/*                                                                    */
/*   Reference       = Winthorn Functional Specification              */
/*                     Device Driver Interface Specification          */
/*                     Printer Device Driver Design Specification     */
/*                                                                    */
/*                                                                    */
/**********************************************************************/


#define MIX_USES_SRC 2
#define MIX_USES_DST 1

/**********************************************************************/
/* These should go into eddhcone.h when possible                      */
/**********************************************************************/
#define SRC_PIX_MAP_MASK    0x00F00000
#define STEP_FN_DRAW_AND_STEP_WRITE     0x04000000
#define STEP_FN_PXBLT       0x08000000
#define PLOT_STEP_DIR_MASK  0xE0
#define PLOT_STEP_COUNT_MASK    0x0F

/**********************************************************************/
/* Indexes for function table                                         */
/**********************************************************************/
#define index_DestOnlyBlt    0
#define index_drawaachar     1
#define index_drawtext       2
#define index_PatDestBlt     3
/* 4 UNUSED - was index_PMHIMAGEDATA */
/* 5 UNUSED - was index_PMHLINE      */
/* 6 UNUSED - was index_PMHSCANLINE  */
#define index_PMIMAGEDATA    7
#define index_PMLINES        8
#define index_PMPLOTSTEP     9
#define index_PMSCANLINE     10
#define index_PMSHORTLINES   11
#define index_SrcDestBlt     12

#define NUM_FUNCTIONS  13

/**********************************************************************/
/* Indexes for swapping physical and logical addresses in and out at  */
/* death and resurrection.                                            */
/**********************************************************************/

#define index_MarkerPhys       0
#define index_LinePatternPhys  1
#define index_pCacheStart      2
#define index_pCacheEnd        3

#define NUM_ADDRESSES          4
