/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/

/**********************************************************************/
/*                                                                    */
/*   File            = EDDESUBR                                       */
/*                                                                    */
/*   Description     = Enable subroutines                             */
/*                                                                    */
/*   Function        = set_dc_defaults sets the DC instance data to   */
/*                     its default value.                             */
/*                     FreeDCItems frees the memory hanging off the   */
/*                     DC instance data structure.                    */
/*                                                                    */
/*   Reference       = Winthorn Functional Specification              */
/*                     Device Driver Interface Specification          */
/*                     Display Device Driver Design                   */
/*                                                                    */
/*                                                                    */
/**********************************************************************/

#define INCL_DDIMISC

#include <eddinclt.h>
#include <eddconty.h>
#include <edddtypt.h>
#include <eddetypt.h>
#include <eddaextf.h>
#include <eddeextf.h>
#include <eddgextf.h>
#include <eddtextf.h>
#include <eddcextf.h>
#include <eddacone.h>
#include <eddvcone.h>
#include <eddecone.h>
#include <eddhcone.h>
#include <eddhtype.h>
#include <memman.h>

extern DDTType               DDT;

/**********************************************************************/
/* set_dc_defaults sets the DC instance data to its default values.   */
/* When called by resetDC this resets the DC to its created state     */
/**********************************************************************/
USHORT set_dc_defaults(VOID)

{
    /******************************************************************/
    /* Local variables                                                */
    /******************************************************************/
    USHORT      i;

    /******************************************************************/
    /* Logical Color Table                                            */
    /******************************************************************/
    if (pdc->DCIColFormat != LCOLF_DEFAULT)
    {
        eddc_ResetLogColorTable();
    }

    /******************************************************************/
    /* The DeviceSetAttributes functions are used to set the default  */
    /* attributes.                                                    */
    /******************************************************************/

    if ( pdc->DCIChanged & (NOTDEFAULT_TextAttrs |
                            NOTDEFAULT_LineAttrs |
                            NOTDEFAULT_MarkAttrs |
                            NOTDEFAULT_PtrnAttrs |
                            NOTDEFAULT_ImagAttrs) )
    {
        if (pdc->DCIChanged & NOTDEFAULT_LineAttrs)
        {
            /**********************************************************/
            /* Do Line Attributes                                     */
            /**********************************************************/
            SetLineAttributes (ALL_DEFAULTS, ALL_DEFAULTS, FNULL);
        }

        if (pdc->DCIChanged & NOTDEFAULT_TextAttrs)
        {
            /**********************************************************/
            /* Do Text Attributes                                     */
            /**********************************************************/
            if ( OK != SetTextAttributes (ALL_DEFAULTS, ALL_DEFAULTS, FNULL) )
            {
                return (ERROR_ZERO);
            }
        }

        if (pdc->DCIChanged & NOTDEFAULT_MarkAttrs)
        {
            /**********************************************************/
            /* During the setting up of the markers it checks to see  */
            /* if any previous definitions need to be freed. Set this */
            /* to zero to ensure that when setting defaults it        */
            /* doesn't try to free anything                           */
            /**********************************************************/
            /**********************************************************/
            /* No!!... This shouldn't be done here (JPB).             */
            /**********************************************************/
//          pdc->DCIMarker = 0;

            /**********************************************************/
            /* Do Marker Attributes                                   */
            /**********************************************************/
            if ( OK != SetMarkerAttributes (ALL_DEFAULTS, ALL_DEFAULTS, FNULL) )
            {
                return (ERROR_ZERO);
            }
        }

        if (pdc->DCIChanged & NOTDEFAULT_PtrnAttrs)
        {
            /**********************************************************/
            /* Do Pattern Attributes                                  */
            /**********************************************************/
            if ( OK != SetPatternAttributes (ALL_DEFAULTS, ALL_DEFAULTS, FNULL) )
            {
                return (ERROR_ZERO);
            }
        }

        if (pdc->DCIChanged & NOTDEFAULT_ImagAttrs)
        {
            /**********************************************************/
            /* Do Image Attributes                                    */
            /**********************************************************/
            SetImageAttributes (ALL_DEFAULTS, ALL_DEFAULTS, FNULL);
        }
    }

    /******************************************************************/
    /* Current position                                               */
    /******************************************************************/
    pdc->DCICurrPosAI.X = 0;
    pdc->DCICurrPosAI.Y = pdc->DCIConvFactor;

    /******************************************************************/
    /* Set World current position to (0,0).                           */
    /******************************************************************/
    pdc->DCICurrPosWorld.x = 0;
    pdc->DCICurrPosWorld.y = 0;


    /******************************************************************/
    /* Disable pair kerning                                           */
    /******************************************************************/
    pdc->DCIPairKerning = 0;

    /******************************************************************/
    /* set the GPI bounds to their default. User bounds are only reset*/
    /* when a DC is opened but not on any subsequent ResetDC's.       */
    /******************************************************************/
    pdc->DCIDefGPIBounds  = TRUE;

    /******************************************************************/
    /* set the correlation rectangles                                 */
    /******************************************************************/
    pdc->DCIPickWindowPage[0].X =
       (pdc->DCIPickWindowDevice[0].X = -(SHORT)DDT.AlphaCellWidth/2);
    pdc->DCIPickWindowPage[0].Y =
      (pdc->DCIPickWindowDevice[0].Y = -(SHORT)DDT.AlphaCellHeight/2);
    pdc->DCIPickWindowPage[1].X =
             (pdc->DCIPickWindowDevice[1].X = DDT.AlphaCellWidth/2);
    pdc->DCIPickWindowPage[1].Y =
              pdc->DCIPickWindowDevice[1].Y = DDT.AlphaCellHeight/2;
    pdc->DCICorrNum = 0;
    pdc->DCICorrInvalid = TRUE;

    /******************************************************************/
    /* Initialise the font table                                      */
    /******************************************************************/
    pdc->DCIRealizedFonts  = FNULL;
    pdc->DCIFontTabNum     = 0;

    /******************************************************************/
    /* Initialise the loadable AVIO font data.                        */
    /* Make sure any old fonts are freed (Reset_DC calls here!)       */
    /******************************************************************/
    for ( i = 0; i <= CNT_LOADABLE_LCIDS; i++ )
    {
        if (pdc->DCIAvioFonts[i].pFocaFont)
        {
            eddt_FreeCachedFont( pdc->DCIAvioFonts[i].usFontID,
                            pdc->DCIAvioFonts[i].usCachedFontIndex );
            pdc->DCIAvioFonts[i].pFocaFont = FNULL;
            pdc->DCIAvioInfo.pfciTable[i] = FNULL;
        }
    }
    /******************************************************************/
    /* Initialise AVIO cell size to force location first time         */
    /******************************************************************/
    pdc->DCIAvioInfo.bCellWidth  = 0xFF;
    pdc->DCIAvioInfo.bCellHeight = 0xFF;

    return(OK);

} /* set_dc_defaults */
#undef TFUNC






/**********************************************************************/
/* This routine frees those items of DC instance data which are not   */
/* part of the DC type structure. Note that memory required for clip  */
/* rectangles and correlation rectangles is retained until a          */
/* DisableDC.                                                         */
/**********************************************************************/
/* This routine takes a PDC parameter because it is freeing parrts of */
/* saved DC instances, rather than the current DC.                    */
/**********************************************************************/
VOID edde_FreeDCItems (PDC pdcFree)

{
#define TFUNC "edde_FreeDCItems"


    /******************************************************************/
    /* Free corr rectangles memory.                                   */
    /******************************************************************/
    if (pdcFree->DCICorrSize)
    {
        FreeMemory(pdcFree->DCICorrRects);
    }

    /******************************************************************/
    /* if there is a logical color table present then free the        */
    /* memory allocated for it                                        */
    /******************************************************************/
    if (pdcFree->DCIColFormat == LCOLF_INDRGB )
    {
        FreeMemory(pdcFree->DCIColorTable);
    }

    /******************************************************************/
    /* If there is a font table then free its memory                  */
    /******************************************************************/
    if ( pdcFree->DCIFontTabNum )
    {
        register ULONG i;
        /**************************************************************/
        /* fonts have been realised so free the memory used for them  */
        /* This is done by calling RealizeFont with the DELETE option */
        /* for every entry in the font table which has not already    */
        /* been deleted, ie. still has a valid pointer to the         */
        /* character definitions                                      */
        /**************************************************************/
        for ( i = pdcFree->DCIFontTabNum ;
              i--;
              )
        {
            if ( pdcFree->DCIRealizedFonts[i].AICharSetDefn )
            {
                edda_RealizeFont(pdcFree->DCIhdc,
                                 RF_DELETE_FONT,
                                 0,
                                 FTB_LCID_BASE + i,
                                 pdcFree,
                                 0);
            }
        }
        /**************************************************************/
        /* Free memory used for the realized font table.              */
        /**************************************************************/
        FreeMemory(pdcFree->DCIRealizedFonts);
    }

    /**************************************************************/
    /* free the character pattern bitmap if one was created       */
    /**************************************************************/
    if ( pdcFree->DCIChanged & PATTERN_BITMAP_CREATED )
    {
        /**********************************************************/
        /* Get rid of the bitmap memory                           */
        /**********************************************************/
        destroy_character_bitmap(pdcFree->TempPattern);
    }

    if (pdcFree->DCIChanged & PATTERN_HEADER_CREATED)
    {
        /**********************************************************/
        /* Get rid of the bitmap header                           */
        /**********************************************************/
        FreeMemory(pdc->TempPattern);
    }

    /**************************************************************/
    /* free the character marker bitmap if one was created        */
    /**************************************************************/
    if ( pdcFree->DCIChanged & MARKER_BITMAP_CREATED )
    {
        /**********************************************************/
        /* Get rid of the bitmap memory                           */
        /**********************************************************/
        destroy_character_bitmap(pdcFree->DCIMarker);

        /**********************************************************/
        /* Get rid of the bitmap header                           */
        /**********************************************************/
        FreeMemory(pdcFree->DCIMarker);
    }

}
#undef TFUNC



VOID free_transient_dc_memory(VOID)

 /**********************************************************************/
 /* frees memory allocated to a device context sometime after its      */
 /* initial creation. Used as part of resetDC to restore the dc to its */
 /* created state                                                      */
 /**********************************************************************/

{
#define TFUNC "free_transient_dc_memory"


    if ( pdc->DCIFontTabNum )
    {
        register USHORT i;
        /**************************************************************/
        /* fonts have been realised so free the memory used for them  */
        /* This is done by calling RealizeFont with the DELETE option */
        /* for every entry in the font table which has not already    */
        /* been deleted, ie. still has a valid pointer to the         */
        /* character definitions                                      */
        /**************************************************************/
        for ( i = pdc->DCIFontTabNum ;
              i--;
              )
        {
            if ( pdc->DCIRealizedFonts[i].AICharSetDefn )
            {
                edda_RealizeFont(pdc->DCIhdc,
                                 (ULONG)RF_DELETE_FONT,
                                 0L,
                                 (ULONG)(FTB_LCID_BASE + i),
                                 pdc,
                                 0L);
            }
        }

        /**************************************************************/
        /* Free the memory used for the realized font table.          */
        /**************************************************************/
        FreeMemory(pdc->DCIRealizedFonts);
    }

} /* free_transient_dc_memory */
#undef TFUNC
