/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/

/**********************************************************************/
/*                                                                    */
/*   File            = EDDESRES                                       */
/*                                                                    */
/*   Description     = Display Device Driver set screen mode header   */
/*                                                                    */
/*   Function        =                                                */
/*                                                                    */
/*   Reference       = Device Driver Interface Specification          */
/*                                                                    */
/*                                                                    */
/**********************************************************************/

/* macros for determining hardware configuration */
#ifndef   _8514
//#define ENABLED_16BPP ((DDT.fScreenFlags & USE_16BPP)!=0)
//#define HALF_MEG_ADAPTER (aiXGAAdapter.lMemorySize<=0x80000)
//#define HI_RES_POSSIBLE (HI_RES_DISPLAY(aiXGAAdapter))
#define ENABLED_16BPP FALSE
#define HALF_MEG_ADAPTER FALSE
#define HI_RES_POSSIBLE TRUE

/* total number of supported screen resolutions */
#define NUM_SCREEN_RESOLUTIONS 5

#else    //_8514
#ifndef   S3
#define NUM_SCREEN_RESOLUTIONS 1
#else    //S3
#ifdef BPP24
#define NUM_SCREEN_RESOLUTIONS 8
#else
#define NUM_SCREEN_RESOLUTIONS 7
#endif
#define ONE_MEG_ADAPTER   0x100000
#define TWO_MEG_ADAPTER   0x200000
#define THREE_MEG_ADAPTER   0x300000
#define FOUR_MEG_ADAPTER   0x400000
#define HALF_MEG_ADAPTER 0x80000
#endif  //S3
#endif  //_8514

/* Access to INI file */
#define UMS_APPLICATION_NAME "PM_DISPLAYDRIVERS"
#define UMS_KEY "DEFAULTSYSTEMRESOLUTION"


/* Globals */
extern PSCREENRESOLUTION asrScreenResolution;
extern USHORT usNumScreenResolutions;


/* #defines to move to 2.0 header edde??? */
#define LO_RES_WIDTH  640
#define LO_RES_HEIGHT 480
#define RES_800_WIDTH  800
#define RES_800_HEIGHT 600
#define HI_RES_WIDTH  1024
#define HI_RES_HEIGHT 768
#define RES_1280_WIDTH  1280
#define RES_1280_HEIGHT 1024
#define NUM_PLANES    1
#define NUM_4BPP_COLOURS  16
#define NUM_8BPP_COLOURS  256
#define NUM_16BPP_COLOURS 65536
#define NUM_24BPP_COLOURS 0x01000000
