/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**********************************************************************/
/*                                                                    */
/*   File            = EDDEDDC                                        */
/*                                                                    */
/*   Description     = Enable : subfunction Disable Device Context    */
/*                                                                    */
/*   Function        = DisableDC is called when an individual DC      */
/*                     is terminating.                                */
/*                                                                    */
/*   Reference       = Winthorn Functional Specification              */
/*                     Device Driver Interface Specification          */
/*                     Display Device Driver Design                   */
/*                                                                    */
/*                                                                    */
/**********************************************************************/

#define INCL_GRE_PALETTE
#define INCL_DDIMISC
#include <eddinclt.h>

#include <eddetypt.h>
#include <edddtypt.h>
#include <eddhcone.h>
#include <eddtcone.h>
#include <eddhtype.h>
#include <eddaextf.h>
#include <eddeextf.h>
#include <eddgextf.h>
#include <eddtextf.h>
#include <eddbextf.h>

#include <eddecone.h>
#include <eddhmacr.h>

#include <memman.h>

#ifdef PALETTE_MGR
#include <twozero.h>
#endif /* PALETTE_MGR */

/**********************************************************************/
/*                                                                    */
/* DisableDC is called when a DC is terminating. It deallocates all   */
/* memory allocated to the DC.                                        */
/*                                                                    */
/**********************************************************************/
USHORT DisableDC (PDC    pdcArg)

{
    /******************************************************************/
    /* Local variables                                                */
    /******************************************************************/
    ULONG       i;

    /******************************************************************/
    /* Get driver semaphore and perform entry checks                  */
    /* (Definitely don't clean here - can cause crash as DC can be    */
    /* invalid by now)                                                */
    /******************************************************************/
    EnterDriver(pdcArg, FUNN_UNKNOWN, EDF_STANDARD | EDF_DONT_CLEAN);

    /**************************************************************/
    /* Free the currently selected font.                          */
    /**************************************************************/
    eddt_FreeCachedFont( pdc->CurrentFont.usFontID,
                         pdc->CurrentFont.usCachedFontIndex);

    /**************************************************************/
    /* Free the AVIO fonts as well.                               */
    /**************************************************************/
    for ( i= 0 ; i <= CNT_LOADABLE_LCIDS ; i++ )
    {
        if (pdc->DCIAvioFonts[i].pFocaFont)
        {
            eddt_FreeCachedFont( pdc->DCIAvioFonts[i].usFontID,
                        pdc->DCIAvioFonts[i].usCachedFontIndex );
            pdc->DCIAvioFonts[i].pFocaFont = FNULL;
            pdc->DCIAvioInfo.pfciTable[i]  = FNULL;
        }
    }

#ifdef PALETTE_MGR
#ifdef FIREWALLS
    /**************************************************************/
    /* The engine should have cleaned up the DC before trying to  */
    /* delete it.                                                 */
    /* This means it should have deleted any bitmaps, palettes    */
    /* etc which may have been selected into it - however just to */
    /* make sure we will check for the existence of a palette     */
    /* ourselves, and delete it if necessary                      */
    /**************************************************************/
    if (pdc->DCIColFormat == LCOLF_PALETTE)
    {
        DebugOutput("Disable DC - palette still selected\n\r");

        InnerDeletePalette(pdc->Palette);
    }
#endif /* FIREWALLS */
#endif /* PALETTE_MGR */

    /******************************************************************/
    /* Free memory objects that have been created for this DC.        */
    /******************************************************************/
    edde_FreeDCItems(pdc);

    /******************************************************************/
    /* Free dc instance memory.                                       */
    /******************************************************************/
    FreeMemory(pdc);

    /******************************************************************/
    /* Release driver semaphore                                       */
    /******************************************************************/
    ExitDriver(pdcArg, FUNN_UNKNOWN, EDF_STANDARD| EDF_DONT_CLEAN);

    return(TRUE);
}
