/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/

/**********************************************************************/
/*                                                                    */
/*   File            = EDDECONE                                       */
/*                                                                    */
/*   Description     = Printer Device Driver Enable constants         */
/*                                                                    */
/*   Function        =                                                */
/*                                                                    */
/*   Reference       = Device Driver Interface Specification          */
/*                                                                    */
/*                                                                    */
/**********************************************************************/

/**********************************************************************/
/* enable subfunction codes                                           */
/**********************************************************************/
#define EN_FILL_LDB          1
#define EN_FILL_PDB          2
#define EN_FILL_IPDB         3
#define EN_DISABLE_PDB       4
#define EN_ENABLE_DC         5
#define EN_DISABLE_DC        6
#define EN_SAVE_DC           7
#define EN_RESTORE_DC        8
#define EN_RESET_DC          9
#define EN_COMPLETE_OPEN    10
#define EN_BEGIN_CLOSE      11

/**********************************************************************/
/* flags to show if DCI attributes are no longer set to default       */
/**********************************************************************/
#define NOTDEFAULT_TextAttrs    0x00000001
#define NOTDEFAULT_LineAttrs    0x00000002
#define NOTDEFAULT_MarkAttrs    0x00000004
#define NOTDEFAULT_PtrnAttrs    0x00000008
#define NOTDEFAULT_ImagAttrs    0x00000010
#define NEW_MARKER_SYMBOL       0x00000020
#define NEW_PATTERN_SYMBOL      0x00000040
#define PATTERN_BITMAP_CREATED  0x00000080
#define PATTERN_HEADER_CREATED  0x00000200
#define MARKER_BITMAP_CREATED   0x00000100

/**********************************************************************/
/* Value to pass to attribute setting routine to force all the        */
/* defaults to be used.                                               */
/**********************************************************************/
#define ALL_DEFAULTS    0xFFFFFFFF

/**********************************************************************/
/* monitor types                                                      */
/* note all values may be written to OS2.INI so should be printable   */
/* characters (ie best to keep to the range 32 to 128)                */
/*                                                                    */
/* Note : CHICAGO (8604) and ALBANY (8507) cannot be distinguished    */
/*                 8512  and         8513  cannot be distinguished    */
/**********************************************************************/
#define UNKNOWN         0x20

#define TYPE8503        0x33      /* prints as '3' */
#define TYPE8506        0x36      /* prints as '6' */
#define TYPE8507        0x37      /* prints as '7' */
#define TYPE8508        0x38      /* prints as '8' */
#define TYPE8512or13    0x3c      /* prints as '<' */
#define TYPE8514        0x3e      /* prints as '>' */
#define TYPE8515        0x3f      /* prints as '?' */
#define TYPE5081        81        /* prints as 'Q' */

#define BUFFALO        TYPE8506
#define ALBANY         TYPE8507
#define BOSTON         TYPE8508
#define DALLAS         TYPE8515

/**********************************************************************/
/* System font Identifiers                                            */
/**********************************************************************/
#define SysLowFont     102
#define SysHighFont    103
#define SysDallasFont  104

/**********************************************************************/
/* Name of the font resource DLL                                      */
/**********************************************************************/
#define RESOURCE_DLL "dspres"
