/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**********************************************************************/
/*                                                                    */
/*   File            = EDDDTYPT                                       */
/*                                                                    */
/*   Description     = Display Device Driver DDT/DVT/DCT Table        */
/*                     constants and types                            */
/*                                                                    */
/*   Function        =                                                */
/*                                                                    */
/*   Reference       = Winthorn Functional Specification              */
/*                     Device Driver Interface Specification          */
/*                     Printer Device Driver Design Specification     */
/*                                                                    */
/*                                                                    */
/**********************************************************************/

/**********************************************************************/
/* Definition for cuurent cached state of an anti-aliased font        */
/**********************************************************************/
typedef struct
    {
        BYTE                      XLateCount;
        BYTE                      CurrentXLate;
        BYTE                      XLateTables[8][8];
        BYTE                      CacheFlag[NUM_AA_GLYPHS];
        BYTE                      CharacterWidth[NUM_AA_GLYPHS];
#ifndef CC20
        ULONG                     CharPosInCache[NUM_AA_GLYPHS];
#else /* ndef CC20 */
        ULONG                     ImagPosInCache[NUM_AA_GLYPHS];
        ULONG                     MaskPosInCache[NUM_AA_GLYPHS];
#endif /* ndef CC20 */
    } FontCacheInfoType;

typedef FontCacheInfoType * pFontCacheInfoType;

/**********************************************************************/
/* Device Description Table (DDT) type.                               */
/**********************************************************************/

typedef struct _ddt
{
    /**************************************************************/
    /* Description of the screen                                  */
    /**************************************************************/
    USHORT          fScreenFlags;
    USHORT          ScreenWidth;
    USHORT          ScreenHeight;
    USHORT          BitCount;
    USHORT          AlphaCellWidth;
    USHORT          AlphaCellHeight;
    USHORT          horizontal_resolution;
    USHORT          vertical_resolution;
    USHORT          graphics_char_width;
    USHORT          graphics_char_height;
    /**************************************************************/
    /* Cursor information                                         */
    /**************************************************************/
    USHORT          CursorWidth;
    USHORT          CursorHeight;
    /**************************************************************/
    /* AVIO information                                           */
    /**************************************************************/
    USHORT          NoOfAvioCellSizes;
    #ifdef _8514
    BOOL            fCaching;
    #endif

} DDTType;

/**********************************************************************/
/* Type definition for a AI palette                                   */
/**********************************************************************/
typedef ULONG PaletteType;

typedef PaletteType * lpPalette;

#ifdef AVIO_RES_FONTS
/**********************************************************************/
/* Type definition for AVIO font description table                    */
/**********************************************************************/
typedef struct
{
    BYTE                    CellWidth;
    BYTE                    CellHeight;
    USHORT                  ResourceType;
    USHORT                  ResourceName;
    PVOID                   pResourceData;
} AvioFontTableType;

#else

/**********************************************************************/
/* Type definition for AVIO font description table                    */
/**********************************************************************/
typedef struct
{
    BYTE                    CellWidth;
    BYTE                    CellHeight;
    CHAR *                  AvioFontFilename;
    pCharSetDef             AvioFontDef;
} AvioFontTableType;

#endif

/**********************************************************************/
/* Type definition for AVIO default font table. This stores the       */
/* normal and small default fonts for each of the possible AI modes   */
/**********************************************************************/
typedef struct
{
    BYTE                    SmallFont;
    BYTE                    NormalFont;
} AvioDefaultFontTableType;

/**********************************************************************/
/* Type definition for local RGB holding store. This stores the       */
/* individual RGB values for the 4bpp dither pattern                  */
/**********************************************************************/
typedef struct
{
    BYTE                    R;
    BYTE                    G;
    BYTE                    B;
} RGBPatternType;

/**********************************************************************/
/* we need a pointer to rgb type                                      */
/**********************************************************************/
typedef RGB * PRGB;
