/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**********************************************************************/
/*                                                                    */
/*   Module File     = EDDDTAB                                        */
/*                                                                    */
/*   Description     = Display Device Driver DDT/DVT/DCT Tables       */
/*                                                                    */
/*   Function        = Defines DDT, DVT, DCT Tables, and associated   */
/*                     Headers.                                       */
/*                                                                    */
/*   Reference       = Display Device Driver Design                   */
/*                     Device Driver Interface Specification          */
/*                     Display Device Driver Design Specification     */
/*                                                                    */
/*                                                                    */
/**********************************************************************/
#define INCL_DDIMISC
#include <eddinclt.h>

#include <edddtypt.h>
#include <eddmcone.h>
#include <eddvcone.h>
#include <eddbcone.h>

/**********************************************************************/
/* General data structures                                            */
/**********************************************************************/

/**********************************************************************/
/* Device Description Table (DDT)                                     */
/**********************************************************************/
DDTType         DDT;
#ifndef   _8514
ADAPTERINFO     aiXGAAdapter;
#endif

/**********************************************************************/
/* List entry to be associated with direct DC's                       */
/**********************************************************************/
BitmapHeader DirectListEntry = {
                                FNULL,
                                FNULL,
                                0L,
                                0, 0, 0, 0, 0, 0,
                                0L
                                };

BitmapHeader DummyInfoBitmap = {
                                FNULL,
                                FNULL,
                                0L,
                                0, 0, 0, 0, 0, 0,
                                0L
                                };

#ifdef MATROX
BitmapHeader VRAMBitmap = {
                            FNULL,
                            FNULL,
                            0L,
                            0, 0, 0, 0, 0, 0,
                            0L
                            };
#endif /* MATROX */

/**********************************************************************/
/* AVIO font description table.                                       */
/* This contains the width and height of each AVIO font, along with   */
/* the Resource Type, Resource Name and Character Definition Headers. */
/**********************************************************************/
AvioFontTableType AvioBaseFont[NO_OF_AVIO_FONTS] =
{
    {  5, 12, 1000, 2001, 0 },
    {  5, 16, 1000, 2002, 0 },
    {  6, 10, 1000, 2003, 0 },
    {  6, 14, 1000, 2004, 0 },
    {  7, 15, 1000, 2005, 0 },
    {  7, 25, 1000, 2006, 0 },
    {  8,  8, 1000, 2007, 0 },
    {  8, 10, 1000, 2008, 0 },
    {  8, 12, 1000, 2009, 0 },
    {  8, 14, 1000, 2010, 0 },
    {  8, 16, 1000, 2011, 0 },
    {  8, 18, 1000, 2012, 0 },
    { 10, 18, 1000, 2013, 0 },
    { 12, 16, 1000, 2014, 0 },
    { 12, 20, 1000, 2015, 0 },
    { 12, 22, 1000, 2016, 0 },
    { 12, 30, 1000, 2017, 0 },
};

/**********************************************************************/
/* AVIO default font table, indicating the default large and small    */
/* fonts for each mode that the adapter can be used in.               */
/**********************************************************************/
AvioDefaultFontTableType AvioDefaultFont[NO_OF_VIDEO_MODES] =
{
    { SYS08x14, SYS12x22 },
    { SYS08x08, SYS08x14 }
};

/**********************************************************************/
/* The default AVIO fonts for the current screen mode.                */
/**********************************************************************/
BYTE                   DefaultSmallFont;
BYTE                   DefaultNormalFont;

/**********************************************************************/
/* Handle of DC that realised its Logical Color Table                 */
/**********************************************************************/
HDC     ColorTableRealized = 0;

/**********************************************************************/
/* A variable indicating the current state of the system colors       */
/**********************************************************************/
USHORT  CurrentSysColState = 0;

#ifndef PALETTE_MGR
/**********************************************************************/
/* Physical Color Table representing the palette loaded across the AI */
/**********************************************************************/
lpPalette  PhysicalColorTable;

#ifndef NEW_PALETTE
/**********************************************************************/
/* Array used for translation when in (8,1) format                    */
/**********************************************************************/
PBYTE   RGBToPalette;

/**********************************************************************/
/* Colour Range for 6 shades (linear)                                 */
/**********************************************************************/
ULONG   ColRange[6] = { 0, 51, 102, 153, 204, 255 };
#endif /* ndef NEW_PALETTE */
#endif /* ndef PALETTE_MGR */
