/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**********************************************************************/
/*                                                                    */
/*   Module File     = EDDDATA                                        */
/*                                                                    */
/*   Description     = Display Device Driver data                     */
/*                                                                    */
/*   Function        =                                                */
/*                                                                    */
/*   Reference       = Display Device Driver Design                   */
/*                     Device Driver Interface Specification          */
/*                     Display Device Driver Design Specification     */
/*                                                                    */
/*                                                                    */
/**********************************************************************/
#define INCL_GREALL
#define INCL_DDIMISC
#define INCL_DDIPATHS
#define INCL_WINSYS
#define INCL_GRE_PALETTE
#include <eddinclt.h>

#include <eddacone.h>
#include <eddbcone.h>
#include <eddccone.h>
#include <eddhcone.h>
#include <eddvcone.h>

#include <eddetypt.h>
#include <eddhtype.h>
#ifdef VRAMPTR
#include <eddncach.h>
#endif /* VRAMPTR */

/**********************************************************************/
/* temp                                                               */
/**********************************************************************/
AIWORK  AIWork;

/**********************************************************************/
/* The hmodule needed for DosGetResource calls.                       */
/**********************************************************************/
HMODULE         hModule = 65535; /* GP fault forced if not initialise */

/**********************************************************************/
/* A flag to indicate whether the Driver is dead (in the background)  */
/* or alive (in the foreground).                                      */
/**********************************************************************/
BOOL    fXgaDead = FALSE;

/**********************************************************************/
/* The enter driver semaphore.                                        */
/**********************************************************************/
HMTX    hDriverSem;

/**********************************************************************/
/* The driver uses a line style pattern length of 16 and a step size  */
/* of 0x80 - the step size is used for both x and y directions.       */
/*                                                                    */
/* The step size is returned to the graphics engine in GetStyleRatio; */
/* SetStyleRatio is hooked (required by brute force printer drivers)  */
/* but it does not alter the step size.                               */
/*                                                                    */
/* The driver keeps track of the current position in the line style   */
/* pattern in DCILinePatCnt - this takes values between 0 and 15.     */
/*                                                                    */
/* The engine also keeps track of the pattern c.p. in units of the    */
/* step size (as returned in GetStyleRatio).  The pattern c.p. is     */
/* held in two bytes - the mask position (between 0 and 7) and the    */
/* error term (an integer number of step sizes).  This c.p. is        */
/* passed between the driver and the engine in DrawLinesInPath,       */
/* PolyShortLine, SetLineOrigin and GetLineOrigin in (us)Style.       */
/* Only the bottom three bits of the mask position byte are valid -   */
/* the engine reserves the other five bits for use as flags.          */
/*                                                                    */
/* When the engine's c.p. value gets to 0x800 it is "wrapped" back to */
/* 0x000.  Hence our pattern length x our step size must be equal     */
/* to 0x800.                                                          */
/* NOTE: 16 is the same value as LINE_PATTERN_LENGTH used in line     */
/*       output assembler routines                                    */
/**********************************************************************/
BYTE  LinePatStep   = 0x80;
BYTE  LinePatLength = 16;

/**********************************************************************/
/* single pel buffer for transfer during get and set pel              */
/**********************************************************************/
ONEPELBUFFER   get_and_set_pel_buffer;

/**********************************************************************/
/* control structure for fetching clip rectangles via GreGetClipRects */
/**********************************************************************/
RGNRECT GetClipsControl = { 0,            /* start clip               */
                            CACHED_CLIPS, /* return buffer size       */
                            0,            /* number of rects returned */
                            RECTDIR_LFRT_TOPBOT }; /* direction       */

/**********************************************************************/
/* bounding rectangle for fetching clip rectangles via GreGetClipRects*/
/**********************************************************************/
RECTL GetClipsBounds = {0, 0, 0, 0};

/**********************************************************************/
/* global variables used for getting clip rectangles from the engine  */
/**********************************************************************/
RECTL          ClipBounds;
RGNRECT        ClipControl = { 1,   /* start - set before use         */
                               CACHED_CLIPS,
                                    /* buffer size - fixed            */
                               0,   /* number returned - fn return    */
                               RECTDIR_LFRT_TOPBOT };
                                    /* direction - fixed              */


/**********************************************************************/
/* default font character definition VRAM cache physical address      */
/**********************************************************************/
PBYTE   DefaultFontPhysicalAddress;

/**********************************************************************/
/* pointer to dummy physical instance data. This is global because    */
/* FillPhysicalDeviceBlock can be called multiple times and we use    */
/* this to detect whether we have been called already (not NULL)      */
/**********************************************************************/
lpPDBI  PDBInstance = FNULL;

/**********************************************************************/
/*                                                                    */
/*                       Default Marker Set                           */
/*                                                                    */
/*     markers are defined on a 9 * 9 grid within a 16 * 9 cell       */
/*        which are used as bitmap by the code                        */
/*                                                                    */
/**********************************************************************/

BYTE MarkerDefaultSet[] = {
    0x80, 0x80, 0x41, 0x00, 0x22, 0x00, 0x14, 0x00, 0x08, 0x00,
    0x14, 0x00, 0x22, 0x00, 0x41, 0x00, 0x80, 0x80,
                                             /* cross                 */
    0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0xff, 0x80,
    0x08, 0x00, 0x08, 0x00, 0x08, 0x00, 0x08, 0x00,
                                             /* plus                  */
    0x08, 0x00, 0x14, 0x00, 0x22, 0x00, 0x41, 0x00, 0x80, 0x80,
    0x41, 0x00, 0x22, 0x00, 0x14, 0x00, 0x08, 0x00,
                                             /* diamond               */
    0xff, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0x80,
    0x80, 0x80, 0x80, 0x80, 0x80, 0x80, 0xff, 0x80,
                                             /* square                */
    0x08, 0x00, 0x14, 0x00, 0xff, 0x80, 0x63, 0x00, 0x41, 0x00,
    0x63, 0x00, 0xff, 0x80, 0x14, 0x00, 0x08, 0x00,
                                             /* six-point star        */
    0x88, 0x80, 0x49, 0x00, 0x2A, 0x00, 0x1C, 0x00, 0xFF, 0x80,
    0x1C, 0x00, 0x2A, 0x00, 0x49, 0x00, 0x88, 0x80,
                                             /* eight-point star      */
    0x08, 0x00, 0x1C, 0x00, 0x3E, 0x00, 0x7F, 0x00, 0xFF, 0x80,
    0x7F, 0x00, 0x3E, 0x00, 0x1C, 0x00, 0x08, 0x00,
                                             /* filled diamond        */
    0xFF, 0x80, 0xFF, 0x80, 0xFF, 0x80, 0xFF, 0x80, 0xFF, 0x80,
    0xFF, 0x80, 0xFF, 0x80, 0xFF, 0x80, 0xFF, 0x80,
                                             /* filled square         */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x08, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                             /* dot                   */
    0x00, 0x00, 0x00, 0x00, 0x1C, 0x00, 0x22, 0x00, 0x22, 0x00,
    0x22, 0x00, 0x1C, 0x00, 0x00, 0x00, 0x00, 0x00,
                                             /* small circle          */
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00,
                                             /* blank                 */
    };



/**********************************************************************/
/* bitmap header for markers and a buffer for marker positions        */
/* Marker header is initialised to the default marker                 */
/**********************************************************************/
#ifdef SDBM20
ULONG                      MarkerCur;
#endif
ULONG                      MarkerSys;
ULONG                      MarkerPhys;

POINTL                     MarkerCoords[MAX_MARKERS];
BitmapHeader               MarkerBitmapHeader = {
                           MarkerDefaultSet,   /* address of default  */
                           0L,                 /* physical address    */
                           DEF_MARKER_LENGTH,  /* size                */
                           DEF_MARKER_WIDTH,   /* bitmap width        */
                           DEF_MARKER_HEIGHT,  /* bitmap height       */
                           1,                  /* bitcount            */
                           DEF_MARKER_WIDTH_IN_BYTES*8-1,
                                               /* bitmap h/w width */
                           DEF_MARKER_HEIGHT-1,/* bitmap h/w height   */
                           ONE_BIT_PER_PEL,    /* h/w format          */
                           0L,                 /* not selected        */
                           (DEF_MARKER_WIDTH+7)/8,
                                               /* bytes per line      */
#ifdef VRAMPTR
                           BITMAP_NOT_CACHED,  /* VRAM cache slot     */
#endif /* VRAMPTR */
                           {0, 0}              /* margin values       */
                           };


/**********************************************************************/
/*                                                                    */
/*            Default Attribute bundles                               */
/*                                                                    */
/**********************************************************************/

/**********************************************************************/
/* The define indicates which parts of the default text attributes    */
/* require simulation.                                                */
/* It is the value the DCITextSim will be initialsed to and is made   */
/* up of the CBB_ flags that require simulations.                     */
/* Eg if the default character direction and foreground colour        */
/* required simulation(!), the value would be:                        */
/*          CBB_DIRECTION | CBB_COLOR                                 */
/**********************************************************************/
BOOL        DefaultTextSimulation   =    0;


/**********************************************************************/
/* Text bundle of attributes                                          */
/**********************************************************************/
DCHARBUNDLE DefaultTextAttrs = {
       sizeof(CHARBUNDLE),        /* attribute count (bytes)          */
       sizeof(CHARDEFS),          /* definition count (bytes)         */
           DEFAULT_FOREGROUND_COL,    /* foreground colour            */
           DEFAULT_BACKGROUND_COL,    /* background colour            */
           DEFAULT_FOREGROUND_MIX,    /* mix                          */
           DEFAULT_BACKGROUND_MIX,    /* background mix               */
           0,                         /* set                          */
           0x1,                       /* precision mode - 1           */
           {0x0L,0x0L},               /* cell width, height           */
           {0x1L,0x0L},               /* Angle                        */
           {0x0L,0x1L},               /* Shear                        */
           0x1,                       /* Direction - left to right    */
#ifdef EXTRA_SPACE      /* DCR 25045 (+DCR 02028 for Text Align) */
           TA_NORMAL_HORIZ |          /* Text Align                   */
           TA_NORMAL_VERT,
           0L,                        /* CharExtra                    */
           0L,                        /* CharBreakExtra               */
#endif /* EXTRA_SPACE */
       FNULL,                     /* pointer to current set           */
       0,                         /* flags                            */
       0,                         /* codepage                         */
       0                          /* spacing                          */
   };

/**********************************************************************/
/* Line bundle of attributes                                          */
/**********************************************************************/
DLINEBUNDLE     DefaultLineAttrs = {
       sizeof(LINEBUNDLE),        /* attribute count (bytes)          */
       sizeof(LINEDEFS),          /* definition count (bytes)         */
           DEFAULT_FOREGROUND_COL,    /* foreground color             */
           DEFAULT_BACKGROUND_COL,    /* background color             */
           DEFAULT_FOREGROUND_MIX,    /* foreground mix               */
           DEFAULT_BACKGROUND_MIX,    /* background mix               */
           0x00010000L,               /* width - normal               */
           0xFFFFFFFFL,               /* geometric width - cosmetic   */
           0x7,                       /* type - solid                 */
           0x1,                       /* end - flat                   */
           0x1,                       /* joint - bevel                */
       0L                         /* def type                         */
   };

/**********************************************************************/
/* Pattern bundle of attributes                                       */
/**********************************************************************/
DAREABUNDLE     DefaultPatternAttrs = {
       sizeof(AREABUNDLE),        /* attribute count (bytes)          */
       sizeof(AREADEFS),          /* definition count (bytes)         */
           DEFAULT_FOREGROUND_COL,    /* foreground color             */
           DEFAULT_BACKGROUND_COL,    /* background color             */
           DEFAULT_FOREGROUND_MIX,    /* foreground mix               */
           DEFAULT_BACKGROUND_MIX,    /* background mix               */
           0x00,                      /* set - BASE?                  */
           0x10,                      /* symbol - solid shading       */
           {0x0L,0x0L},               /* ref point                    */
       FNULL,                     /* pointer to current set           */
       0,                         /* flags                            */
       0                          /* codepage                         */
   };

/**********************************************************************/
/* Image bundle of attributes                                         */
/**********************************************************************/
DIMAGEBUNDLE  DefaultImageAttrs = {
       sizeof(IMAGEBUNDLE),       /* attribute count (bytes)          */
       0,                         /* IMAGEDEFS is empty so not defined*/
           DEFAULT_FOREGROUND_COL,    /* foreground color             */
           DEFAULT_BACKGROUND_COL,    /* background color             */
           DEFAULT_FOREGROUND_MIX,    /* foreground mix               */
           DEFAULT_BACKGROUND_MIX     /* background mix               */
   };

/**********************************************************************/
/* Marker bundle of attributes                                        */
/**********************************************************************/
DMARKERBUNDLE DefaultMarkerAttrs = {
       sizeof(MARKERBUNDLE),      /* attribute count (bytes)          */
       sizeof(MARKERDEFS),        /* definition count (bytes)         */
           DEFAULT_FOREGROUND_COL,    /* foreground colour            */
           DEFAULT_BACKGROUND_COL,    /* background colour            */
           DEFAULT_FOREGROUND_MIX,    /* mix                          */
           DEFAULT_BACKGROUND_MIX,    /* background mix               */
           0,                         /* set                          */
           0,                         /* symbol (cross)               */
           0x00090000,                /* box x dimension              */
           0x00090000,                /* box y dimension              */
       FNULL,                     /* pointer to current set           */
       0,                         /* flags                            */
       0                          /* codepage                         */
   };

/**********************************************************************/
/* count of number of resident fonts                                  */
/**********************************************************************/
USHORT   ResidentFonts;

/**********************************************************************/
/* Under palette manager the default device palette is 256 entries    */
/* (the default 8514 palette). As HW palette slots are allocated to   */
/* palett manager logical palettes the device default palette is      */
/* reduced in size in stages of 128, 64, 32, and down to a minimum    */
/* size of 16 entries.  The result of mixes is not "what is expected" */
/* in most cases, with the exception that inverses always come out as */
/* the expected color.  These palettes are defined here in the        */
/* following arrays of RGB2 values (actually we use ULONGs to make    */
/* initialization easier).  Note that the fcOptions field is set to   */
/* PC_DEFAULT (0x80).  At 4 bits per pel the default palette is the   */
/* Reduced16DeviceDefaultPalette.                                     */
/*                                                                    */
/* If any of the palettes below are changed then the following        */
/* functions must also be changed:                                    */
/*      ExactLogicalIndexFromRGB                                      */
/**********************************************************************/

/**********************************************************************/
/* The 16 entry palette is the same as the default VGA palette.       */
/**********************************************************************/
ULONG Reduced16DeviceDefaultPalette[16] = {
        XGA_BLACK,
        XGA_DARK_BLUE,
        XGA_DARK_GREEN,
        XGA_DARK_CYAN,
        XGA_DARK_RED,
        XGA_PURPLE,
        XGA_MUSTARD,
        XGA_GRAY,
        XGA_LIGHT_GRAY,
        XGA_BLUE,
        XGA_GREEN,
        XGA_CYAN,
        XGA_RED,
        XGA_MAGENTA,
        XGA_YELLOW,
        XGA_WHITE
    };

/**********************************************************************/
/* The 256 entry palette is the same as the default 8514 palette.     */
/*                                                                    */
/* The structure is as follows:                                       */
/*                                                                    */
/* The middle 32 entries form an increasing grey scale.               */
/* The colours are the entries 0-111 and 144-255.                     */
/* The order of the colour entries is:                                */
/*     for each Red value in the group       00,2B,55,80,AA,D5,FF     */
/*       for each Green value in the group   00,24,49,6D,92,B6,DB,FF  */
/*         for each Blue value in the group  00,55,AA,FF              */
/*           RGB is Red,Green,Blue                                    */
/*         endfor                                                     */
/*       endfor                                                       */
/*     endfor                                                         */
/*                                                                    */
/* 8514 Notes                                                         */
/* ----------                                                         */
/* Since the 8514 doesn't adjust the 256 color to make it ISO         */
/* compliant, we adjust it here manually.  This cause the 8514/S3     */
/* palette to match the end result of the "fudged" XGA palette.       */
/* Specifically, the 0x80CCCCCC value eliminate the need to dither    */
/* greys all over the place, i.e. system notebooks.                   */
/*                                                                    */
/* Rich Wooley, Binar Graphics                                        */
/**********************************************************************/
ULONG FullSizeDeviceDefaultPalette[256] = {
        /**************************************************************/
        /* start off with the first half of the colors                */
        /**************************************************************/
        0x80000000, 0x80000055, 0x800000AA, 0x800000FF,
        0x80002400, 0x80002455, 0x800024AA, 0x800024FF,
        0x80004900, 0x80004955, 0x800049AA, 0x800049FF,
        0x80006D00, 0x80006D55, 0x80006DAA, 0x80006DFF,
        0x80009200, 0x80009255, 0x800092AA, 0x800092FF,
        0x8000B600, 0x8000B655, 0x8000B6AA, 0x8000B6FF,
        0x8000DB00, 0x8000DB55, 0x8000DBAA, 0x8000DBFF,
        0x8000FF00, 0x8000FF55, 0x8000FFAA, 0x8000FFFF,

        0x802B0000, 0x802B0055, 0x802B00AA, 0x802B00FF,
        0x802B2400, 0x802B2455, 0x802B24AA, 0x802B24FF,
        0x802B4900, 0x802B4955, 0x802B49AA, 0x802B49FF,
        0x802B6D00, 0x802B6D55, 0x802B6DAA, 0x802B6DFF,
        0x802B9200, 0x802B9255, 0x802B92AA, 0x802B92FF,
        0x802BB600, 0x802BB655, 0x802BB6AA, 0x802BB6FF,
        0x802BDB00, 0x802BDB55, 0x802BDBAA, 0x802BDBFF,
        0x802BFF00, 0x802BFF55, 0x802BFFAA, 0x802BFFFF,

        0x80550000, 0x80550055, 0x805500AA, 0x805500FF,
        0x80552400, 0x80552455, 0x805524AA, 0x805524FF,
        0x80554900, 0x80554955, 0x805549AA, 0x805549FF,
        0x80556D00, 0x80556D55, 0x80556DAA, 0x80556DFF,
        0x80559200, 0x80559255, 0x805592AA, 0x805592FF,
        0x8055B600, 0x8055B655, 0x8055B6AA, 0x8055B6FF,
        0x8055DB00, 0x8055DB55, 0x8055DBAA, 0x8055DBFF,
        0x8055FF00, 0x8055FF55, 0x8055FFAA, 0x8055FFFF,

#ifdef XGA
        0x80800000, 0x80800055, 0x808000AA, 0x808000FF,
#else
        0x80800000, 0x80800055, 0x80800080, 0x808000FF,
#endif
        0x80802400, 0x80802455, 0x808024AA, 0x808024FF,
        0x80804900, 0x80804955, 0x808049AA, 0x808049FF,
        0x80806D00, 0x80806D55, 0x80806DAA, 0x80806DFF,

        /**************************************************************/
        /* now come the group of 32 greys                             */
        /**************************************************************/
        0x80080808, 0x800F0F0F, 0x80171717, 0x801F1F1F,
        0x80272727, 0x802E2E2E, 0x80363636, 0x803E3E3E,
        0x80464646, 0x804D4D4D, 0x80555555, 0x805D5D5D,
        0x80646464, 0x806C6C6C, 0x80747474, 0x807C7C7C,
        0x80838383, 0x808B8B8B, 0x80939393, 0x809B9B9B,
        0x80A2A2A2, 0x80AAAAAA, 0x80B2B2B2, 0x80B9B9B9,
#ifdef XGA
        0x80C1C1C1, 0x80C9C9C9, 0x80D1D1D1, 0x80D8D8D8,
#else
        0x80C1C1C1, 0x80CCCCCC, 0x80D1D1D1, 0x80D8D8D8,
#endif
        0x80E0E0E0, 0x80E8E8E8, 0x80F0F0F0, 0x80F7F7F7,

        /**************************************************************/
        /* now back to the colours again                              */
        /**************************************************************/
#ifdef XGA
        0x80809200, 0x80809255, 0x808092AA, 0x808092FF,
#else
        0x80808000, 0x80809255, 0x808092AA, 0x808092FF,
#endif
        0x8080B600, 0x8080B655, 0x8080B6AA, 0x8080B6FF,
        0x8080DB00, 0x8080DB55, 0x8080DBAA, 0x8080DBFF,
        0x8080FF00, 0x8080FF55, 0x8080FFAA, 0x8080FFFF,

        0x80AA0000, 0x80AA0055, 0x80AA00AA, 0x80AA00FF,
        0x80AA2400, 0x80AA2455, 0x80AA24AA, 0x80AA24FF,
        0x80AA4900, 0x80AA4955, 0x80AA49AA, 0x80AA49FF,
        0x80AA6D00, 0x80AA6D55, 0x80AA6DAA, 0x80AA6DFF,
        0x80AA9200, 0x80AA9255, 0x80AA92AA, 0x80AA92FF,
        0x80AAB600, 0x80AAB655, 0x80AAB6AA, 0x80AAB6FF,
        0x80AADB00, 0x80AADB55, 0x80AADBAA, 0x80AADBFF,
        0x80AAFF00, 0x80AAFF55, 0x80AAFFAA, 0x80AAFFFF,

        0x80D50000, 0x80D50055, 0x80D500AA, 0x80D500FF,
        0x80D52400, 0x80D52455, 0x80D524AA, 0x80D524FF,
        0x80D54900, 0x80D54955, 0x80D549AA, 0x80D549FF,
        0x80D56D00, 0x80D56D55, 0x80D56DAA, 0x80D56DFF,
        0x80D59200, 0x80D59255, 0x80D592AA, 0x80D592FF,
        0x80D5B600, 0x80D5B655, 0x80D5B6AA, 0x80D5B6FF,
        0x80D5DB00, 0x80D5DB55, 0x80D5DBAA, 0x80D5DBFF,
        0x80D5FF00, 0x80D5FF55, 0x80D5FFAA, 0x80D5FFFF,

        0x80FF0000, 0x80FF0055, 0x80FF00AA, 0x80FF00FF,
        0x80FF2400, 0x80FF2455, 0x80FF24AA, 0x80FF24FF,
        0x80FF4900, 0x80FF4955, 0x80FF49AA, 0x80FF49FF,
        0x80FF6D00, 0x80FF6D55, 0x80FF6DAA, 0x80FF6DFF,
        0x80FF9200, 0x80FF9255, 0x80FF92AA, 0x80FF92FF,
        0x80FFB600, 0x80FFB655, 0x80FFB6AA, 0x80FFB6FF,
        0x80FFDB00, 0x80FFDB55, 0x80FFDBAA, 0x80FFDBFF,
        0x80FFFF00, 0x80FFFF55, 0x80FFFFAA, 0x80FFFFFF

    };

/**********************************************************************/
/* The 128 entry palette has the following structure:                 */
/*                                                                    */
/* The middle 8 entries form an increasing grey scale.                */
/* The colours are the entries 0-59 and 68-127.                       */
/* The order of the colour entries is:                                */
/*     for each Red value in the group       00,40,80,C0,FF           */
/*       for each Green value in the group   00,33,66,99,CC,FF        */
/*         for each Blue value in the group  00,55,AA,FF              */
/*           RGB is Red,Green,Blue                                    */
/*         endfor                                                     */
/*       endfor                                                       */
/*     endfor                                                         */
/*                                                                    */
/**********************************************************************/
ULONG Reduced128DeviceDefaultPalette[128] = {
        /**************************************************************/
        /* start off with the first half of the colors                */
        /**************************************************************/
        0x80000000, 0x80000055, 0x800000AA, 0x800000FF,
        0x80003300, 0x80003355, 0x800033AA, 0x800033FF,
        0x80006600, 0x80006655, 0x800066AA, 0x800066FF,
        0x80009900, 0x80009955, 0x800099AA, 0x800099FF,
        0x8000CC00, 0x8000CC55, 0x8000CCAA, 0x8000CCFF,
        0x8000FF00, 0x8000FF55, 0x8000FFAA, 0x8000FFFF,

        0x80400000, 0x80400055, 0x804000AA, 0x804000FF,
        0x80403300, 0x80403355, 0x804033AA, 0x804033FF,
        0x80406600, 0x80406655, 0x804066AA, 0x804066FF,
        0x80409900, 0x80409955, 0x804099AA, 0x804099FF,
        0x8040CC00, 0x8040CC55, 0x8040CCAA, 0x8040CCFF,
        0x8040FF00, 0x8040FF55, 0x8040FFAA, 0x8040FFFF,

        0x80800000, 0x80800055, 0x808000AA, 0x808000FF,
        0x80803300, 0x80803355, 0x808033AA, 0x808033FF,
        0x80806600, 0x80806655, 0x808066AA, 0x808066FF,

        /**************************************************************/
        /* now the 8 gray scales                                      */
        /**************************************************************/
        0x801C1C1C, 0x80383838, 0x80545454, 0x80707070,
        0x808C8C8C, 0x80A8A8A8, 0x80C4C4C4, 0x80E0E0E0,

        /**************************************************************/
        /* now the last half of the colors                            */
        /**************************************************************/
        0x80809900, 0x80809955, 0x808099AA, 0x808099FF,
        0x8080CC00, 0x8080CC55, 0x8080CCAA, 0x8080CCFF,
        0x8080FF00, 0x8080FF55, 0x8080FFAA, 0x8080FFFF,

        0x80C00000, 0x80C00055, 0x80C000AA, 0x80C000FF,
        0x80C03300, 0x80C03355, 0x80C033AA, 0x80C033FF,
        0x80C06600, 0x80C06655, 0x80C066AA, 0x80C066FF,
        0x80C09900, 0x80C09955, 0x80C099AA, 0x80C099FF,
        0x80C0CC00, 0x80C0CC55, 0x80C0CCAA, 0x80C0CCFF,
        0x80C0FF00, 0x80C0FF55, 0x80C0FFAA, 0x80C0FFFF,

        0x80FF0000, 0x80FF0055, 0x80FF00AA, 0x80FF00FF,
        0x80FF3300, 0x80FF3355, 0x80FF33AA, 0x80FF33FF,
        0x80FF6600, 0x80FF6655, 0x80FF66AA, 0x80FF66FF,
        0x80FF9900, 0x80FF9955, 0x80FF99AA, 0x80FF99FF,
        0x80FFCC00, 0x80FFCC55, 0x80FFCCAA, 0x80FFCCFF,
        0x80FFFF00, 0x80FFFF55, 0x80FFFFAA, 0x80FFFFFF
    };

/**********************************************************************/
/* The 64 entry palette has the following structure:                  */
/*                                                                    */
/* The middle 4 entries form an increasing grey scale.                */
/* The colours are the entries 0-29 and 34-63.                        */
/* The order of the colour entries is:                                */
/*     for each Red value in the group       00,55,AA,FF              */
/*       for each Green value in the group   00,40,80,C0,FF           */
/*         for each Blue value in the group  00,80,FF                 */
/*           RGB is Red,Green,Blue                                    */
/*         endfor                                                     */
/*       endfor                                                       */
/*     endfor                                                         */
/*                                                                    */
/**********************************************************************/
ULONG Reduced64DeviceDefaultPalette[64] = {
        /**************************************************************/
        /* start off with the first half of the colors                */
        /**************************************************************/
        0x80000000, 0x80000080, 0x800000FF,
        0x80004000, 0x80004080, 0x800040FF,
        0x80008000, 0x80008080, 0x800080FF,
        0x8000C000, 0x8000C080, 0x8000C0FF,
        0x8000FF00, 0x8000FF80, 0x8000FFFF,

        0x80550000, 0x80550080, 0x805500FF,
        0x80554000, 0x80554080, 0x805540FF,
        0x80558000, 0x80558080, 0x805580FF,
        0x8055C000, 0x8055C080, 0x8055C0FF,
        0x8055FF00, 0x8055FF80, 0x8055FFFF,

        /**************************************************************/
        /* now the 4 gray scales (these are the same as 4 of the      */
        /* grays in the 32 entry palette).                            */
        /**************************************************************/
        0x80555555, 0x80808080, 0x80A6A6A6, 0x80CCCCCC,

        /**************************************************************/
        /* now the last half of the colors                            */
        /**************************************************************/
        0x80AA0000, 0x80AA0080, 0x80AA00FF,
        0x80AA4000, 0x80AA4080, 0x80AA40FF,
        0x80AA8000, 0x80AA8080, 0x80AA80FF,
        0x80AAC000, 0x80AAC080, 0x80AAC0FF,
        0x80AAFF00, 0x80AAFF80, 0x80AAFFFF,

        0x80FF0000, 0x80FF0080, 0x80FF00FF,
        0x80FF4000, 0x80FF4080, 0x80FF40FF,
        0x80FF8000, 0x80FF8080, 0x80FF80FF,
        0x80FFC000, 0x80FFC080, 0x80FFC0FF,
        0x80FFFF00, 0x80FFFF80, 0x80FFFFFF
    };

/**********************************************************************/
/* The 32 entry palette is the is similar to the default VGA palette  */
/* in terms of its structure in that it is based around RxGxBxLevel.  */
/* The default VGA palette (16 entries) is 2x2x2x2. Here we will use  */
/* a 2x2x2x4 structure. Because the all the entires of the 16 entry   */
/* palette are incorporated into this palette then the change from    */
/* one to the other should be less horrible! The greys chosen here    */
/* are designed to fit in with the ones in the 16 entry palette (and  */
/* are the same ones also used in the 64 entry palette).              */
/**********************************************************************/
ULONG Reduced32DeviceDefaultPalette[32] = {
        0x80000000,     /* black           0 */

        0x80000040,     /* very dark blue  1 */
        0x80004000,     /* very dark green   */
        0x80004040,     /* very dark cyan    */
        0x80400000,     /* very dark red     */
        0x80400040,     /* very dark magenta */
        0x80404000,     /* very dark yellow  */

        0x80000080,     /* dark blue       7 */
        0x80008000,     /* dark green        */
        0x80008080,     /* dark cyan         */
        0x80800000,     /* dark red          */
        0x80800080,     /* dark magenta      */
        0x80808000,     /* dark yellow       */

        0x802B2B2B,     /* very dark gray 13 */
        0x80555555,     /* dark gray         */
        0x80808080,     /* gray              */
        0x80A6A6A6,     /* quite light gray  */
        0x80CCCCCC,     /* light gray        */
        0x80E0E0E0,     /* very light gray   */

        0x800000C0,     /* light blue     19 */
        0x8000C000,     /* light green       */
        0x8000C0C0,     /* light cyan        */
        0x80C00000,     /* light red         */
        0x80C000C0,     /* light magenta     */
        0x80C0C000,     /* light yellow      */

        0x800000FF,     /* blue           25 */
        0x8000FF00,     /* green             */
        0x8000FFFF,     /* cyan              */
        0x80FF0000,     /* red               */
        0x80FF00FF,     /* magenta           */
        0x80FFFF00,     /* yellow            */

        0x80FFFFFF,     /* white          31 */
    };

/**********************************************************************/
/* The following point to the device default palettes that will be    */
/* used by OD_DIRECT and OD_MEMORY device contexts respectively.  The */
/* one for OD_MEMORY is initialized at start of day and should not    */
/* change.  The OD_DIRECT will also be initialized at start of day    */
/* but will change as the device default palette is resized when HW   */
/* slots are allocated to palette manager palettes. The size of the   */
/* current direct dc device default palette is stored in              */
/* ulDirectDeviceDefaultPalette.                                      */
/**********************************************************************/
PRGB2           MemoryDeviceDefaultPalette;
PRGB2           DirectDeviceDefaultPalette;
ULONG           ulDirectDeviceDefaultPaletteSize;

#ifdef PDP
/**********************************************************************/
/* plasma panel status (set during FillPdb                            */
/**********************************************************************/
BOOL    plasma_status = 0;
#endif /* PDP */

/**********************************************************************/
/* The following tables conatin the RGB values of the default logical */
/* color tables - these are always the same, but the indexes into the */
/* palette differ depending on the bits per pel and the size of the   */
/* current device default palette.  For OD_MEMORY devices we will     */
/* always use the full size device default palette.  For OD_DIRECT    */
/* the size of the palette may change at eight bits per pel as HW     */
/* palette slots are allocated to palette manager palettes.  (This is */
/* why there are the 5 different versions of the eight bit per pel    */
/* logical color table each of which corresponds to one of the        */
/* palettes defined above).                                           */
/**********************************************************************/
COLORTABLETYPE  DefaultEightBppTable16[DFLT_LOG_COL_TABLE_SIZE] =
    {
        /*  blue  green red  flags */
        { { 0xFF, 0xFF, 0xFF, 0 } , 255L } , /* Background   */
        { { 0xFF, 0x00, 0x00, 0 } , 249L } , /* Blue         */
        { { 0x00, 0x00, 0xFF, 0 } , 252L } , /* Red          */
        { { 0xFF, 0x00, 0xFF, 0 } , 253L } , /* Magenta      */
        { { 0x00, 0xFF, 0x00, 0 } , 250L } , /* Green        */
        { { 0xFF, 0xFF, 0x00, 0 } , 251L } , /* Cyan         */
        { { 0x00, 0xFF, 0xFF, 0 } , 254L } , /* Yellow       */
        { { 0x00, 0x00, 0x00, 0 } ,   0L } , /* Neutral      */
        { { 0x80, 0x80, 0x80, 0 } ,   7L } , /* Dark grey    */
        { { 0x80, 0x00, 0x00, 0 } ,   1L } , /* Dark blue    */
        { { 0x00, 0x00, 0x80, 0 } ,   4L } , /* Dark red     */
        { { 0x80, 0x00, 0x80, 0 } ,   5L } , /* Dark magenta */
        { { 0x00, 0x80, 0x00, 0 } ,   2L } , /* Dark green   */
        { { 0x80, 0x80, 0x00, 0 } ,   3L } , /* Dark cyan    */
        { { 0x00, 0x80, 0x80, 0 } ,   6L } , /* Brown        */
        { { 0xCC, 0xCC, 0xCC, 0 } , 248L }   /* Light grey   */
    };

COLORTABLETYPE  DefaultEightBppTable32[DFLT_LOG_COL_TABLE_SIZE] =
    {
        /*  blue  green red  flags */
        { { 0xFF, 0xFF, 0xFF, 0 } , 255L } , /* Background   */
        { { 0xFF, 0x00, 0x00, 0 } , 249L } , /* Blue         */
        { { 0x00, 0x00, 0xFF, 0 } , 252L } , /* Red          */
        { { 0xFF, 0x00, 0xFF, 0 } , 253L } , /* Magenta      */
        { { 0x00, 0xFF, 0x00, 0 } , 250L } , /* Green        */
        { { 0xFF, 0xFF, 0x00, 0 } , 251L } , /* Cyan         */
        { { 0x00, 0xFF, 0xFF, 0 } , 254L } , /* Yellow       */
        { { 0x00, 0x00, 0x00, 0 } ,   0L } , /* Neutral      */
        { { 0x80, 0x80, 0x80, 0 } ,  14L } , /* Dark grey    */
        { { 0x80, 0x00, 0x00, 0 } ,   7L } , /* Dark blue    */
        { { 0x00, 0x00, 0x80, 0 } ,  10L } , /* Dark red     */
        { { 0x80, 0x00, 0x80, 0 } ,  11L } , /* Dark magenta */
        { { 0x00, 0x80, 0x00, 0 } ,   8L } , /* Dark green   */
        { { 0x80, 0x80, 0x00, 0 } ,   9L } , /* Dark cyan    */
        { { 0x00, 0x80, 0x80, 0 } ,  12L } , /* Brown        */
        { { 0xCC, 0xCC, 0xCC, 0 } , 241L }   /* Light grey   */
    };

COLORTABLETYPE  DefaultEightBppTable64[DFLT_LOG_COL_TABLE_SIZE] =
    {
        /*  blue  green red  flags */
        { { 0xFF, 0xFF, 0xFF, 0 } , 255L } , /* Background   */
        { { 0xFF, 0x00, 0x00, 0 } ,   2L } , /* Blue         */
        { { 0x00, 0x00, 0xFF, 0 } , 242L } , /* Red          */
        { { 0xFF, 0x00, 0xFF, 0 } , 244L } , /* Magenta      */
        { { 0x00, 0xFF, 0x00, 0 } ,  12L } , /* Green        */
        { { 0xFF, 0xFF, 0x00, 0 } ,  14L } , /* Cyan         */
        { { 0x00, 0xFF, 0xFF, 0 } , 253L } , /* Yellow       */
        { { 0x00, 0x00, 0x00, 0 } ,   0L } , /* Neutral      */
        { { 0x80, 0x80, 0x80, 0 } ,  31L } , /* Dark grey    */
        { { 0x80, 0x00, 0x00, 0 } ,   1L } , /* Dark blue    */
        { { 0x00, 0x00, 0x80, 0 } , 226L } , /* Dark red     */
        { { 0x80, 0x00, 0x80, 0 } , 227L } , /* Dark magenta */
        { { 0x00, 0x80, 0x00, 0 } ,   6L } , /* Dark green   */
        { { 0x80, 0x80, 0x00, 0 } ,   7L } , /* Dark cyan    */
        { { 0x00, 0x80, 0x80, 0 } , 232L } , /* Brown        */
        { { 0xCC, 0xCC, 0xCC, 0 } , 225L }   /* Light grey   */
    };

COLORTABLETYPE  DefaultEightBppTable128[DFLT_LOG_COL_TABLE_SIZE] =
    {
        /*  blue  green red  flags */
        { { 0xFF, 0xFF, 0xFF, 0 } , 255L } , /* Background   */
        { { 0xFF, 0x00, 0x00, 0 } ,   3L } , /* Blue         */
        { { 0x00, 0x00, 0xFF, 0 } , 232L } , /* Red          */
        { { 0xFF, 0x00, 0xFF, 0 } , 235L } , /* Magenta      */
        { { 0x00, 0xFF, 0x00, 0 } ,  20L } , /* Green        */
        { { 0xFF, 0xFF, 0x00, 0 } ,  23L } , /* Cyan         */
        { { 0x00, 0xFF, 0xFF, 0 } , 252L } , /* Yellow       */
        { { 0x00, 0x00, 0x00, 0 } ,   0L } , /* Neutral      */
        { { 0x80, 0x80, 0x80, 0 } ,  64L } , /* Dark grey    */
        { { 0x80, 0x00, 0x00, 0 } ,   2L } , /* Dark blue    */
        { { 0x00, 0x00, 0x80, 0 } ,  48L } , /* Dark red     */
        { { 0x80, 0x00, 0x80, 0 } ,  50L } , /* Dark magenta */
        { { 0x00, 0x80, 0x00, 0 } ,  12L } , /* Dark green   */
        { { 0x80, 0x80, 0x00, 0 } ,  14L } , /* Dark cyan    */
        { { 0x00, 0x80, 0x80, 0 } , 196L } , /* Brown        */
        { { 0xCC, 0xCC, 0xCC, 0 } ,  66L }   /* Light grey   */
    };

COLORTABLETYPE  DefaultEightBppTable256[DFLT_LOG_COL_TABLE_SIZE] =
    {
        /*  blue  green red  flags */
        { { 0xFF, 0xFF, 0xFF, 0 } , 255L } , /* Background   */
        { { 0xFF, 0x00, 0x00, 0 } ,   3L } , /* Blue         */
        { { 0x00, 0x00, 0xFF, 0 } , 224L } , /* Red          */
        { { 0xFF, 0x00, 0xFF, 0 } , 227L } , /* Magenta      */
        { { 0x00, 0xFF, 0x00, 0 } ,  28L } , /* Green        */
        { { 0xFF, 0xFF, 0x00, 0 } ,  31L } , /* Cyan         */
        { { 0x00, 0xFF, 0xFF, 0 } , 252L } , /* Yellow       */
        { { 0x00, 0x00, 0x00, 0 } ,   0L } , /* Neutral      */
        { { 0x83, 0x83, 0x83, 0 } , 128L } , /* Dark grey    */
        { { 0xAA, 0x00, 0x00, 0 } ,   2L } , /* Dark blue    */
        { { 0x00, 0x00, 0x80, 0 } ,  96L } , /* Dark red     */
        { { 0xAA, 0x00, 0x80, 0 } ,  98L } , /* Dark magenta */
        { { 0x00, 0x92, 0x00, 0 } ,  16L } , /* Dark green   */
        { { 0xAA, 0x92, 0x00, 0 } ,  18L } , /* Dark cyan    */
        { { 0x00, 0x92, 0x80, 0 } , 144L } , /* Brown        */
        { { 0xC9, 0xC9, 0xC9, 0 } , 138L }   /* Light grey   */
    };

COLORTABLETYPE  DefaultFourBppTable[DFLT_LOG_COL_TABLE_SIZE] =
    {
        /*  blue  green red  flags */
        { { 0xFF, 0xFF, 0xFF, 0 } ,  15L } , /* Background   */
        { { 0xFF, 0x00, 0x00, 0 } ,   9L } , /* Blue         */
        { { 0x00, 0x00, 0xFF, 0 } ,  12L } , /* Red          */
        { { 0xFF, 0x00, 0xFF, 0 } ,  13L } , /* Magenta      */
        { { 0x00, 0xFF, 0x00, 0 } ,  10L } , /* Green        */
        { { 0xFF, 0xFF, 0x00, 0 } ,  11L } , /* Cyan         */
        { { 0x00, 0xFF, 0xFF, 0 } ,  14L } , /* Yellow       */
        { { 0x00, 0x00, 0x00, 0 } ,   0L } , /* Neutral      */
        { { 0x80, 0x80, 0x80, 0 } ,   7L } , /* Dark grey    */
        { { 0x80, 0x00, 0x00, 0 } ,   1L } , /* Dark blue    */
        { { 0x00, 0x00, 0x80, 0 } ,   4L } , /* Dark red     */
        { { 0x80, 0x00, 0x80, 0 } ,   5L } , /* Dark magenta */
        { { 0x00, 0x80, 0x00, 0 } ,   2L } , /* Dark green   */
        { { 0x80, 0x80, 0x00, 0 } ,   3L } , /* Dark cyan    */
        { { 0x00, 0x80, 0x80, 0 } ,   6L } , /* Brown        */
        { { 0xCC, 0xCC, 0xCC, 0 } ,   8L }   /* Light grey   */
    };

COLORTABLETYPE  DefaultSixteenBppTable[DFLT_LOG_COL_TABLE_SIZE] =
    {
        /*  blue  green red  flags */
        { { 0xFF, 0xFF, 0xFF, 0 } , 0x0000FFFF  } , /* Background   */
        { { 0xFF, 0x00, 0x00, 0 } , 0x0000001F  } , /* Blue         */
        { { 0x00, 0x00, 0xFF, 0 } , 0x0000F800  } , /* Red          */
        { { 0xFF, 0x00, 0xFF, 0 } , 0x0000F81F  } , /* Magenta      */
        { { 0x00, 0xFF, 0x00, 0 } , 0x000007E0  } , /* Green        */
        { { 0xFF, 0xFF, 0x00, 0 } , 0x000007FF  } , /* Cyan         */
        { { 0x00, 0xFF, 0xFF, 0 } , 0x0000FFE0  } , /* Yellow       */
        { { 0x00, 0x00, 0x00, 0 } , 0x00000000  } , /* Neutral      */
        { { 0x80, 0x80, 0x80, 0 } , 0x00008410  } , /* Dark grey    */
        { { 0x80, 0x00, 0x00, 0 } , 0x00000010  } , /* Dark blue    */
        { { 0x00, 0x00, 0x80, 0 } , 0x00008000  } , /* Dark red     */
        { { 0x80, 0x00, 0x80, 0 } , 0x00008010  } , /* Dark magenta */
        { { 0x00, 0x80, 0x00, 0 } , 0x00000400  } , /* Dark green   */
        { { 0x80, 0x80, 0x00, 0 } , 0x00000410  } , /* Dark cyan    */
        { { 0x00, 0x80, 0x80, 0 } , 0x00008400  } , /* Brown        */
        { { 0xCC, 0xCC, 0xCC, 0 } , 0x0000CE79  }   /* Light grey   */
    };

/**********************************************************************/
/* The following point to the default color tables that will be used  */
/* by OD_DIRECT and OD_MEMORY device contexts respectively. The       */
/* one for OD_MEMORY is initialized at start of day and should not    */
/* change. The OD_DIRECT will also be initialized at start of day but */
/* will change as the device default palette is resized when HW slots */
/* are allocated to palette manager palettes.                         */
/**********************************************************************/
PCOLORTABLE     DefaultDirectLogicalColorTable;
PCOLORTABLE     DefaultMemoryLogicalColorTable;

/**********************************************************************/
/* The special colors table contains the RGB and physical indices for */
/* negative logical indices - ie both special colors and system       */
/* colors. There are two versions of the table (one for memory DCs    */
/* and one for direct DCs) because the screen may have a different    */
/* device default palette than memory DCs (because of HW slots being  */
/* allocated to palette manager palettes).                            */
/* The entry in the table x is for logical color (-x).                */
/**********************************************************************/
COLORTABLETYPE  DirectSpecialColorTable[SPECIAL_COL_TAB_SIZE] =
    {
        /*  blue  green red  flags */
        { { 0x00, 0x00, 0x00, 0 } , CLR_NOPHYINDEX } , /* zeroth entry */
        { { 0x00, 0x00, 0x00, 0 } , 0              } , /* CLR_BLACK    */
        { { 0xFF, 0xFF, 0xFF, 0 } , 255            } , /* CLR_WHITE    */
        { { 0x00, 0x00, 0x00, 0 } , CLR_NOPHYINDEX } , /* CLR_DEFAULT  */
        { { 0xFF, 0xFF, 0xFF, 0 } , 255            } , /* CLR_TRUE     */
        { { 0x00, 0x00, 0x00, 0 } , 0              } , /* CLR_FALSE    */
        { { 0x00, 0x00, 0x00, 0 } , CLR_NOPHYINDEX } , /* (-6) invalid */
        { { 0x00, 0x00, 0x00, 0 } , CLR_NOPHYINDEX } , /* (-7) invalid */
        { { 0x00, 0x00, 0x00, 0 } , CLR_NOPHYINDEX } , /* (-8) invalid */
        { { 0x00, 0x00, 0x00, 0 } , CLR_NOPHYINDEX } , /* (-9) invalid */

        /* the remaining entries are set using CreateLogColorTable by PM */
    };

COLORTABLETYPE  MemorySpecialColorTable[SPECIAL_COL_TAB_SIZE] =
    {
        /*  blue  green red  flags */
        { { 0x00, 0x00, 0x00, 0 } , CLR_NOPHYINDEX } , /* zeroth entry */
        { { 0x00, 0x00, 0x00, 0 } , 0              } , /* CLR_BLACK    */
        { { 0xFF, 0xFF, 0xFF, 0 } , 255            } , /* CLR_WHITE    */
        { { 0x00, 0x00, 0x00, 0 } , CLR_NOPHYINDEX } , /* CLR_DEFAULT  */
        { { 0xFF, 0xFF, 0xFF, 0 } , 255            } , /* CLR_TRUE     */
        { { 0x00, 0x00, 0x00, 0 } , 0              } , /* CLR_FALSE    */
        { { 0x00, 0x00, 0x00, 0 } , CLR_NOPHYINDEX } , /* (-6) invalid */
        { { 0x00, 0x00, 0x00, 0 } , CLR_NOPHYINDEX } , /* (-7) invalid */
        { { 0x00, 0x00, 0x00, 0 } , CLR_NOPHYINDEX } , /* (-8) invalid */
        { { 0x00, 0x00, 0x00, 0 } , CLR_NOPHYINDEX } , /* (-9) invalid */

        /* the remaining entries are set using CreateLogColorTable by PM */
    };

/**********************************************************************/
/* Global constants used by the color functions.  cPhysicalColors is  */
/* always the same as SizeOfHWPalette except at 16bpp when            */
/* SizeOfHWPalette is not set up.  MaxLogColorIndex is always 255.    */
/* This all seems a bit duff!                                         */
/**********************************************************************/
ULONG    cPhysicalColors;
USHORT   SizeOfHWPalette;
USHORT   MaxLogColorIndex;

/**********************************************************************/
/* The AVIO Color Table contains the RGB values of the default        */
/* AVIO palette used for both foreground and background colours.      */
/**********************************************************************/
RGB2  AVIOColorTable[AVIO_PALETTE_SIZE] =
{
       /* blue  green red   options */
        { 0x00, 0x00, 0x00, 0x00 },             /* Black              */
        { 0x80, 0x00, 0x00, 0x00 },             /* Dark blue          */
        { 0x00, 0x80, 0x00, 0x00 },             /* Dark green         */
        { 0x80, 0x80, 0x00, 0x00 },             /* Dark cyan          */
        { 0x00, 0x00, 0x80, 0x00 },             /* Dark red           */
        { 0x80, 0x00, 0x80, 0x00 },             /* Dark magenta       */
        { 0x00, 0x80, 0x80, 0x00 },             /* Brown              */
        { 0xCC, 0xCC, 0xCC, 0x00 },             /* Light grey         */
        { 0x80, 0x80, 0x80, 0x00 },             /* Dark grey          */
        { 0xFF, 0x00, 0x00, 0x00 },             /* Blue               */
        { 0x00, 0xFF, 0x00, 0x00 },             /* Green              */
        { 0xFF, 0xFF, 0x00, 0x00 },             /* Cyan               */
        { 0x00, 0x00, 0xFF, 0x00 },             /* Red                */
        { 0xFF, 0x00, 0xFF, 0x00 },             /* Magenta            */
        { 0x00, 0xFF, 0xFF, 0x00 },             /* Yellow             */
        { 0xFF, 0xFF, 0xFF, 0x00 }              /* White              */
};

/**********************************************************************/
/* AVIOXlate tables translate from the VIO colour to the physical     */
/* index.  This info is filled in at boot time for the 256 color      */
/* table, and as required for the other tables.  Setting the first    */
/* entry to CLR_NOPHYINDEX marks the table as not yet setup.          */
/**********************************************************************/
PULONG  pAVIOColorXlate;
ULONG   AVIOXlate256[AVIO_PALETTE_SIZE] = { CLR_NOPHYINDEX };
ULONG   AVIOXlate128[AVIO_PALETTE_SIZE] = { CLR_NOPHYINDEX };
ULONG   AVIOXlate64[AVIO_PALETTE_SIZE]  = { CLR_NOPHYINDEX };
ULONG   AVIOXlate32[AVIO_PALETTE_SIZE]  = { CLR_NOPHYINDEX };
ULONG   AVIOXlate16[AVIO_PALETTE_SIZE]  = { CLR_NOPHYINDEX };

/**********************************************************************/
/* Flag to say we support realization with the current configuration. */
/**********************************************************************/
BOOL    fRealizeSupported;

/**********************************************************************/
/* _acrtused is required in a Dynamic Link Library to nullify         */
/* automatic loading of C runtime support. It must be initialised     */
/* to 1 or 0.                                                         */
/* See OS/2 programming Guide Chapter 6.                              */
/**********************************************************************/
int             _acrtused = 1;

/**********************************************************************/
/* global variables used by DCRs for and screen modes                 */
/**********************************************************************/
USHORT                   VRAMK;
PBYTE                    FreeVRAM;

/**********************************************************************/
/* Variable to store the resource ID of the default system font       */
/**********************************************************************/
ULONG                   ulSysFontId;

/**********************************************************************/
/* Variable to store the default codepage (used by AVIO).             */
/**********************************************************************/
USHORT                  usDefaultCodePage;

/**********************************************************************/
/* OS/2 version number                                                */
/**********************************************************************/
USHORT                  usVersion;

/**********************************************************************/
/* Variable to turn system color dithering on or off                  */
/**********************************************************************/
BOOL                    SystemDithering = TRUE;

/**********************************************************************/
/* near copy of the dci data                                          */
/* Global PDC which is set by Enter Driver to be the PDC passed to    */
/* the driver - having this globally means that it never needs to be  */
/* passed as an explicit parameter to any other routine.              */
/**********************************************************************/
PDC     pdc;

#ifndef   _8514
// @DMS the 8514 code could probably use this know since it didnt exist when we
// did the conversion ... ours is in eddefldb.c !!!
/**********************************************************************/
/* Start of Software Motion Video changes.                            */
/**********************************************************************/
/**********************************************************************/
/* Table defining which ring each DDI function is called at. The      */
/* table contains a byte for each function, corresponding to its      */
/* function number which can take the following values                */
/*                                                                    */
/* HEX VALUE                                                          */
/*                                                                    */
/*  0x00    =    End of table.                                        */
/*  0x01    =    Ring 2 conforming                                    */
/*  0x10    =    Call at ring 2                                       */
/*  0x11    =    Call at ring 3                                       */
/**********************************************************************/
BYTE   pascal OS2_PM_DRV_RING_LEVELS[] = {
    1,                          /* 0x?000 */
    1,                          /* 0x?001 */
    1,                          /* 0x?002 */
    1,                          /* 0x?003 */
    1,                          /* 0x?004 */
    1,                          /* 0x?005 */
    1,                          /* 0x?006 */
    1,                          /* 0x?007 */
    1,                          /* 0x?008 */
    1,                          /* 0x?009 */
    1,                          /* 0x?00a */
    1,                          /* 0x?00b */
    1,                          /* 0x?00c */
    1,                          /* 0x?00d */
    1,                          /* 0x?00e */
    1,                          /* 0x?00f */
    1,                          /* 0x?010 */
    1,                          /* 0x?011 */
    1,                          /* 0x?012 */
    1,                          /* 0x?013 */
    1,                          /* 0x?014 */
    1,                          /* 0x?015 */
    1,                          /* 0x?016 */
    1,                          /* 0x?017 */
    1,                          /* 0x?018 */
    1,                          /* 0x?019 */
    1,                          /* 0x?01a */
    1,                          /* 0x?01b */
    1,                          /* 0x?01c */
    1,                          /* 0x?01d */
    1,                          /* 0x?01e */
    1,                          /* 0x?01f */
    1,                          /* 0x?020 */
    1,                          /* 0x?021 */
    1,                          /* 0x?022 */
    1,                          /* 0x?023 */
    1,                          /* 0x?024 */
    1,                          /* 0x?025 */
    1,                          /* 0x?026 BitBlt                      */
    1,                          /* 0x?027 */
    1,                          /* 0x?028 */
    1,                          /* 0x?029 */
    1,                          /* 0x?02a */
    1,                          /* 0x?02b */
    1,                          /* 0x?02c */
    1,                          /* 0x?02d */
    1,                          /* 0x?02e */
    1,                          /* 0x?02f */
    1,                          /* 0x?030 */
    1,                          /* 0x?031 */
    1,                          /* 0x?032 */
    1,                          /* 0x?033 */
    1,                          /* 0x?034 */
    1,                          /* 0x?035 */
    1,                          /* 0x?036 */
    1,                          /* 0x?037 */
    1,                          /* 0x?038 */
    1,                          /* 0x?039 */
    1,                          /* 0x?03a */
    1,                          /* 0x?03b */
    1,                          /* 0x?03c */
    1,                          /* 0x?03d */
    1,                          /* 0x?03e */
    1,                          /* 0x?03f */
    1,                          /* 0x?040 */
    1,                          /* 0x?041 */
    1,                          /* 0x?042 */
    1,                          /* 0x?043 */
    1,                          /* 0x?044 */
    1,                          /* 0x?045 */
    1,                          /* 0x?046 */
    1,                          /* 0x?047 */
    1,                          /* 0x?048 */
    1,                          /* 0x?049 */
    1,                          /* 0x?04a */
    1,                          /* 0x?04b */
    1,                          /* 0x?04c */
    1,                          /* 0x?04d */
    1,                          /* 0x?04e */
    1,                          /* 0x?04f */
    1,                          /* 0x?050 */
    1,                          /* 0x?051 */
    1,                          /* 0x?052 */
    1,                          /* 0x?053 */
    1,                          /* 0x?054 */
    1,                          /* 0x?055 */
    1,                          /* 0x?056 */
    1,                          /* 0x?057 */
    1,                          /* 0x?058 */
    1,                          /* 0x?059 */
    1,                          /* 0x?05a */
    1,                          /* 0x?05b */
    1,                          /* 0x?05c */
    1,                          /* 0x?05d */
    1,                          /* 0x?05e */
    1,                          /* 0x?05f */
    1,                          /* 0x?060 */
    1,                          /* 0x?061 */
    1,                          /* 0x?062 */
    1,                          /* 0x?063 */
    1,                          /* 0x?064 */
    1,                          /* 0x?065 */
    1,                          /* 0x?066 */
    1,                          /* 0x?067 */
    1,                          /* 0x?068 */
    1,                          /* 0x?069 */
    1,                          /* 0x?06a */
    1,                          /* 0x?06b */
    1,                          /* 0x?06c */
    1,                          /* 0x?06d */
    1,                          /* 0x?06e */
    1,                          /* 0x?06f */
    1,                          /* 0x?070 */
    1,                          /* 0x?071 */
    1,                          /* 0x?072 */
    1,                          /* 0x?073 */
    1,                          /* 0x?074 */
    1,                          /* 0x?075 */
    1,                          /* 0x?076 */
    1,                          /* 0x?077 */
    1,                          /* 0x?078 */
    1,                          /* 0x?079 */
    1,                          /* 0x?07a */
    1,                          /* 0x?07b */
    1,                          /* 0x?07c */
    1,                          /* 0x?07d */
    1,                          /* 0x?07e */
    1,                          /* 0x?07f */
    1,                          /* 0x?080 */
    1,                          /* 0x?081 */
    1,                          /* 0x?082 */
    1,                          /* 0x?083 */
    1,                          /* 0x?084 */
    1,                          /* 0x?085 */
    1,                          /* 0x?086 */
    1,                          /* 0x?087 */
    1,                          /* 0x?088 */
    1,                          /* 0x?089 */
    1,                          /* 0x?08a */
    1,                          /* 0x?08b */
    1,                          /* 0x?08c */
    1,                          /* 0x?08d */
    1,                          /* 0x?08e */
    1,                          /* 0x?08f */
    1,                          /* 0x?090 */
    1,                          /* 0x?091 */
    1,                          /* 0x?092 */
    1,                          /* 0x?093 */
    1,                          /* 0x?094 */
    1,                          /* 0x?095 */
    1,                          /* 0x?096 */
    1,                          /* 0x?097 */
    1,                          /* 0x?098 */
    1,                          /* 0x?099 */
    1,                          /* 0x?09a */
    1,                          /* 0x?09b */
    1,                          /* 0x?09c */
    1,                          /* 0x?09d */
    1,                          /* 0x?09e */
    1,                          /* 0x?09f */
    1,                          /* 0x?0a0 */
    1,                          /* 0x?0a1 */
    1,                          /* 0x?0a2 */
    1,                          /* 0x?0a3 */
    1,                          /* 0x?0a4 */
    1,                          /* 0x?0a5 */
    1,                          /* 0x?0a6 */
    1,                          /* 0x?0a7 */
    1,                          /* 0x?0a8 */
    1,                          /* 0x?0a9 */
    1,                          /* 0x?0aa */
    1,                          /* 0x?0ab */
    1,                          /* 0x?0ac */
    1,                          /* 0x?0ad */
    1,                          /* 0x?0ae */
    1,                          /* 0x?0af */
    1,                          /* 0x?0b0 */
    1,                          /* 0x?0b1 */
    1,                          /* 0x?0b2 */
    1,                          /* 0x?0b3 */
    1,                          /* 0x?0b4 */
    1,                          /* 0x?0b5 */
    1,                          /* 0x?0b6 */
    1,                          /* 0x?0b7 */
    1,                          /* 0x?0b8 */
    1,                          /* 0x?0b9 */
    1,                          /* 0x?0ba */
    1,                          /* 0x?0bb */
    1,                          /* 0x?0bc */
    1,                          /* 0x?0bd */
    1,                          /* 0x?0be */
    1,                          /* 0x?0bf */
    1,                          /* 0x?0c0 */
    1,                          /* 0x?0c1 */
    1,                          /* 0x?0c2 */
    1,                          /* 0x?0c3 */
    1,                          /* 0x?0c4 */
    1,                          /* 0x?0c5 */
    1,                          /* 0x?0c6 */
    1,                          /* 0x?0c7 */
    1,                          /* 0x?0c8 */
    1,                          /* 0x?0c9 */
    1,                          /* 0x?0ca */
    1,                          /* 0x?0cb */
    1,                          /* 0x?0cc */
    1,                          /* 0x?0cd */
    1,                          /* 0x?0ce */
    1,                          /* 0x?0cf */
    1,                          /* 0x?0d0 */
    1,                          /* 0x?0d1 QueryDeviceCaps             */
    2,                          /* 0x?0d2 DevEscape                   */
    0                           };

/**********************************************************************/
/* End of Software Motion Video changes.                              */
/**********************************************************************/
#endif
