/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/

/**********************************************************************/
/*                                                                    */
/*   Module File     = EDDCDATA                                       */
/*                                                                    */
/*   Description     = Display Device Driver data for color dithering */
/*                                                                    */
/*   Function        =                                                */
/*                                                                    */
/*   Reference       = Display Device Driver Design                   */
/*                                                                    */
/*                                                                    */
/**********************************************************************/
#define INCL_WINSYS

#include <eddinclt.h>
#include <eddccone.h>

BOOL    DitheredPattern = FALSE;
ULONG   LastRGBDithered = 0L;
ULONG   ColorPatPhysical;
ULONG   MonoPatPhysical;

BYTE    SolidImage[] = { 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF, 0xFF };

BOOL    fDitherInVRAM = FALSE;
BYTE    Colorpat[DITHMATRIX_XSIZE][DITHMATRIX_YSIZE];
BYTE    Monopat[MONODITH_XSIZE][MONODITH_YSIZE];

BYTE dithermatrix[2][2] = { { 10, 30 },
                            { 40, 20 } };

BYTE    mono_table[] = {
    0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  0 and 64 */

    0x80, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, /*  1 and 63 */
    0x80, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, /*  2 and 62 */
    0x88, 0x00, 0x00, 0x00, 0x08, 0x00, 0x00, 0x00, /*  3 and 61 */
    0x88, 0x00, 0x00, 0x00, 0x88, 0x00, 0x00, 0x00, /*  4 and 60 */
    0x88, 0x00, 0x20, 0x00, 0x88, 0x00, 0x00, 0x00, /*  5 and 59 */
    0x88, 0x00, 0x20, 0x00, 0x88, 0x00, 0x02, 0x00, /*  6 and 58 */
    0x88, 0x00, 0x22, 0x00, 0x88, 0x00, 0x02, 0x00, /*  7 and 57 */
    0x88, 0x00, 0x22, 0x00, 0x88, 0x00, 0x22, 0x00, /*  8 and 56 */

    0xa8, 0x00, 0x22, 0x00, 0x88, 0x00, 0x22, 0x00, /*  9 and 55 */
    0xa8, 0x00, 0x22, 0x00, 0x8a, 0x00, 0x22, 0x00, /* 10 and 54 */
    0xaa, 0x00, 0x22, 0x00, 0x8a, 0x00, 0x22, 0x00, /* 11 and 53 */
    0xaa, 0x00, 0x22, 0x00, 0xaa, 0x00, 0x22, 0x00, /* 12 and 52 */
    0xaa, 0x00, 0xa2, 0x00, 0xaa, 0x00, 0x22, 0x00, /* 13 and 51 */
    0xaa, 0x00, 0xa2, 0x00, 0xaa, 0x00, 0x2a, 0x00, /* 14 and 50 */
    0xaa, 0x00, 0xaa, 0x00, 0xaa, 0x00, 0x2a, 0x00, /* 15 and 49 */
    0xaa, 0x00, 0xaa, 0x00, 0xaa, 0x00, 0xaa, 0x00, /* 16 and 48 */

    0xaa, 0x40, 0xaa, 0x00, 0xaa, 0x00, 0xaa, 0x00, /* 17 and 47 */
    0xaa, 0x40, 0xaa, 0x00, 0xaa, 0x04, 0xaa, 0x00, /* 18 and 46 */
    0xaa, 0x44, 0xaa, 0x00, 0xaa, 0x04, 0xaa, 0x00, /* 19 and 45 */
    0xaa, 0x44, 0xaa, 0x00, 0xaa, 0x44, 0xaa, 0x00, /* 20 and 44 */
    0xaa, 0x44, 0xaa, 0x10, 0xaa, 0x44, 0xaa, 0x00, /* 21 and 43 */
    0xaa, 0x44, 0xaa, 0x10, 0xaa, 0x44, 0xaa, 0x01, /* 22 and 42 */
    0xaa, 0x44, 0xaa, 0x11, 0xaa, 0x44, 0xaa, 0x01, /* 23 and 41 */
    0xaa, 0x44, 0xaa, 0x11, 0xaa, 0x44, 0xaa, 0x11, /* 24 and 40 */

    0xaa, 0x54, 0xaa, 0x11, 0xaa, 0x44, 0xaa, 0x11, /* 25 and 39 */
    0xaa, 0x54, 0xaa, 0x11, 0xaa, 0x45, 0xaa, 0x11, /* 26 and 38 */
    0xaa, 0x55, 0xaa, 0x11, 0xaa, 0x45, 0xaa, 0x11, /* 27 and 37 */
    0xaa, 0x55, 0xaa, 0x11, 0xaa, 0x55, 0xaa, 0x11, /* 28 and 36 */
    0xaa, 0x55, 0xaa, 0x51, 0xaa, 0x55, 0xaa, 0x11, /* 29 and 35 */
    0xaa, 0x55, 0xaa, 0x51, 0xaa, 0x55, 0xaa, 0x15, /* 30 and 34 */
    0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x15, /* 31 and 33 */
    0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55, 0xaa, 0x55  /* 32 */
};

/**********************************************************************/
/* We need ready setup RGB2 values for black and white.               */
/**********************************************************************/
RGB2    RGBWhite = {0xff, 0xff, 0xff, 0};
RGB2    RGBBlack = {0x00, 0x00, 0x00, 0};

/**********************************************************************/
/* We must keep Palette Manager palettes, and Realizable Logical      */
/* Color Tables separate. The best way to ensure this is to have      */
/* them each write to their own version of what they think is the     */
/* hardware palette.  This works file if the RealizedLCTPalette is    */
/* only used when the app is full screen, foreground (which it        */
/* should be).                                                        */
/**********************************************************************/
RGB2    RealizedLCTPalette[HW_PAL_SIZE];

/**********************************************************************/
/* Globals used to speed up nearest color searches when we have a     */
/* realized logical color table.                                      */
/**********************************************************************/
ULONG   RealizedWhiteIndex;
ULONG   RealizedBlackIndex;
ULONG   ulLastSearched;
ULONG   ulIndexLastSearched;
