/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/

/**********************************************************************/
/*                                                                    */
/*   File            = EDDCCONE                                       */
/*                                                                    */
/*   Description     = Display Device Driver Color function constants */
/*                                                                    */
/*   Function        =                                                */
/*                                                                    */
/*   Reference       = Device Driver Interface Specification          */
/*                                                                    */
/*                                                                    */
/**********************************************************************/


/**********************************************************************/
/* Size of the default logical colour table                           */
/**********************************************************************/
#define  DFLT_LOG_COL_TABLE_SIZE    16

/**********************************************************************/
/* Extra option that can be passed to CreateLogicalColorTable to      */
/* change the system colors.                                          */
/**********************************************************************/
#define LCOL_SYSCOLORS         0x0010L

/**********************************************************************/
/* Possible color modes                                               */
/**********************************************************************/
#define RGB_MODE               0
#define INDEX_MODE             1

/**********************************************************************/
/* Physical indices are (currently) up to 16 bits.                    */
/* We always store them in a ULONG value in order to allow for other  */
/* special values, notably error values to be kept.                   */
/* These special values are defined below.                            */
/**********************************************************************/
#define CLR_NOPHYINDEX          0xFFFFFFFF
#define MODE_WAS_RGB            0xFFFFFFFE

/**********************************************************************/
/* Value that specifies an undefined entry in the PhyToLog table      */
/**********************************************************************/
#define NO_LOG_INDEX           0xffff

/**********************************************************************/
/* Define size of 8bpp dither matrix                                  */
/**********************************************************************/
#define DITHMATRIX_XSIZE  2
#define DITHMATRIX_YSIZE  2

/**********************************************************************/
/* Define size of mono dither                                         */
/**********************************************************************/
#define MONODITH_XSIZE  8
#define MONODITH_YSIZE  8

/**********************************************************************/
/* Define size of 4bpp dither matrix                                  */
/**********************************************************************/
#define DITHMATRIX4BPP_XSIZE  2
#define DITHMATRIX4BPP_YSIZE  2

/**********************************************************************/
/* Error codes that should really be defined in pmgpi.h               */
/**********************************************************************/
#define QRC_ERROR              (-1L)
#define QNC_ERROR              (-1L)
#define QCI_ERROR              (-1L)

/**********************************************************************/
/* Constant giving the size of the SpecialColorTable.                 */
/* Special colours are -1 to -9, but we also need an entry for 0!     */
/* In addition the table stores the system colors, the number of      */
/* which is given by SYSCLR_CSYSCOLORS.                               */
/**********************************************************************/
#define SPECIAL_COL_TAB_SIZE (SYSCLR_CSYSCOLORS + 10)
