/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/

/**********************************************************************/
/*                                                                    */
/*   Module          = EDDASETG                                       */
/*                                                                    */
/*   Description     = Display Device Driver minor function           */
/*                     DeviceSetGlobalAttribute                       */
/*                                                                    */
/*   Function        = DeviceSetGlobalAttribute sets an attribute,    */
/*                     across all bundles, to its default or a given  */
/*                     value.                                         */
/*                                                                    */
/*   Reference       = Winthorn Functional Specification              */
/*                     Device Driver Interface Specification          */
/*                     Display Device Driver Design Specification     */
/*                                                                    */
/*                                                                    */
/**********************************************************************/


#define INCL_DDIMISC
#define INCL_WINSYS
#include <eddinclt.h>

#include <eddacone.h>
#include <eddccone.h>
#include <eddecone.h>
#include <edddtypt.h>

#include <eddaextf.h>
#include <eddcextf.h>
#include <eddgextf.h>
#include <eddtextf.h>

/**********************************************************************/
/* DeviceSetGlobalAttribute sets either foregroud color,              */
/* background color, foreground mix or background mix across all      */
/* bundle types.                                                      */
/* Note, the line attribute bundle has no background attributes at 1.3*/
/* and although it has one at 2.0 for backward compatibility it is    */
/* not set by this global attribute change operation.                 */
/**********************************************************************/

DDIENTRY edda_DeviceSetGlobalAttribute (HDC           hdc,
                                        ULONG         ArgAttrType,
                                        ULONG         ArgAttrValue,
                                        ULONG         ArgOptions,
                                        PDC           pdcArg,
                                        ULONG         FunN)

{
#define TFUNC "edda_DeviceSetGlobalAttribute"

    /******************************************************************/
    /* Local variables                                                */
    /******************************************************************/
    ULONG       PhyIndex;             /* Stores color physical index  */

    /******************************************************************/
    /* Get driver semaphore and perform entry checks                  */
    /******************************************************************/
    EnterDriver(pdcArg, FunN, EDF_STANDARD | EDF_DONT_CLEAN);
    PROFILE_ENTER(25);

    /******************************************************************/
    /* Select according to desired attribute type                     */
    /* If ArgOptions equals GATTR_DEFAULT then the desired attribute  */
    /* is set to its default value. For attribute types 3 and 4 the   */
    /* engine sets the default and passes to the driver the default   */
    /* value as well as clearing the option flag                      */
    /******************************************************************/
    switch ((USHORT)ArgAttrType)
    {
    case ATYPE_COLOR:

        if (ArgOptions & GATTR_DEFAULT)
        {
            ArgAttrValue = DEFAULT_FOREGROUND_COL;
        }

        /**************************************************************/
        /* We can only calculate the correct physical colors if there */
        /* is a bitmap selected into the DC.  (Selecting a bitmap     */
        /* into the DC will cause the physical colors to be           */
        /* recalculated).                                             */
        /**************************************************************/
        if (pdc->DCISelListEntry != NULL)
        {
            PhyIndex = LogToPhyIndex(ArgAttrValue);
            if ( PhyIndex == CLR_NOPHYINDEX )
            {
                LOGERR(TFUNC, "Invalid foreground color",
                                &ArgAttrValue, 1, PMERR_INV_COLOR_ATTR);
                goto SETGLOBATTRS_ERR_EXIT;
            }
            pdc->DCILineColatts.ForeColor = PhyIndex;
            pdc->DCICharColatts.ForeColor = PhyIndex;
            pdc->DCIMarkColatts.ForeColor = PhyIndex;
            pdc->DCIPattColatts.ForeColor = PhyIndex;
            pdc->DCIImagColatts.ForeColor = PhyIndex;
        }
        pdc->DCICurLinAts.lbnd.lColor = ArgAttrValue;
        pdc->DCICurTxtAts.cbnd.lColor = ArgAttrValue;
        pdc->DCICurMrkAts.mbnd.lColor = ArgAttrValue;
        pdc->DCICurPtnAts.abnd.lColor = ArgAttrValue;
        pdc->DCICurImgAts.ibnd.lColor = ArgAttrValue;

        break;

    case ATYPE_BACK_COLOR:

        if (ArgOptions & GATTR_DEFAULT)
        {
            ArgAttrValue = DEFAULT_BACKGROUND_COL;
        }

        /**************************************************************/
        /* We can only calculate the correct physical colors if there */
        /* is a bitmap selected into the DC.  (Selecting a bitmap     */
        /* into the DC will cause the physical colors to be           */
        /* recalculated).                                             */
        /**************************************************************/
        if (pdc->DCISelListEntry != NULL)
        {
            PhyIndex = LogToPhyIndex(ArgAttrValue);
            if ( PhyIndex == CLR_NOPHYINDEX )
            {
                LOGERR(TFUNC, "Invalid background color",
                           &ArgAttrValue, 1, PMERR_INV_BACKGROUND_COL_ATTR);
                goto SETGLOBATTRS_ERR_EXIT;
            }

            /**********************************************************/
            /* This looks like a     to me!  Global attribute change  */
            /* does not change the line background color, so dont     */
            /* change our internal version                            */
            /**********************************************************/
            /* pdc->DCILineColatts.BackColor = PhyIndex; */
            pdc->DCICharColatts.BackColor = PhyIndex;
            pdc->DCIMarkColatts.BackColor = PhyIndex;
            pdc->DCIPattColatts.BackColor = PhyIndex;
            pdc->DCIImagColatts.BackColor = PhyIndex;
        }

        pdc->DCICurLinAts.lbnd.lBackColor = ArgAttrValue;
        pdc->DCICurTxtAts.cbnd.lBackColor = ArgAttrValue;
        pdc->DCICurMrkAts.mbnd.lBackColor = ArgAttrValue;
        pdc->DCICurPtnAts.abnd.lBackColor = ArgAttrValue;
        pdc->DCICurImgAts.ibnd.lBackColor = ArgAttrValue;

        break;

    case ATYPE_MIX_MODE:

        pdc->DCICurLinAts.lbnd.usMixMode = (USHORT)ArgAttrValue;
        pdc->DCICurTxtAts.cbnd.usMixMode = (USHORT)ArgAttrValue;
        pdc->DCICurMrkAts.mbnd.usMixMode = (USHORT)ArgAttrValue;
        pdc->DCICurPtnAts.abnd.usMixMode = (USHORT)ArgAttrValue;
        pdc->DCICurImgAts.ibnd.usMixMode = (USHORT)ArgAttrValue;
        break;

    case ATYPE_BACK_MIX_MODE:

        {
        SHORT sBackMix;

        sBackMix = GetBackgroundMix((USHORT)ArgAttrValue);
        if ( sBackMix == BM_ERROR )
        {
           goto SETGLOBATTRS_ERR_EXIT;
        }
        else /* valid background mix */
        {
          /* Defect 68669 and 66855 - To be consistant with the     */
          /* VGA driver and the graphics engine, we will not allow  */
          /* the background mix to be changed for the LINEBUNDLE.   */
          /*                                                        */
          /* pdc->DCICurLinAts.lbnd.usBackMixMode = sBackMix;       */

          pdc->DCICurTxtAts.cbnd.usBackMixMode = sBackMix;
          pdc->DCICurMrkAts.mbnd.usBackMixMode = sBackMix;
          pdc->DCICurPtnAts.abnd.usBackMixMode = sBackMix;
          pdc->DCICurImgAts.ibnd.usBackMixMode = sBackMix;
        }
        break;
       }

    default:

        LOGERR(TFUNC,"Unknown Type", ArgAttrType, 1, UNKNOWN_PARM);
        goto SETGLOBATTRS_ERR_EXIT;
    }


    /******************************************************************/
    /* Set flags in DCIData to indicate that the attributes have been */
    /* changed from their default values.                             */
    /* OR the default flags with the existing value to preserve the   */
    /* state of the new marker and pattern symbol flags               */
    /******************************************************************/
    pdc->DCIChanged |= NOTDEFAULT_TextAttrs |
                       NOTDEFAULT_LineAttrs |
                       NOTDEFAULT_MarkAttrs |
                       NOTDEFAULT_PtrnAttrs |
                       NOTDEFAULT_ImagAttrs;

    /******************************************************************/
    /* Release driver semaphore                                       */
    /******************************************************************/
    ExitDriver(pdcArg, FunN, EDF_STANDARD | EDF_DONT_CLEAN);

    PROFILE_EXIT(25);
    return (OK);


SETGLOBATTRS_ERR_EXIT:
    /******************************************************************/
    /* Release driver semaphore                                       */
    /******************************************************************/
    ExitDriver(pdcArg, FunN, EDF_STANDARD | EDF_DONT_CLEAN);

    PROFILE_EXIT(25);
    return(ERROR_ZERO);
}
#undef TFUNC
