/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/

/**********************************************************************/
/*                                                                    */
/*   Module          = EDDARFNT                                       */
/*                                                                    */
/*   Description     = Display Device Driver Realize Font             */
/*                                                                    */
/*   Function        = Called when the engine attempts to realize a   */
/*                     font. Returns indicating whether the driver    */
/*                     can realize the font.                          */
/*                                                                    */
/*   Reference       = Winthorn Functional Specification              */
/*                     Device Driver Interface Specification          */
/*                     Display Device Driver Design Specification     */
/*                                                                    */
/*                                                                    */
/**********************************************************************/


#define INCL_DEV
#define INCL_DDIMISC
#include <eddinclt.h>
#include <edddtypt.h>
#include <eddhcone.h>
#include <eddhtype.h>
#include <eddacone.h>
#include <edddcone.h>
#include <eddtcone.h>
#include <eddaextf.h>
#include <eddgextf.h>
#include <eddtextf.h>
#include <memman.h>

//#define INCL_GRE_FONTS
//#include <pmddim.h>

extern DDTType                DDT;

extern USHORT                 ResidentFonts;
extern USHORT                 DefaultFontListIndex;
extern PINTFONT               pDefaultFont;
extern PVOID                  pResourceFont;


/**********************************************************************/
/* RealizeFont is called when:-                                       */
/* 1 The engine asks the driver if it can realize a device font for   */
/*   the logical font request.                                        */
/* 2 The driver is asked to turn an engine font into a device font.   */
/* 3 The driver is asked to delete a device font.                     */
/**********************************************************************/

DDIENTRY edda_RealizeFont (HDC         hdc,
                           ULONG       ArgCommand,
                           ULONG       ArgLogFont,
                           ULONG       ArgEngFont,
                           PDC         pdcArg,
                           ULONG       FunN)


{
#define TFUNC "edda_RealizeFont"

    /******************************************************************/
    /* The engine is managing our font for us - we just return no     */
    /* match for realizing a font                                     */
    /******************************************************************/
    IgnoreParam(hdc);
    IgnoreParam(ArgCommand);
    IgnoreParam(ArgLogFont);
    IgnoreParam(ArgEngFont);
    IgnoreParam(pdcArg);
    IgnoreParam(FunN);

    return(NO_FONT_MATCH);
}
#undef TFUNC

