/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**********************************************************************/
/*                                                                    */
/*   Module          = EDDAGETB                                       */
/*                                                                    */
/*   Description     = Display Device Driver minor function           */
/*                     DeviceGetAttributes                            */
/*                                                                    */
/*   Function        = DeviceGetAttributes returns information about  */
/*                     the foreground and background color for a      */
/*                     given attribute bundle.                        */
/*                                                                    */
/*   Reference       = Winthorn Functional Specification              */
/*                     Device Driver Interface Specification          */
/*                     Display Device Driver Design Specification     */
/*                                                                    */
/*                                                                    */
/**********************************************************************/
#include <eddinclt.h>

#include <eddacone.h>
#include <eddaextf.h>
#include <eddgextf.h>

/**********************************************************************/
/* DeviceGetAttributes returns the current foreground and background  */
/* colors in the corresponding attribute bundle.                      */
/**********************************************************************/

DDIENTRY edda_DeviceGetAttributes (HDC            hdc,
                                   ULONG          ArgBundleType,
                                   ULONG          ArgAttrsMask,
                                   PVOID          ArgAttributes,
                                   PDC            pdcArg,
                                   ULONG          FunN)
{
#define TFUNC "edda_DeviceGetAttributes"
    /******************************************************************/
    /* Get driver semaphore and perform entry checks                  */
    /******************************************************************/
    IgnoreParam(hdc);
    EnterDriver(pdcArg, FunN, EDF_STANDARD);

    /******************************************************************/
    /* Apply the DC command mask to the command bits                  */
    /******************************************************************/
    COMMANDBITS(FunN) &= pdc->DCICommandMask;

    /******************************************************************/
    /* Switch according to bundle type. Only need to return           */
    /* information on foreground and background colour                */
    /******************************************************************/
    switch (ArgBundleType)
    {
    case PRIM_LINE:                    /* line bundle                 */
        if (ArgAttrsMask & GET_FORE_COLOR)
        {
            ((PLINEBUNDLE)ArgAttributes)->lColor =
                                     pdc->DCICurLinAts.lbnd.lColor;
        }
#ifdef LINESBG
        if (ArgAttrsMask & GET_BACK_COLOR)
        {
            ((PLINEBUNDLE)ArgAttributes)->lBackColor =
                                   pdc->DCICurLinAts.lbnd.lBackColor;
        }
#endif /* LINESBG */
        break;

    case PRIM_CHAR:                    /* character bundle            */
        if (ArgAttrsMask & GET_FORE_COLOR)
        {
            ((PCHARBUNDLE)ArgAttributes)->lColor =
                                     pdc->DCICurTxtAts.cbnd.lColor;
        }
        if (ArgAttrsMask & GET_BACK_COLOR)
        {
            ((PCHARBUNDLE)ArgAttributes)->lBackColor =
                                 pdc->DCICurTxtAts.cbnd.lBackColor;
        }
        break;

    case PRIM_MARKER:                  /* marker bundle               */
        if (ArgAttrsMask & GET_FORE_COLOR)
        {
            ((PMARKERBUNDLE)ArgAttributes)->lColor =
                                     pdc->DCICurMrkAts.mbnd.lColor;
        }
        if (ArgAttrsMask & GET_BACK_COLOR)
        {
            ((PMARKERBUNDLE)ArgAttributes)->lBackColor =
                                 pdc->DCICurMrkAts.mbnd.lBackColor;
        }
        break;

    case PRIM_AREA:                    /* pattern bundle              */
        if (ArgAttrsMask & GET_FORE_COLOR)
        {
            ((PAREABUNDLE)ArgAttributes)->lColor =
                                     pdc->DCICurPtnAts.abnd.lColor;
        }
        if (ArgAttrsMask & GET_BACK_COLOR)
        {
            ((PAREABUNDLE)ArgAttributes)->lBackColor =
                                 pdc->DCICurPtnAts.abnd.lBackColor;
        }
        break;

    case PRIM_IMAGE:                   /* image bundle                */
        if (ArgAttrsMask & GET_FORE_COLOR)
        {
            ((PIMAGEBUNDLE)ArgAttributes)->lColor =
                                     pdc->DCICurImgAts.ibnd.lColor;
        }
        if (ArgAttrsMask & GET_BACK_COLOR)
        {
            ((PIMAGEBUNDLE)ArgAttributes)->lBackColor =
                                 pdc->DCICurImgAts.ibnd.lBackColor;
        }
        break;

    default:
        LOGERR(TFUNC, "Unknown bundle", &ArgBundleType,1, UNKNOWN_PARM);
        goto GETATTRIBUTES_ERR_EXIT;
    }

    /******************************************************************/
    /* Release driver semaphore                                       */
    /******************************************************************/
    ExitDriver(pdcArg, FunN, EDF_STANDARD);
    return(OK);

GETATTRIBUTES_ERR_EXIT:
    /******************************************************************/
    /* Release driver semaphore                                       */
    /******************************************************************/
    ExitDriver(pdcArg, FunN, EDF_STANDARD);
    return(ERROR_ZERO);

}
#undef TFUNC
