/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/

/* Internal Use Only                                                         */
/*                                                                           */
/*              Program:      Definitions and declarations relevant to the   */
/*                            AF Interface                                   */
/*              File/module:  AFIDATA.H                                      */
/*              Author:                                                      */
/*                                                                           */
/* May be used with Lattice C 3.00 large model ( -mls option),               */
/*                  Microsoft C 3.00 with the /Ze option (any model),        */
/*                  IBM C 1.00 compiler with /Ze option enabled (any model). */
/*                                                                           */
/*                                                                           */
/* #DEFINES beginning B4_ are specific to the 4-Plane display only           */
/* #DEFINES beginning B8_ are specific to the 8-Plane display only           */
/*                                                                           */
/*****************************************************************************/

#define HOPEN_DATA struct { USHORT length; BYTE oflags,mode,iflags; }
/* usage: HOPEN_DATA will give the following structure                  */
/*                                                                      */
/*  struct                                                              */
/*  {                                                                   */
/*  USHORT length;                                                      */
/*  BYTE oflags,                                                        */
/*       mode,                                                          */
/*       iflags;                                                        */
/*  }                                                                   */
/*                                                                      */
/*                                                                      */

#define MIX_NOC       0x00      /* No change to mix     */
#define MIX_OR        0x01      /* OR                   */
#define MIX_OVER      0x02      /* Overpaint             */
#define MIX_XOR       0x04      /* Exclusive OR          */
#define MIX_LEAVE     0x05      /* Leave alone           */
#define MIX_ADD       0x08      /* Add colour to screen  */
#define MIX_SUB       0x09      /* screen - colour      */
#define MIX_MEAN      0x0B      /* average of screen & colour   */

#define HINT_DATA struct { USHORT length; LONG eventid; }
/* usage: HINT_DATA will give the following structure                   */
/*                                                                      */
/*  struct                                                              */
/*  {                                                                   */
/*  USHORT length;                                                      */
/*  LONG eventid;                                                       */
/*  }                                                                   */
/*                                                                      */

#define HSMODE_DATA struct { USHORT length; BYTE scformat; }
/* usage: HSMODE_DATA will give the following structure                 */
/*                                                                      */
/*  struct                                                              */
/*  {                                                                   */
/*  USHORT length;                                                      */
/*  BYTE scformat;                                                      */
/*  }                                                                   */
/*                                                                      */

#define HQMODE_DATA struct { USHORT length; BYTE mode; BYTE clvl[2]; BYTE atype,dtype,ac_w,ac_h,nplanes;USHORT width,height,h_pitch,v_pitch;BYTE moco,n_i_lvls, afp;PBYTE sprt;USHORT magic; }
/* usage: HQMODE_DATA will give the following structure                 */
/*                                                                      */
/*  struct                                                              */
/*  {                                                                   */
/*  USHORT length;                                                      */
/*  BYTE mode;                                                          */
/*  BYTE clvl[2];                                                       */
/*  BYTE atype,                                                         */
/*       dtype,                                                         */
/*       ac_w,                                                          */
/*       ac_h,                                                          */
/*       nplanes;                                                       */
/*  USHORT width,                                                       */
/*       height,                                                        */
/*       h_pitch,                                                       */
/*       v_pitch;                                                       */
/*  BYTE moco,                                                          */
/*       n_i_lvls,                                                      */
/*       area_fill_pln;                                                 */
/*  PBYTE sprt;                                                         */
/*  USHORT magic;                                                       */
/*  }                                                                   */
/*                                                                      */

#define HQMODES_DATA struct { USHORT length; BYTE atype,modes[32]; }
/* usage: HQMODES_DATA will give the following structure                */
/*                                                                      */
/*  struct                                                              */
/*  {                                                                   */
/*  USHORT length;                                                      */
/*  BYTE atype,                                                         */
/*       modes[32];                                                     */
/*  }                                                                   */
/*                                                                      */

#define HQDPS_DATA struct { USHORT length; SHORT size, stack, palbufsize; LONG vramsize, afpsize; }
/* usage: HQDPS_DATA will give the following structure                  */
/*                                                                      */
/*  struct                                                              */
/*  {                                                                   */
/*  USHORT length;                                                      */
/*  SHORT size,                                                         */
/*      stack,                                                          */
/*      palbufsize;                                                     */
/*  LONG vramsize,                                                      */
/*       afpsize;                                                       */
/*  }                                                                   */
/*                                                                      */

#define HCLOSE_DATA struct { USHORT length; USHORT flags; }
/* usage: HCLOSE_DATA will give the following structure                 */
/*                                                                      */
/*  struct                                                              */
/*  {                                                                   */
/*  USHORT length;                                                      */
/*  USHORT flags;                                                       */
/*  }                                                                   */
/*                                                                      */
/*                                                                      */

/*                                                                      */

struct CharSetDef   /* Character Set Definition block                   */
{
  BYTE reserve1;        /* reserved                                     */
  BYTE csettype;        /* Char set type  0 - image/triplane image      */
                        /*                3 - short stroke vector       */
  LONG reserve2;        /* reserved                                     */
  BYTE reserve3;        /* reserved                                     */
  BYTE cellwidth;       /* character cell width (pels)                  */
  BYTE cellheight;      /* character cell height (pels)                 */
  BYTE reserve4;        /* reserved                                     */
  USHORT cellnbytes;      /* no. bytes per cell definition (ceil(cx*cy/8))*/
  USHORT flags;           /* Flags as follows                             */
#define MULTIPLANE 0x4000       /* single or multi plane                */
#define PROPSPACE  0x2000       /* single or multi plane                */
  PUSHORT indextbl;   /* address of index table                       */
  PBYTE enveltbl;   /* address of envelope table                    */
  BYTE cdpt1st;         /* initial code point                           */
  BYTE cdptlast;        /* final code point                             */
  PBYTE chardef1;   /* address of character definition 1            */
  USHORT reserve5;        /* reserved                                     */
  PBYTE chardef2;   /* address of character definition 2            */
  USHORT reserve6;        /* reserved                                     */
  PBYTE chardef3;   /* address of character definition 3            */
};

typedef struct CharSetDef FAR * pCharSetDef;

#define HCHST_DATA(L) struct { USHORT length; coord_pr coord; CHAR string[L]; }
/* usage: HCHST_DATA will give the following structure                  */
/*                                                                      */
/*  struct                                                              */
/*  {                                                                   */
/*  USHORT length;                                                      */
/*  coord_pr coord;                                                     */
/*  CHAR string[L];                                                     */
/*  }                                                                   */
/*                                                                      */

#define AXLATE_DATA struct { USHORT length; ULONG foretable[16],backtable[16]; }
/* usage: AXLATE_DATA will give the following structure                 */
/*                                                                      */
/* struct                                                               */
/* {                                                                    */
/* USHORT length;                                                       */
/* ULONG  foretable[16],                                                */
/*        backtable[16];                                                */
/* }                                                                    */
/*                                                                      */

#define HINIT_DATA struct { USHORT length; USHORT segment; }
/* usage: HINIT_DATA will give the following structure                  */
/*                                                                      */
/*  struct                                                              */
/*  {                                                                   */
/*  USHORT length;                                                        */
/*  USHORT segment;                                                       */
/*  }                                                                   */
/*                                                                      */

#define HSYNC_DATA struct { USHORT length; USHORT segment; }
/* usage: HSYNC_DATA will give the following structure                  */
/*                                                                      */
/*  struct                                                              */
/*  {                                                                   */
/*  USHORT length;                                                        */
/*  USHORT segment;                                                       */
/*  }                                                                   */
/*                                                                      */

/* Font file definition                                                 */
/* This is the layout of the font file header                           */
/* All the address fields within the CSD's (Character Set Definition)   */
/* are offsets within the file. To these should be added the address    */
/* at which the font is loaded to give the correct values.              */
/*                                                                      */
struct FontFileDefn
{
  SHORT no_pages; /* no of code pages in the file (size of page_array)    */
  SHORT def_page; /* default page index (into page_array)                 */
  SHORT alt_page; /* alternate default page index (into page_array)       */
  struct
  {
    CHAR code_page_id[4];       /* code page id                         */
    SHORT  csd_offset;            /* offset within file of CSD block      */
  } page_array[1];      /* array of code page ID's and CSD offsets      */
};

typedef struct FontFileDefn FAR * pFontFileDefn;

#define HSBMAP_DATA struct { USHORT length; BYTE flags, format; PBYTE address; USHORT width, height; }
#define HQBMAP_DATA struct { USHORT length; BYTE flags, format; PBYTE address; USHORT bwidth, bheight; coord_pr coord; USHORT wwidth, wheight; }

/*  HSCAN_DATA is used by PolyScanLine. It is equivalent to the HRECT_  */
/*  DATA but with multiple rectangles                                   */

#define HSCAN_DATA(S) struct { USHORT length; ScanRectangle rects[S]; }
/* usage: HSCAN_DATA(size) will give the following structure            */
/*                                                                      */
/*  struct                                                              */
/*  {                                                                   */
/*  USHORT          length;                                             */
/*  ScanRectangle rects[size];     typedef struct                       */
/*  }                              {                                    */
/*                                     coord_pr coord;                  */
/*                                     SHORT width,                     */
/*                                         height;                      */
/*                                 } ScanRectangle;                     */
/*                                                                      */
