/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/**********************************************************************/
/*                                                                    */
/*   Module          = 8514.H                                         */
/*                                                                    */
/*   Description     = Register specific info for the 8514/A          */
/*                     BitBlt                                         */
/*                                                                    */
/*   Function        = BitBlt block transfers a series of bits from   */
/*                     a source bitmap to a target bitmap, optionally */
/*                     under control of a pattern.                    */
/*                                                                    */
/*   Reference       = Graphics Programming for 8514/A                */
/*                     Device Driver Interface Specification          */
/*                     Display Device Driver Design Specification     */
/*                                                                    */
/*   Note : Unlike previous versions of this header file which were   */
/*          written to use value that could be ORed together to fill  */
/*          a 16-bit register, we use the BIT types available in C    */
/*          and, therefore, have converted register constants to be   */
/*          "unshifted".  This avoids the necessity of having to      */
/*          constantly mask off portions of a shadow register that    */
/*          we are not updating.                                      */
/*                                                                    */
/*                                                                    */
/**********************************************************************/

// Old 8514 off-screen definition
//
// #define SCR_8514_WIDTH      1024   /* Width of 8514 VRAM/visible screen */
// #define SCR_8514_HEIGHT     1024   /* Height of 8514 VRAM */
// #define SCR_8514_VIS_HEIGHT  768   /* Height of 8514 visible screen */
//
// #define START_BITMAP_CACHE  0xF00C0080    // (128,768)
// #define START_FONT_CACHE    0xF00E0000    // (  0,896)
// #define HEIGHT_FONT_CACHE          128
//
// /* Positional constant when seamless enters the picture */
// #define SM_START_FONT_CACHE 0xF00C0100    // (256,768)
// #define SM_LEFT_FONT_CACHE         256
// #define SM_RIGHT_FONT_CACHE       1016
// #define SM_BOTTOM_FONT_CACHE       896
//
// #define COLORCURSOR_VRAM    0xF00D0040    // ( 64,832)
// #define SAVECURSOR_VRAM     0xF00D0000    // (  0,832)
// #define ANDMASK_VRAM        0xF00C0000    // (  0,768)
// #define ORMASK_VRAM         0xF00C0040    // ( 64,768)
//
// #define COLORDITH_VRAM      0xF00C03F8    // (1016,768)
// #define MONODITH_VRAM       0xF00C23F8    // (1016,776)
//
//

#define SCR_S3_WIDTH        2048   /* Width of S3 VRAM/visible screen */
#define SCR_S3_HEIGHT       1638   /* Width of S3 VRAM/visible screen */
#define SCR_8514_WIDTH      1024   /* Width of 8514 VRAM/visible screen */
#define SCR_8514_HEIGHT     1024   /* Height of 8514 VRAM */

// Locations of off-screen resource for 640x480
#define W640_VIS_WIDTH         640
#define W640_VIS_HEIGHT        480

#define W640_BMCACHE           0xF08001E0      // (128,480)
#define W640_FONTCACHE         0xF0000260      // (  0,608)
#define W640_FONTCACHEHEIGHT   416
#define W640_MAXBITMAPS        8

#define W640_SL_FONTCACHE      0xF0000260      // (  0,608)
#define W640_SL_LEFTFONT       0
#define W640_SL_RIGHTFONT      624
#define W640_SL_TOPFONT        608
#define W640_SL_BOTTOMFONT     752
#define W640_SL_MAXBITMAPS     2

#define W640_COLORCURSOR       0xF0400220      // ( 64,544)
#define W640_SAVECURSOR        0xF0000220      // (  0,544)
#define W640_ANDMASK           0xF00001E0      // (  0,480)
#define W640_XORMASK           0xF04001E0      // ( 64,480)
#define W640_HWCUR_SCAN        607

#define W640_COLORDITH         0xF27801E0      // (632,480)
#define W640_MONODITH          0xF27801E8      // (632,488)

// Locations of off-screen resource for 800x600
#define W800_VIS_WIDTH         800
#define W800_VIS_HEIGHT        600

#define W800_BMCACHE           0xF0800280      // (128,640)
#define W800_FONTCACHE         0xF0000300      // (  0,768)
#define W800_FONTCACHEHEIGHT   256
#define W800_MAXBITMAPS        11

#define W800_SL_FONTCACHE      0xF1000280      // (256,640)
#define W800_SL_LEFTFONT       256
#define W800_SL_RIGHTFONT      792
#define W800_SL_TOPFONT        640
#define W800_SL_BOTTOMFONT     812
#define W800_SL_MAXBITMAPS     2

#define W800_COLORCURSOR       0xF04002c0      // ( 64,704)
#define W800_SAVECURSOR        0xF00002c0      // (  0,704)
#define W800_ANDMASK           0xF0000280      // (  0,640)
#define W800_XORMASK           0xF0400280      // ( 64,640)
#define W800_HWCUR_SCAN        600

#define W801_BMCACHE           0xF0000000      // (0,0)
#define W801_FONTCACHE         0xF1000260      // (256,608)
#define W801_FONTCACHEHEIGHT   32
#define W801_MAXBITMAPS        0

#define W801_SL_FONTCACHE      0xF0F00260      // (240,608)
#define W801_SL_LEFTFONT       0x140           //  320
#define W801_SL_RIGHTFONT      784
#define W801_SL_TOPFONT        608
#define W801_SL_BOTTOMFONT     640
#define W801_SL_MAXBITMAPS     0

#define W801_COLORCURSOR       0xF0C00260      // ( 192,608)
#define W801_SAVECURSOR        0xF0800260      // ( 128,608)
#define W801_ANDMASK           0xF0000260      // ( 0,608)
#define W801_XORMASK           0xF0400260      // ( 64,608)
#define W801_HWCUR_SCAN        600

#define W800_COLORDITH         0xF3180260      // (792,608)
#define W800_MONODITH          0xF3180268      // (792,616)

// Locations of off-screen resource for 1024x768
#define W1024_VIS_WIDTH        1024
#define W1024_VIS_HEIGHT       768

#define W1024_BMCACHE          0xF0800300      // (128,768)
#define W1024_FONTCACHE        0xF0000380      // (  0,896)
#define W1024_FONTCACHEHEIGHT  128
#define W1024_MAXBITMAPS       13

#define W1024_SL_FONTCACHE     0xF1000300      // (256,768)
#define W1024_SL_LEFTFONT      256
#define W1024_SL_RIGHTFONT     1008
#define W1024_SL_TOPFONT       768
#define W1024_SL_BOTTOMFONT    894
#define W1024_SL_MAXBITMAPS    2

#define W1024_COLORCURSOR      0xF0400340      // ( 64,832)
#define W1024_SAVECURSOR       0xF0000340      // (  0,832)
#define W1024_ANDMASK          0xF0000300      // (  0,768)
#define W1024_XORMASK          0xF0400300      // ( 64,768)
#define W1024_HWCUR_SCAN       895

#define W1024_COLORDITH        0xF3f80300      // (1016,768)
#define W1024_MONODITH         0xF3f80308      // (1016,776)

// Locations of off-screen resource for 1280x1024
#define W1280_VIS_WIDTH        1280
#define W1280_VIS_HEIGHT       1024

#define W1280_BMCACHE          0xF0800400      // (128,1024)
#define W1280_FONTCACHE        0xF0000480      // (  0,1152)
#define W1280_FONTCACHEHEIGHT  128
#define W1280_MAXBITMAPS       13

#define W1280_SL_FONTCACHE     0xF1000400      // (256,1024)
#define W1280_SL_LEFTFONT      256
#define W1280_SL_RIGHTFONT     1008
#define W1280_SL_TOPFONT       1024
#define W1280_SL_BOTTOMFONT    1150
#define W1280_SL_MAXBITMAPS    2

#define W1280_COLORCURSOR      0xF0400440      // ( 64,1088)
#define W1280_SAVECURSOR       0xF0000440      // (  0,1088)
#define W1280_ANDMASK          0xF0000400      // (  0,1024)
#define W1280_XORMASK          0xF0400400      // ( 64,1024)
#define W1280_HWCUR_SCAN       1151

#define W1280_COLORDITH        0xF3f80400      // (1016,1024)
#define W1280_MONODITH         0xF3f80408      // (1016,1032)

#define MEMMAPADDR             0xA0000         // Able Thousand
#define MEMMAPADDR24           0xE00000        // 14 MEG

#define MEMMAPLENGTH           0x10000         // 64k
#define MEMMAPLENGTH24         0x200000        // 2-MEG
#define CB_SCAN24              0x100           // 2k

/*
;
; I/O port definitions for the INMOS RAMDAC:
;
;
 */
#define RAMDAC_PMASK    0x02ea      /* pixel mask                           */
#define RAMDAC_RADDR    0x02eb      /* read lut index address               */
#define RAMDAC_WADDR    0x02ec      /* write lut index address              */
#define RAMDAC_RGB      0x02ed      /* rgb data port                        */

/*
;
; I/O port definitions for the 8514/A Update Controller (primary decodes):
; (NOTE: We utilize the discard feature i/o ports)
;
 */
#define SRCY               0x82e8      /* src y coordinate for primitives      */
#define SRCX               0x86e8      /* src x coordinate for primitives      */
#define DESTY              0x8ae8      /* dest y coordinate for Copy Rectangle */
#define DESTX              0x8ee8      /* dest x coordinate for Copy Rectangle */

#define K1              0x8ae8      /* Bresenham term1 for vectors          */
#define K2              0x8ee8      /* Bresenham term2 for vectors          */
#define ERR_TERM        0x92e8      /* Bresenham error term accumulator     */

#define LX              0x96e8      /* x-axis length for primitives         */

#define CMD_FLAGS       0x9ae8      /* command/flags register (w)           */

  #define CMD_C_NULL         0      /* null command                         */
  #define CMD_C_VECTOR       1      /* output vector                        */
  #define CMD_C_HRECT        2      /* horizontal rectangle                 */
  #define CMD_C_VRECT        3      /* vertical rectangle                   */
  #define CMD_C_FRECT        4      /* fast rectangle                       */
  #define CMD_C_OUTLINE      5      /* outline draw                         */
  #define CMD_C_COPYRECT     6      /* copy rectangle                       */

  #define CMD_BO_HL          0      /* high byte first, low byte second     */
  #define CMD_BO_LH          1      /* low byte first, high byte second     */

  #define CMD_BYTE           0      /* byte/word field                      */
  #define CMD_WORD           1      /* byte/word field                      */

  #define CMD_FV_FIX         0      /* use fixed data in VRAM               */
  #define CMD_FV_VAR         1      /* use variable data in COLOR_0_WAIT    */

  #define CMD_MA_MOVE        0      /* move (no access of bit planes)       */
  #define CMD_MA_ACCESS      1      /* access bit planes                    */

  #define CMD_CD_ANGLED      0      /* Bresenham Line                       */
  #define CMD_CD_45          1      /* Vector Line                          */

  #define CMD_LP_DRAW        0      /* draw last pel                        */
  #define CMD_LP_NULL        1      /* don't draw last pel                  */

  #define CMD_PA_ONE         0      /* r/w 1 pel at a time                  */
  #define CMD_PA_FOUR        1      /* r/w 4 pels at a time                 */

  #define CMD_RW_R           0      /* read bit planes                      */
  #define CMD_RW_W           1      /* write bit planes                     */

#define QSTATUS         0x9ae8      /* queue status register (r)            */

  #define QS_IDLE            0      /* queue empty                          */
  #define QS_BUSY            1      /* 8514/A executing a graphics cmd.     */

  #define QS_R_Q_NODATA      0      /* no data available in read queue      */
  #define QS_R_Q_DATA        1      /* data available in read queue         */

  #define QS_W_Q_FULL   0x00ff      /* write queue is full                  */

#define SHORTSTROKE     0x9ee8      /* short stroke data (w)                */
  #define SS_0_DEG           0      /* 0 Degress - Right                    */
  #define SS_45_DEG          1      /* 45 Degress                           */
  #define SS_90_DEG          2      /* 90 Degress - Up                      */
  #define SS_135_DEG         3      /* 135 Degress -                        */
  #define SS_180_DEG         4      /* 180 Degress - Left                   */
  #define SS_225_DEG         5      /* 225 Degress -                        */
  #define SS_270_DEG         6      /* 270 Degress - Down                   */
  #define SS_315_DEG         7      /* 315 Degress -                        */

  #define SS_MOVE            0      /* move only                            */
  #define SS_MOVE_DRAW       1      /* move and draw                        */

#define COLOR_0         0xa2e8      /* background color (r/w)               */
#define COLOR_0_WAIT    0xe2e8      /* COLOR 0 wait port                    */
#define COLOR_1         0xa6e8      /* foreground color (r/w)               */

#define WRITE_ENABLE    0xaae8      /* plane write enable register (w)      */
#define READ_ENABLE     0xaee8      /* plane read enable register (w)       */

#define COLOR_COMP      0xb2e8      /* color comparison register (w)        */

#define FUNCTION_0      0xb6e8      /* background mix (w)                   */
#define FUNCTION_1      0xbae8      /* foreground mix (w)                   */

  #define FUNC_2OP_COL0      0      /* second operand src is Background Color  */
  #define FUNC_2OP_COL1      1      /* second operand src is Foreground Color  */
  #define FUNC_2OP_VAR       2      /* second operand src is variable data     */
  #define FUNC_2OP_COPY      3      /* second operand src is copy rectangle    */

  #define FUNC_ND            0      /* ~dest -> dest                        */
  #define FUNC_ZEROS         1      /* 0s -> dest                           */
  #define FUNC_ONES          2      /* 1s -> dest                           */
  #define FUNC_D             3      /* dest -> dest                         */
  #define FUNC_NS            4      /* ~src -> dest                         */
  #define FUNC_S_XOR_D       5      /* src xor dest -> dest                 */
  #define FUNC_S_XNOR_D      6      /* src xnor dest -> dest                */
  #define FUNC_S             7      /* src -> dest                          */
  #define FUNC_NS_OR_ND      8      /* ~src or ~dest -> dest                */
  #define FUNC_NS_OR_D       9      /* ~src or dest -> dest                 */
  #define FUNC_S_OR_ND      10      /* src or ~dest -> dest                 */
  #define FUNC_S_OR_D       11      /* src or ~dest -> dest                 */
  #define FUNC_S_AND_D      12      /* src and dest -> dest                 */
  #define FUNC_S_AND_ND     13      /* src and ~dest -> dest                */
  #define FUNC_NS_AND_D     14      /* ~src and dest -> dest                */
  #define FUNC_NS_AND_ND    15      /* ~src and ~dest -> dest               */
  #define FUNC_MIN_S_D      16      /* min(src,dest) -> dest                */
  #define FUNC_D_SUB_S      17      /* dest - src -> dest                   */
  #define FUNC_S_SUB_D      18      /* src - dest -> dest                   */
  #define FUNC_D_ADD_S      19      /* src + dest -> dest                   */
  #define FUNC_MAX_S_D      20      /* max(src,dest) -> dest                */
  #define FUNC_D_SUB_S_2    21      /* (dest - src)/2 -> dest               */
  #define FUNC_S_SUB_D_2    22      /* (src - dest)/2 -> dest               */
  #define FUNC_D_ADD_S_2    23      /* (src + dest)/2 -> dest               */
  #define FUNC_D_SUBS_S     25      /* dest - src -> dest w/saturate        */
  #define FUNC_S_SUBS_D     26      /* src - dest -> dest w/saturate        */
  #define FUNC_D_ADDS_S     27      /* src + dest -> dest w/saturate        */
  #define FUNC_D_SUBS_S_2   29      /* (dest - src)/2 -> dest w/saturate    */
  #define FUNC_S_SUBS_D_2   30      /* (src - dest)/2 -> dest               */

#define CNTL_STATUS     0x42e8      /* control/status register              */

  #define CS_R_NULL          0      /* null effect                          */
  #define CS_R_NORMAL        1      /* update controller normal operation   */
  #define CS_R_RESET         2      /* reset update controller              */

  #define CS_T_NULL          0      /* null effect                          */
  #define CS_T_NORMAL        1      /* normal mode                          */
  #define CS_T_TESTMODE      2      /* test mode                            */

#define PROM_PAGE       0x46e8      /* prom page select register            */

#define MISC_IO         0x4ae8      /* miscellaneous i/o register           */

  #define MI_PELCLK_640      0      /* pel clock for 640 wide               */
  #define MI_PELCLK_1024     1      /* pel clock for 1024 wide              */

  #define MI_AF_VGA          0      /* VGA has control                      */
  #define MI_AF_AFC          1      /* 8514A has control                    */

#define ADAPTER_ID      0x0100      /* adapter id register                  */
#define ADAPTER_ENABLE  0x0102      /* adapter enable register              */

/*
;
; I/O port definitions for the 8514/A Update Controller (secondary decodes):
; (NOTE: We utilize the discard feature i/o ports)
;
 */

#define SECOND_DECODE   0xbee8      /* secondary decodes                    */

#define LY              0xbee8      /* y-axis length for primitives (w)     */
#define LY_2DECODE      0x0000      /* secondary decode                     */

#define YMIN            0xbee8      /* scissor min y (w)                    */
#define YMIN_2DECODE    0x1000      /* secondary decode                     */

#define XMIN            0xbee8      /* scissor min x (w)                    */
#define XMIN_2DECODE    0x2000      /* secondary decode                     */

#define YMAX            0xbee8      /* scissor max y (w)                    */
#define YMAX_2DECODE    0x3000      /* secondary decode                     */

#define XMAX            0xbee8      /* scissor max x (w)                    */
#define XMAX_2DECODE    0x4000      /* secondary decode                     */

#define CONFIG          0xbee8      /* configuration (w)                    */
#define CONFIG_2DECODE  0x5000      /* secondary decode                     */

  #define CFG_VRAM_512       0      /* value for 512 line mode              */
  #define CFG_VRAM_1024      1      /* value for 1k line mode               */

  #define CFG_WORDWIDTH      1      /* wordwidth field (w)                  */
  #define CFG_INTERLEAVE     2      /* interleave field (w)                 */

#define PATTERN_0       0xbee8      /* pattern 0 register (w)               */
#define PATTERN_0_2DECODE 0x8000    /* secondary decode                     */
  #define PATTERN_0_DATA  0x1e      /* lo 4 bits pattern field              */

#define PATTERN_1       0xbee8      /* pattern 1 register (w)               */
#define PATTERN_1_2DECODE 0x9000    /* secondary decode                     */
  #define PATTERN_1_DATA  0x1e      /* hi 4 bits pattern field              */

#define MODE            0xbee8      /* mode register (w)                    */
#define MODE_2DECODE    0xa000      /* secondary decode                     */

  #define MD_PS_ONES         0      /* pattern = ONEs                       */
  #define MD_PS_PATT         1      /* pattern = PATTERN_0,PATTERN_1 regs   */
  #define MD_PS_VAR          2      /* pattern = variable data              */
  #define MD_PS_COPY         3      /* pattern = copy rectangle (read phase)*/

  #define MD_UP_FALSE        0      /* always false                         */
  #define MD_UP_TRUE         1      /* always true                          */
  #define MD_UP_GE           2      /* plane data >= color compare          */
  #define MD_UP_LT           3      /* plane data <  color compare          */
  #define MD_UP_NE           4      /* plane data != color compare          */
  #define MD_UP_EQ           5      /* plane data == color compare          */
  #define MD_UP_LE           6      /* plane data <= color compare          */
  #define MD_UP_GT           7      /* plane data >  color compare          */

  #define MD_AREAFILL     0x06      /* area fill control field              */
  #define MD_AF_W_NORMAL  0x00      /* normal operation for writes          */
  #define MD_AF_R_THRU    0x00      /* thru planes for reads                */
  #define MD_AF_W_SPP     0x04      /* special plane fill for writes        */
  #define MD_AF_R_ACROSS  0x04      /* across planes for reads              */
  #define MD_AF_W_SPC     0x06      /* special color fill for writes        */
  #define MD_WORDWIDTH    0x01      /* word width field                     */

/*
;
; I/O port definitions for the 8514/A Display Controller:
;
 */
#define LINE_TOTAL      0x02e8      /* line total length                    */
#define LINE_BLANK      0x06e8      /* line blank start                     */
#define LINE_SYNC_POS   0x0ae8      /* line sync position                   */
#define LINE_SYNC_WIDE  0x0ee8      /* line sync width                      */
#define FRAME_TOTAL     0x12e8      /* frame total length                   */
#define FRAME_BLANK     0x16e8      /* frame blank start                    */
#define FRAME_SYNC_POS  0x1ae8      /* frame sync position                  */
#define FRAME_SYNC_WIDE 0x1ee8      /* frame sync width                     */

#define CRTC_MODE       0x22e8      /* crtc mode                            */
#define CRTM_RESET      0x60        /* crtc reset field (01100000b) */
#define CRTM_R_NULL     0x00        /* no effect (00000000b) */
#define CRTM_R_NORMAL   0x20        /* normal operation (00100000b) */
#define CRTM_R_RESET    0x40        /* reset crt controller (01000000b) */
#define CRTM_INTERLACE  0x10        /* interlace field (00010000b) */
#define CRTM_VREPL      0x08        /* vertical replication (00001000b) */
#define CRTM_VRAM_BANK  0x03        /* vram bank select field (00000110b) */
#define CRTM_VB_1024    0x02        /* vram bank select for 1024 lines (00000010b) */
#define CRTM_VB_512     0x00        /* vram bank select for 512 lines (00000000b) */
#define CRTM_INTERLEAVE 0x01        /* interleave mode (00000001b) */

#define CRTC_STATUS     0x02e8      /* crtc status */


#define PIXOP_READ          0x0000
#define PIXOP_WRITE         0x0001

#define PIXOP_ONEPIX        0x0000
#define PIXOP_FOURPIX       0x0002

#define PIXOP_LASTPIX       0x0000
#define PIXOP_NOLASTPIX     0x0004

#define PIXOP_BRESLINE      0x0000
#define PIXOP_SSTROKE       0x0008

#define PIXOP_MOVE          0x0000
#define PIXOP_DRAW          0x0010

#define PIXOP_RIGHTTOLEFT   0x0000
#define PIXOP_LEFTTORIGHT   0x0020

#define PIXOP_XMAJOR        0x0000
#define PIXOP_YMAJOR        0x0040

#define PIXOP_BOTTOMTOTOP   0x0000
#define PIXOP_TOPTOBOTTOM   0x0080

#define PIXOP_VRAMDATA      0x0000
#define PIXOP_MEMDATA       0x0100

#define PIXOP_8BIT          0x0000
#define PIXOP_16BIT         0x0200

#define PIXOP_HIGHFIRST     0x0000
#define PIXOP_LOWFIRST      0x1000

#define PIXOP_NOOP          0x0000
#define PIXOP_LINEDRAW      0x0001
#define PIXOP_HORIZRECT     0x0002
#define PIXOP_VERTRECT      0x0003
#define PIXOP_FASTRECT      0x0004
#define PIXOP_OUTLINE       0x0005
#define PIXOP_COPYRECT      0x0006

#define PIXOP_0DEG          0x0000
#define PIXOP_45DEG         0x0020
#define PIXOP_90DEG         0x0040
#define PIXOP_135DEG        0x0060
#define PIXOP_180DEG        0x0080
#define PIXOP_225DEG        0x00A0
#define PIXOP_270DEG        0x00C0
#define PIXOP_315DEG        0x00E0
/*
;
; Macros to access the hardware:
;
 */


/*
; WaitIO
; ------
; General purpose macro to sit on an i/o port and test for a particular value:
;
;       p:              port # to be polled. If not present then it is assumed
;                       that the port # has already been loaded into Dx.
;
;       s:              sense of jump needed to remain in polling loop.
;
;       m:              the value that will be and'ed with the
;                       polled contents of Port.
;
;       e:              the value that must match the Port
;                       contents, after masking
;
 */
#define WaitIO(p,m,e) while ((inpw (p) & m) == e)
#define WaitIONot(p,m,e) while ((inpw (p) & m) != e)


/*
; WaitQ
; -----
; Special purpose macro to wait for the 8514A adapter's input queue to have
; a minimum # of words of free space. The queue is up to 8 words deep and
; at any time the # words still to be dequeued can be ascertained.
;
;       s:              fall out of wait loop if at least this many words are
;                       available in the queue. This parameter must be present.
;
 */
#define WaitQ(s) WaitIONot (QSTATUS, (0x80 >> (s - 1)), 0)

/*
; outwQ
; -----
; Special purpose macro to output a word value to the 8514A input queue.
;
;       Port:           port # for which data that is written will be queued.
;                       If this parameter is not present the port # will be
;                       assumed to already have been loaded into Dx.
;
;       Data:           immediate or indirect specification of data that will
;                       be output to Port. If this parameter is not present
;                       the data will be assumed to already have been loaded
;                       into the Ax register.
;
 */
#define outwQ(p,d) outpw(p,d)

/*
; outbQ
; -----
; Special purpose macro to output a byte value to the 8514A input queue. This
; macro differs from outwQ in that it is assumed that only the low half of the
; Ax register needs to be loaded. A slight saving in code size is thereby
; achieved.
;
;       Port:           port # for which data that is written will be queued.
;                       If this parameter is not present the port # will be
;                       assumed to already have been loaded into the Dx register
;
;       Data:           immediate or indirect specification of data that will
;                       be output to Port. If this parameter is not present
;                       the data will be assumed to already have been loaded
;                       into the Ax register.
;
;       SaveRegs:       parameter is present if registers used in polling are
;                       to be saved and restored, the actual content of this
;                       parameter is ignored, only its presence matters.
;
 */
#define outbQ(p,d) outp(p,d)

/*
; LoadPattern
; -----------
; Load the 8514/A pattern registers with an 8 bit pattern value. The macro
; shields us from the fact that an 8 bit pattern gets loaded into the 8514/A
; as two 4 bit values, each half shifted up 1 bit, and sent out to independent
; ports.
;
;       Pattern:        8 bit pattern to be loaded. If not present then it is
;                       assumed that the pattern is already loaded into Al.
;
 */
#define LoadPattern(p)\
    outpw(PATTERN_0, PATTERN_0_2DECODE | ((p & 0x000f) << 1));\
    outpw(PATTERN_1, PATTERN_1_2DECODE | (((p >> 4) & 0x000f) << 1))

