/*DDK*************************************************************************/
/*                                                                           */
/* COPYRIGHT    Copyright (C) 1995 IBM Corporation                           */
/*                                                                           */
/*    The following IBM OS/2 WARP source code is provided to you solely for  */
/*    the purpose of assisting you in your development of OS/2 WARP device   */
/*    drivers. You may use this code in accordance with the IBM License      */
/*    Agreement provided in the IBM Device Driver Source Kit for OS/2. This  */
/*    Copyright statement may not be removed.                                */
/*                                                                           */
/*****************************************************************************/
/****************************************************************************\
*                                                                            *
*  MODULE NAME: WPPRTRC.H                                                    *       *
*                                                                            *
*                                                                            *
*                                                                            *
*                                                                            *
\****************************************************************************/
/*******************************************************************************
*/

#define IDW_PRT_DEST            0x0001
#define IDW_PRT_JOB             0x0002
#define IDW_PRT_PDR             0x0003
#define IDR_SPOOLER             1
#define ID_NOTEBOOK             0x0002
#define ID_PDR_CNR              0x0100
#define ID_JOB_CNR              0x0300
#define JOB_ICON                0x0001
#define SPOOL_ICON              0x0002
#define PORT_ICON               0x0003
#define JOB_PRNT_ICON           0x0004
#define JOB_NORM_ICON           0x0005
#define JOB_HELD_ICON           0x0006
#define JOB_SPL_ICON            0x0007
#define JOB_ERR_ICON            0x0008
#define QUEUE_PROC_ICON         0x0009
#define SPOOLER_ICON            0x000a

/* @NET remote job icons */
#define RJOB_PRNT_ICON          0x000b   /* @NET */
#define RJOB_NORM_ICON          0x000c   /* @NET */
#define RJOB_HELD_ICON          0x000d   /* @NET */
#define RJOB_SPL_ICON           0x000e   /* @NET */
#define RJOB_ERR_ICON           0x000f   /* @NET */

#define ICON_ID_POSTSCRIPT      0x0010
#define ICON_ID_PLOTER          0x0013
#define ICON_ID_RASTER          0x0014

/* @NET remote printer icons */
#define RPRT_ICON               0x0015   /* @NET */
#define RPRT_UNAVAIL_ICON       0x0016   /* @NET */

#define DDFOLDER_ICON           0x0017

#define ICM_JOB_MENU            5000
#define IDM_JOB_COPY            5001
#define IDM_JOB_DEL             5002
#define IDM_JOB_STARTAGAIN      5006
#define IDM_JOB_PRINTNEXT       5007
#define IDM_JOB_RELEASE         5008
#define IDM_JOB_HOLD            5009
#define IDM_JOB_SETTINGS        5010
#define IDM_JOB_CONTENT         5011
#define IDM_JOB_OPEN            5012
#define IDM_JOB_STATUS          5013
#define IDM_JOB_HELP            5040

#define ICM_JOB_OPENMENU        5050
#define IDM_JOB_VIEW            5051

#define ICM_PD_OPENMENU         6000
#define IDM_OPENDETAIL          6001
#define IDM_OPENVIEW            6002

#define ICM_REDIRECT_MENU       7000
#define IDM_DUMMY1              7001
#define IDM_SEPARATOR           7002
#define IDM_PORT_REDIRECT       7100

#define ICM_REDIRECT_MENU1      7500
#define IDM_PORT_REDIRECT1      7600

#define ICM_INSTALL_MENU        8000
#define IDM_INSTALL             8001
#define IDM_DELETE              8002


#define ICM_PD_MENU             9000
#define IDM_PD_NEW              9001
#define IDM_SEPARATOR1          9002
#define IDM_PD_STATUS           9003
#define IDM_PD_HOLD             9004
#define IDM_PD_RELEASE          9005
#define IDM_PD_COPY             9006
#define IDM_PD_DEL              9007
#define IDM_PD_OPEN             9008
#define IDM_PD_DETAIL           9009
#define IDM_PD_ICON             9010
#define IDM_PD_SETTINGS         9011
#define IDM_PD_PRINT            9012
#define IDM_PD_REFRESH          9013
#define IDM_PD_LINK             9014
#define IDM_PD_MOVE             9015
#define IDM_PD_DELETE_JOBS      9016

 /* @NET remote print destination menu items */
#define ICM_RPRTMENU            9017     /* @NET */
#define IDM_RPRTACCESSANOTHER   9018     /* @NET */
#define IDM_RPRTCONNECT         9019     /* @NET */
#define IDM_RPRTDISCONNECT      9020     /* @NET */
#define IDM_RPRTLOGON           9021     /* @NET */
#define IDM_RPRTLOGOFF          9022     /* @NET */
#define IDM_RPRTSEPARATOR       9023     /* @NET */
#define IDM_RPRTREMADMIN        9024     /* @NET */
#define IDM_RPRTREMADMIN_COPY   9025     /* @NET */
#define IDM_RPRTREMADMIN_CREATE 9026     /* @NET */
#define IDM_RPRTREMADMIN_DELETE 9027     /* @NET */

   /* 9100 - 9900 are reversed for dynamic default
   /* print destination menu items */
#define IDM_PD_DEFAULT          9100
#define IDM_PD_DEFAULT_MAX      9900


    /* spool object resouce constants */
#define ICM_SPOOL_ENABLE        5001
#define ICM_SPOOL_DISABLE       5002
#define ICM_SPOOL_SECUR_ENABLE  5003
#define ICM_SPOOL_SECUR_DISABLE 5004

#define IDM_SPOOL_ENABLE        5101
#define IDM_SPOOL_DISABLE       5102
#define IDM_SPOOL_SECUR_ENABLE  5003
#define IDM_SPOOL_SECUR_DISABLE 5004

#define ID_SPOOLENABLE          5101
#define ID_SPOOLDISABLE         5102
#define ID_SPOOL_SECUR_ENABLE   5003
#define ID_SPOOL_SECUR_DISABLE  5004

#define ICM_PDR_ICON_VIEW       10000
#define IDM_PDR_ICON_VIEW       10001

#define STR_SPOOLERTITLE         10001

#define FLAG_SPOOLER_ENABLE      0x0001
#define FLAG_SPOOLER_DISABLE     0x0002

    /* resrouce string ids */
#define STR_PD_TAB_0            5000
#define STR_PD_TAB_1            5001
#define STR_PD_TAB_2            5002
#define STR_PD_TAB_3            5003
#define STR_PD_TAB_4            5004
#define STR_PD_TAB_5            5005
#define STR_PD_TAB_6            5006

#define STR_JOB_TAB_1           5020
#define STR_JOB_TAB_2           5021
#define STR_JOB_TAB_3           5022

#define STR_SPOOL_PATH_TAB      5030
#define STR_SPOOL_PRIORITY_TAB  5031                            /* @USE */

#define STR_PRINTER_DRIVER      5070

#define STR_PD_SELPORT_1        6007
#define STR_PD_SELPORT_2        6008
#define STR_PD_SELPRTDRV        6009
#define STR_PD_SELPRTDEST       6010
#define STR_PD_SELQDRV          6011
#define STR_PD_SELNET           6012
#define STR_PD_SELPOOL          6013
#define STR_JOB_SUBDATA         6014
#define STR_JOB_SPOOLOPT        6015
#define STR_JOB_QOPT            6016
#define STR_PORT_COM1           6017
#define STR_PORT_LPT1           6018
#define STR_PRINTMANAGER        6019
#define STR_DRIVE_A             6020


#define STR_BASE                   7000
#define STR_BAD_PATH1              (STR_BASE + 1)
#define STR_DRIVE_NOT_READY1       (STR_BASE + 2)
#define STR_NO_DRIVERS_IN_PATH     (STR_BASE + 3)
#define STR_NOMEMORY1              (STR_BASE + 4)
#define STR_CANNOTSTART            (STR_BASE + 5)
#define STR_PMRUNNING              (STR_BASE + 6)
#define STR_INVALID_DRIVE          (STR_BASE + 7)
#define STR_INIFILEERROR           (STR_BASE + 9)
#define STR_COULDNOTCREATE         (STR_BASE + 10)
#define STR_DISK_BAD1              (STR_BASE + 13)
#define STR_OUT_OF_DISK_SPACE1     (STR_BASE + 14)
#define STR_OptionalFileFailure    (STR_BASE + 15)
#define STR_SHARING_VIOLATION1     (STR_BASE + 16)
#define STR_DOSCOPY_FAILED         (STR_BASE + 17)
#define STR_MissingRequiredFile    (STR_BASE + 18)
#define STR_INFORM_REBOOT          (STR_BASE + 19)
#define STR_INSTALLWND30DRV        (STR_BASE + 20)         /* @53036 */
#define STR_INSTALLWND31DRV        (STR_BASE + 21)         /* @53036 */
#define STR_SPL_SUCCESS_ENABLE     (STR_BASE + 22)
#define STR_CONFIRM_DEL_JOBS       (STR_BASE + 23)
#define STR_PDRV_ALREADY_INST      (STR_BASE + 24)
#define STR_QDRV_ALREADY_INST      (STR_BASE + 25)
#define STR_PORT_ALREADY_INST      (STR_BASE + 26)
#define STR_PDRV_SELECTED_INST     (STR_BASE + 27)
#define STR_QDRV_SELECTED_INST     (STR_BASE + 28)
#define STR_PORT_SELECTED_INST     (STR_BASE + 29)
#define STR_INVALID_CODEPAGE       (STR_BASE + 30)
#define STR_QUEUE_NOT_EMPTY        (STR_BASE + 31)
#define STR_INV_SEPFILE_NAME       (STR_BASE + 32)
#define STR_PDRIVER_INSTALLED      (STR_BASE + 33)
#define STR_QDRIVER_INSTALLED      (STR_BASE + 34)
#define STR_PORT_INSTALLED         (STR_BASE + 35)
#define STR_DLL_LOAD_ERROR         (STR_BASE + 36)
#define STR_PRINT_ERROR            (STR_BASE + 37)

/* @NET RemoteAdmin strings */
#define STR_REMOTE_COPY            (STR_BASE + 38)   /* @NET */
#define STR_REMOTE_COPY_ERROR      (STR_BASE + 39)   /* @NET */
#define STR_REMOTE_CREATE          (STR_BASE + 40)   /* @NET */
#define STR_REMOTE_CREATE_ERROR    (STR_BASE + 41)   /* @NET */
#define STR_REMOTE_DELETE          (STR_BASE + 42)   /* @NET */
#define STR_REMOTE_DELETE_ERROR    (STR_BASE + 43)   /* @NET */
#define STR_REMOTE_INITPD_ERROR    (STR_BASE + 44)   /* @NET */
#define STR_REMOTE_NOT_USABLE      (STR_BASE + 45)   /* @NET */

#define STR_PDR_INST_TITLE         (STR_BASE + 100)
#define STR_CANCEL_INST_DDR        (STR_BASE + 101)
#define STR_REMOVEFILESFROMDISK    (STR_BASE + 102)
#define STR_REMOVEFILESFROMDISK2   (STR_BASE + 103)
#define STR_REMOVEFILESERROR       (STR_BASE + 104)
#define STR_REMOVEFILESERROR2      (STR_BASE + 105)
#define STR_PRINTER_NAME_MISSING   (STR_BASE + 106) /* @9504 */
#define STR_PDRV_IN_USE            (STR_BASE + 107)             /* @USE */
#define STR_DISKETTE_DIR           (STR_BASE + 108)             /* @USE */
#define STR_REMOVEABLE_DIR         (STR_BASE + 109)             /* @USE */
#define STR_FIXED_DIR              (STR_BASE + 110)             /* @USE */
#define STR_PDRV_REPLACE           (STR_BASE + 111)             /* @USE */
#define STR_PDRV_FILE_NOT_FOUND    (STR_BASE + 112)             /* @USE */
#define STR_OTHERWISE_DIR          (STR_BASE + 113)             /* @USE */
#define STR_INCORRECT_DIR          (STR_BASE + 114)             /* @USE */
#define STR_SPL_PRTY_ERROR         (STR_BASE + 115)             /* @USE */
#define STR_DEL_PDRV_IN_USE        (STR_BASE + 116)             /* @59038 */
#define STR_PICVIEW_MISSING        (STR_BASE + 117)             /* @60517 */
#define STR_OTHERWISE_ANOTH_DIR    (STR_BASE + 118)
#define STR_INSTALLWNDDRV          (STR_BASE + 119)
#define STR_DEL_QDRV_IN_USE        (STR_BASE + 120)
#define STR_REMOVEQFILESFROMDISK   (STR_BASE + 121)
#define STR_REMOVEQFILESFROMDISK2  (STR_BASE + 122)
#define STR_REMOVEQFILESERROR      (STR_BASE + 123)
#define STR_REMOVEQFILESERROR2     (STR_BASE + 124)
#define STR_WINDRV_REPLACE         (STR_BASE + 125)
#define STR_PRTNAME_TOO_LONG       (STR_BASE + 126)
#define STR_PRTDRV_OK_CREATE       (STR_BASE + 127)
#define STR_NO_CREATE              (STR_BASE + 128)
#define STR_INSERT_OS2_DISK        (STR_BASE + 129)
#define STR_INSERT_OS2_PD_DISK     (STR_BASE + 130)
#define STR_READING                (STR_BASE + 131)
#define STR_LOADING                (STR_BASE + 132)
#define STR_COPYING                (STR_BASE + 133)
#define STR_UNPACKING              (STR_BASE + 134)
#define STR_UNPACK_FAILED          (STR_BASE + 135)
#define STR_WINDOWS_DISKETTE_DIR   (STR_BASE + 136)             /* @FERENGI */
#define STR_DISKETTE_PROMPT        (STR_BASE + 137)             /* @83000   */

#define STRING_BASE             8000
#define STR_ID_DESTNAME         (STRING_BASE + 1)
#define STR_ID_QUEUENAME        (STRING_BASE + 2)
#define STR_ID_SEPERATORFILE    (STRING_BASE + 3)
#define STR_ID_PRPROC           (STRING_BASE + 4)
#define STR_ID_DRIVERNAME       (STRING_BASE + 5)
#define STR_ID_PRINTERNAME      (STRING_BASE + 6)
#define STR_ID_LOGADDR          (STRING_BASE + 7)
#define STR_ID_DRIVERS          (STRING_BASE + 8)
#define STR_ID_JOBCOMMENT       (STRING_BASE + 9)
#define STR_ID_JOBDOCNAME       (STRING_BASE + 10)
#define STR_ID_JOBID            (STRING_BASE + 11)
#define STR_ID_JOBPRIORITY      (STRING_BASE + 12)
#define STR_ID_JOBSIZE          (STRING_BASE + 13)
#define STR_ID_JOB_TITLE        (STRING_BASE + 14)
#define STR_ID_SYSTEM_TITLE     (STRING_BASE + 15)
#define STR_ID_FAX              (STRING_BASE + 16)    /* @58061 */

#define IDS_MINID                  0
#define IDS_HARDERROR              0
#define IDS_QUEUEHELD              1
#define IDS_HOLDINGQUEUE           2
#define IDS_RELEASINGQUEUE         3
#define IDS_JOBHELD                4
#define IDS_PRINTING               5
#define IDS_CHANGERIBBON           6
#define IDS_OUTOFPAPER             7
#define IDS_JAMMED                 8
#define IDS_PRINTINGNEXT           9
#define IDS_CANCELLINGJOB         10
#define IDS_RESTARTINGJOB         11
#define IDS_HOLDINGJOB            12
#define IDS_RELEASINGJOB          13
#define IDS_REPEATINGJOB          14
#define IDS_JOBS                  15
#define IDS_JOBPAUSED             16
#define IDS_UNTITLED              17
#define IDS_PRINTERJAMMED         18
#define IDS_FORMCHG               19
#define IDS_SPOOLING              20
#define IDS_WAITING               21
#define IDS_STATUSUNKNOWN         22
#define IDS_REVERSE_CLIPPING      36

#define IDS_QUEUEPAUSED           23
#define IDS_QUEUEACTIVE           24
#define IDS_QUEUEPEND             25
#define IDS_QUEUESTATUS           26
#define IDS_QUEUEDISABLE          35
#define IDS_QUEUEDELETINGJOBS     40


#define IDS_JOBID                 27
#define IDS_JOB_DOCNAME           28
#define IDS_JOB_DATE              29
#define IDS_JOB_TIME              30
#define IDS_JOB_STATUS            31
#define IDS_JOB_OWNER             32

#define IDS_JOB_ICON_TITLE        33
#define IDS_JOB_DETAIL_TITLE      34

#define IDS_SYSTEM_TITLE          37

/* @NET "Remote Printer" */
#define IDS_RPRTNAME              38   /* @NET */

#define IDS_PDR_ICON_TITLE        39

#define IDS_MAXID                 41


/****************************************************************************/
/*              PRINT  OBJECT  DIALOG BOX CONSTANTS                         */
/****************************************************************************/
          /*********************************************************/
          /*         Push buttons - Ok, Cancel, Help.              */
          /*********************************************************/
#define IDC_OK           1100                    /* OK push button */
#define IDC_CANCEL       DID_CANCEL              /* Cancel push button */
#define IDC_HELP         1102                    /* Help push button */
#define IDC_RESET        1103                    /* Help push button */
#define IDC_DEFAULT      1104                    /* Help push button */
#define IDC_DELETE       1105                    /* delete push button */
#define IDC_REFRESH      1106                    /* Refresh pushbutton */
#define IDC_TEXT         1107                    /* Static text */
#define IDC_JOBPROP      1108                    /* Job property button*/
#define IDC_CREATE       1109                    /* Create another button (@8295) */

          /*********************************************************/
          /*    New Print Destination - Setup                      */
          /*********************************************************/
#define IDD_PRTDESTNEW   20000                  /* @8295:Changed next 4 lines */
#define IDC_PDN_NAME     (IDD_PRTDESTNEW + 1)   /* Destination name           */
#define IDC_PDN_PDRCNR   (IDD_PRTDESTNEW + 2)   /* Print driver container     */
#define IDC_PDN_PORTCNR  (IDD_PRTDESTNEW + 3)   /* Port container             */
#define IDC_PDN_FILE     (IDD_PRTDESTNEW + 4)   /* File check box             */
#define IDC_PDN_INSTALL  (IDD_PRTDESTNEW + 5)   /* Install new pdriver button @USE */

          /*********************************************************/
          /*    Print Destination Conatiner Window                 */
          /*********************************************************/
#define IDD_PRTDESTCONTAINER  20100
#define IDC_PDC_DETAILCNR     (IDD_PRTDESTCONTAINER + 1)

          /*********************************************************/
          /*    Print Destination Settings - Port                  */
          /*********************************************************/
#define IDD_PRTDESTPORT       20200
#define IDC_PDP_PORTCNR       (IDD_PRTDESTPORT + 1)   /* Port container */
#define IDC_PDP_FILE          (IDD_PRTDESTPORT + 2)   /* File check box */

#define IDD_NBPRTDESTBASE     IDD_PRTDESTPORT

          /*********************************************************/
          /*    Print Destination Settings - Printer Drivers       */
          /*********************************************************/
#define IDD_PRTDESTDRIVER     20300
#define IDC_PDD_PRTDRVCNR     (IDD_PRTDESTDRIVER + 1)   /* Driver container */
#define IDC_PDD_DEFPRTDRVCNR  (IDD_PRTDESTDRIVER + 2)   /* Default Driver container */

          /*********************************************************/
          /*    Print Destination Settings - Printer Options       */
          /*********************************************************/
#define IDD_PRTDESTPRINTER    20400
#define IDC_PDP_QUEUED        (IDD_PRTDESTPRINTER + 1)   /* Queued type */
#define IDC_PDP_DIRECT        (IDD_PRTDESTPRINTER + 2)   /* Direct type */
#define IDC_PDP_APPDEFAULT    (IDD_PRTDESTPRINTER + 3)   /* Application default */
#define IDC_PDP_GRAPHLOC      (IDD_PRTDESTPRINTER + 4)   /* Gphics locally */

          /*********************************************************/
          /*    Print Destination Settings - Advance Options       */
          /*********************************************************/
#define IDD_PRTDESTADVOPT     20500
#define IDC_PDQ_QUEDRVCNR     (IDD_PRTDESTADVOPT+ 1)   /* Que driver cnr */
#define IDC_PDQ_JOBDLG        (IDD_PRTDESTADVOPT+ 2)
#define IDC_PDQ_PRTSFORMAT    (IDD_PRTDESTADVOPT+ 3)
#define IDC_PDQ_QUEDRVSTRING  (IDD_PRTDESTADVOPT+ 4)   /* @NET */
#define IDC_PDQ_PRTWHILESPL   (IDD_PRTDESTADVOPT+ 5)   /* @9313 */

          /*********************************************************/
          /*    Print Destination Settings - Network Options       */
          /*********************************************************/
#define IDD_PRTDESTNETWORK    20600
#define IDC_PDN_SEPFILE       (IDD_PRTDESTNETWORK + 1)   /* Separator file */
#define IDC_PDN_STARTTIME     (IDD_PRTDESTNETWORK + 2)   /* Start time */
#define IDC_PDN_STOPTIME      (IDD_PRTDESTNETWORK + 3)   /* Stop time */
#define IDC_PDN_REFRESHINT    (IDD_PRTDESTNETWORK + 4)   /* Refresh interval */
#define IDC_STSPINHOUR        (IDD_PRTDESTNETWORK + 4)
#define IDC_STSPINMIN         (IDD_PRTDESTNETWORK + 5)
#define IDC_TOSPINHOUR        (IDD_PRTDESTNETWORK + 6)
#define IDC_TOSPINMIN         (IDD_PRTDESTNETWORK + 7)
#define IDC_STAM              (IDD_PRTDESTNETWORK + 8)
#define IDC_STPM              (IDD_PRTDESTNETWORK + 9)
#define IDC_TOAM              (IDD_PRTDESTNETWORK + 10)
#define IDC_TOPM              (IDD_PRTDESTNETWORK + 11)

          /*********************************************************/
          /*    Print Destination Settings - View setting          */
          /*********************************************************/
#define IDD_PRTDESTSET        20700
#define IDC_PDS_DETAIL        (IDD_PRTDESTSET + 1)
#define IDC_PDS_ICON          (IDD_PRTDESTSET + 2)
#define IDC_PDS_SETTINGS      (IDD_PRTDESTSET + 3)
#define IDC_PDS_ALLJOB        (IDD_PRTDESTSET + 4)
#define IDC_PDS_OWNJOB        (IDD_PRTDESTSET + 5)
#define IDC_PDS_REFRESH       (IDD_PRTDESTSET + 6)
#define IDC_REFRESH_TEXT1     (IDD_PRTDESTSET + 7)
#define IDC_REFRESH_TEXT2     (IDD_PRTDESTSET + 8)
#define IDC_PDS_REMOTE        (IDD_PRTDESTSET + 9)
#define IDC_PDS_QUEUENAME     (IDD_PRTDESTSET + 10)



          /*********************************************************/
          /*    Job settings - Submission Data                     */
          /*********************************************************/
#define IDD_JOBSUBDATA        20800
#define IDC_JSD_DATE          (IDD_JOBSUBDATA + 1)   /* Data */
#define IDC_JSD_TIME          (IDD_JOBSUBDATA + 2)   /* Time */
#define IDC_JSD_SIZE          (IDD_JOBSUBDATA + 3)   /* Size */
#define IDC_JSD_COMMENT       (IDD_JOBSUBDATA + 4)   /* Comment */
#define IDC_JSD_OWNER         (IDD_JOBSUBDATA + 5)   /* Owner */
#define IDC_JSD_PRTDRVCNR     (IDD_JOBSUBDATA + 6)   /* Printer Driver Container*/
#define IDC_JSD_OWNER_TEXT    (IDD_JOBSUBDATA + 7)   /* Owner */ //@9311

          /*********************************************************/
          /*    Job settings - Spooler Options                     */
          /*********************************************************/
#define IDD_JOBSPOOLOPT       20900
#define IDC_JSO_JOBID         (IDD_JOBSPOOLOPT + 1)   /* Job identifier */
#define IDC_JSO_COPIES        (IDD_JOBSPOOLOPT + 2)   /* Copies */
#define IDC_JSO_PRIORITY      (IDD_JOBSPOOLOPT + 3)   /* Priority */
#define IDC_JSO_FORMNAME      (IDD_JOBSPOOLOPT + 4)   /* Form Name */
#define IDC_JSO_JOBSTATUS     (IDD_JOBSPOOLOPT + 5)   /* Job Status */
#define IDC_JSO_JOBPOSITION   (IDD_JOBSPOOLOPT + 6)   /* Job position */
#define IDC_JSO_COPIES_TEXT   (IDD_JOBSPOOLOPT + 7)   /* Copies */    //@NET
#define IDC_JSO_PRIORITY_TEXT (IDD_JOBSPOOLOPT + 8)   /* Priority */  //@NET
#define IDC_JSO_FORMNAME_TEXT (IDD_JOBSPOOLOPT + 9)   /* Form Name */ //@NET

          /*********************************************************/
          /*    Job settings - Queue Options                       */
          /*********************************************************/
#define IDD_JOBQUEOPT         21000
#define IDC_JQO_CODEPAGE      (IDD_JOBQUEOPT + 1)   /* Code Page */
#define IDC_JQO_COLOR         (IDD_JOBQUEOPT + 2)   /* Color */
#define IDC_JQO_MONO          (IDD_JOBQUEOPT + 3)   /* Mono */
#define IDC_JQO_QUEDRVCNR     (IDD_JOBQUEOPT + 4)   /* Queue Driver Container */
#define IDC_JQO_NORMAL        (IDD_JOBQUEOPT + 5)   /* mapping normal */
#define IDC_JQO_INVERTED      (IDD_JOBQUEOPT + 6)   /* mapping inverted */
#define IDC_JQO_OVERRIDE      (IDD_JOBQUEOPT + 7)   /* options overide */
#define IDC_JQO_OPTS          (IDD_JOBQUEOPT + 8)   /* queue driver options */
#define IDC_JQO_OVERTEXT      (IDD_JOBQUEOPT + 9)   /* override text */

          /*********************************************************/
          /*    Job settings - Network Options                     */
          /*********************************************************/
#define IDD_JOBNETOPT         21100
#define IDC_JNO_OWNER         (IDD_JOBNETOPT + 1)   /* Owner */
#define IDC_JNO_SEPFILE       (IDD_JOBNETOPT + 2)   /* Seperator File */

          /*********************************************************/
          /*    Port driver Installation                           */
          /*********************************************************/
#define IDD_PORTDRVINSTALL    21200
#define IDC_PIN_PORTDRIVER    (IDD_PORTDRVINSTALL + 1) /* Port Driver */
#define IDC_PIN_PORTSELCNR    (IDD_PORTDRVINSTALL + 2) /* Port Selection container */

          /*********************************************************/
          /*    Printer Driver Installation                        */
          /*********************************************************/
#define IDD_PRTDRVINSTALL     21500
#define IDC_PDI_DIRECTORY     (IDD_PRTDRVINSTALL + 1) /* Directory        */
#define IDC_PDI_PRTDRVCNR     (IDD_PRTDRVINSTALL + 2) /* Printer Driver container */
/* @NET */
#define IDC_PDI_REMOTEDRV     (IDD_PRTDRVINSTALL + 3) /* @NET Remote Driver to install */
#define IDC_PDI_AUTOREMOTEDRV (IDD_PRTDRVINSTALL + 4) /* @USE Automatically install remote driver */
#define IDC_PDI_OS2           (IDD_PRTDRVINSTALL + 5) /* @USE Drivers shipped with OS/2 */
#define IDC_PDI_OTHER         (IDD_PRTDRVINSTALL + 6) /* @USE Other OS/2 drivers */
#define IDC_PDI_DIRTEXT       (IDD_PRTDRVINSTALL + 7) /* @USE "Directory" @61749 */

          /*********************************************************/
          /*    Queue Driver Installation                          */
          /*********************************************************/
#define IDD_QUEDRVINSTALL     21600
#define IDC_QDI_DIRECTORY     (IDD_QUEDRVINSTALL + 1) /* Directory        */
#define IDC_QDI_QUEDRVCNR     (IDD_QUEDRVINSTALL + 2) /* Queue Driver container */

          /*********************************************************/
          /*    Discard printer driver                             */
          /*********************************************************/
#define IDD_PRTDRVDISCARD     21700
#define IDC_PDD_PRTDESTCNR    (IDD_PRTDRVDISCARD + 1) /* Print Dest container */

          /*********************************************************/
          /*    Discard Queue driver                               */
          /*********************************************************/
#define IDD_QUEDRVDISCARD     21800
#define IDC_QDD_PRTDESTCNR    (IDD_QUEDRVDISCARD + 1) /* Print Dest container */

          /*********************************************************/
          /*    Discard port driver                                */
          /*********************************************************/
#define IDD_PORTDRVDISCARD    21900
#define IDC_POR_PRINTDESTCNR  (IDD_PORTDRVDISCARD + 1) /* Print Dest container */

          /*********************************************************/
          /*    Setting the spooler path                           */
          /*********************************************************/
#define IDD_SETSPOOLPATH      22000
#define IDC_SPL_PATH          (IDD_SETSPOOLPATH + 1) /* Spool Path */

          /*********************************************************/
          /*    Setting the spooler priority             @USE      */
          /*********************************************************/
#define IDD_SETSPOOLPRIORITY  22400
#define IDC_SPL_PRIORITY      (IDD_SETSPOOLPRIORITY + 1) /* Priority slider */
#define IDC_SPL_PRTY_VALUE    (IDD_SETSPOOLPRIORITY + 2) /* Priority value */

          /*********************************************************/
          /*    Remote Print Destination Network Status page. @NET */
          /*********************************************************/
#define IDD_RPRTSTATUS                    22100                     /* @NET */
#define IDC_RPRTSTATUS_HELP               (IDD_RPRTSTATUS + 1)      /* @NET */
#define IDC_RPRTSTATUS_NETWORK            (IDD_RPRTSTATUS + 2)      /* @NET */
#define IDC_RPRTSTATUS_SERVER             (IDD_RPRTSTATUS + 3)      /* @NET */
#define IDC_RPRTSTATUS_RESOURCE           (IDD_RPRTSTATUS + 4)      /* @NET */
#define IDC_RPRTSTATUS_DESCRIPTION        (IDD_RPRTSTATUS + 5)      /* @NET */
#define IDC_RPRTSTATUS_STATUS             (IDD_RPRTSTATUS + 6)      /* @NET */
#define IDC_RPRTSTATUS_PORT               (IDD_RPRTSTATUS + 7)      /* @NET */
          /*********************************************************/
          /*    Remote Print Destination Connect dialog box.  @NET */
          /*********************************************************/
#define IDD_RPRTCONNECT                   22200                     /* @NET */
#define IDC_RPRTCONNECT_COMBOBOX          (IDD_RPRTCONNECT + 1)     /* @NET */
#define IDC_RPRTCONNECT_HELP              (IDD_RPRTCONNECT + 2)     /* @NET */
          /***********************************************************/
          /* Remote Print Destination AccessAnother dialog box. @NET */
          /***********************************************************/
#define IDD_RPRTCREATEANOTHER             22300                       /* @NET */
#define IDC_RPRTCREATEANOTHER_NETWORK     (IDD_RPRTCREATEANOTHER + 1) /* @NET */
#define IDC_RPRTCREATEANOTHER_SERVER      (IDD_RPRTCREATEANOTHER + 2) /* @NET */
#define IDC_RPRTCREATEANOTHER_RESOURCE    (IDD_RPRTCREATEANOTHER + 3) /* @NET */
#define IDC_RPRTCREATEANOTHER_HELP        (IDD_RPRTCREATEANOTHER + 4) /* @NET */

          /*********************************************************/
          /*    message dialog for installation                    */
          /*********************************************************/
#define IDD_STATUS            23000
#define IDC_STA_TEXT          (IDD_STATUS + 1)   /* Text to display */

          /*********************************************************/
          /*    message dialog for installation                    */
          /*********************************************************/
#define IDD_READING           23030
#define IDC_READING_TEXT      (IDD_READING + 1)   /* Reading the list */

          /*********************************************************/
          /*    message dialog for installation                    */
          /*********************************************************/
#define IDD_COPYING           23050
#define IDC_COPYING_TEXT      (IDD_COPYING + 1)   /* Copying the files */

          /*********************************************************/
          /*    message dialog for printer driver directory  @USE  */
          /*********************************************************/
#define IDD_DIRECTORY         23100
#define IDC_DIR_STA_TEXT      (IDD_DIRECTORY + 1)   /* Text to display */
#define IDC_DIR_STA_TEXT2     (IDD_DIRECTORY + 2)   /* Text to display */
#define IDC_DIR_DIRECTORY     (IDD_DIRECTORY + 3)

          /*********************************************************/
          /*    Pop up dialog                                      */
          /*********************************************************/
#define IDD_NOINSTALLPDRIVER  30001
#define IDD_NOINSTALLQDRIVER  30002
#define IDD_NOINSTALLPORT     30003
#define IDD_DELPRINTDEST1     30100
#define IDD_DELPRINTDEST2     30200
#define IDD_DELPRINTDEST3     30300
#define IDD_INSTALLREMOTEDRV  30400   /* @NET */
#define IDD_AUTOINSTREMOTEDRV 30500                             /* @USE */


/****************************************************************************/
/*              PRINT  OBJECT  CONSTANTS FOR HELPS                          */
/****************************************************************************/
#define WPPRINT_HELPTABLE_BASE           20000
#define WPPRINT_HELPTABLE                (WPPRINT_HELPTABLE_BASE + 1)
#define SUB_DELCONFORM                   (WPPRINT_HELPTABLE_BASE + 2)
#define SUB_NOINSTALL                    (WPPRINT_HELPTABLE_BASE + 3)
#define SUB_INSTPORT                     (WPPRINT_HELPTABLE_BASE + 4)
#define SUB_DELPORT                      (WPPRINT_HELPTABLE_BASE + 5)
#define SUB_INSTPDRIVER                  (WPPRINT_HELPTABLE_BASE + 6)
#define SUB_DELPDRIVER                   (WPPRINT_HELPTABLE_BASE + 7)
#define SUB_INSTQDRIVER                  (WPPRINT_HELPTABLE_BASE + 8)
#define SUB_DELQDRIVER                   (WPPRINT_HELPTABLE_BASE + 9)
#define SUB_INSTREMOTEDRV                (WPPRINT_HELPTABLE_BASE + 10)  /* @NET */

          /*********************************************************/
          /*    Delete conformation dialog boxes.                  */
          /*********************************************************/
#define IDH_DELCONFORM_DELETE             15713
#define IDH_DELCONFORM_CANCEL             15714
#define IDH_DELCONFORM_HELP               15712
          /*********************************************************/
          /*    No installed dialog boxes.                         */
          /*********************************************************/
#define IDH_NOINST_INSTALL                15500
#define IDH_NOINST_CANCEL                 15501
#define IDH_NOINST_HELP                   15499
          /*********************************************************/
          /*    Install Port dialog box.                           */
          /*********************************************************/
#define IDH_INSTPORT_PATH                 15474
#define IDH_INSTPORT_OUTPUTPORT           15475
#define IDH_INSTPORT_PORTICON             15428
#define IDH_INSTPORT_INSTALL              15476
#define IDH_INSTPORT_REFRESH              15497
#define IDH_INSTPORT_CANCEL               15729
#define IDH_INSTPORT_HELP                 15473
          /*********************************************************/
          /*    Delete Port dialog box.                            */
          /*********************************************************/
#define IDH_DELPORT_PD                    15707
#define IDH_DELPORT_PDICON                15723
#define IDH_DELPORT_CANCEL                15740
#define IDH_DELPORT_HELP                  15706
          /*********************************************************/
          /*    Install Printer Driver dialog box.                 */
          /*********************************************************/
#define IDH_INSTPD_OS2                    15483            /* @USE */
#define IDH_INSTPD_OTHER                  15484            /* @USE */
#define IDH_INSTPD_PATH                   15485
#define IDH_INSTPD_PDRIVER                15486
#define IDH_INSTPD_PDRIVERICON            15431
#define IDH_INSTPD_INSTALL                15487
#define IDH_INSTPD_REFRESH                15497
#define IDH_INSTPD_CANCEL                 15729
#define IDH_INSTPD_HELP                   15498
          /*********************************************************/
          /*    Printer Driver Directory dialog box.               */
          /*********************************************************/
#define IDH_PDDIRDLG_HELP                 15829            /* @USE */
          /*********************************************************/
          /*    Delete Printer Driver dialog box.                  */
          /*********************************************************/
#define IDH_DELPD_PD                      15709
#define IDH_DELPD_PDICON                  15724
#define IDH_DELPD_CANCEL                  15741
#define IDH_DELPD_HELP                    15708
          /*********************************************************/
          /*    Install Queue Driver dialog box.                   */
          /*********************************************************/
#define IDH_INSTQD_PATH                   15489
#define IDH_INSTQD_QDRIVER                15490
#define IDH_INSTQD_QDRIVERICON            15439
#define IDH_INSTQD_INSTALL                15491
#define IDH_INSTQD_REFRESH                15497
#define IDH_INSTQD_CANCEL                 15729
#define IDH_INSTQD_HELP                   15488
          /*********************************************************/
          /*    Delete Queue Driver dialog box.                    */
          /*********************************************************/
#define IDH_DELQD_PD                      15711
#define IDH_DELQD_PDICON                  15725
#define IDH_DELQD_CANCEL                  15741
#define IDH_DELQD_HELP                    15710

          /***************************************************************/
          /*    Install Printer Driver for Remote Print Destination @NET */
          /***************************************************************/
#define IDH_INSTREMOTE_HELP               15499                    /* @NET */
